/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.KioskApplication;
import com.sun.ut.service.KioskDescriptor;
import java.util.ArrayList;
import java.util.List;

public class Kiosk {
    private KioskDescriptor descriptor;
    private String timeout = "";
    private String maxCPU = "";
    private String maxVM = "";
    private String maxFiles = "";
    private String maxFileSize = "";
    private String locale = "";
    private String args = "";
    private List applications;
    private String contents;

    public Kiosk(KioskDescriptor descriptor, String timeout, String maxCPU, String maxVM, String maxFiles, String maxFileSize, String locale, String args, List applications) {
        this.descriptor = descriptor;
        if (timeout != null) {
            this.timeout = timeout;
        }
        if (maxCPU != null) {
            this.maxCPU = maxCPU;
        }
        if (maxVM != null) {
            this.maxVM = maxVM;
        }
        if (maxFiles != null) {
            this.maxFiles = maxFiles;
        }
        if (maxFileSize != null) {
            this.maxFileSize = maxFileSize;
        }
        if (locale != null) {
            this.locale = locale;
        }
        if (args != null) {
            this.args = args;
        }
        if (applications == null) {
            applications = new ArrayList();
        }
        this.applications = applications;
    }

    public Kiosk(Kiosk kiosk) {
        if (kiosk == null) {
            return;
        }
        this.descriptor = kiosk.descriptor;
        if (kiosk.descriptor != null) {
            this.descriptor = new KioskDescriptor(kiosk.descriptor);
        }
        if (this.timeout != null) {
            this.timeout = this.timeout;
        }
        if (this.maxCPU != null) {
            this.maxCPU = this.maxCPU;
        }
        if (this.maxVM != null) {
            this.maxVM = this.maxVM;
        }
        if (this.maxFiles != null) {
            this.maxFiles = this.maxFiles;
        }
        if (this.maxFileSize != null) {
            this.maxFileSize = this.maxFileSize;
        }
        if (this.locale != null) {
            this.locale = this.locale;
        }
        if (this.args != null) {
            this.args = this.args;
        }
        this.applications = new ArrayList();
        if (kiosk.applications != null) {
            for (int i = 0; i < kiosk.applications.size(); ++i) {
                KioskApplication application = (KioskApplication)kiosk.applications.get(i);
                this.applications.add(new KioskApplication(application));
            }
        }
    }

    public Kiosk(String contents) {
        this.contents = contents;
    }

    public KioskDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(KioskDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getMaxCPU() {
        return this.maxCPU;
    }

    public void setMaxCPU(String maxCPU) {
        this.maxCPU = maxCPU;
    }

    public String getMaxVM() {
        return this.maxVM;
    }

    public void setMaxVM(String maxVM) {
        this.maxVM = maxVM;
    }

    public String getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(String maxFiles) {
        this.maxFiles = maxFiles;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public List getApplications() {
        return this.applications;
    }

    public void setApplications(List applications) {
        this.applications = applications;
    }

    public String getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        StringBuffer sb = new StringBuffer();
        if (this.descriptor == null) {
            return "";
        }
        String id = this.descriptor.getId();
        if (id == null || id.length() <= 0) {
            return "";
        }
        sb.append("KIOSK_SESSION=" + id + "\n");
        if (this.timeout != null && this.timeout.length() > 0) {
            sb.append("KIOSK_SESSION_TIMEOUT_DETACHED=" + this.timeout + "\n");
        }
        if (this.maxCPU != null && this.maxCPU.length() > 0) {
            sb.append("KIOSK_SESSION_LIMIT_CPU=" + this.maxCPU + "\n");
        }
        if (this.maxVM != null && this.maxVM.length() > 0) {
            sb.append("KIOSK_SESSION_LIMIT_VMSIZE=" + this.maxVM + "\n");
        }
        if (this.maxFiles != null && this.maxFiles.length() > 0) {
            sb.append("KIOSK_SESSION_LIMIT_DESCRIPTORS=" + this.maxFiles + "\n");
        }
        if (this.maxFileSize != null && this.maxFileSize.length() > 0) {
            sb.append("KIOSK_SESSION_LIMIT_FILESIZE=" + this.maxFileSize + "\n");
        }
        if (this.locale != null && this.locale.length() > 0) {
            sb.append("KIOSK_SESSION_LOCALE=" + this.locale + "\n");
        }
        if (this.args != null && this.args.length() > 0) {
            sb.append("KIOSK_SESSION_ARGS=" + Kiosk.protectQuotes(this.args) + "\n");
        }
        if (this.applications != null && this.applications.size() > 0) {
            sb.append("KIOSK_SESSION_APPLIST=");
            for (int i = 0; i < this.applications.size(); ++i) {
                KioskApplication application = (KioskApplication)this.applications.get(i);
                sb.append(application.getType() + ":");
                sb.append(application.getId() + ":");
                sb.append(application.getMode() + ";");
                String arguments = application.getArgs();
                if (arguments != null && arguments.length() > 0) {
                    sb.append(arguments);
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public boolean isTimeoutSet() {
        return this.timeout != null && this.timeout.length() > 0;
    }

    public boolean isMaxCPUSet() {
        return this.maxCPU != null && this.maxCPU.length() > 0;
    }

    public boolean isMaxVMSet() {
        return this.maxVM != null && this.maxVM.length() > 0;
    }

    public boolean isMaxFilesSet() {
        return this.maxFiles != null && this.maxFiles.length() > 0;
    }

    public boolean isMaxFileSizeSet() {
        return this.maxFileSize != null && this.maxFileSize.length() > 0;
    }

    public boolean isLocaleSet() {
        return this.locale != null && this.locale.length() > 0;
    }

    public boolean isArgsSet() {
        return this.args != null && this.args.length() > 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("descriptor={" + this.descriptor + "}");
        sb.append(", timeout=" + this.timeout);
        sb.append(", maxCPU=" + this.maxCPU);
        sb.append(", maxVM=" + this.maxVM);
        sb.append(", maxFiles=" + this.maxFiles);
        sb.append(", maxFileSize=" + this.maxFileSize);
        sb.append(", locale=" + this.locale);
        sb.append(", args=" + this.args);
        sb.append(", applications=");
        if (this.applications == null) {
            sb.append("null");
        } else {
            sb.append("[");
            for (int i = 0; i < this.applications.size(); ++i) {
                sb.append((KioskApplication)this.applications.get(i));
                if (i >= this.applications.size() - 1) continue;
                sb.append("][");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private static String protectQuotes(String s) {
        if (s != null && s.startsWith("\"") && s.endsWith("\"")) {
            return " " + s;
        }
        return s;
    }
}

