/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.jni;

import com.sun.ut.service.LogicalToken;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.User;
import com.sun.ut.service.jni.Datastore;
import com.sun.ut.service.jni.DatastoreFactory;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class TokenTest
extends TestCase {
    private static final String TOKEN_A = "pseudo.8765432";
    private static final String TOKEN_B = "pseudo.7654321";
    private static final String USER_A = "User A";
    private static final String USER_B = "User B";
    private static final String LDAP_USERNAME_ATTRIBUTE = "utname";
    private Datastore ds;
    private LogicalToken logicalToken;
    private User userA;

    private User findUser(String userName) throws ServiceException {
        User result = null;
        List users = this.ds.getUsers("(utname=" + userName + ")");
        if (!users.isEmpty()) {
            Iterator it = users.iterator();
            result = (User)it.next();
        }
        return result;
    }

    private LogicalToken getLogicalToken(User user) {
        LogicalToken result = null;
        List tokens = user.getLogicalTokens();
        if (!tokens.isEmpty()) {
            Iterator it = tokens.iterator();
            result = (LogicalToken)it.next();
        }
        return result;
    }

    protected final void setUp() throws ServiceException {
        this.ds = DatastoreFactory.getDatastore();
        if (this.findUser(USER_A) == null) {
            this.ds.addUser(USER_A, USER_A, TOKEN_A);
        }
        this.userA = this.findUser(USER_A);
        TokenTest.assertNotNull((Object)this.userA);
        this.logicalToken = this.getLogicalToken(this.userA);
        TokenTest.assertNotNull((Object)this.logicalToken);
    }

    protected final void tearDown() throws ServiceException {
        if (this.ds.getUser(this.userA.getId()) != null) {
            this.ds.deleteUser(this.userA.getId());
        }
        this.ds = null;
    }

    public void testGetUser() throws ServiceException {
        TokenTest.assertNotNull((Object)this.ds.getUser(this.userA.getId()));
        TokenTest.assertNull((Object)this.ds.getUser(""));
    }

    public void testAddUser() throws ServiceException {
        if (this.findUser(USER_B) != null) {
            this.ds.deleteUser(this.findUser(USER_B).getId());
        }
        String id = this.ds.addUser(USER_B, USER_B, TOKEN_B);
        TokenTest.assertNotNull((Object)id);
        TokenTest.assertNotNull((Object)this.ds.getUser(id));
        System.out.println("Added new user User B with id " + id);
        try {
            System.out.println("Tried to add already existing token");
            this.ds.addUser(USER_A, USER_A, TOKEN_A);
            TokenTest.fail((String)"Could add token twice!");
        }
        catch (ServiceException ex) {
            System.out.println("Caught expected exception");
        }
        this.ds.deleteUser(id);
        TokenTest.assertNull((Object)this.ds.getUser(id));
        System.out.println("Removed user User B");
    }

    public void testDeleteUser() throws ServiceException {
        this.ds.deleteUser(this.userA.getId());
        TokenTest.assertNull((Object)this.ds.getUser(this.userA.getId()));
        TokenTest.assertNull((Object)this.findUser(USER_A));
        System.out.println("Removed user User A");
    }

    public void testModifyUser() throws ServiceException {
        this.ds.modifyUser(this.userA.getId(), USER_B, USER_B);
        User user = this.ds.getUser(this.userA.getId());
        TokenTest.assertTrue((boolean)USER_B.equals(user.getUserName()));
        TokenTest.assertTrue((boolean)USER_B.equals(user.getDescription()));
        System.out.println("Modfied user User A");
    }

    private void printSessionType(LogicalToken token) throws ServiceException {
        System.out.print("Session type for " + token.getId() + ": ");
        int sessionType = this.ds.getSessionType(token.getId());
        switch (sessionType) {
            case 0: {
                System.out.println("Default behaviour");
                break;
            }
            case 1: {
                System.out.println("Kiosk session behaviour");
                break;
            }
            case 2: {
                System.out.println("Regular login behavior");
                break;
            }
            default: {
                System.out.println("No valid session type specified!");
            }
        }
    }

    private void setSessionType(int type) throws ServiceException {
        this.printSessionType(this.logicalToken);
        this.ds.setSessionType(this.logicalToken.getId(), type);
        this.printSessionType(this.logicalToken);
        TokenTest.assertEquals((int)type, (int)this.ds.getSessionType(this.logicalToken.getId()));
        TokenTest.assertEquals((int)type, (int)this.getLogicalToken(this.findUser(USER_A)).getSessionType());
    }

    public void testSetKioskSessionType() throws ServiceException {
        System.out.println("Setting kiosk behaviour");
        this.setSessionType(1);
    }

    public void testSetRegularSessionType() throws ServiceException {
        System.out.println("Setting regular behaviour");
        this.setSessionType(2);
    }

    public void testSetDefaultSessionType() throws ServiceException {
        System.out.println("Setting default behaviour");
        this.setSessionType(0);
    }
}

