/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.AlarmBase;
import java.io.IOException;
import java.util.Comparator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class Alarm
extends AlarmBase
implements Comparator {
    public static final String SEVERITY_DOWN = "down";
    public static final String SEVERITY_CRITICAL = "critical";
    public static final String SEVERITY_MAJOR = "major";
    public static final String SEVERITY_MINOR = "minor";
    public static final String SEVERITY_OK = "ok";
    public static final String DEFAULT_SEVERITY = "ok";
    private final int SEVERITY_LEVEL_DOWN = 1;
    private final int SEVERITY_LEVEL_CRITICAL = 2;
    private final int SEVERITY_LEVEL_MAJOR = 3;
    private final int SEVERITY_LEVEL_MINOR = 4;
    private final int SEVERITY_LEVEL_OK = 5;

    public Alarm() {
    }

    public Alarm(String severity) {
        this.setSeverity(severity);
    }

    public int compare(Object o1, Object o2) throws ClassCastException {
        int s2;
        int s1 = this.getSeverityLevel((Alarm)o1);
        return s1 > (s2 = this.getSeverityLevel((Alarm)o2)) ? -1 : (s1 == s2 ? 0 : 1);
    }

    public boolean equals(Object o) throws ClassCastException {
        int s2;
        int s1 = this.getSeverityLevel(this);
        return s1 == (s2 = this.getSeverityLevel((Alarm)o));
    }

    private int getSeverityLevel(Alarm alarm) {
        int severity = 5;
        String alarmSeverity = alarm.getSeverity();
        if (alarmSeverity == null) {
            return severity;
        }
        if (alarmSeverity.equals(SEVERITY_DOWN)) {
            severity = 1;
        } else if (alarmSeverity.equals(SEVERITY_CRITICAL)) {
            severity = 2;
        } else if (alarmSeverity.equals(SEVERITY_MAJOR)) {
            severity = 3;
        } else if (alarmSeverity.equals(SEVERITY_MINOR)) {
            severity = 4;
        }
        return severity;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, (UIComponent)this);
        }
    }
}

