/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.protocol.ClientCommand;
import auth.sdk.Log;
import auth.utauthd.Terminal;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class Crypto {
    public final int SECURE_SESSION = 0;
    public final int INSECURE_SESSION = 1;
    public final int NO_SESSION = 2;
    private final int LOW = 0;
    private final int HIGH = 1;
    public static final String KEYSTATUS_UNCONFIRMED = "unconfirmed";
    public static final String KEYSTATUS_AUTOCONFIRMED = "autoconfirmed";
    public static final String KEYSTATUS_CONFIRMED = "confirmed";
    public static final String KEYSTATUS_CONFLICT = "conflict";
    public static final String KEYSTATUS_REJECT = "reject";
    public static final String KEYSTATUS_INVALID = "invalid";
    public static final String KEYSTATUS_ERROR = "error";
    private static final String DSA_AUTH = "DSA";
    private static final String DSA_KEY_PLAIN = "dsa-sha1";
    private static final String DSA_KEY_INDEX1 = "dsa-sha1-x1";
    private static final String[] DSA_KEY_TYPES = new String[]{"dsa-sha1-x1", "dsa-sha1"};
    private String authUpType;
    private String clientAuthMode;
    private String authDownType;
    private String encUpType;
    private String encDownType;
    private String securityMode;
    private String lastTokenId = null;
    private String[] acceptedKeyTypes;
    private boolean allowSoftModes = true;
    private int sessionType = 1;
    private String clientRandom = null;
    private String serverRandom = "";
    private String myDHMsg = "";
    private String masterKey = null;
    private String signature = null;
    private String keyType = null;
    private String clientKey = null;
    private String clientKeyID = null;
    private String clientKeyStatus = null;
    private byte[] clientData = null;
    private int clientDataCount;
    private boolean waitingForSignature = false;

    public Crypto() {
        this.setSecurity(0, true);
    }

    private boolean readConfig(String string, boolean bl) {
        if (string.equals(this.lastTokenId)) {
            return false;
        }
        Admin admin = Admin.getAdmin();
        if (admin != null) {
            String[] stringArray = admin.getCryptoEntByTokenID(string);
            Log.debug((String)("CryptoConfigData:: tokenId=" + string));
            if (stringArray != null) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "=");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    hashtable.put(string2, string3);
                    Log.debug((String)("CryptoConfigData::" + string2 + " = " + string3));
                }
                if (bl) {
                    this.clientAuthMode = (String)hashtable.get("auth_mode");
                    this.setAuthUpType((String)hashtable.get("auth_up_type"));
                }
                this.securityMode = (String)hashtable.get("mode");
                this.authDownType = (String)hashtable.get("auth_down_type");
                this.encUpType = (String)hashtable.get("enc_up_type");
                this.encDownType = (String)hashtable.get("enc_down_type");
            } else {
                Log.notice((String)"Crypto.readConfig: config values are not found in the admin database, defaulting to high security options.");
                this.setSecurity(1, bl);
            }
        } else {
            Log.debug((String)"Crypto.readConfig: admin database not found");
            return false;
        }
        return true;
    }

    public static void init() {
        Crypto.loadPrivateKey();
    }

    public boolean collectMessage(ClientCommand clientCommand) {
        String string = clientCommand.getFullMessage();
        if (string == null) {
            Log.unexpectedError((String)"Crypto: attempting to collect command without message");
            return false;
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            Log.unexpectedError((String)"Crypto: unexpected: message text in command terminated");
            return false;
        }
        this.collectClientData(string + "\n");
        clientCommand.setFullMessage(null);
        return true;
    }

    public boolean collectMessage(String string) {
        if (string == null) {
            Log.unexpectedError((String)"Crypto: attempting to collect null message");
            return false;
        }
        if (string.length() == 0) {
            Log.unexpectedError((String)"Crypto: attempting to collect empty message");
            return false;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            Log.unexpectedError((String)"Crypto: attempting to collect unterminated message");
            return false;
        }
        this.collectClientData(string);
        return true;
    }

    private boolean collectSignedMessage(ClientCommand clientCommand, String string) {
        boolean bl = this.collectSignedMessage(clientCommand.getFullMessage(), string);
        if (bl) {
            clientCommand.setFullMessage(null);
        }
        return bl;
    }

    private boolean collectSignedMessage(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = Crypto.findTrailingKey(string, string2);
        if (n < 0) {
            Log.unexpectedError((String)("Crypto: Message '" + string + "' doesn't end with expected key: " + string2));
            return false;
        }
        this.collectClientData(string.substring(0, n));
        return true;
    }

    private static int findTrailingKey(String string, String string2) {
        String[] stringArray = string.split("[ \t]+");
        if (stringArray.length == 0) {
            Log.debug((String)"Crypto: findSignature: No keyvals found");
            return -1;
        }
        String string3 = stringArray[stringArray.length - 1];
        if (!string3.startsWith(string2 + "=")) {
            Log.debug((String)("Crypto: findSignature: Unexpected last keyval \n" + string3 + "\""));
            Log.debug((String)("Crypto: findSignature: Complete list: " + stringArray));
            return -1;
        }
        return string.lastIndexOf(string3);
    }

    private void resetClientKey() {
        this.clientKey = null;
        this.clientKeyID = null;
        this.clientKeyStatus = null;
    }

    private void resetClientAuth() {
        this.waitingForSignature = false;
        this.clientData = null;
        this.clientDataCount = 0;
        this.serverRandom = "";
        this.signature = null;
    }

    private void resetEncryption() {
        this.sessionType = 1;
        this.myDHMsg = "";
        this.masterKey = null;
        this.signature = null;
    }

    private void setSessionType() {
        this.sessionType = this.isAuthDownEnabled() || this.isEncUpEnabled() || this.isEncDownEnabled() ? (this.clientRandom != null ? 0 : (!this.allowSoftModes || this.securityMode.equalsIgnoreCase("hard") ? 2 : 1)) : 1;
        if (this.isAuthUpEnabled() && this.keyType == null && (!this.allowSoftModes || this.clientAuthMode.equalsIgnoreCase("hard"))) {
            this.sessionType = 2;
        }
    }

    private void initClientAuth(String string) {
        if (this.clientKey != null) {
            if (!this.handleNewKey(string, this.keyType, this.clientKey)) {
                Log.debug((String)"Crypto: Failed to validate old key - resetting key.");
                this.resetClientKey();
            } else {
                Log.debug((String)"Crypto: Reusing client key.");
            }
        }
        if (this.needsClientKey()) {
            if (this.serverRandom.length() == 0) {
                this.serverRandom = this.genServerRand();
            }
            this.encUpType = null;
            this.encDownType = null;
            Log.debug((String)"Crypto: Client authentication ready.");
        }
    }

    private void initEncryption() {
        if (this.sessionType == 2 || this.sessionType == 1) {
            return;
        }
        if (this.isEncUpEnabled() || this.isEncDownEnabled()) {
            if (this.serverRandom.length() == 0) {
                this.serverRandom = this.genServerRand();
            }
            if (this.myDHMsg.length() == 0) {
                this.myDHMsg = this.genDHMsg();
            }
            Log.debug((String)"Crypto: DH exchange ready.");
        }
    }

    private void initSignature() {
        if (this.sessionType == 2 || this.sessionType == 1) {
            return;
        }
        if (this.isAuthDownEnabled() && this.signature == null) {
            String string = this.clientRandom + ":" + this.serverRandom + ":" + this.myDHMsg + ":" + this.getEffectiveEncUpType() + ":" + this.getEffectiveEncDownType();
            if (this.keyType != null) {
                string = string + ":" + this.keyType;
            }
            this.signature = this.sign(string);
            Log.debug((String)"Crypto: Server authentication ready.");
        }
    }

    private boolean finishEncryptionSetup(Hashtable hashtable) {
        if (this.isEncUpEnabled() || this.isEncDownEnabled()) {
            if (this.masterKey != null) {
                return true;
            }
            if (this.genDHKey(hashtable)) {
                Log.debug((String)"Crypto: Encryption ready");
                return true;
            }
            Log.debug((String)"Crypto: Encryption setup failed");
            return false;
        }
        return true;
    }

    public boolean setupForTokenConnect(String string) {
        if (!this.readConfig(string, false)) {
            return true;
        }
        this.resetEncryption();
        this.setSessionType();
        this.initEncryption();
        return true;
    }

    private void selectKeyType(String string) {
        String string2 = this.keyType;
        this.keyType = null;
        if (string != null) {
            List<String> list = Arrays.asList(string.split(","));
            if (string2 != null && this.clientKey != null && this.isKeyStatusValid(true)) {
                if (list.contains(string2)) {
                    this.keyType = string2;
                } else {
                    Log.unexpectedError((String)("Crypto: client does not support key-type '" + string2 + "' any more."));
                }
            }
            if (this.keyType == null) {
                for (int i = 0; i < this.acceptedKeyTypes.length; ++i) {
                    if (!list.contains(this.acceptedKeyTypes[i])) continue;
                    this.keyType = this.acceptedKeyTypes[i];
                    break;
                }
            }
            if (this.keyType == null) {
                Log.debug((String)("Crypto: Key negotiation failed. Presented: '" + string + "'" + "Accepted: " + this.acceptedKeyTypes));
            } else {
                Log.debug((String)("Crypto: Negotiated key type: " + this.keyType));
            }
        } else if (string2 != null) {
            Log.unexpectedError((String)"Crypto: client does not support client authentication any more");
        } else {
            Log.debug((String)"Crypto: Client does not support client authentication.");
        }
        if (this.keyType == null || !this.keyType.equals(string2)) {
            this.resetClientKey();
        }
    }

    public boolean processInsertReq(ClientCommand clientCommand, boolean bl) {
        this.resetClientAuth();
        this.resetEncryption();
        this.allowSoftModes = bl;
        this.readConfig(clientCommand.getRawTokenId(), true);
        this.clientRandom = clientCommand.getParam("clientRand");
        if (this.acceptedKeyTypes != null) {
            this.selectKeyType(clientCommand.getParam("keyTypes"));
        }
        this.initClientAuth(Terminal.getTerminalCID(clientCommand));
        return this.collectMessage(clientCommand);
    }

    private boolean handleSignedMessage(ClientCommand clientCommand, String string) {
        String string2 = clientCommand.getParam("clientSignature");
        if (string2 == null) {
            Log.clientError((String)("Crypto: missing client signature in " + clientCommand.getCommand() + " message."));
            return false;
        }
        String string3 = clientCommand.getParam("keyType");
        if (string3 == null) {
            Log.clientError((String)("Crypto: missing keyType on signed " + clientCommand.getCommand() + " message."));
            return false;
        }
        if (!string3.equals(this.keyType)) {
            Log.clientError((String)("Crypto: unexpected keyType on signed " + clientCommand.getCommand() + " message." + " Found '" + string3 + "', expected '" + this.keyType + "'"));
            return false;
        }
        if (!this.collectSignedMessage(clientCommand, "clientSignature")) {
            return false;
        }
        Log.debug((String)("Crypto: verifying hash of " + this.clientDataCount + " characters"));
        if (!this.verify(this.keyType, string, string2)) {
            Log.clientError((String)"Crypto: client signature verification failed");
            return false;
        }
        this.collectClientData("clientSignature=" + string2 + "\n");
        this.waitingForSignature = false;
        return true;
    }

    public boolean processKeyRsp(ClientCommand clientCommand) {
        if (!this.waitingForSignature || !this.needsClientKey()) {
            Log.clientError((String)("Crypto: Out of sequence keyRsp: " + clientCommand));
            return false;
        }
        String string = clientCommand.getParam("clientKey");
        if (string == null) {
            Log.clientError((String)("Crypto: missing client keyin " + clientCommand.getCommand() + " message."));
            return false;
        }
        if (!this.handleSignedMessage(clientCommand, string)) {
            return false;
        }
        if (!this.handleNewKey(Terminal.getTerminalCID(clientCommand), this.keyType, string)) {
            Log.unexpectedError((String)"Crypto: Failed to update key status.");
            return false;
        }
        this.clientKey = string;
        return this.finishEncryptionSetup(clientCommand.getParams());
    }

    public boolean processConnRsp(ClientCommand clientCommand) {
        if (this.needsClientKey()) {
            Log.clientError((String)"Crypto: Unexpected connRsp: client key required");
            return false;
        }
        if (this.waitingForSignature && !this.handleSignedMessage(clientCommand, this.clientKey)) {
            return false;
        }
        return this.finishEncryptionSetup(clientCommand.getParams());
    }

    public String getSessionInfo() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("encryptUpType=" + this.getEffectiveEncUpType() + "\n");
        stringBuffer.append("encryptDownType=" + this.getEffectiveEncDownType() + "\n");
        stringBuffer.append("authenticateUpType=" + this.getEffectiveAuthUpType() + "\n");
        stringBuffer.append("authenticateDownType=" + this.getEffectiveAuthDownType() + "\n");
        stringBuffer.append("clientAuthMode=" + this.getEffectiveClientAuthMode() + "\n");
        if (this.clientKeyStatus != null) {
            stringBuffer.append("clientKeyStatus=" + this.clientKeyStatus + "\n");
        }
        if (this.clientKeyID != null) {
            stringBuffer.append("clientKeyID=" + this.clientKeyID + "\n");
        }
        stringBuffer.append("securityMode=" + this.getEffectiveSecurityMode());
        return stringBuffer.toString();
    }

    public String getMasterKey() {
        return this.masterKey;
    }

    public boolean isKeyStatusValid(boolean bl) {
        if (this.clientKeyStatus == null) {
            return !bl;
        }
        return this.clientKeyStatus.equals(KEYSTATUS_CONFIRMED) || this.clientKeyStatus.equals(KEYSTATUS_AUTOCONFIRMED) || this.clientKeyStatus.equals(KEYSTATUS_UNCONFIRMED);
    }

    public boolean shouldRefuseSession() {
        if (this.sessionType == 2) {
            return true;
        }
        if (this.keyType == null) {
            return false;
        }
        if (this.clientKey == null || this.waitingForSignature) {
            return true;
        }
        return !this.isKeyStatusValid(true);
    }

    public void keyInfSent(Hashtable hashtable) {
        this.waitingForSignature = true;
    }

    public void connInfSent(Hashtable hashtable) {
        if (hashtable.containsKey("keyType")) {
            this.waitingForSignature = true;
        }
    }

    public boolean needsClientKey() {
        return this.keyType != null && this.clientKey == null;
    }

    public boolean needsDHExchange() {
        return this.myDHMsg.length() != 0 && this.masterKey == null;
    }

    public boolean isAuthUpEnabled() {
        return this.authUpType != null && !this.authUpType.equals("none");
    }

    public boolean isAuthDownEnabled() {
        return this.authDownType != null && !this.authDownType.equals("none");
    }

    public boolean isEncUpEnabled() {
        return this.encUpType != null && !this.encUpType.equals("none");
    }

    public boolean isEncDownEnabled() {
        return this.encDownType != null && !this.encDownType.equals("none");
    }

    public String getEffectiveEncUpType() {
        return this.sessionType == 0 ? this.encUpType : "none";
    }

    public String getEffectiveEncDownType() {
        return this.sessionType == 0 ? this.encDownType : "none";
    }

    public String getEffectiveAuthDownType() {
        return this.sessionType == 0 ? this.authDownType : "none";
    }

    public String getEffectiveAuthUpType() {
        return this.keyType != null ? this.authUpType : "none";
    }

    public String getEffectiveClientAuthMode() {
        return this.allowSoftModes ? this.clientAuthMode : "hard";
    }

    public String getEffectiveSecurityMode() {
        return this.allowSoftModes ? this.securityMode : "hard";
    }

    public boolean hasClientKey() {
        return this.clientKey != null;
    }

    public String getClientKeyStatus() {
        return this.clientKeyStatus;
    }

    public boolean fillKeyRequest(Hashtable hashtable) {
        if (this.keyType == null || this.keyType.trim().length() == 0) {
            Log.unexpectedError((String)"Crypto: No valid client Key Type for key request");
            return false;
        }
        if (this.serverRandom.length() == 0) {
            Log.unexpectedError((String)"Crypto: Authentication not initialized");
            return false;
        }
        this.putSecurityAttributes(hashtable, true);
        return true;
    }

    public boolean fillConnInf(Hashtable hashtable) {
        this.putSecurityAttributes(hashtable, this.keyType != null);
        return true;
    }

    private void putSecurityAttributes(Hashtable hashtable, boolean bl) {
        this.initSignature();
        if (bl) {
            hashtable.put("keyType", this.keyType);
        }
        if (this.needsDHExchange()) {
            hashtable.put("serverDH", this.myDHMsg);
        }
        if (this.serverRandom.length() != 0) {
            hashtable.put("serverRand", this.serverRandom);
        }
        if (this.signature != null) {
            hashtable.put("signature", this.signature);
        }
        if (this.encUpType != null) {
            hashtable.put("encUpType", this.getEffectiveEncUpType());
        }
        if (this.encDownType != null) {
            hashtable.put("encDownType", this.getEffectiveEncDownType());
        }
    }

    private boolean genDHKey(Hashtable hashtable) {
        String string = (String)hashtable.get("clientDH");
        if (string != null) {
            this.masterKey = this.genMasterKey(string, this.clientRandom, this.serverRandom);
        }
        return this.masterKey != null;
    }

    private void setAuthUpType(String string) {
        if (string == null || string.equals("none")) {
            this.authUpType = "none";
            this.acceptedKeyTypes = null;
        } else if (string.equals(DSA_AUTH)) {
            this.authUpType = string;
            this.acceptedKeyTypes = DSA_KEY_TYPES;
        } else {
            Log.notice((String)("WARNING: Crypto: Unsupported client auth mechanism: " + string));
            this.authUpType = null;
            this.acceptedKeyTypes = new String[0];
        }
    }

    private void setSecurity(int n, boolean bl) {
        switch (n) {
            case 0: {
                if (bl) {
                    this.setAuthUpType("none");
                    this.clientAuthMode = "soft";
                }
                this.authDownType = "none";
                this.encUpType = "none";
                this.encDownType = "none";
                this.securityMode = "soft";
                break;
            }
            case 1: {
                if (bl) {
                    this.setAuthUpType(DSA_AUTH);
                    this.clientAuthMode = "hard";
                }
                this.authDownType = "simple";
                this.encUpType = "ARCFOUR";
                this.encDownType = "ARCFOUR";
                this.securityMode = "hard";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown security level:" + n));
            }
        }
    }

    private void collectClientData(String string) {
        this.appendClientData(string);
        this.clientDataCount += string.length();
    }

    public native String genServerRand();

    public native String genDHMsg();

    public native String genMasterKey(String var1, String var2, String var3);

    public native String sign(String var1);

    private native void appendClientData(String var1);

    private native boolean verify(String var1, String var2, String var3);

    private native boolean handleNewKey(String var1, String var2, String var3);

    public static native void loadPrivateKey();

    static {
        System.loadLibrary("utcrypto");
    }
}

