/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class MonitorTimings {
    private static final String SCCS_ID = "@(#)MonitorTimings.java\t1.2\t09/04/13 SMI";
    private Timing[] timingArray;
    private int[] timingIndexToMenuPos;
    private static final int NO_MENU_POSITION_FOR_INDEX = -42;
    private String localisedStandard = "Standard";
    private String localisedMonitor = "Monitor";
    private String localisedSiteDefined = "Site-Defined";

    public MonitorTimings(ResourceBundle resourceBundle) {
        int n;
        try {
            this.localisedStandard = resourceBundle.getString("GUI.Display.ResRefresh.Standard");
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("no translation for GUI.Display.ResRefresh.Standard");
        }
        try {
            this.localisedMonitor = resourceBundle.getString("GUI.Display.ResRefresh.Monitor");
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("no translation for GUI.Display.ResRefresh.Monitor");
        }
        try {
            this.localisedSiteDefined = resourceBundle.getString("GUI.Display.ResRefresh.SiteDefined");
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("no translation for GUI.Display.ResRefresh.SiteDefined");
        }
        Vector<Timing> vector = new Vector<Timing>(40);
        vector.add(new Timing("standard", this.localisedStandard, 0));
        vector.add(new Timing("monitor", this.localisedMonitor, 1));
        vector.add(new Timing("custom", this.localisedSiteDefined, 16));
        vector.add(new Timing("640x480@60", "640x480 @ 60 Hz", 14));
        vector.add(new Timing("640x480@75", "640x480 @ 75 Hz", 17));
        vector.add(new Timing("640x480@85", "640x480 @ 85 Hz", 2));
        vector.add(new Timing("800x600@60", "800x600 @ 60 Hz", 15));
        vector.add(new Timing("800x600@75", "800x600 @ 75 Hz", 18));
        vector.add(new Timing("800x600@85", "800x600 @ 85 Hz", 3));
        vector.add(new Timing("1024x768@60", "1024x768 @ 60 Hz", 4));
        vector.add(new Timing("1024x768@75", "1024x768 @ 75 Hz", 5));
        vector.add(new Timing("1024x768@85", "1024x768 @ 85 Hz", 13));
        vector.add(new Timing("1152x900@66", "1152x900 @ 66 Hz", 6));
        vector.add(new Timing("1152x900@76", "1152x900 @ 76 Hz", 7));
        vector.add(new Timing("1280x800@60d", "1280x800 @ 60 Hz [D]", 31));
        vector.add(new Timing("1280x1024@60", "1280x1024 @ 60 Hz", 8));
        vector.add(new Timing("1280x1024@66", "1280x1024 @ 66 Hz", 9));
        vector.add(new Timing("1280x1024@75", "1280x1024 @ 75 Hz", 10));
        vector.add(new Timing("1280x1024@76", "1280x1024 @ 76 Hz", 11));
        vector.add(new Timing("1280x1024@85", "1280x1024 @ 85 Hz", 12));
        vector.add(new Timing("1400x1050@60", "1400x1050 @ 60 Hz", 28));
        vector.add(new Timing("1440x900@60", "1440x900 @ 60 Hz", 29));
        vector.add(new Timing("1600x1024@60", "1600x1024 @ 60 Hz", 19));
        vector.add(new Timing("1600x1200@60", "1600x1200 @ 60 Hz", 27));
        vector.add(new Timing("1600x1200@60d", "1600x1200 @ 60 Hz [D]", 20));
        vector.add(new Timing("1600x1200@75", "1600x1200 @ 75 Hz", 21));
        vector.add(new Timing("1680x1050@60", "1680x1050 @ 60 Hz", 30));
        vector.add(new Timing("1920x1080@60d", "1920x1080 @ 60 Hz [D]", 22));
        vector.add(new Timing("1920x1080@70", "1920x1080 @ 70 Hz", 23));
        vector.add(new Timing("1920x1080@72", "1920x1080 @ 72 Hz", 24));
        vector.add(new Timing("1920x1200@60d", "1920x1200 @ 60 Hz [D]", 25));
        vector.add(new Timing("1920x1200@70", "1920x1200 @ 70 Hz", 26));
        this.timingArray = vector.toArray(new Timing[vector.size()]);
        int n2 = this.timingArray[0].timingIndex;
        for (n = 1; n < this.timingArray.length; ++n) {
            if (this.timingArray[n].timingIndex <= n2) continue;
            n2 = this.timingArray[n].timingIndex;
        }
        this.timingIndexToMenuPos = new int[1 + n2];
        for (n = 0; n < this.timingArray.length; ++n) {
            this.timingIndexToMenuPos[n] = -42;
        }
        for (n = 0; n < this.timingArray.length; ++n) {
            this.timingIndexToMenuPos[this.timingArray[n].timingIndex] = n;
        }
    }

    public void addItems(Choice choice) {
        for (int i = 0; i < this.timingArray.length; ++i) {
            choice.addItem(this.timingArray[i].timingGuiName);
        }
    }

    public int getMenuPositionForTimingIndex(int n) throws SettingsBoundsException {
        int n2 = -42;
        try {
            n2 = this.timingIndexToMenuPos[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SettingsBoundsException("Timing index " + n + " out of bounds", arrayIndexOutOfBoundsException);
        }
        if (-42 == n2) {
            throw new SettingsBoundsException("Timing index " + n + " unknown");
        }
        return n2;
    }

    public int getTimingIndexForMenuPosition(int n) throws SettingsBoundsException {
        try {
            Timing timing = this.timingArray[n];
            return timing.timingIndex;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SettingsBoundsException("Menu position " + n + " out of bounds", arrayIndexOutOfBoundsException);
        }
    }

    public String getResNameForTimingIndex(int n) throws SettingsBoundsException {
        Timing timing = this.timingArray[this.getMenuPositionForTimingIndex(n)];
        return timing.timingCliName;
    }

    private class Timing {
        String timingCliName;
        String timingGuiName;
        int timingIndex;

        Timing(String string, String string2, int n) {
            this.timingCliName = string;
            this.timingGuiName = string2;
            this.timingIndex = n;
        }
    }
}

