/*
 * Decompiled with CFR 0.152.
 */
package admin.multihead.utmhconfig;

import admin.multihead.utmhconfig.BindTerminals;
import admin.multihead.utmhconfig.TraceHotDesk;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class DiscoverTerminals
extends Thread {
    private TraceHotDesk tracer = null;
    private BindTerminals binder = null;
    private Vector discoveryListeners = null;

    private DiscoverTerminals() {
    }

    public DiscoverTerminals(ResourceBundle resourceBundle, int n) throws IOException {
        this.tracer = new TraceHotDesk(resourceBundle, true);
        this.binder = new BindTerminals(resourceBundle, n, true);
        this.discoveryListeners = new Vector();
    }

    public BindTerminals getBinder() {
        return this.binder;
    }

    public void addDiscoveryListener(Runnable runnable) {
        this.discoveryListeners.add(runnable);
    }

    public void run() {
        String string = "";
        boolean bl = false;
        while (!bl) {
            try {
                string = this.tracer.traceTerminalId();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                System.exit(1);
            }
            bl = this.binder.newTerminal(string);
            Enumeration enumeration = this.discoveryListeners.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    SwingUtilities.invokeAndWait((Runnable)enumeration.nextElement());
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println(invocationTargetException);
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

