/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import java.io.Serializable;
import java.util.StringTokenizer;

public class Security
implements Serializable {
    public static final int MODE_SOFT = 0;
    public static final int MODE_HARD = 1;
    public static final String NONE = "none";
    public static final String ENC_ARCFOUR = "ARCFOUR";
    public static final String AUTH_SIMPLE = "simple";
    public static final String AUTH_HARD = "hard";
    public static final String AUTH_SOFT = "soft";
    public static final String AUTH_DSA = "DSA";
    private static final String KEY_ENC_UP = "enc_up_type";
    private static final String KEY_ENC_DOWN = "enc_down_type";
    private static final String KEY_AUTH_UP = "auth_up_type";
    private static final String KEY_AUTH_DOWN = "auth_down_type";
    private static final String KEY_MODE = "mode";
    private static final String KEY_AUTH_MODE = "auth_mode";
    private boolean encUp;
    private boolean encDown;
    private boolean authUp;
    private boolean authDown;
    private int encryptionMode;
    private int clientMode;

    public Security() {
    }

    public Security(boolean encUp, boolean encDown, boolean authUp, boolean authDown, int encryptionMode, int clientMode) {
        this.encUp = encUp;
        this.encDown = encDown;
        this.authUp = authUp;
        this.authDown = authDown;
        this.encryptionMode = encryptionMode;
        this.clientMode = clientMode;
    }

    public Security(String content) {
        this.setContent(content);
    }

    public Security(Security security) {
        this.encUp = security.encUp;
        this.encDown = security.encDown;
        this.authUp = security.authUp;
        this.authDown = security.authDown;
        this.encryptionMode = security.encryptionMode;
        this.clientMode = security.clientMode;
    }

    public void setEncUp(boolean encUp) {
        this.encUp = encUp;
    }

    public boolean isEncUp() {
        return this.encUp;
    }

    public void setEncDown(boolean encDown) {
        this.encDown = encDown;
    }

    public boolean isEncDown() {
        return this.encDown;
    }

    public void setAuthUp(boolean authUp) {
        this.authUp = authUp;
    }

    public boolean isAuthUp() {
        return this.authUp;
    }

    public void setAuthDown(boolean authDown) {
        this.authDown = authDown;
    }

    public boolean isAuthDown() {
        return this.authDown;
    }

    public void setEncryptionMode(int mode) {
        this.encryptionMode = mode;
    }

    public int getEncryptionMode() {
        return this.encryptionMode;
    }

    public void setClientMode(int mode) {
        this.clientMode = mode;
    }

    public int getClientMode() {
        return this.clientMode;
    }

    public String getContent() {
        StringBuffer sb = new StringBuffer();
        if (this.isEncUp()) {
            this.appendContent(sb, KEY_ENC_UP, ENC_ARCFOUR);
        } else {
            this.appendContent(sb, KEY_ENC_UP, NONE);
        }
        if (this.isEncDown()) {
            this.appendContent(sb, KEY_ENC_DOWN, ENC_ARCFOUR);
        } else {
            this.appendContent(sb, KEY_ENC_DOWN, NONE);
        }
        if (this.isAuthUp()) {
            this.appendContent(sb, KEY_AUTH_UP, AUTH_DSA);
        } else {
            this.appendContent(sb, KEY_AUTH_UP, NONE);
        }
        if (this.isAuthDown()) {
            this.appendContent(sb, KEY_AUTH_DOWN, AUTH_SIMPLE);
        } else {
            this.appendContent(sb, KEY_AUTH_DOWN, NONE);
        }
        if (this.getEncryptionMode() == 0) {
            this.appendContent(sb, KEY_MODE, AUTH_SOFT);
        }
        if (this.getEncryptionMode() == 1) {
            this.appendContent(sb, KEY_MODE, AUTH_HARD);
        }
        if (this.getClientMode() == 0) {
            this.appendContent(sb, KEY_AUTH_MODE, AUTH_SOFT);
        }
        if (this.getClientMode() == 1) {
            this.appendContent(sb, KEY_AUTH_MODE, AUTH_HARD);
        }
        return sb.toString();
    }

    protected void appendContent(StringBuffer buffer, String key, String value) {
        buffer.append(key);
        buffer.append("=");
        buffer.append(value);
        buffer.append("\n");
    }

    public void setContent(String contents) {
        this.encUp = false;
        this.encDown = false;
        this.authUp = false;
        this.authDown = false;
        this.encryptionMode = 0;
        this.clientMode = 0;
        StringTokenizer strtok = new StringTokenizer(contents, "\n");
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            int index = token.indexOf("=");
            if (index <= 0 || token.length() <= index + 1) continue;
            String key = token.substring(0, index);
            String value = token.substring(index + 1);
            if (key.equals(KEY_ENC_UP) && value.equals(ENC_ARCFOUR)) {
                this.encUp = true;
                continue;
            }
            if (key.equals(KEY_ENC_DOWN) && value.equals(ENC_ARCFOUR)) {
                this.encDown = true;
                continue;
            }
            if (key.equals(KEY_AUTH_DOWN) && value.equals(AUTH_SIMPLE)) {
                this.authDown = true;
                continue;
            }
            if (key.equals(KEY_AUTH_UP) && value.equals(AUTH_DSA)) {
                this.authUp = true;
                continue;
            }
            if (key.equals(KEY_MODE) && value.equals(AUTH_HARD)) {
                this.encryptionMode = 1;
                continue;
            }
            if (!key.equals(KEY_AUTH_MODE) || !value.equals(AUTH_HARD)) continue;
            this.clientMode = 1;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("encUp=");
        sb.append(this.encUp);
        sb.append(", encDown=");
        sb.append(this.encDown);
        sb.append(", authUp=");
        sb.append(this.authUp);
        sb.append(", authDown=");
        sb.append(this.authDown);
        sb.append(", mode=");
        sb.append(this.encryptionMode);
        sb.append(", authMode=");
        sb.append(this.clientMode);
        return sb.toString();
    }
}

