/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.UtDevadm;
import junit.framework.TestCase;

public class UtDevadmTest
extends TestCase {
    private static final int MAX_DEVICE_COUNT = 3;

    protected final void setUp() throws ServiceException {
        UtDevadm cmd = new UtDevadm();
        cmd.disableService("all");
    }

    public void testGetDevicesStatus() throws ServiceException {
        UtDevadm cmd = new UtDevadm();
        Object[][] devices = cmd.getServicesStatus();
        UtDevadmTest.assertTrue((String)"Exit code of utdevadm command is not zero!", (cmd.getExitCode() == 0 ? 1 : 0) != 0);
        UtDevadmTest.assertNotNull((String)"utdevadm returned null", (Object)devices);
        UtDevadmTest.assertTrue((String)"Wrong devices number", (devices.length == 3 ? 1 : 0) != 0);
        System.out.println(cmd.getSyntax());
        for (int i = 0; i < devices.length; ++i) {
            Object[] info = devices[i];
            String serviceName = (String)info[0];
            Boolean status = (Boolean)info[1];
            UtDevadmTest.assertNotNull((String)"Invalid service name", (Object)serviceName);
            UtDevadmTest.assertNotNull((String)"Invalid status", (Object)status);
            if (status.booleanValue()) {
                System.out.println(serviceName + ": ENABLED");
                continue;
            }
            System.out.println(serviceName + ": DISABLED");
        }
    }

    public void testEnableSerialService() throws ServiceException {
        this.enableService("internal_serial");
        UtDevadmTest.assertTrue((boolean)this.isServiceEnabled("internal_serial"));
        this.disableService("internal_serial");
        UtDevadmTest.assertFalse((boolean)this.isServiceEnabled("internal_serial"));
    }

    public void testEnableSmartCardService() throws ServiceException {
        this.enableService("internal_smartcard_reader");
        UtDevadmTest.assertTrue((boolean)this.isServiceEnabled("internal_smartcard_reader"));
        this.disableService("internal_smartcard_reader");
        UtDevadmTest.assertFalse((boolean)this.isServiceEnabled("internal_smartcard_reader"));
    }

    public void testEnableUsbService() throws ServiceException {
        this.enableService("usb");
        UtDevadmTest.assertTrue((boolean)this.isServiceEnabled("usb"));
        this.disableService("usb");
        UtDevadmTest.assertFalse((boolean)this.isServiceEnabled("usb"));
    }

    protected boolean isServiceEnabled(String serviceName) throws ServiceException {
        UtDevadm cmd = new UtDevadm();
        return cmd.isServiceEnabled(serviceName);
    }

    protected void enableService(String serviceName) throws ServiceException {
        UtDevadm cmd = new UtDevadm();
        cmd.enableService(serviceName);
    }

    protected void disableService(String serviceName) throws ServiceException {
        UtDevadm cmd = new UtDevadm();
        cmd.disableService(serviceName);
    }
}

