/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.RemoteCommand;
import com.sun.ut.service.command.Task;

public class UtReader
extends Task {
    public static final String ADD_READER = "-a";
    public static final String REMOVE_READER = "-d";
    private static final String UT_READER_CMD = "/opt/SUNWut/sbin/utreader";
    private static final String FAILED_MESSAGE = "Failed";
    private String operation;
    private String terminalID;

    public UtReader() {
    }

    public UtReader(String operation, String terminalID) {
        this.operation = operation;
        this.terminalID = terminalID;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }

    public String getTerminalID() {
        return this.terminalID;
    }

    public String[] getElements() {
        String[] cmd = new String[]{UT_READER_CMD, this.operation, this.terminalID};
        return cmd;
    }

    public void addReader(String terminal) throws ServiceException {
        this.terminalID = terminal;
        this.operation = ADD_READER;
        RemoteCommand cmd = new RemoteCommand(this.getElements());
        cmd.run();
        if (cmd.getErrorMsg().indexOf(FAILED_MESSAGE) >= 0) {
            throw new ServiceException(null, cmd.getSyntax() + ":" + cmd.getErrorMsg(), -1);
        }
    }

    public void removeReader(String terminal) throws ServiceException {
        this.terminalID = terminal;
        this.operation = REMOVE_READER;
        RemoteCommand cmd = new RemoteCommand(this.getElements());
        cmd.run();
        if (cmd.getErrorMsg().indexOf(FAILED_MESSAGE) >= 0) {
            throw new ServiceException(null, cmd.getSyntax() + ":" + cmd.getErrorMsg(), -1);
        }
    }
}

