/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.RemoteCommand;
import com.sun.ut.service.command.Task;

public class UtReplica
extends Task {
    private static final String UT_REPLICA_CMD = "/opt/SUNWut/sbin/utreplica";
    private static final String LIST_OPTION = "-l";
    private static final String STANDALONE_SERVER_MSG = "No replica";
    private static final String PRIMARY_SERVER_MSG = "is a primary server";
    private static final String SECONDARY_SERVER_MSG = "is a secondary server";
    public static final int UNKNOWN = 0;
    public static final int STANDALONE_SERVER = 1;
    public static final int PRIMARY_SERVER = 2;
    public static final int SECONDARY_SERVER = 4;

    public String[] getElements() {
        String[] cmd = new String[]{UT_REPLICA_CMD, LIST_OPTION};
        return cmd;
    }

    public boolean isReplicated() {
        RemoteCommand cmd = new RemoteCommand(this.getElements());
        cmd.run();
        String out = cmd.getOutputMsg();
        if (out != null) {
            return out.indexOf(STANDALONE_SERVER_MSG) < 0;
        }
        return false;
    }

    public int getReplicationRole(String hostname) throws ServiceException {
        RemoteCommand cmd = new RemoteCommand(hostname, this.getElements());
        cmd.run();
        String out = cmd.getOutputMsg();
        if (cmd.getExitCode() != 0) {
            throw new ServiceException(out, cmd.getSyntax(), cmd.getExitCode());
        }
        if (out != null) {
            if (out.indexOf(PRIMARY_SERVER_MSG) > 0) {
                return 2;
            }
            if (out.indexOf(SECONDARY_SERVER_MSG) > 0) {
                return 4;
            }
            if (out.indexOf(STANDALONE_SERVER_MSG) > 0) {
                return 1;
            }
        }
        return 0;
    }
}

