/*
 * ident	"@(#)utdiskctl.h	1.5	06/08/23 SMI"
 *
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _UTDISKCTL_H
#define	_UTDISKCTL_H

#ifdef	SCCSID
static char *_SCCSid_ = "@(#)utdiskctl.h	1.5 06/08/23 SMI";
#endif	/* defined _SCCSID */

/*
 * UTDISKCTL: This header file describes the interface between the
 * sunray disk kernel module and user-space disk controller processes
 */

#ifdef  __cplusplus
extern "C" {
#endif

/* includes */
#include <linux/ioctl.h>
#if defined(CONFIG_COMPAT) || defined(CONFIG_SPARC64) || defined(CONFIG_X86_64) || defined(CONFIG_PPC64)
#include <asm/uaccess.h>
#include <linux/ioctl32.h>
#include <linux/compat.h>
#endif	/* CONFIG_COMPAT */

/* macro and constant definitions */
#ifndef __WORDSIZE
#error __WORDSIZE not defined
#endif
#if __WORDSIZE == 64
#ifndef _LP64
#define	_LP64	1
#endif
#endif

/* controller names */
#define	UTDISK_DISK_DRV_NAME	"utdisk"
#define	UTDISK_CTL_DRV_NAME	"utdiskctl"

/*
 * number of bytes in a sector, as expected by the kernel
 * Unfortunately, this number is hardcoded all over the kernel
 * We make our own definition & hope we learn of the change in a future kernel
 */
#define	UTDISK_HARDSECT_SIZE_BYTES	512

/*
 * maximum number of minor numbers per disk
 * Note that one minor number will be used to represent the full disk
 */
#define	UTDISK_MINORS_PER_DISK		8

/* maximum partitions per disk */
#define	UTDISK_PARTMAX		UTDISK_MINORS_PER_DISK

#ifndef	UTDISK_OK
#define	UTDISK_OK		0	/* no errors */
#endif

/* Linux note: have to avoid ioctl definitions in <linux/usbdevice_fs.h> */
/* supported ioctls */
#define	UTA_IOC_BASE		'U'
#define	UTDISK_HOTPLUG		_IO(UTA_IOC_BASE, 0x41)
#define	UTDISK_UNPLUG		_IO(UTA_IOC_BASE, 0x42)
#define	UTDISK_MEDIA_CHANGE	_IO(UTA_IOC_BASE, 0x43)
#define	UTDISK_GET_CTL_MAJOR	_IO(UTA_IOC_BASE, 0x44)
#define	UTDISK_GET_DISK_MAJOR	_IO(UTA_IOC_BASE, 0x45)
#define	UTDISK_GET_MESG		_IO(UTA_IOC_BASE, 0x46)
#define	UTDISK_GET_CDB		_IO(UTA_IOC_BASE, 0x47)
#define	UTDISK_DISK_READY	_IO(UTA_IOC_BASE, 0x48)

/* flag to tag above command code with on 32-bit ioctl calls */
#define	UTDISK_32BIT_PTRS	0x800000

/* media state bitflags */
#define	UT_MEDIASTATE_NONE	0x00
#define	UT_MEDIASTATE_EJECTED	0x01
#define	UT_MEDIASTATE_INSERTED	0x02
#define	UT_MEDIASTATE_WRPROT	0x04

/* partition states */
#define	UTDC_PSTATE_UNKNOWN	0	/* do nothing */
#define	UTDC_PSTATE_NEW		1	/* needs minor number */
#define	UTDC_PSTATE_ASSIGNED	2	/* active, do nothing */

/*
 * transaction type bit flags
 * All are mutually exclusive, ok to check for equality instead of masking bits
 */
#define	UTDC_TX_NONE		0x00
#define	UTDC_TX_WRITE		0x01
#define	UTDC_TX_READ		0x02
#define	UTDC_TX_IOCTL		0x04
#define	UTDC_TX_USCSI		0x08	/* uscsi */

/* Transaction return values */
#define	UTDC_TX_OK		0
#define	UTDC_TX_ERROR		1	/* transaction was aborted */

#define UTDC_TX_IOCTL_STATE	1
#define UTDC_TX_IOCTL_EJECT	2

#define UT_USCSI_WRITE		0x00000 /* send data to device */
#define UT_USCSI_READ		0x00008 /* get data from device */
#define UT_USCSI_RQENABLE	0x10000 /* Enable Request Sense extensions */

/* timeout value in seconds */
#ifdef DEBUG
#define UT_SCSI_TIMEOUT		10
#else
#define UT_SCSI_TIMEOUT		60
#endif

/* scsi command default sense buffer size */

#define UTS_DEFAULT_SENSEBUFSIZE	0x12

/* typedefs, structs and unions */

/* user defined scsi command */
struct ut_uscsi_cmd {
	uint32_t	uscsi_flags;	/* read, write, etc. see below */
	uint16_t	uscsi_status;	/* resulting status  */
	uint16_t	uscsi_timeout;	/* Command Timeout */
	char		*uscsi_cdb;	/* cdb to send to target */
	char		*uscsi_bufaddr;	/* i/o source/destination */
	uint32_t 	uscsi_buflen;	/* size of i/o to take place */
	uint32_t	uscsi_resid;	/* resid from i/o operation */
	unsigned char	uscsi_cdblen;	/* # of valid cdb bytes */
	unsigned char	uscsi_rqlen;	/* size of uscsi_rqbuf */
	unsigned char	uscsi_rqstatus;	/* status of request sense cmd */
	unsigned char	uscsi_rqresid;	/* resid of request sense cmd */
	char		*uscsi_rqbuf;	/* request sense buffer */
	void		*uscsi_reserved_5;
};

typedef struct ut_uscsi_cmd	ut_uscsi_cmd_t;

/* some data types unavailable in Linux today */
typedef unsigned int	uint_t;
#ifndef	 __UT_NEED_MAJOR_MINOR_T
typedef int		major_t;
typedef int		minor_t;
#endif	/* __UT_NEED_MAJOR_MINOR_T */

/* transaction info expected from client */
typedef struct utdc_tx_s {
	uint32_t	offset;		/* block number from LUN block 0 ... */
					/* blksz = UTDISK_HARDSECT_SIZE_BYTES */
	uint32_t	nblock;		/* in UTDISK_HARDSECT_SIZE_BYTES blocks */
	char		*cdb;		/* buf for uscsi cdb */
	char 		*uscsi;		/* buf for uscsi cmd */
	uint32_t	cdblen;		/* size of cdb */
	uint32_t	type;		/* type flags defined above */
	uint32_t	cmd;		/* ioctl cmd or prev tx.type */
	uint32_t	resid;		/* data residue */
	uint32_t	ret;		/* return value */
} utdc_tx_t;


#ifdef	_LP64

/* 32bit version of ut_uscsi_cmd */
struct ut_uscsi_cmd32 {
	uint32_t	uscsi_flags;	/* read, write, etc. see below */
	uint16_t	uscsi_status;	/* resulting status  */
	uint16_t	uscsi_timeout;	/* Command Timeout */
	uint32_t	uscsi_cdb;	/* cdb to send to target */
	uint32_t	uscsi_bufaddr;	/* i/o source/destination */
	uint32_t 	uscsi_buflen;	/* size of i/o to take place */
	uint32_t	uscsi_resid;	/* resid from i/o operation */
	unsigned char	uscsi_cdblen;	/* # of valid cdb bytes */
	unsigned char	uscsi_rqlen;	/* size of uscsi_rqbuf */
	unsigned char	uscsi_rqstatus;	/* status of request sense cmd */
	unsigned char	uscsi_rqresid;	/* resid of request sense cmd */
	uint32_t	uscsi_rqbuf;	/* request sense buffer */
	uint32_t	uscsi_reserved_5;
};

typedef struct ut_uscsi_cmd32	ut_uscsi_cmd32_t;

/* 32bit version of utdc_tx_t */
typedef struct utdc_tx32_s {
	uint32_t	offset;		/* block number from LUN block 0 ... */
					/* blksz = UTDISK_HARDSECT_SIZE_BYTES */
	uint32_t	nblock;		/* in UTDISK_HARDSECT_SIZE_BYTES blocks */
	uint32_t	cdb;		/* buf for uscsi cdb */
	uint32_t 	uscsi;		/* buf for uscsi cmd */
	uint32_t	cdblen;		/* size of cdb */
	uint32_t	type;		/* type flags defined above */
	uint32_t	cmd;		/* ioctl cmd or prev tx.type */
	uint32_t	resid;		/* data residue */
	uint32_t	ret;		/* return value */
} utdc_tx32_t;

#endif	/* _LP64 */


/* partition map */
typedef struct utdc_pmap_s {
	uint32_t	pstart_abs;	/* starting block number w.r.t ... */
					/*  .. absolute blk zero */
	uint32_t	psize;		/* # of blocks (UT_SYS_BLOCKSIZE) */
	minor_t		mnum;		/* minor number */
	uint32_t	state;		/* see UTDC_PSTATE_ defs */
} utdc_pmap_t;


/* device parameters */
typedef struct utdc_diskinfo_s {
	uint32_t	block_size;	/* target device block size */
	uint32_t	nblock;		/* number of block_size Byte blocks */
	minor_t		ctlmin;		/* controller minor number */
	utdc_pmap_t	pmap[UTDISK_PARTMAX];	/* unused by kernel */
	uint32_t	removable;	/* whether removable media drive */
	uid_t		owner;
	uint32_t	media_state;
} utdc_diskinfo_t;


/* public function prototypes */

/* external variable declarations */


#ifdef __cplusplus
}
#endif	/* defined __cplusplus */

#endif	/* _UTDISKCTL_H */
