<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/Util.js"/>
                </ui:head>    
                <ui:body focus="f1:p1:a1:s1:p1:i1_editable_required"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="dtus"/>
                        <ui:alert binding ="#{statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.dtu_newDialog_pageTitle}" 
                                             helpText="#{msg.dtu_newDialog_pageHelpText}">

                            <f:facet name="pageButtonsTop">
                                <ui:panelGroup> 
                                    <ui:button id="ok_submit"
                                               text="#{msg.ok_button}"
                                               primary="true"
                                               action="#{newDtu.save}"
                                               toolTip="#{msg.dtu_newDialog_ok_tooltip}"
                                               alt="#{msg.ok_button_alt}"/>
                                    <ui:button id="cancel"
                                               text="#{msg.cancel_button}"
                                               action="viewDesktopUnits"
                                               immediate="true"
                                               toolTip="#{msg.dtu_newDialog_cancel_tooltip}"
                                               alt="#{msg.cancel_button_alt}"/> 
                                </ui:panelGroup> 
                            </f:facet> 

                            <ui:propertySheet id="a1"
                                              jumpLinks="false" 
                                              requiredFields="true">

                                <ui:propertySheetSection id="s1" 
                                                         label="#{msg.dtu_general_section}">
                                    <ui:property id="p1"
                                                 label="#{msg.dtu_identifier}" 
                                                 labelAlign="right"
                                                 helpText="#{msg.dtu_identifier_helpText}">
                                        <ui:textField id="i1_editable_required"
                                                      text="#{newDtu.id}" 
                                                      columns="50" 
                                                      required="true"
                                                      onKeyUp="javascript: setTimeout('toggleNewButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleNewButtons()', 0);"
                                                      toolTip="#{msg.dtu_identifier_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p2"
                                                 label="#{msg.dtu_location}"
                                                 labelAlign="right">
                                        <ui:textField id="i2_editable"
                                                      text="#{newDtu.location}" 
                                                      columns="50"
                                                      onKeyUp="javascript: setTimeout('toggleNewButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleNewButtons()', 0);"
                                                      toolTip="#{msg.dtu_location_tooltip}"/>
                                    </ui:property>
                                    <ui:property id="p3"
                                                 label="#{msg.dtu_description}" 
                                                 labelAlign="right">
                                        <ui:textField id="i3_editable"
                                                      text="#{newDtu.description}" 
                                                      columns="50"
                                                      onKeyUp="javascript: setTimeout('toggleNewButtons()', 0);"
                                                      onChange="javascript: setTimeout('toggleNewButtons()', 0);"
                                                      toolTip="#{msg.dtu_description_tooltip}"/>
                                        <f:verbatim><br/><br/></f:verbatim>
                                    </ui:property>
                                </ui:propertySheetSection>
                            </ui:propertySheet>
                        </ui:contentPageTitle> 
                        <ui:script>
                            <f:verbatim>
                                initValues();
                                toggleNewButtons()
                            </f:verbatim>
                        </ui:script>
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 

