<?xml version="1.0" encoding="UTF-8"?>
<!-- ident "$Id$ SMI" -->

<!-- Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
     Use is subject to license terms. -->
     
<jsp:root version="1.2" 
          xmlns:f="http://java.sun.com/jsf/core" 
          xmlns:h="http://java.sun.com/jsf/html" 
          xmlns:jsp="http://java.sun.com/JSP/Page" 
          xmlns:ui="http://www.sun.com/web/ui">
    <jsp:directive.page contentType="text/html;charset=UTF-8" 
                        pageEncoding="UTF-8"/>
    <f:view>
        <f:loadBundle basename="com.sun.ut.console.resource.ConsoleLabels" var="msg"/>
        <ui:page>
            <ui:html>
                <ui:head title="#{login.serverName} - #{msg.default_pageTitle}">
                    <ui:meta name="Copyright" content="#{msg.meta_copyright}"/>
                    <ui:script url="../../js/DesktopUnit.js"/>
                </ui:head>    
                <ui:body focus="f1:p1:z1"> 
                    <ui:form id="f1">
                        <jsp:directive.include file="../misc/Masthead.jsp"/>
                        <ui:tabSet binding="#{tabs.tabSet}" selected="dtus"/>
                        <ui:alert binding ="#{dtuSearchHandler.statusMessage.alert}"/>

                        <ui:contentPageTitle id="p1" 
                                             title="#{msg.dtus_search_pageTitle}"
                                             helpText="#{msg.dtus_search_pageHelpText}">
                            <ui:markup tag="div" styleClass="ConMgn">
                                <f:verbatim><br/></f:verbatim>

                                <ui:dropDown id="z1"
                                             items="#{dtuSearchCriteria.options}" 
                                             selected="#{dtuSearchCriteria.filter}"
                                             toolTip="#{msg.dtu_searchCriteria_options_tooltip}"/> 
                                <ui:textField id="z2"
                                              text="#{dtuSearchCriteria.searchString}" 
                                              columns="40"
                                              toolTip="#{msg.dtu_searchCriteria_searchString_tooltip}"/>
                                <ui:staticText text="&#160;" escape="false"/>
                                <ui:button id="search"
                                           text="#{msg.search_button}" 
                                           primary="true"
                                           action="#{dtuSearchHandler.search}"
                                           toolTip="#{msg.dtu_search_button_tooltip}"
                                           alt="#{msg.search_button_alt}"/>

                                <f:verbatim><br/><br/></f:verbatim>

                                <ui:label text="#{msg.search_criteria}"/>
                                <ui:staticText id="s1" text="#{dtuSearchCriteria.description}"/> 
                                <ui:staticText text="&#160;" escape="false"/>
                                <ui:button id="b1" 
                                           text="#{msg.reset_search_button}"
                                           action="viewDesktopUnits"
                                           toolTip="#{msg.dtu_reset_search_tooltip}"
                                           alt="#{msg.reset_search_button_alt}"/>
                                <f:verbatim><br/><br/></f:verbatim>

                                <ui:table id="t1"
                                          title="#{dtuSearchHandler.title}" 
                                          paginateButton="true"
                                          paginationControls="true"
                                          selectMultipleButton="#{dtuSearchHandler.selectable}"
                                          selectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          deselectMultipleButton="#{dtuSearchHandler.selectable}"
                                          deselectMultipleButtonOnClick="setTimeout('disableActions()', 0)"
                                          clearSortButton="true"
                                          summary="#{msg.dtu_table_search_summary}"
                                          toolTip="#{dtuSearchHandler.tableTooltip}">

                                    <ui:tableRowGroup sourceData="#{dtuSearchHandler.dtus}" 
                                                      rows="20"
                                                      sourceVar="dtuRowGroup"
                                                      binding="#{dtuSearchHandler.tableRowGroup}"
                                                      selected="#{dtuSearchHandler.selectHelper.selectedState}">

                                        <!-- Selection column -->
                                        <ui:tableColumn extraHeaderHtml="nowrap='nowrap'" 
                                                        extraFooterHtml="nowrap='nowrap'"
                                                        extraTableFooterHtml="nowrap='nowrap'"
                                                        selectId="select"
                                                        visible="#{dtuSearchHandler.selectable}">
                                            <ui:checkbox id="select" 
                                                         onClick="setTimeout('initAllRows();disableActions()', 0)"
                                                         selected="#{dtuSearchHandler.selectHelper.selected}"
                                                         selectedValue="#{dtuSearchHandler.selectHelper.selectedValue}"
                                                         toolTip="#{msg.dtu_table_selectedValue_tooltip}"/>
                                        </ui:tableColumn>

                                        <!-- Identifier column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_identifier_header}"
                                                        rowHeader="true"
                                                        sort="id"
                                                        style="width: 12%;">
                                            <ui:hyperlink text="#{dtuRowGroup.value.id}" 
                                                          action="#{dtuSearchHandler.viewProperties}"
                                                          immediate="true"
                                                          toolTip="#{msg.dtu_table_value_tooltip}">
                                                <f:param name="id" 
                                                         value="#{dtuRowGroup.value.id}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>

                                        <!-- Location column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_location_header}" 
                                                        rowHeader="true" 
                                                        sort="location"
                                                        style="width: 25%;">
                                            <ui:staticText text="#{dtuRowGroup.value.location}"/>
                                        </ui:tableColumn>

                                        <!-- Description column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_description_header}" 
                                                        sort="description"
                                                        rowHeader="true">
                                            <ui:staticText text="#{dtuRowGroup.value.description}"/>
                                        </ui:tableColumn>
                                        
                                        <!-- Server column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_server_header}"
                                                        sort="server"
                                                        rendered="#{dtuSearchHandler.currentDTUs}"
                                                        rowHeader="true">
                                                <ui:hyperlink text="#{dtuRowGroup.value.server}"
                                                          action="#{dtuSearchHandler.viewServer}"
                                                          immediate="true">
                                                <f:param name="server_id"
                                                         value="#{dtuRowGroup.value.server}"/>
                                            </ui:hyperlink>
                                        </ui:tableColumn>
                                        
                                        <!-- Multihead Group column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_multihead_header}"
                                                        style="width: 25%;"
                                                        rendered="#{dtuSearchHandler.multiheadGroups}">
                                            <ui:tableColumn headerText="#{msg.servers_table_name_header}" 
                                                            sort="#{dtuRowGroup.value.multiheadGroup.name}"
                                                            rowHeader="true"
                                                            style="width: 13%;"
                                                            rendered="#{dtuSearchHandler.multiheadGroups}">

                                                <ui:staticText text="#{dtuRowGroup.value.multiheadGroup.name}"/>
                                            </ui:tableColumn>
                                            <ui:tableColumn headerText="#{msg.dtus_table_geometry_header}" 
                                                            sort="#{dtuRowGroup.value.multiheadGroup.geometry}"
                                                            rowHeader="true"
                                                            style="width: 12%;"
                                                            rendered="#{dtuSearchHandler.multiheadGroups}">
                                                <ui:staticText text="#{dtuRowGroup.value.multiheadGroup.geometry}"/>
                                            </ui:tableColumn>
                                        </ui:tableColumn>

                                        <!-- Client Key Status column -->
                                        <ui:tableColumn headerText="#{msg.dtus_table_status_header}" 
                                                        sort="clientKeyStatus"
                                                        rowHeader="true">
                                            <ui:staticText text="#{msg.dtu_keys_none}" rendered="#{dtuRowGroup.value.clientKeyNew}"/>
                                            <ui:staticText text="#{msg.dtu_keys_confirmed}" rendered="#{dtuRowGroup.value.clientKeyConfirmed}"/>
                                            <ui:staticText text="#{msg.dtu_keys_unconfirmed}" rendered="#{dtuRowGroup.value.clientKeyUnconfirmed}"/>
                                            <ui:staticText text="#{msg.dtu_keys_autoconfirmed}" rendered="#{dtuRowGroup.value.clientKeyAutomatic}"/>
                                            <ui:staticText text="#{msg.dtu_keys_conflict}" rendered="#{dtuRowGroup.value.clientKeyConflicting}"/> 
                                            <ui:staticText text="#{msg.dtu_keys_invalid}" rendered="#{dtuRowGroup.value.clientKeyInvalid}"/>    
                                        </ui:tableColumn>
                                    </ui:tableRowGroup>
                                    <!-- Action buttons -->
                                    <f:facet name="actionsTop">
                                        <f:subview id="actionsTop" 
                                            rendered="#{dtuSearchHandler.selectable}">
                                            <ui:button id="new"
                                                       disabled="false"
                                                       text="#{msg.new_button}"
                                                       action="newDesktopUnit"
                                                       immediate="true"
                                                       toolTip="#{msg.dtu_new_button_tooltip}"
                                                       alt="#{msg.new_button_alt}"/>
                                            <ui:button id="delete"
                                                       disabled="true"
                                                       text="#{msg.delete_button}" 
                                                       action="#{dtuSearchHandler.delete}"
                                                       onClick="if (confirmDeleteSelectedRows() == false) return false"
                                                       toolTip="#{msg.dtu_delete_button_tooltip}"
                                                       alt="#{msg.delete_button_alt}"/>
                                        </f:subview>
                                    </f:facet>
                                </ui:table>

                            </ui:markup>
                        </ui:contentPageTitle> 
                    </ui:form>
                </ui:body>
            </ui:html>    
        </ui:page>
    </f:view>
</jsp:root> 


