<!--
 - Copyright (C) 2005  Internet Systems Consortium, Inc. ("ISC")
 -
 - Permission to use, copy, modify, and distribute this software for any
 - purpose with or without fee is hereby granted, provided that the above
 - copyright notice and this permission notice appear in all copies.
 -
 - THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 - REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 - AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 - INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 - LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 - OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 - PERFORMANCE OF THIS SOFTWARE.
-->

<!-- $Id: isc-docbook-latex.xsl.in,v 1.2.10.2 2005/05/13 01:22:35 marka Exp $ -->

<!-- ISC customizations for db2latex generator -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- Import the db2latex stuff -->
  <xsl:import href="db2latex/xsl/docbook.xsl"/>

  <!-- Blank lines between paragraphs, please -->
  <xsl:param name="latex.use.parskip" select="1"/>

  <!-- Least bad current option for constructing tables -->
  <xsl:param name="latex.use.ltxtable" select="1"/>
  <xsl:param name="latex.use.longtable" select="1"/>

  <!-- LaTeX2e documentclass options. -->
  <xsl:param name="latex.documentclass.common" select="''"/>

  <!-- This documentation is in English (or maybe Bad English) -->
  <xsl:param name="latex.babel.language" select="'english'"/>
  <xsl:param name="l10n.gentext.default.language" select="'en'"/>

  <!-- Where to find "admonition" graphics -->
  <xsl:param name="admon.graphics.path" select="'db2latex/xsl/figures'"/>

  <!-- ANSI C function prototypes, please -->
  <xsl:param name="funcsynopsis.style">ansi</xsl:param>

  <!-- Patch around db2latex (0.8pre1) bug -->
  <xsl:template match="copyright/year">
    <xsl:apply-templates />
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- Include our copyright generator -->
  <xsl:include href="copyright.xsl"/>

  <!-- Set comment convention for this output format -->
  <xsl:param name="isc.copyright.leader">% </xsl:param>

  <!-- Intercept top level to prepend copyright -->
  <xsl:template match="/">
    <xsl:value-of select="$isc.copyright"/>
    <xsl:apply-imports/>
  </xsl:template>

  <!--
    - Add support for multiple <para/> elements in a table entry.
    - db2latex is already typesetting the table entry as a parbox,
    - so we just have to insert the paragraph breaks.
    -->
  <xsl:template match="tbody/row/entry/para[position() != last()]">
    <xsl:apply-imports/>
    <xsl:text> \par </xsl:text>
  </xsl:template>

</xsl:stylesheet>

<!-- 
  - Local variables:
  - mode: sgml
  - End:
 -->
