<!--
 - Copyright (C) 2005, 2007, 2010  Internet Systems Consortium, Inc. ("ISC")
 -
 - Permission to use, copy, modify, and/or distribute this software for any
 - purpose with or without fee is hereby granted, provided that the above
 - copyright notice and this permission notice appear in all copies.
 -
 - THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 - REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 - AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 - INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 - LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 - OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 - PERFORMANCE OF THIS SOFTWARE.
-->

<!-- $Id: isc-docbook-latex.xsl.in,v 1.9 2010-04-20 23:51:12 tbox Exp $ -->

<!-- ISC customizations for db2latex generator -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- Import the db2latex stuff -->
  <xsl:import href="db2latex/xsl/docbook.xsl"/>

  <!-- Blank lines between paragraphs, please -->
  <xsl:param name="latex.use.parskip" select="1"/>

  <!-- Least bad current option for constructing tables -->
  <xsl:param name="latex.use.ltxtable" select="1"/>
  <xsl:param name="latex.use.longtable" select="1"/>

  <!-- LaTeX2e documentclass options. -->
  <xsl:param name="latex.documentclass.common"/>
  <xsl:param name="latex.documentclass.book">10pt,twoside,openright</xsl:param>

  <!-- This documentation is in English (or maybe Bad English) -->
  <xsl:param name="latex.babel.language" select="'english'"/>
  <xsl:param name="l10n.gentext.default.language" select="'en'"/>

  <!-- Where to find "admonition" graphics -->
  <xsl:param name="admon.graphics.path" select="'db2latex/xsl/figures'"/>

  <!-- ANSI C function prototypes, please -->
  <xsl:param name="funcsynopsis.style">ansi</xsl:param>

  <!-- Local modifications to db2latex's mapping rules -->
  <xsl:param name="latex.mapping.xml" select="document('isc-docbook-latex-mappings.xml')"/>

  <!-- Patch around db2latex (0.8pre1) bug -->
  <xsl:template match="copyright/year">
    <xsl:apply-templates />
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- Include our copyright generator -->
  <xsl:include href="copyright.xsl"/>

  <!-- Set comment convention for this output format -->
  <xsl:param name="isc.copyright.leader">% </xsl:param>

  <!-- Intercept top level to prepend copyright -->
  <xsl:template match="/">
    <xsl:value-of select="$isc.copyright"/>
    <xsl:apply-imports/>
  </xsl:template>

  <!--
    - Add support for multiple <para/> elements in a table entry.
    - db2latex is already typesetting the table entry as a parbox,
    - so we just have to insert the paragraph breaks.
   -->
  <xsl:template match="tbody/row/entry/para[position() != last()]">
    <xsl:apply-imports/>
    <xsl:text> \par </xsl:text>
  </xsl:template>

  <!-- 
    - Add support for <optional/> in <programlisting/>.
   -->
  <xsl:template match="optional" mode="latex.verbatim">
    <xsl:text>[</xsl:text>
    <xsl:apply-templates mode="latex.verbatim"/>
    <xsl:text>]</xsl:text>
  </xsl:template>

  <!--
    - Customize the title page.  Are we having fun yet?
    -
    - NB: filename of graphic specified without extension.
    - LaTeX includes file.eps, PDFLaTeX includes file.pdf.
    -
    - Spacing and font sizes could probably use some work.
   -->
  <xsl:param name="latex.maketitle">
    <xsl:text>
      \begin{titlepage}
        \null\vfil
        \vskip 60pt
        \begin{center}%
          { %\LARGE
	    \Huge
	    \bfseries
            </xsl:text>
	    <xsl:for-each select="/book/title">
	      <xsl:call-template name="text"/>
	    </xsl:for-each>
            <xsl:text>
            \par}%
          \vskip 3em%
          { %\large
	    \Large
            \lineskip .75em%
            </xsl:text>
	    <xsl:for-each select="/book/bookinfo/releaseinfo[1]">
	      <xsl:call-template name="text"/>
	    </xsl:for-each>
            <xsl:text>
            \par}
          %\vskip 1.5em%
	  \vfil
	  % Not sure exactly how much to trim logo, but given that
	  % this is a centered environment, we need not be too precise
	  % so long as the image is centered in the input PDF, we
	  % trim enough for it to fit on page, and we do not trim
	  % so much that we clip out part of the graphic itself.
	  % This seems to work, anyway.
	  \includegraphics[trim=400 400 400 400,scale=2.5]{isc-logo}
        \end{center}\par
        \vfil\null
      \end{titlepage}
    </xsl:text>
    <xsl:text>&#10;</xsl:text>
  </xsl:param>

  <!--
    - More front matter: copyright notice, CVS revision number, table
    - of contents.
   -->
  <xsl:template match="book/bookinfo">
    <xsl:text>\thispagestyle{empty}&#10;</xsl:text>
    <xsl:apply-imports/>
    <xsl:text>\begin{center}&#10;</xsl:text>
    <xsl:value-of select="$isc.copyright.text"/>
    <xsl:text>\end{center}&#10;</xsl:text>
    <xsl:for-each select="/book/bookinfo/releaseinfo[position() &gt; 1]">
      <xsl:text>\begin{center}</xsl:text>
      <xsl:call-template name="text"/>
      <xsl:text>\end{center}&#10;</xsl:text>
    </xsl:for-each>
    <xsl:text>
      \vfill
      \begin{center}
      Internet System Consortium \\
      950 Charter Street \\
      Redwood City, California \\
      USA \\
      http://www.isc.org/
      \end{center}
    </xsl:text>
    <xsl:text>
      \newpage
      \pagenumbering{roman}
      \tableofcontents
      \newpage
      \pagenumbering{arabic}
    </xsl:text>
  </xsl:template>

  <!--
    - Try to avoid some weird looking line breaks.
    -
    - This doesn't really work right, so disable for now.
   -->
  <xsl:template match="literal" mode="disabled">
    <xsl:text>\mbox{</xsl:text>
    <xsl:apply-imports/>
    <xsl:text>}</xsl:text>
  </xsl:template>

</xsl:stylesheet>

<!-- 
  - Local variables:
  - mode: sgml
  - End:
 -->
