
#ifndef _GPIO_ADAPTER_H_
#define _GPIO_ADAPTER_H_

#define Hi 1
#define Lo 0

enum {
	GERENAL = 0,
	I2C,
};

enum {
	INPUT_DIR = 0,
	OUTPUT_DIR,
};

enum {
	NONE = 0,
	LOW_LEV = 1,
	HIGH_LEV ,
	FALLING_EDGE ,
	RISING_EDGE ,
};

enum {
	MOD_7 = 7,
	MOD_8,
	MOD_9 = 9,
};

enum {
	PORT_A = 0,
	PORT_B = 1,
	PORT_C = 2,
	PORT_D = 3,
};

typedef struct
{
	unsigned int pin_index;		
	unsigned int adapter_type;
	unsigned int port_no;
	unsigned int port_mod;
	unsigned int pin_no;
	unsigned int dir;
	unsigned int interrupt;
	unsigned int init_value;
}PinInfo;



#define GPIO_MAJOR_NO 243
#define GPIO_MINOR_NO 0

enum {
	PORT_DATA_WRITE = 0,
	PORT_DATA_READ,
	PORT_STATUS_WRITE,
	PORT_STATUS_READ,
	PORT_DIR_WRITE,
	PORT_DIR_READ,
	PORT_IER_WRITE,
	PORT_IER_READ,
	PORT_INST0_WRITE,
	PORT_INST0_READ,
	PORT_INST1_WRITE,
	PORT_INST1_READ,
	PORT_INST2_WRITE,
	PORT_INST2_READ,
};	

typedef struct
{
	unsigned char cmd;
	unsigned char port_no;
	unsigned char value;
}PortInfo;

#define ASPEED_GPIO_IOC_MAGIC  'g'
#define IOCTL_CTRL		_IOWR(ASPEED_GPIO_IOC_MAGIC,  1, PortInfo)

#define PCA9555
#define I2C_CHANNEL_ADDR 0x42
#define I2C_CHANNEL 4 


#define cr_singal opma_cr_singal 
enum {
	FAULT_LED_L, 
	CHASSIS_ID_L, 
	MCARD_PWRBTN_L, 
	MCARD_RSTBTN_L, 
	MCARD_NMIBTN_L, 
	MCARD_LOCAL_LOCK_L, 
	MCARD_CLR_CMOS_L, 
	MCARD_SYS_SPKR_L, 
	MCARD_SCI_INT_L, 
	MCARD_AUX_SOL_CTRL_L, 
	MCARD_ID0, 
	MCARD_ID1, 
	MCARD_ID2, 
	MCARD_DETECT_L, 
	M3_LED,

	PWROK, 
	MCARD_THERMTRIP_L, 
	MCARD_INTRUDER_L, 
	SYS_LINE_AC_L, 
	SYS_PWRBTN_L, 
	SYS_RSTBTN_L, 
	SYS_NMIBTN_L, 
	SYS_SMI_L, 
	SYS_PCI_RST_L, 
	SYS_ACPI_STATE0, 
	SYS_ACPI_STATE1, 
	SYS_ACPI_STATE2, 
	SYS_SMBUS_IO_EXP_INTR_L, 
};

#ifndef IP1500A_2
const PinInfo opma_cr_singal[] = {
	{FAULT_LED_L,			I2C	,	PORT_B,	MOD_8,	4,	OUTPUT_DIR,	NONE,	1},
	{CHASSIS_ID_L,			I2C,		PORT_A,	MOD_8,	1,	OUTPUT_DIR,	NONE,	1},
	{MCARD_PWRBTN_L,		GERENAL,	PORT_B,	MOD_8,	7,	OUTPUT_DIR,	NONE,	1},
	{MCARD_RSTBTN_L,		I2C	,	PORT_A,	MOD_8,	6,	OUTPUT_DIR,	NONE,	1},
	{MCARD_NMIBTN_L,		I2C,		PORT_B,	MOD_8,	2,	OUTPUT_DIR,	NONE,	1},
	{MCARD_LOCAL_LOCK_L,		I2C,		PORT_A,	MOD_8,	2,	OUTPUT_DIR,	NONE,	1},
	{MCARD_CLR_CMOS_L,		GERENAL,	PORT_A,	MOD_8,	4,	OUTPUT_DIR,	NONE,	1},
	{MCARD_SYS_SPKR_L,		GERENAL,	PORT_A,	MOD_8,	5,	OUTPUT_DIR,	NONE,	1},
	{MCARD_SCI_INT_L,		I2C,		PORT_B,	MOD_8,	3,	OUTPUT_DIR,	NONE,	1},
	{MCARD_AUX_SOL_CTRL_L,		I2C,		PORT_B,	MOD_8,	5,	OUTPUT_DIR,	NONE,	1},
	{MCARD_ID0,			I2C,		PORT_A,	MOD_8,	7,	OUTPUT_DIR,	NONE,	1},
	{MCARD_ID1,			I2C,		PORT_B,	MOD_8,	0,	OUTPUT_DIR,	NONE,	1},
	{MCARD_ID2,			I2C,		PORT_B,	MOD_8,	1,	OUTPUT_DIR,	NONE,	1},
	{MCARD_DETECT_L,		GERENAL,	PORT_C,	MOD_8,	4,	OUTPUT_DIR,	NONE,	1},
	{M3_LED,			I2C,		PORT_A,	MOD_8,	0,	OUTPUT_DIR,	NONE,	1}, 
	{PWROK,				GERENAL,	PORT_D,	MOD_8,	7,	INPUT_DIR,	NONE,	1},
	{MCARD_THERMTRIP_L,		GERENAL,	PORT_D,	MOD_8,	6,	INPUT_DIR,	NONE,	1},
	{MCARD_INTRUDER_L,		GERENAL,	PORT_C,	MOD_8,	3,	INPUT_DIR,	NONE,	1},
	{SYS_LINE_AC_L,			GERENAL,	PORT_B,	MOD_8,	4,	INPUT_DIR,	NONE,	1},
	{SYS_PWRBTN_L,			GERENAL,	PORT_C,	MOD_8,	5,	INPUT_DIR,	NONE,	1},
	{SYS_RSTBTN_L,			GERENAL,	PORT_B,	MOD_8,	2,	INPUT_DIR,	NONE,	1},
	{SYS_NMIBTN_L,			GERENAL,	PORT_B,	MOD_8,	3,	INPUT_DIR,	NONE,	1},
	{SYS_SMI_L,			GERENAL,	PORT_B,	MOD_8,	5,	INPUT_DIR,	NONE,	1},
	{SYS_PCI_RST_L,			GERENAL,	PORT_B,	MOD_8,	1,	INPUT_DIR,	NONE,	1},
	{SYS_ACPI_STATE0,		I2C,		PORT_A,	MOD_8,	3,	INPUT_DIR,	NONE,	1},
	{SYS_ACPI_STATE1,		I2C,		PORT_A,	MOD_8,	4,	INPUT_DIR,	NONE,	1},
	{SYS_ACPI_STATE2,		I2C,		PORT_A,	MOD_8,	5,	INPUT_DIR,	NONE,	1},
	{SYS_SMBUS_IO_EXP_INTR_L,	GERENAL,	PORT_C,	MOD_8,	2,	INPUT_DIR,	NONE,	1},

};
#else
const PinInfo opma_cr_singal[] = {
	{FAULT_LED_L,			GERENAL,	PORT_B,	MOD_8,	6,	OUTPUT_DIR,	NONE,	1},
	{CHASSIS_ID_L,			I2C,		PORT_A,	MOD_8,	1,	OUTPUT_DIR,	NONE,	1},
	{MCARD_PWRBTN_L,		GERENAL,	PORT_B,	MOD_8,	7,	OUTPUT_DIR,	NONE,	1},
	{MCARD_RSTBTN_L,		GERENAL,	PORT_C,	MOD_8,	2,	OUTPUT_DIR,	NONE,	1},
	{MCARD_NMIBTN_L,		GERENAL,	PORT_C,	MOD_8,	3,	OUTPUT_DIR,	NONE,	1},
	{MCARD_LOCAL_LOCK_L,		GERENAL,	PORT_B,	MOD_8,	1,	OUTPUT_DIR,	NONE,	1},
	{MCARD_CLR_CMOS_L,		GERENAL,	PORT_A,	MOD_8,	4,	OUTPUT_DIR,	NONE,	1},
	{MCARD_SYS_SPKR_L,		GERENAL,	PORT_A,	MOD_8,	5,	OUTPUT_DIR,	NONE,	1},
	{MCARD_SCI_INT_L,		I2C,		PORT_B,	MOD_8,	3,	OUTPUT_DIR,	NONE,	1},
	{MCARD_AUX_SOL_CTRL_L,		I2C,		PORT_B,	MOD_8,	5,	OUTPUT_DIR,	NONE,	1},
	{MCARD_ID0,			I2C,		PORT_A,	MOD_8,	7,	OUTPUT_DIR,	NONE,	1},
	{MCARD_ID1,			I2C,		PORT_B,	MOD_8,	0,	OUTPUT_DIR,	NONE,	1},
	{MCARD_ID2,			I2C,		PORT_B,	MOD_8,	1,	OUTPUT_DIR,	NONE,	1},
	{MCARD_DETECT_L,		GERENAL,	PORT_C,	MOD_8,	4,	OUTPUT_DIR,	NONE,	1},
	{M3_LED,			I2C,		PORT_A,	MOD_8,	0,	OUTPUT_DIR,	NONE,	1}, 
	{PWROK,				GERENAL,	PORT_D,	MOD_8,	7,	INPUT_DIR,	NONE,	1},
	{MCARD_THERMTRIP_L,		GERENAL,	PORT_D,	MOD_8,	6,	INPUT_DIR,	NONE,	1},
	{MCARD_INTRUDER_L,		I2C,		PORT_B,	MOD_8,	2,	INPUT_DIR,	NONE,	1},
	{SYS_LINE_AC_L,			GERENAL,	PORT_B,	MOD_8,	4,	INPUT_DIR,	NONE,	1},
	{SYS_PWRBTN_L,			GERENAL,	PORT_C,	MOD_8,	5,	INPUT_DIR,	NONE,	1},
	{SYS_RSTBTN_L,			GERENAL,	PORT_B,	MOD_8,	2,	INPUT_DIR,	NONE,	1},
	{SYS_NMIBTN_L,			GERENAL,	PORT_B,	MOD_8,	3,	INPUT_DIR,	NONE,	1},
	{SYS_SMI_L,			GERENAL,	PORT_B,	MOD_8,	5,	INPUT_DIR,	NONE,	1},
	{SYS_PCI_RST_L,			I2C,		PORT_A,	MOD_8,	2,	INPUT_DIR,	NONE,	1},
	{SYS_ACPI_STATE0,		I2C,		PORT_A,	MOD_8,	3,	INPUT_DIR,	NONE,	1},
	{SYS_ACPI_STATE1,		I2C,		PORT_A,	MOD_8,	4,	INPUT_DIR,	NONE,	1},
	{SYS_ACPI_STATE2,		I2C,		PORT_A,	MOD_8,	5,	INPUT_DIR,	NONE,	1},
	{SYS_SMBUS_IO_EXP_INTR_L,	I2C,		PORT_A,	MOD_8,	6,	INPUT_DIR,	NONE,	1},

};
#endif

#ifndef __KERNEL__
STATUS PltGPIO_Init(void);
STATUS PltGPIO_Read(int pin_index, unsigned char *value);
STATUS PltGPIO_Write(int pin_index, unsigned char *value);
#endif

#endif






