
#ifdef IPMI_FW_FIREWALL
#ifndef	_FIREWALL_H_
#define	_FIREWALL_H_

#include <type.h>
#include <IPMI.h>
#include <msgbuf.h>
#include "firewallrule.h"


#define	IPMI_ERRATA				0x01
#define	IPMI_REVERSION			0x01

#define FIREWALL_NO_SUBFN		0x00
#define FIREWALL_SUCCESS		0x01

#define MAX_SUBFN_BYTES			4



#define NO_FWFIREWALL_DEF_IPMB


typedef struct
{
	const BYTE				NetFn;
	const BYTE				LUN;
	const BYTE				FFSUPCMD_Table[32];
	const BYTE				FFCFGCMD_Table[32];
	
	BYTE					FFCMD_Table[32];

}St_FIREWALL_SUP_CFG_DATATag;

typedef struct
{
	St_FIREWALL_SUP_CFG_DATATag		Firewall_data;
	BYTE							Body_IANA[3];
}St_FIREWALL_IANA_DATATag;

typedef struct
{
	St_FIREWALL_IANA_DATATag	*ChannelTbl;
}St_FIREWALL_IANA_CHNLTBLTag;

typedef struct
{
	BYTE						ChannelNum;
	BYTE						TblLength;
	St_FIREWALL_SUP_CFG_DATATag	*ChannelTbl;
}St_FIREWALL_CNLTBLTag;

#ifdef FWFIREWALL_CUSTOM
typedef St_FIREWALL_SUP_CFG_DATATag 	CmdTblType;
typedef St_FIREWALL_CNLTBLTag 			FIREWALL_CUSTOMCmdTag;
#endif 


typedef struct
{
	const BYTE				NetFn;
	const BYTE				CMD_Num;
	const BYTE				LUN;
	const BYTE				Sup_SubFn[4];
	const BYTE				Cfg_SubFn[4];
	
	BYTE	      			SubFn[4];
}St_FIREWALL_SUBFN_DATATag;

typedef struct
{
	BYTE						ChannelNum;
	BYTE						TblLength;
	St_FIREWALL_SUBFN_DATATag	*SubFnChnlTbl;
}St_FIREWALL_SUBFNCNLTBLTag;

#ifdef FWFIREWALL_CUSTOM
typedef St_FIREWALL_SUBFN_DATATag 	SubTblType;
typedef St_FIREWALL_SUBFNCNLTBLTag 	FIREWALL_CUSTOMSubTag;
#endif 

typedef struct
{
	St_FIREWALL_SUBFN_DATATag		Firewall_data;
	BYTE							Body_IANA[3];
}St_FIREWALL_IANASUBFN_DATATag;

typedef struct
{
	St_FIREWALL_IANASUBFN_DATATag	*ChannelTbl;
}St_FIREWALL_IANASUBFN_CHNLTBLTag;






#ifdef _FIREWALL_C_

#include "customer.h"

#ifndef NO_FWFIREWALL_DEF_IPMB

St_FIREWALL_SUP_CFG_DATATag	ws_a_St_Firewall_IPMBCMDTable[] = 
{
	{
		NET_FN_CHASSIS,0x0,
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  
		},
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_BRIDGE,0x0,
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_SE,0x0,
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_APP,0x0,
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1F,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1E,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1F,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_STORAGE,0x0,
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_TRANSPORT,0x0,
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	}
};
#endif


#ifndef NO_FWFIREWALL_DEF_LAN

St_FIREWALL_SUP_CFG_DATATag	ws_a_St_Firewall_LANCMDTable[] = 
{
	{
		NET_FN_CHASSIS,0x0,
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  
		},
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_BRIDGE,0x0,
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_SE,0x0,
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_APP,0x0,
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1F,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1E,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1F,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_STORAGE,0x0,
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_TRANSPORT,0x0,
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	}
};
#endif  

#ifndef NO_FWFIREWALL_DEF_UART

St_FIREWALL_SUP_CFG_DATATag	ws_a_St_Firewall_UARTCMDTable[] = 
{
	{
		NET_FN_CHASSIS,0x0,
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  
		},
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_BRIDGE,0x0,
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_SE,0x0,
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_APP,0x0,
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1F,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1E,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1F,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_STORAGE,0x0,
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_TRANSPORT,0x0,
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	}
};
#endif  

#ifndef NO_FWFIREWALL_DEF_KCS
St_FIREWALL_SUP_CFG_DATATag	ws_a_St_Firewall_KCSCMDTable[] = 
{
	{
		NET_FN_CHASSIS,0x0,
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  
		},
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFF,0x8F,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_BRIDGE,0x0,
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_SE,0x0,
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x07,0x00,0xFF,0x00,0xFF,0xEF,0x01,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_APP,0x0,
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1F,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1E,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0xFE,0x3F,0x00,0x00,0x34,0xC0,0xFF,0xFF,
			0xFF,0xFF,0xF5,0x00,0x1F,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_STORAGE,0x0,
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x00,0x00,0x07,0x00,0xFF,0x1F,0x00,0x00,
			0xFF,0x03,0x00,0x0C,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	},
	{
		NET_FN_TRANSPORT,0x0,
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		},
		{
			0x1E,0x00,0xFF,0x1F,0x07,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
		}
	}
};
#endif 

#ifdef FWFIREWALL_CUSTOM
St_FIREWALL_CNLTBLTag	ws_a_St_Firewall_ChannelTbl[25] = 
#else
St_FIREWALL_CNLTBLTag	ws_a_St_Firewall_ChannelTbl[] =
#endif 
{
	#ifndef NO_FWFIREWALL_DEF_IPMB
	{0x00, (sizeof(ws_a_St_Firewall_IPMBCMDTable) / sizeof(St_FIREWALL_SUP_CFG_DATATag)),ws_a_St_Firewall_IPMBCMDTable},
	#endif 

	#ifndef NO_FWFIREWALL_DEF_LAN	
	{0x01, (sizeof(ws_a_St_Firewall_LANCMDTable) / sizeof(St_FIREWALL_SUP_CFG_DATATag)),ws_a_St_Firewall_LANCMDTable},
	#endif 
	
	#ifndef NO_FWFIREWALL_DEF_UART
	{0x03, (sizeof(ws_a_St_Firewall_UARTCMDTable) / sizeof(St_FIREWALL_SUP_CFG_DATATag)),ws_a_St_Firewall_UARTCMDTable},
	#endif 

	#ifndef NO_FWFIREWALL_DEF_KCS
	{0x0F, (sizeof(ws_a_St_Firewall_KCSCMDTable) / sizeof(St_FIREWALL_SUP_CFG_DATATag)),ws_a_St_Firewall_KCSCMDTable},
	#endif 
	
#ifdef FWFIREWALL_CUSTOM
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
#endif 
	

	{0xff,0xff,NULL}

			
};

#ifndef NO_FWFIREWALL_DEF_IPMB
St_FIREWALL_SUBFN_DATATag	ws_a_St_Firewall_IPMBSubFNTbl[] = 
{
	{
		NET_FN_CHASSIS,0x02,0x0,
		
		{0x3E,0x00,0x00,0x00},
		
		{0x3E,0x00,0x00,0x00},
		
		{0x3E,0x00,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x04,0x0,
		{0x01,0x00,0x00,0x00},
		{0x01,0x00,0x00,0x00},
		{0x01,0x00,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x08,0x0,
		{0x38,0x1F,0x00,0x00},
		{0x38,0x1F,0x00,0x00},
		{0x38,0x1F,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x0A,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_SE,0x11,0x0,
		{0x07,0x00,0x00,0x00},
		{0x07,0x00,0x00,0x00},
		{0x07,0x00,0x00,0x00}
	},
	{
		NET_FN_SE,0x12,0x0,
		{0xFF,0x1F,0x00,0x00},
		{0xFF,0x1F,0x00,0x00},
		{0xFF,0x1F,0x00,0x00}
	},
	{
		NET_FN_SE,0x16,0x0,
		{0x02,0x01,0x00,0x00},
		{0x02,0x01,0x00,0x00},
		{0x02,0x01,0x00,0x00}
	},
	{
		NET_FN_APP,0x24,0x0,
		{0x0F,0x00,0x00,0x00},
		{0x0F,0x00,0x00,0x00},
		{0x0F,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x2E,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x30,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x32,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x34,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x3C,0x0,
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x40,0x0,
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x52,0x0,
		{0x00,0x3F,0x00,0x00},
		{0x00,0x3F,0x00,0x00},
		{0x00,0x3F,0x00,0x00}
	},
	{
		NET_FN_STORAGE,0x5B,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x01,0x0,
		{0x02,0xF7,0x0F,0x00},
		{0x02,0xF7,0x0F,0x00},
		{0x02,0xF7,0x0F,0x00}
	},
	{
		NET_FN_TRANSPORT,0x03,0x0,
		{0x02,0x02,0x00,0x00},
		{0x02,0x02,0x00,0x00},
		{0x02,0x02,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x10,0x0,
		{0x08,0x17,0x10,0x00},
		{0x08,0x17,0x10,0x00},
		{0x08,0x17,0x10,0x00}
	},
	{
		NET_FN_TRANSPORT,0x12,0x0,
		{0x1E,0x00,0x00,0x00},
		{0x1E,0x00,0x00,0x00},
		{0x1E,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x14,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x16,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x19,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x1A,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x21,0x0,
		{0x02,0x1F,0x00,0x00},
		{0x02,0x1F,0x00,0x00},
		{0x02,0x1F,0x00,0x00}
	}
};
#endif  

#ifndef NO_FWFIREWALL_DEF_LAN

St_FIREWALL_SUBFN_DATATag	ws_a_St_Firewall_LANSubFNTbl[] = 
{
	{
		NET_FN_CHASSIS,0x02,0x0,
		{0x3E,0x00,0x00,0x00},
		{0x3E,0x00,0x00,0x00},
		{0x3E,0x00,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x04,0x0,
		{0x01,0x00,0x00,0x00},
		{0x01,0x00,0x00,0x00},
		{0x01,0x00,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x08,0x0,
		{0x38,0x1F,0x00,0x00},
		{0x38,0x1F,0x00,0x00},
		{0x38,0x1F,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x0A,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_SE,0x11,0x0,
		{0x07,0x00,0x00,0x00},
		{0x07,0x00,0x00,0x00},
		{0x07,0x00,0x00,0x00}
	},
	{
		NET_FN_SE,0x12,0x0,
		{0xFF,0x1F,0x00,0x00},
		{0xFF,0x1F,0x00,0x00},
		{0xFF,0x1F,0x00,0x00}
	},
	{
		NET_FN_SE,0x16,0x0,
		{0x02,0x01,0x00,0x00},
		{0x02,0x01,0x00,0x00},
		{0x02,0x01,0x00,0x00}
	},
	{
		NET_FN_APP,0x24,0x0,
		{0x0F,0x00,0x00,0x00},
		{0x0F,0x00,0x00,0x00},
		{0x0F,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x2E,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x30,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x32,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x34,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x3C,0x0,
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x40,0x0,
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x52,0x0,
		{0x00,0x3F,0x00,0x00},
		{0x00,0x3F,0x00,0x00},
		{0x00,0x3F,0x00,0x00}
	},
	{
		NET_FN_STORAGE,0x5B,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x01,0x0,
		{0x02,0xF7,0x0F,0x00},
		{0x02,0xF7,0x0F,0x00},
		{0x02,0xF7,0x0F,0x00}
	},
	{
		NET_FN_TRANSPORT,0x03,0x0,
		{0x02,0x02,0x00,0x00},
		{0x02,0x02,0x00,0x00},
		{0x02,0x02,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x10,0x0,
		{0x08,0x17,0x10,0x00},
		{0x08,0x17,0x10,0x00},
		{0x08,0x17,0x10,0x00}
	},
	{
		NET_FN_TRANSPORT,0x12,0x0,
		{0x1E,0x00,0x00,0x00},
		{0x1E,0x00,0x00,0x00},
		{0x1E,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x14,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x16,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x19,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x1A,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x21,0x0,
		{0x02,0x1F,0x00,0x00},
		{0x02,0x1F,0x00,0x00},
		{0x02,0x1F,0x00,0x00}
	}
};
#endif  

#ifndef NO_FWFIREWALL_DEF_UART

St_FIREWALL_SUBFN_DATATag	ws_a_St_Firewall_UARTSubFNTbl[] = 
{
	{
		NET_FN_CHASSIS,0x02,0x0,
		{0x3E,0x00,0x00,0x00},
		{0x3E,0x00,0x00,0x00},
		{0x3E,0x00,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x04,0x0,
		{0x01,0x00,0x00,0x00},
		{0x01,0x00,0x00,0x00},
		{0x01,0x00,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x08,0x0,
		{0x38,0x1F,0x00,0x00},
		{0x38,0x1F,0x00,0x00},
		{0x38,0x1F,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x0A,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_SE,0x11,0x0,
		{0x07,0x00,0x00,0x00},
		{0x07,0x00,0x00,0x00},
		{0x07,0x00,0x00,0x00}
	},
	{
		NET_FN_SE,0x12,0x0,
		{0xFF,0x1F,0x00,0x00},
		{0xFF,0x1F,0x00,0x00},
		{0xFF,0x1F,0x00,0x00}
	},
	{
		NET_FN_SE,0x16,0x0,
		{0x02,0x01,0x00,0x00},
		{0x02,0x01,0x00,0x00},
		{0x02,0x01,0x00,0x00}
	},
	{
		NET_FN_APP,0x24,0x0,
		{0x0F,0x00,0x00,0x00},
		{0x0F,0x00,0x00,0x00},
		{0x0F,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x2E,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x30,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x32,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x34,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x3C,0x0,
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x40,0x0,
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x52,0x0,
		{0x00,0x3F,0x00,0x00},
		{0x00,0x3F,0x00,0x00},
		{0x00,0x3F,0x00,0x00}
	},
	{
		NET_FN_STORAGE,0x5B,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x01,0x0,
		{0x02,0xF7,0x0F,0x00},
		{0x02,0xF7,0x0F,0x00},
		{0x02,0xF7,0x0F,0x00}
	},
	{
		NET_FN_TRANSPORT,0x03,0x0,
		{0x02,0x02,0x00,0x00},
		{0x02,0x02,0x00,0x00},
		{0x02,0x02,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x10,0x0,
		{0x08,0x17,0x10,0x00},
		{0x08,0x17,0x10,0x00},
		{0x08,0x17,0x10,0x00}
	},
	{
		NET_FN_TRANSPORT,0x12,0x0,
		{0x1E,0x00,0x00,0x00},
		{0x1E,0x00,0x00,0x00},
		{0x1E,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x14,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x16,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x19,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x1A,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x21,0x0,
		{0x02,0x1F,0x00,0x00},
		{0x02,0x1F,0x00,0x00},
		{0x02,0x1F,0x00,0x00}
	}
};
#endif  

#ifndef NO_FWFIREWALL_DEF_KCS
St_FIREWALL_SUBFN_DATATag	ws_a_St_Firewall_KCSSubFNTbl[] = 
{
	{
		NET_FN_CHASSIS,0x02,0x0,
		{0x3E,0x00,0x00,0x00},
		{0x3E,0x00,0x00,0x00},
		{0x3E,0x00,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x04,0x0,
		{0x01,0x00,0x00,0x00},
		{0x01,0x00,0x00,0x00},
		{0x01,0x00,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x08,0x0,
		{0x38,0x1F,0x00,0x00},
		{0x38,0x1F,0x00,0x00},
		{0x38,0x1F,0x00,0x00}
	},
	{
		NET_FN_CHASSIS,0x0A,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_SE,0x11,0x0,
		{0x07,0x00,0x00,0x00},
		{0x07,0x00,0x00,0x00},
		{0x07,0x00,0x00,0x00}
	},
	{
		NET_FN_SE,0x12,0x0,
		{0xFF,0x1F,0x00,0x00},
		{0xFF,0x1F,0x00,0x00},
		{0xFF,0x1F,0x00,0x00}
	},
	{
		NET_FN_SE,0x16,0x0,
		{0x02,0x01,0x00,0x00},
		{0x02,0x01,0x00,0x00},
		{0x02,0x01,0x00,0x00}
	},
	{
		NET_FN_APP,0x24,0x0,
		{0x0F,0x00,0x00,0x00},
		{0x0F,0x00,0x00,0x00},
		{0x0F,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x2E,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x30,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x32,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x34,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x3C,0x0,
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x40,0x0,
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00},
		{0x02,0x00,0x00,0x00}
	},
	{
		NET_FN_APP,0x52,0x0,
		{0x00,0x3F,0x00,0x00},
		{0x00,0x3F,0x00,0x00},
		{0x00,0x3F,0x00,0x00}
	},
	{
		NET_FN_STORAGE,0x5B,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x01,0x0,
		{0x02,0xF7,0x0F,0x00},
		{0x02,0xF7,0x0F,0x00},
		{0x02,0xF7,0x0F,0x00}
	},
	{
		NET_FN_TRANSPORT,0x03,0x0,
		{0x02,0x02,0x00,0x00},
		{0x02,0x02,0x00,0x00},
		{0x02,0x02,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x10,0x0,
		{0x08,0x17,0x10,0x00},
		{0x08,0x17,0x10,0x00},
		{0x08,0x17,0x10,0x00}
	},
	{
		NET_FN_TRANSPORT,0x12,0x0,
		{0x1E,0x00,0x00,0x00},
		{0x1E,0x00,0x00,0x00},
		{0x1E,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x14,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x16,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x19,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x1A,0x0,
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00}
	},
	{
		NET_FN_TRANSPORT,0x21,0x0,
		{0x02,0x1F,0x00,0x00},
		{0x02,0x1F,0x00,0x00},
		{0x02,0x1F,0x00,0x00}
	}
};
#endif 

#ifdef FWFIREWALL_CUSTOM
St_FIREWALL_SUBFNCNLTBLTag	ws_a_St_FirewallSubFnTbl[25] = 
#else
St_FIREWALL_SUBFNCNLTBLTag	ws_a_St_FirewallSubFnTbl[] =
#endif 
{
	#ifndef NO_FWFIREWALL_DEF_IPMB	
	{0x00, (sizeof(ws_a_St_Firewall_IPMBSubFNTbl) / sizeof(St_FIREWALL_SUBFN_DATATag)),ws_a_St_Firewall_IPMBSubFNTbl},
	#endif 
	
	#ifndef NO_FWFIREWALL_DEF_LAN
	{0x01, (sizeof(ws_a_St_Firewall_LANSubFNTbl) / sizeof(St_FIREWALL_SUBFN_DATATag)),ws_a_St_Firewall_LANSubFNTbl},
	#endif 
	
	#ifndef NO_FWFIREWALL_DEF_UART
	{0x03, (sizeof(ws_a_St_Firewall_UARTSubFNTbl) / sizeof(St_FIREWALL_SUBFN_DATATag)),ws_a_St_Firewall_UARTSubFNTbl},
	#endif
	
	#ifndef NO_FWFIREWALL_DEF_KCS
	{0x0F, (sizeof(ws_a_St_Firewall_KCSSubFNTbl) / sizeof(St_FIREWALL_SUBFN_DATATag)),ws_a_St_Firewall_KCSSubFNTbl},
	#endif
	
	#ifdef FWFIREWALL_CUSTOM
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	{0xff,0xff,NULL},
	#endif 
	

	{0xff,0xff,NULL}

	
	
};

#ifdef IPMI_FW_FIREWALL_SUB_IANA

typedef struct
{
	BYTE	buf[3];
}OEMIANA;

#define MAXOEMIANA	64

#define	MAX_FWBODYINX	63
#define MAX_FWOEMIANAINX 63
BYTE	FWBodyCode[MAXOEMIANA];
OEMIANA	FWOEMIANA[MAXOEMIANA];
#endif



CMD_STATUS GetCmdSupportCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
CMD_STATUS GetCmdSubFnSupportCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
CMD_STATUS GetConfigureCmdCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
CMD_STATUS GetConfgCmdSubFnCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
CMD_STATUS GetCmdEnableCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
CMD_STATUS GetConfgCmdSubFnEnableCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
CMD_STATUS SetCommandEnableCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
CMD_STATUS SetConfgCmdSubFnEnableCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
CMD_STATUS GetOEMNetFnIANASupportCmd(MsgBufFmt *MsgBufIn, MsgBufFmt *MsgBufOut);

BYTE ApiDoingGetNetFnSupportCmd(MsgBufFmt *MsgBufOut,BYTE b_channel_num);
BYTE ApiDoingGetCmdSupportCmd(MsgBufFmt *MsgBufOut,BYTE b_firewall_chnl_num,BYTE b_firewall_cmd_mask,BYTE b_firewall_netfn,BYTE b_firewall_lun,BYTE *firewall_body_data);
BYTE ApiDoingGetCmdSubFnSupportCmd(MsgBufFmt *MsgBufOut,BYTE b_chnl_num,BYTE b_firewall_netfn,BYTE b_firewall_lun,BYTE b_firewall_cmd,BYTE *firewall_body_data);
BYTE ApiDoingGetConfigureCmdCmd(MsgBufFmt *MsgBufOut,BYTE b_firewall_chnl_num,BYTE b_firewall_cmd_mask,BYTE b_firewall_netfn,BYTE b_firewall_lun,BYTE *firewall_body_dat);
BYTE ApiDoingGetConfgCmdSubFnCmd(MsgBufFmt *MsgBufOut,BYTE b_chnl_num,BYTE b_firewall_netfn,BYTE b_firewall_lun,BYTE b_firewall_cmd,BYTE *firewall_body_data);
BYTE ApiDoingGetCmdEnableCmd(MsgBufFmt *MsgBufOut,BYTE b_firewall_chnl_num,BYTE b_firewall_cmd_mask,BYTE b_firewall_netfn,BYTE b_firewall_lun);
BYTE ApiDoingGetConfgCmdSubFnEnableCmd(MsgBufFmt *MsgBufOut,BYTE b_chnl_num,BYTE b_firewall_netfn,BYTE b_firewall_lun,BYTE b_firewall_cmd);
BYTE ApiDoingSetCommandEnableCmd(MsgBufFmt *MsgBufIn,BYTE b_firewall_chnl_num,BYTE b_firewall_cmd_mask,BYTE b_firewall_netfn,BYTE b_firewall_lun,BYTE *firewall_body_data);
BYTE ApiDoingSetConfgCmdSubFnEnableCmd(MsgBufFmt *MsgBufIn,BYTE b_chnl_num,BYTE b_firewall_netfn,BYTE b_firewall_lun,BYTE b_firewall_cmd);
BYTE ApiDoingGetOEMNetFnIANASupportCmd(MsgBufFmt *MsgBufOut,BYTE b_chnl_num,BYTE b_firewall_netfn,BYTE b_firewall_IANA_index);
#else

extern CMD_STATUS GetNetFnSupportCmd(MsgBufFmt *MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS GetCmdSupportCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS GetCmdSubFnSupportCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS GetConfigureCmdCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS GetConfgCmdSubFnCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS GetCmdEnableCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS GetConfgCmdSubFnEnableCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS SetCommandEnableCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS SetConfgCmdSubFnEnableCmd(MsgBufFmt * MsgBufIn, MsgBufFmt *MsgBufOut);
extern CMD_STATUS GetOEMNetFnIANASupportCmd(MsgBufFmt *MsgBufIn, MsgBufFmt *MsgBufOut);


extern St_FIREWALL_IANASUBFN_CHNLTBLTag	ws_as_Firewall_IANASubFn_ChnlTbl[];
extern St_FIREWALL_IANA_CHNLTBLTag	ws_as_Firewall_IANA_ChnlTbl[];
extern St_FIREWALL_SUBFNCNLTBLTag	ws_a_St_FirewallSubFnTbl[];
extern St_FIREWALL_CNLTBLTag	ws_a_St_Firewall_ChannelTbl[];


#endif

#endif
#endif





