/*****************************************************************************/
/*                                                                           */
/*            Copyright (c) 2002-2003 by ATEN International CO., Ltd.        */
/*                                                                           */
/*  This software is supplied under the terms of a license agreement or      */
/*  nondisclosure agreement with ATEN International CO., Ltd. and do not     */
/*  copy, disseminate or distribute except in accordance with the terms      */
/*  of that agreement.                                                       */
/*                                                                           */
/*  ATEN International CO., Ltd. reserves the right to modify this software  */
/*  without notice.                                                          */
/*                                                                           */
/*  ATEN International CO., Ltd.                                             */
/*  3F, No. 125, Sec. 2, Datung Rd.                                          */
/*  Shi-Chi City                              Taiwan phone: 886-2-8692-6789  */
/*  Taipei Hsien, Taiwan 221, R.O.C.          email: ip_manager@aten.com.tw  */
/*                                                                           */
/*****************************************************************************/

#ifndef _LM25066DRV_H_
#define _LM25066DRV_H_



extern STATUS SetupLM25066DRV (DWORD ,DWORD ,void * ,void *);
extern STATUS PryLM25066DRV (DWORD ,DWORD ,void * ,void *);
extern STATUS WriteLM25066DRV (DWORD ,DWORD ,void * ,void *);
extern STATUS ReadLM25066DRV (DWORD ,DWORD ,void * ,void *);
extern STATUS ReadLM25066DRV_Type2(DWORD ,DWORD ,void * ,void *);

#ifdef _LM25066DRV_C_

/* struct LM25066 API */
St_SensorAPITag ws_St_LM25066API=
{
	SetupLM25066DRV,
	PryLM25066DRV,
	WriteLM25066DRV,
	ReadLM25066DRV,
};


//-------------------------------------------------------------------------
// FOR LM25066 begin
//-------------------------------------------------------------------------
typedef enum
{
	PAGE,
	OPERATION,
	ON_OFF_CONFIG,
	CLEAR_FAULTS,
	PHASE,
	PAGE_PLUS,
	RESERVED_06,
	RESERVED_07,
	RESERVED_08,
	RESERVED_09,
	RESERVED_0A,
	RESERVED_0B,
	RESERVED_0C,
	RESERVED_0D,
	RESERVED_0E,
	RESERVED_0F,
	WRITE_PROTECT,
	STORE_DEFAULT_ALL,
	RESTORE_DEFAULT_ALL,
	STORE_DEFAULT_CODE,
	RESTORE_DEFAULT_CODE,
	STORE_USER_ALL,
	RESTORE_USER_ALL,
	STORE_USER_CODE,
	RESTORE_USER_CODE,
	CAPABILITY,
	QUERY,
	RESERVED_1B,
	RESERVED_1C,
	RESERVED_1D,
	RESERVED_1E,
	RESERVED_1F,
	VOUT_MODE,
	VOUT_COMMAND,
	VOUT_TRIM,
	VOUT_CAL_OFFSET,
	VOUT_MAX,
	VOUT_MARGIN_HIGH,
	VOUT_MARGIN_LOW,
	VOUT_TRANSITION_RATE,
	VOUT_DROOP,
	VOUT_SCALE_LOOP,
	VOUT_SCALE_MONITOR,
	RESERVED_2B,
	RESERVED_2C,
	RESERVED_2D,
	RESERVED_2E,
	RESERVED_2F,
	COEFFICENTS,
	POUT_MAX,
	MAX_DUTY,
	FREQUENCY_SWITCH,
	RESERVED_34,
	VIN_ON,
	VIN_OFF,
	INTERLEAVE,
	IOUT_CAL_GAIN,
	IOUT_CAL_OFFSET,
	FAN_CONFIG_1_2,
	FAN_COMMAND_1,
	FAN_COMMAND_2,
	FAN_CONFIG_3_4,
	FAN_COMMAND_3,
	FAN_COMMAND_4,
	VOUT_OV_FAULT_LIMIT,
	VOUT_OV_FAULT_RESPONSE,
	VOUT_OV_WARN_LIMIT,
	VOUT_UV_WARN_LIMIT,
	VOUT_UV_FAULT_LIMIT,
	VOUT_UV_FAULT_RESPONSE,
	IOUT_OC_FAULT_LIMIT,
	IOUT_OC_FAULT_RESPONSE,
	IOUT_OC_LV_FAULT_LIMIT,
	IOUT_OC_LV_FAULT_RESPONSE,
	IOUT_OC_WARN_LIMIT,
	IOUT_UC_FAULT_LIMIT,
	IOUT_UC_FAULT_RESPONSE,
	RESERVED_4D,
	RESERVED_4E,
	OT_FAULT_LIMIT,
	OT_FAULT_RESPONSE,
	OT_WARN_LIMIT,
	UT_WARN_LIMIT,
	UT_FAULT_LIMIT,
	UT_FAULT_RESPONSE,
	VIN_OV_FAULT_LIMIT,
	VIN_OV_FAULT_RESPONSE,
	VIN_OV_WARN_LIMIT,
	VIN_UV_WARN_LIMIT,
	VIN_UV_FAULT_LIMIT,
	VIN_UV_FAULT_RESPONSE,
	IIN_OC_FAULT_LIMIT,
	IIN_OC_FAULT_RESPONSE,
	IIN_OC_WARN_LIMIT,
	POWER_GOOD_ON,
	POWER_GOOD_OFF,
	TON_DELAY,
	TON_RISE,
	TON_MAX_FAULT_LIMIT,
	TON_MAX_FAULT_RESPONSE,
	TOFF_DELAY,
	TOFF_FALL,
	TOFF_MAX_WARN_LIMIT,
	RESERVED_67,
	POUT_OP_FAULT_LIMIT,
	POUT_OP_FAULT_RESPONSE,
	POUT_OP_WARN_LIMIT,
	PIN_OP_WARN_LIMIT,
	RESERVED_6C,
	RESERVED_6D,
	RESERVED_6E,
	RESERVED_6F,
	RESERVED_70,
	RESERVED_71,
	RESERVED_72,
	RESERVED_73,
	RESERVED_74,
	RESERVED_75,
	RESERVED_76,
	RESERVED_77,
	STATUS_BYTE,
	STATUS_WORD,
	STATUS_VOUT,
	STATUS_IOUT,
	STATUS_INPUT,
	STATUS_TEMPERATURE,
	STATUS_CML,
	STATUS_OTHER,
	STATUS_MFR_SPECIFIC,
	STATUS_FANS_1_2,
	STATUS_FANS_3_4,
	RESERVED_83,
	RESERVED_84,
	RESERVED_85,
	RESERVED_86,
	RESERVED_87,
	READ_VIN,
	READ_IIN,
	READ_VCAP,
	READ_VOUT,
	READ_IOUT,
	READ_TEMPERATURE_1,
	READ_TEMPERATURE_2,
	READ_TEMPERATURE_3,
	READ_FAN_SPEED_1,
	READ_FAN_SPEED_2,
	READ_FAN_SPEED_3,
	READ_FAN_SPEED_4,
	READ_DUTY_CYCLE,
	READ_FREQUENCY,
	READ_POUT,
	READ_PIN,
	PMBUS_REVISION,
	MFR_ID,
	MFR_MODEL,
	MFR_REVISION,
	MFR_LOCATION,
	MFR_DATE,
	MFR_SERIAL,
	APP_PROFILE_SUPPORT,
	MFR_VIN_MIN,
	MFR_VIN_MAX,
	MFR_IIN_MAX,
	MFR_PIN_MAX,
	MFR_VOUT_MIN,
	MFR_VOUT_MAX,
	MFR_IOUT_MAX,
	MFR_POUT_MAX,
	MFR_TAMBIENT_MAX,
	MFR_TAMBIENT_MIN,
	MFR_EFFICIENCY_LL,
	MFR_EFFICIENCY_HL,
	MFR_PIN_ACCURACY,
	MFR_IC_DEVICE,
	MFR_IC_DEVICE_REV,
	RESERVED_AF,
	USER_DATA_00,
	USER_DATA_01,
	USER_DATA_02,
	USER_DATA_03,
	USER_DATA_04,
	USER_DATA_05,
	USER_DATA_06,
	USER_DATA_07,
	USER_DATA_08,
	USER_DATA_09,
	USER_DATA_10,
	USER_DATA_11,
	USER_DATA_12,
	USER_DATA_13,
	USER_DATA_14,
	USER_DATA_15,
	RESERVED_C0,
	RESERVED_C1,
	RESERVED_C2,
	RESERVED_C3,
	RESERVED_C4,
	RESERVED_C5,
	RESERVED_C6,
	RESERVED_C7,
	RESERVED_C8,
	RESERVED_C9,
	RESERVED_CA,
	RESERVED_CB,
	RESERVED_CC,
	RESERVED_CD,
	RESERVED_CE,
	RESERVED_CF,
	MFR_SPECIFIC_00,
	MFR_SPECIFIC_01,
	MFR_SPECIFIC_02,
	MFR_SPECIFIC_03,
	MFR_SPECIFIC_04,
	MFR_SPECIFIC_05,
	MFR_SPECIFIC_06,
	MFR_SPECIFIC_07,
	MFR_SPECIFIC_08,
	MFR_SPECIFIC_09,
	MFR_SPECIFIC_10,
	MFR_SPECIFIC_11,
	MFR_SPECIFIC_12,
	MFR_SPECIFIC_13,
	MFR_SPECIFIC_14,
	MFR_SPECIFIC_15,
	MFR_SPECIFIC_16,
	MFR_SPECIFIC_17,
	MFR_SPECIFIC_18,
	MFR_SPECIFIC_19,
	MFR_SPECIFIC_20,
	MFR_SPECIFIC_21,
	MFR_SPECIFIC_22,
	MFR_SPECIFIC_23,
	MFR_SPECIFIC_24,
	MFR_SPECIFIC_25,
	MFR_SPECIFIC_26,
	MFR_SPECIFIC_27,
	MFR_SPECIFIC_28,
	MFR_SPECIFIC_29,
	MFR_SPECIFIC_30,
	MFR_SPECIFIC_31,
	MFR_SPECIFIC_32,
	MFR_SPECIFIC_33,
	MFR_SPECIFIC_34,
	MFR_SPECIFIC_35,
	MFR_SPECIFIC_36,
	MFR_SPECIFIC_37,
	MFR_SPECIFIC_38,
	MFR_SPECIFIC_39,
	MFR_SPECIFIC_40,
	MFR_SPECIFIC_41,
	MFR_SPECIFIC_42,
	MFR_SPECIFIC_43,
	MFR_SPECIFIC_44,
	MFR_SPECIFIC_45,
	MFR_SPECIFIC_COMMAND_EXT,
	PMBUS_COMMAND_EXT
} PMBusLibCmdENUM_t;

typedef enum
{
	READ_AUX = MFR_SPECIFIC_00,
	MFR_READ_IIN = MFR_SPECIFIC_01,
	MFR_READ_PIN = MFR_SPECIFIC_02,
	MFR_IIN_OC_WARN_LIMIT = MFR_SPECIFIC_03,
	MFR_PIN_OP_WARN_LIMIT = MFR_SPECIFIC_04,
	READ_PIN_PEAK = MFR_SPECIFIC_05,
	CLEAR_PIN_PEAK = MFR_SPECIFIC_06,
	GATE_MASK = MFR_SPECIFIC_07,
	ALERT_MASK = MFR_SPECIFIC_08,
	DEVICE_SETUP = MFR_SPECIFIC_09,
	BLOCK_READ = MFR_SPECIFIC_10,
	SAMPLES_FOR_AVG = MFR_SPECIFIC_11,
	READ_AVG_VIN = MFR_SPECIFIC_12,
	READ_AVG_VOUT = MFR_SPECIFIC_13,
	READ_AVG_IIN = MFR_SPECIFIC_14,
	READ_AVG_PIN = MFR_SPECIFIC_15,
	BLACK_BOX_READ = MFR_SPECIFIC_16,
	DIAGNOSTIC_WORD_READ = MFR_SPECIFIC_17,
	AVG_BLOCK_READ = MFR_SPECIFIC_18

} LM25066LibCmdENUM_t;
//-------------------------------------------------------------------------
// FOR LM25066 end
//-------------------------------------------------------------------------


#else

/* struct LM25066 API */

extern St_SensorAPITag ws_St_LM25066API;

#endif //end of #ifdef _LM25066DRV_C_

#endif //end of #define _LM25066DRV_H_

/* End of file */