

#ifndef _NCT7904DDRV_H_
#define _NCT7904DDRV_H_

#define NCT7904D_REG4E_BANKSELECT				0xFF
#define NCT7904D_REG_CPU_OVERTEMP				0x55

extern STATUS Plt_NCT7904D_ClearCaseOpenLatch(void);
extern STATUS SetupNCT7904DDrv (DWORD ,DWORD ,void * ,void *);
extern STATUS PryNCT7904DDrv (DWORD ,DWORD ,void * ,void *);
extern STATUS WriteNCT7904DDrv (DWORD ,DWORD ,void * ,void *);
extern STATUS ReadNCT7904DDrv (DWORD ,DWORD ,void * ,void *);

#ifdef _NCT7904DDRV_C_

St_SensorAPITag ws_St_NCT7904DAPI=
{
	SetupNCT7904DDrv,
	PryNCT7904DDrv,
	WriteNCT7904DDrv,
	ReadNCT7904DDrv,
};

#else

extern St_SensorAPITag ws_St_NCT7904DAPI;

#endif 

// HWM structure
typedef struct
{
	unsigned char bank;
	unsigned char offset;
	unsigned char value;
} HW_MONITOR_CONFIG;

// [Jack] Zone Info
typedef struct{
	BYTE zone_temperature;
	DWORD hwInfo;
} GPU_ZONE_INFO;


unsigned char FanFullSpeed[20]={
								// offset, data
								  0xff, 0x03,		// bank 3
								  0x00, 0x00,		// PWM0 Manual Mode
								  0x01, 0x00,		// PWM1 Manual Mode
								  0x02, 0x00,		// PWM2 Manual Mode
								  0x03, 0x00,		// PWM3 Manual Mode
								  0x10, 0xff,		// PWM0 Full Speed
								  0x11, 0xff,		// PWM1 Full Speed
								  0x12, 0xff,		// PWM2 Full Speed
								  0x13, 0xff,		// PWM3 Full Speed
								  0xff, 0x00		// bank 0
								 };

unsigned char FanNormalSpeed[12]={
								// offset, data
								  0xff, 0x03,		// bank 3
								  0x00, 0x03,		// FANCTL src from src 1 and 2
								  0x01, 0x03,		// FANCTL src from src 1 and 2
								  0x02, 0x03,		// FANCTL src from src 1 and 2
								  0x03, 0x03,		// FANCTL src from src 1 and 2
								  0xff, 0x00		// bank 0
								 };

unsigned char FanOptimalSpeed[12]={
								// offset, data
								  0xff, 0x03,		// bank 3
								  0x00, 0x01,		// FANCTL src from src 1
								  0x01, 0x01,		// FANCTL src from src 1
								  0x02, 0x02,		// FANCTL src from src 2
								  0x03, 0x02,		// FANCTL src from src 2
								  0xff, 0x00		// bank 0
								 };

/*
* Default Init Table
*/
static const HW_MONITOR_CONFIG HW_monitor_config_table[] = 
{
	// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x56}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	
	
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},

	//?Smart Fan IV BEGIN ---  orignal 20%
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},	//CPU
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},	//MEM
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},	//PCH
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},	//RT2
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},
	//?Smart Fan IV END ---  orignal 20%
	
	/*
	 //Smart Fan IV --- BEGIN CPU full speed curve shfit up 5 degree c
	 {0x03, 0x20, 0x5F}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5A}, {0x03, 0x23, 0x50},	//CPU full speed curve shfit up 5 degree c
	{0x03, 0x30, 0x37}, {0x03, 0x31, 0x41}, {0x03, 0x32, 0x55}, {0x03, 0x33, 0x5F},	//CPU full speed curve shift up 5 degree c
	 //Smart Fan IV --- END CPU full speed curve shfit up 5 degree c
	*/
	
	/*
	//Smart Fan IV -- BEGIN 10% and shift up 5 degree C for CPU FSC
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5F}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},

	//Smart Fan IV -- begin 10% and shift up 5 degree C for CPU FSC
	{0x03, 0x30, 0x37}, {0x03, 0x31, 0x41}, {0x03, 0x32, 0x55}, {0x03, 0x33, 0x5F},	//CPU
	{0x03, 0x34, 0x19}, {0x03, 0x35, 0x66}, {0x03, 0x36, 0xB2}, {0x03, 0x37, 0xff},		// 10%

	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},	//MEM
	{0x03, 0x3c, 0x19}, {0x03, 0x3d, 0x66}, {0x03, 0x3e, 0xB2}, {0x03, 0x3f, 0xff},

	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},	//PCH
	{0x03, 0x44, 0x19}, {0x03, 0x45, 0x66}, {0x03, 0x46, 0xB2}, {0x03, 0x47, 0xff},
	
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},	//RT2
	{0x03, 0x4c, 0x19}, {0x03, 0x4d, 0x66}, {0x03, 0x4e, 0xB2}, {0x03, 0x4f, 0xff},
	//Smart Fan IV -- end 10%
	//Smart Fan IV -- END 10% and shift up 5 degree C for CPU FSC
	*/

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSize =  sizeof (HW_monitor_config_table) / sizeof(HW_MONITOR_CONFIG);

static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DR6Rev110[] = 
{
	// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x56}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	// {0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSize_X9DR6Rev110 =  sizeof (HWMonitorConfigSize_X9DR6Rev110) / sizeof(HW_MONITOR_CONFIG);

/*
 * X9DRG
 */
unsigned char FanNormalSpeed_X9DRG[12]={	 //not used
								// offset, data
								  0xff, 0x03,		// bank 3
								  0x00, 0x0D,		// FANCTL src from src 1, 3 & 4
								  0x01, 0x0D,		// FANCTL src from src 1, 3 & 4
								  0x02, 0x0D,		// FANCTL src from src 1, 3 & 4
								  0x03, 0x0D,		// FANCTL src from src 1, 3 & 4
								  //0xff, 0x04,		// bank 4
				 				  //0x00, 0x0D,		// FANCTL src from src 1, 3 & 4
								  0xff, 0x00		// bank 0
								 };

unsigned char FanOptimalSpeed_X9DRG[12]={
								// offset, data
								0xff, 0x03,		// bank 3
								0x00, 0x01,		// FANCTL src from pwm 1
								0x01, 0x01,		// FANCTL src from pwm 1
								0x02, 0x04,		// FANCTL src from pwm 3
								0x03, 0x08,		// FANCTL src from pwm 4
								//0xff, 0x04,		// bank 4
								//0x00, 0x01,		// FANCTL src from src 1
								0xff, 0x00		// bank 0
};


static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRG[] = 
{
	// switch to bank 0
	// [Jack] {0xff, 0x00},
	
    	// Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf1}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// switch to bank 1
	// [Jack] {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x56}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x70, 0x8c}, {0x01, 0x71, 0x06}, {0x01, 0x72, 0x8c}, {0x01, 0x73, 0x06}, {0x01, 0x74, 0x8c}, {0x01, 0x75, 0x06}, {0x01, 0x76, 0x8c}, {0x01, 0x77, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// [Jack ]switch to bank 2
	// {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	
	// [Jack] Init PCH
	// [Jack 111511]
	// {0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90}, 

	// [Jack] switch to bank 3
	//Temperature to Fan Mapping relationships
	{0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode

	//?Temperature Source Selector	
        //?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	// VT2 Table
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	// VT3
	{0x03, 0x40, 0x23}, {0x03, 0x41, 0x2D}, {0x03, 0x42, 0x41}, {0x03, 0x43, 0x4B},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	// VT4
	{0x03, 0x48, 0x23}, {0x03, 0x49, 0x2D}, {0x03, 0x4a, 0x41}, {0x03, 0x4b, 0x4B},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x17},	//adjust the init sequence: VT1(CPU), VT2(MEM, PCH), VT3(GPU1), VT4(GPU4)
	//{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
        {0x03, 0x00, 0x01}, {0x03, 0x01, 0x01}, {0x03, 0x02, 0x04}, {0x03, 0x03, 0x08}, //adjust the init sequence 
	// [Jack] switch to bank 4
	// Temperature Source Selector
	//{0x04, 0x0, 0x03},	// removed RT2 from fan control

};

static int HWMonitorConfigSizeX9DRG =  sizeof (HW_monitor_config_table_X9DRG) / sizeof(HW_MONITOR_CONFIG);

/*
 * X9DRL
 */
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRL[] = 
{
		// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x53}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x21}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x56}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x46}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x67}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x54}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x53}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x21}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSizeX9DRL =  sizeof (HW_monitor_config_table_X9DRL) / sizeof(HW_MONITOR_CONFIG);

/*
 * X9SRG
 */
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9SRG[] = 
{
		// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x56}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}
};

static int HWMonitorConfigSizeX9SRG =  sizeof (HW_monitor_config_table_X9SRG) / sizeof(HW_MONITOR_CONFIG);

/*
 * X9DRX
 */
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRX[] = 
{
		// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x67}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x54}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},

	//?Critical Temperature to Full Speed all Fan
//	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
// linda BEGIN ---RT2 shift down 20 degree C (rev21.52)
{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x3B},	
//linda END --- RT2 shift down 20 degree C (rev21.52)

	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a}, //CPU
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50}, //Mem
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a}, //PCH
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
//	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50}, //RT2
//	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},


// linda BEGIN ---RT2 shift down 20 degree C (rev21.52)
{0x03, 0x48, 0x14}, {0x03, 0x49, 0x21}, {0x03, 0x4a, 0x2E}, {0x03, 0x4b, 0x3B},	
{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbc}, {0x03, 0x4f, 0xff},
//linda END --- RT2 shift down 20 degree C (rev21.52)


	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}
};

static int HWMonitorConfigSizeX9DRX =  sizeof (HW_monitor_config_table_X9DRX) / sizeof(HW_MONITOR_CONFIG);

/*
 * X9DRW_PLUS
 */
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRW_PLUS[] = 
{
		// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf1}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x56}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x3c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x3c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}
};

static int HWMonitorConfigSizeX9DRW_PLUS =  sizeof (HW_monitor_config_table_X9DRW_PLUS) / sizeof(HW_MONITOR_CONFIG);


/*
 * X9DRT 
 */
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRT[] = 
{
	// [Jack] switch to bank 0
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf3}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x55}, {0x01, 0x05, 0x50}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x55}, {0x01, 0x0d, 0x50}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x56}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x46}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x4C}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x3D}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	// MEM
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	// PCH
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	//RT2
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSizeX9DRT =  sizeof (HW_monitor_config_table_X9DRT) / sizeof(HW_MONITOR_CONFIG);


/*
 * X9DRT_D_SG
 */
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRT_SG[] = 
{
	// [Jack] switch to bank 0
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	{0x00, 0xE8, 0x61},	//enable GPIOA; default as input low for X9DRT_SG only
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x55}, {0x01, 0x05, 0x50}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x55}, {0x01, 0x0d, 0x50}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x56}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x46}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x4C}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x3D}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSizeX9DRT_SG =  sizeof (HW_monitor_config_table_X9DRT_SG) / sizeof(HW_MONITOR_CONFIG);

/*
* X9DRD
*/
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRD[] = 
{
	// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x67}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x54}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},


	/*
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},

	//Smart Fan IV -- begin Original 20%
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},	//CPU
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},	//MEM
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},	//PCH
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},	//RT2
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},
	//Smart Fan IV -- end Original
	*/
	/*
	//Smart Fan IV -- begin 10%
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},	//CPU
	{0x03, 0x34, 0x19}, {0x03, 0x35, 0x66}, {0x03, 0x36, 0xB2}, {0x03, 0x37, 0xff},		// 10%

	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},	//MEM
	{0x03, 0x3c, 0x19}, {0x03, 0x3d, 0x66}, {0x03, 0x3e, 0xB2}, {0x03, 0x3f, 0xff},

	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},	//PCH
	{0x03, 0x44, 0x19}, {0x03, 0x45, 0x66}, {0x03, 0x46, 0xB2}, {0x03, 0x47, 0xff},
	
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},	//RT2
	{0x03, 0x4c, 0x19}, {0x03, 0x4d, 0x66}, {0x03, 0x4e, 0xB2}, {0x03, 0x4f, 0xff},
	//Smart Fan IV -- end 10%


	//Smart Fan IV -- begin 0%
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},	//CPU
	{0x03, 0x34, 0x0}, {0x03, 0x35, 0x54}, {0x03, 0x36, 0xA8}, {0x03, 0x37, 0xff},		// 0%

	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},	//MEM
	{0x03, 0x3c, 0x0}, {0x03, 0x3d, 0x54}, {0x03, 0x3e, 0xA8}, {0x03, 0x3f, 0xff},

	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},	//PCH
	{0x03, 0x44, 0x0}, {0x03, 0x45, 0x54}, {0x03, 0x46, 0xA8}, {0x03, 0x47, 0xff},

	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},	//RT2
	{0x03, 0x4c, 0x0}, {0x03, 0x4d, 0x54}, {0x03, 0x4e, 0xA8}, {0x03, 0x4f, 0xff},
	//Smart Fan IV -- end 0%
*/


//Smart Fan IV -- begin 10% and shift up 5 degree C for CPU FSC
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5F}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},

	//Smart Fan IV -- begin 10% and shift up 5 degree C for CPU FSC
	{0x03, 0x30, 0x37}, {0x03, 0x31, 0x41}, {0x03, 0x32, 0x55}, {0x03, 0x33, 0x5F},	//CPU
	{0x03, 0x34, 0x19}, {0x03, 0x35, 0x66}, {0x03, 0x36, 0xB2}, {0x03, 0x37, 0xff},		// 10%

	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},	//MEM
	{0x03, 0x3c, 0x19}, {0x03, 0x3d, 0x66}, {0x03, 0x3e, 0xB2}, {0x03, 0x3f, 0xff},

	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},	//PCH
	{0x03, 0x44, 0x19}, {0x03, 0x45, 0x66}, {0x03, 0x46, 0xB2}, {0x03, 0x47, 0xff},
	
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},	//RT2
	{0x03, 0x4c, 0x19}, {0x03, 0x4d, 0x66}, {0x03, 0x4e, 0xB2}, {0x03, 0x4f, 0xff},
	//Smart Fan IV -- end 10%
//Smart Fan IV -- begin 10% and shift up 5 degree C for CPU FSC


	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSizeX9DRD =  sizeof (HW_monitor_config_table_X9DRD) / sizeof(HW_MONITOR_CONFIG);

/*
*  X9DBU
*/
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DBU[] = 
{
	// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x67}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x54}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSizeX9DBU =  sizeof (HW_monitor_config_table_X9DBU) / sizeof(HW_MONITOR_CONFIG);

/*
*  X9DBL
*/
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DBL[] = 
{
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xC0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x55}, {0x01, 0x05, 0x50}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x55}, {0x01, 0x0d, 0x50}, {0x01, 0x0e, 0x54}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x56}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x46}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x5F}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x58}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x02},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN4/TEMP_CH2)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
};

static int HWMonitorConfigSizeX9DBL =  sizeof (HW_monitor_config_table_X9DBL) / sizeof(HW_MONITOR_CONFIG);

#endif 

/*
 * X9QR7
 */
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9QR7[] = 
{
	// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x03}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x5D}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x21}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x5D}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x21}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x67}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x54}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4B}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x70, 0x8C}, {0x01, 0x71, 0x06}, {0x01, 0x72, 0x8c}, {0x01, 0x73, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	{0x01, 0x98, 0x5F}, {0x01, 0x99, 0x5C}, {0x01, 0x9C, 0x5F}, {0x01, 0x9D, 0x5C}, 
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSizeX9QR7 =  sizeof (HW_monitor_config_table_X9QR7) / sizeof(HW_MONITOR_CONFIG);

/*
* X9DRH
*/
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRH[] = 
{
	// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x0f}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf1}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x4c}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x3d}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x56}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x5d}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x21}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x5d}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x21}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x67}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x4b}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x4b}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x45}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x38}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSizeX9DRH =  sizeof (HW_monitor_config_table_X9DRH) / sizeof(HW_MONITOR_CONFIG);

/*
*  X9DRF
*/
static const HW_MONITOR_CONFIG HW_monitor_config_table_X9DRF[] = 
{
	// [Jack] switch to bank 0
	// {0xff, 0x00},
    // Global Control Register
	{0x00, 0x00, 0x01},
	// Monitoring enable Control Register
	{0x00, 0x20, 0xff}, {0x00, 0x21, 0xff}, {0x00, 0x22, 0x03}, {0x00, 0x23, 0x00}, {0x00, 0x24, 0xff}, {0x00, 0x25, 0x00}, // 0x25 for enable fan 9-12
	{0x00, 0x26, 0x03}, {0x00, 0x27, 0x00}, {0x00, 0x28, 0x03},
	// Monitoring Configuration Register
	{0x00, 0x2e, 0xf0}, {0x00, 0x31, 0x00}, {0x00, 0x32, 0x00},	// 0x2e might need to change if more temp sensor input
	// SMI Control Register
	{0x00, 0xc0, 0x10},	// SMI disable
	// SMI Mask Register
	// disable SMI when BMC handle all HW monitor chip
/*
	{0xcb, 0xff}, {0xcc, 0xff}, {0xcd, 0xff}, {0xce, 0xff}, {0xcf, 0x00}, {0xd0, 0xff}, {0xd1, 0xfc}, {0xd2, 0xff},
	{0xd3, 0xff}, {0xd4, 0xff},
*/
	// [Jack] switch to bank 1
	// {0xff, 0x01},
	//Voltage/Temperature/FANIN Limitation Registers
	{0x01, 0x00, 0x54}, {0x01, 0x01, 0x07}, {0x01, 0x02, 0x39}, {0x01, 0x03, 0x00}, {0x01, 0x04, 0x67}, {0x01, 0x05, 0x07}, {0x01, 0x06, 0x4B}, {0x01, 0x07, 0x00}, 
	{0x01, 0x08, 0x67}, {0x01, 0x09, 0x07}, {0x01, 0x0a, 0x54}, {0x01, 0x0b, 0x00},
	{0x01, 0x0c, 0x56}, {0x01, 0x0d, 0x07}, {0x01, 0x0e, 0x46}, {0x01, 0x0f, 0x00}, {0x01, 0x10, 0x56}, {0x01, 0x11, 0x07}, {0x01, 0x12, 0x46}, {0x01, 0x13, 0x00},
	{0x01, 0x14, 0x55}, {0x01, 0x15, 0x50}, {0x01, 0x16, 0x00}, {0x01, 0x17, 0x00}, {0x01, 0x18, 0x7d}, {0x01, 0x19, 0x07}, {0x01, 0x1a, 0x66}, {0x01, 0x1b, 0x00},
	{0x01, 0x1c, 0x55}, {0x01, 0x1d, 0x50}, {0x01, 0x1e, 0x00}, {0x01, 0x1f, 0x00}, {0x01, 0x20, 0x4B}, {0x01, 0x21, 0x07}, {0x01, 0x22, 0x25}, {0x01, 0x23, 0x00},
	{0x01, 0x24, 0x4B}, {0x01, 0x25, 0x07}, {0x01, 0x26, 0x25}, {0x01, 0x27, 0x00}, {0x01, 0x28, 0x67}, {0x01, 0x29, 0x07}, {0x01, 0x2a, 0x4b}, {0x01, 0x2b, 0x00},
	{0x01, 0x2c, 0x4C}, {0x01, 0x2d, 0x07}, {0x01, 0x2e, 0x3D}, {0x01, 0x2f, 0x00}, {0x01, 0x30, 0x67}, {0x01, 0x31, 0x07}, {0x01, 0x32, 0x4b}, {0x01, 0x33, 0x00},
	{0x01, 0x34, 0x67}, {0x01, 0x35, 0x07}, {0x01, 0x36, 0x54}, {0x01, 0x37, 0x00},
	{0x01, 0x38, 0x4c}, {0x01, 0x39, 0x07}, {0x01, 0x3a, 0x3d}, {0x01, 0x3b, 0x00}, {0x01, 0x3c, 0x4C}, {0x01, 0x3d, 0x07}, {0x01, 0x3e, 0x3D}, {0x01, 0x3f, 0x00},
	{0x01, 0x40, 0x4c}, {0x01, 0x41, 0x07}, {0x01, 0x42, 0x3d}, {0x01, 0x43, 0x00}, {0x01, 0x44, 0x55}, {0x01, 0x45, 0x07}, {0x01, 0x46, 0x50}, {0x01, 0x47, 0x00},
	{0x01, 0x60, 0x8c}, {0x01, 0x61, 0x06}, {0x01, 0x62, 0x8c}, {0x01, 0x63, 0x06}, {0x01, 0x64, 0x8c}, {0x01, 0x65, 0x06}, {0x01, 0x66, 0x8c}, {0x01, 0x67, 0x06},
	{0x01, 0x68, 0x8c}, {0x01, 0x69, 0x06}, {0x01, 0x6a, 0x8c}, {0x01, 0x6b, 0x06}, {0x01, 0x6c, 0x8c}, {0x01, 0x6d, 0x06}, {0x01, 0x6e, 0x8c}, {0x01, 0x6f, 0x06},
	{0x01, 0x90, 0x5f}, {0x01, 0x91, 0x5c}, {0x01, 0x92, 0x55}, {0x01, 0x93, 0x50}, {0x01, 0x94, 0x5f}, {0x01, 0x95, 0x5c}, {0x01, 0x96, 0x55}, {0x01, 0x97, 0x50},
	// Fan Fault Control
	//{0xdd, 0xff}, {0xde, 0x00}, // disable FAN_ALM
	// Temperature Fault Control
	//{0xe2, 0x03}, {0xe3, 0x00}, {0xe0, 0x80}, //disable TEMP_ALM
	// switch to bank 2
	// [Jack] {0xff, 0x02},
	//Set PECI Tbase and enable PECI 
	{0x02, 0x01, 0x01}, {0x02, 0x02, 0x30}, {0x02, 0x03, 0x40}, {0x02, 0x08, 0x64}, {0x02, 0x09, 0x64}, {0x02, 0x0a, 0x64}, {0x02, 0x0b, 0x64}, {0x02, 0x00, 0x98}, {0x02, 0x0c, 0x83}, // reset PECI once
	// [Jack] Init PCH
	//{0x02, 0x61, 0x96}, {0x02, 0x62, 0x44}, {0x02, 0x60, 0x90},

	// [Jack] switch to bank 3
	// {0xff, 0x03},
	//?Temperature to Fan Mapping relationships
	//{0x00, 0x01}, {0x01, 0x01}, {0x02, 0x02}, {0x03, 0x02}, {0x04, 0x66}, {0x05, 0x01}, {0x06, 0x01}, {0x08, 0x02},
	/*{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03},*/ {0x03, 0x04, 0x66}, {0x03, 0x05, 0x01}, {0x03, 0x06, 0x01}, {0x03, 0x08, 0x02}, // default STD mode
	//?Temperature Source Selector
	//{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x14}, {0x03, 0x0b, 0x03}, {0x03, 0x0c, 0x03},	// VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	//?Prescalar
	{0x03, 0x14, 0x84}, {0x03, 0x15, 0x84}, {0x03, 0x16, 0x84}, {0x03, 0x17, 0x84},
	//?Critical Temperature to Full Speed all Fan
	{0x03, 0x20, 0x5a}, {0x03, 0x21, 0x50}, {0x03, 0x22, 0x5a}, {0x03, 0x23, 0x50},
	//?Smart Fan IV
	{0x03, 0x30, 0x32}, {0x03, 0x31, 0x3c}, {0x03, 0x32, 0x50}, {0x03, 0x33, 0x5a},
	{0x03, 0x34, 0x33}, {0x03, 0x35, 0x78}, {0x03, 0x36, 0xbd}, {0x03, 0x37, 0xff},
	{0x03, 0x38, 0x28}, {0x03, 0x39, 0x32}, {0x03, 0x3a, 0x46}, {0x03, 0x3b, 0x50},
	{0x03, 0x3c, 0x33}, {0x03, 0x3d, 0x78}, {0x03, 0x3e, 0xbd}, {0x03, 0x3f, 0xff},
	{0x03, 0x40, 0x32}, {0x03, 0x41, 0x3c}, {0x03, 0x42, 0x50}, {0x03, 0x43, 0x5a},
	{0x03, 0x44, 0x33}, {0x03, 0x45, 0x78}, {0x03, 0x46, 0xbd}, {0x03, 0x47, 0xff},
	{0x03, 0x48, 0x28}, {0x03, 0x49, 0x32}, {0x03, 0x4a, 0x46}, {0x03, 0x4b, 0x50},
	{0x03, 0x4c, 0x33}, {0x03, 0x4d, 0x78}, {0x03, 0x4e, 0xbd}, {0x03, 0x4f, 0xff},

	{0x03, 0x09, 0x14}, {0x03, 0x0a, 0x15}, {0x03, 0x0b, 0x16}, {0x03, 0x0c, 0x03},	//adjust the init sequence: VT1(CPU), VT2(MEM), VT3(PCH), (VSEN8/TEMP_CH4)RT2
	{0x03, 0x00, 0x03}, {0x03, 0x01, 0x03}, {0x03, 0x02, 0x03}, {0x03, 0x03, 0x03}, //adjust the init sequence 
	// [Jack] switch to bank 0
	// {0xff, 0x00}

};

static int HWMonitorConfigSizeX9DRF =  sizeof (HW_monitor_config_table_X9DRF) / sizeof(HW_MONITOR_CONFIG);
