.SS CLASSIFY
This module allows you to set the skb\->priority value (and thus classify the packet into a specific CBQ class).
.TP
\fB\-\-set\-class\fP \fImajor\fP\fB:\fP\fIminor\fP
Set the major and minor class value. The values are always interpreted as
hexadecimal even if no 0x prefix is given.
.SS CLUSTERIP
This module allows you to configure a simple cluster of nodes that share
a certain IP and MAC address without an explicit load balancer in front of
them.  Connections are statically distributed between the nodes in this
cluster.
.TP
\fB\-\-new\fP
Create a new ClusterIP.  You always have to set this on the first rule
for a given ClusterIP.
.TP
\fB\-\-hashmode\fP \fImode\fP
Specify the hashing mode.  Has to be one of
\fBsourceip\fP, \fBsourceip\-sourceport\fP, \fBsourceip\-sourceport\-destport\fP.
.TP
\fB\-\-clustermac\fP \fImac\fP
Specify the ClusterIP MAC address. Has to be a link\-layer multicast address
.TP
\fB\-\-total\-nodes\fP \fInum\fP
Number of total nodes within this cluster.
.TP
\fB\-\-local\-node\fP \fInum\fP
Local node number within this cluster.
.TP
\fB\-\-hash\-init\fP \fIrnd\fP
Specify the random seed used for hash initialization.
.SS CONNMARK
This module sets the netfilter mark value associated with a connection. The
mark is 32 bits wide.
.TP
\fB\-\-set\-xmark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zero out the bits given by \fImask\fR and XOR \fIvalue\fR into the ctmark.
.TP
\fB\-\-save\-mark\fP [\fB\-\-nfmask\fP \fInfmask\fP] [\fB\-\-ctmask\fP \fIctmask\fP]
Copy the packet mark (nfmark) to the connection mark (ctmark) using the given
masks. The new nfmark value is determined as follows:
.IP
ctmark = (ctmark & ~ctmask) ^ (nfmark & nfmask)
.IP
i.e. \fIctmask\fR defines what bits to clear and \fInfmask\fR what bits of the
nfmark to XOR into the ctmark. \fIctmask\fR and \fInfmask\fR default to
0xFFFFFFFF.
.TP
\fB\-\-restore\-mark\fP [\fB\-\-nfmask\fP \fInfmask\fP] [\fB\-\-ctmask\fP \fIctmask\fP]
Copy the connection mark (ctmark) to the packet mark (nfmark) using the given
masks. The new ctmark value is determined as follows:
.IP
nfmark = (nfmark & ~\fInfmask\fR) ^ (ctmark & \fIctmask\fR);
.IP
i.e. \fInfmask\fR defines what bits to clear and \fIctmask\fR what bits of the
ctmark to XOR into the nfmark. \fIctmask\fR and \fInfmask\fR default to
0xFFFFFFFF.
.IP
\fB\-\-restore\-mark\fP is only valid in the \fBmangle\fP table.
.PP
The following mnemonics are available for \fB\-\-set\-xmark\fP:
.TP
\fB\-\-and\-mark\fP \fIbits\fP
Binary AND the ctmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark
0/\fR\fIinvbits\fR, where \fIinvbits\fR is the binary negation of \fIbits\fR.)
.TP
\fB\-\-or\-mark\fP \fIbits\fP
Binary OR the ctmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fR\fB/\fR\fIbits\fR.)
.TP
\fB\-\-xor\-mark\fP \fIbits\fP
Binary XOR the ctmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fR\fB/0\fR.)
.TP
\fB\-\-set\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Set the connection mark. If a mask is specified then only those bits set in the
mask are modified.
.TP
\fB\-\-save\-mark\fP [\fB\-\-mask\fP \fImask\fP]
Copy the nfmark to the ctmark. If a mask is specified, only those bits are
copied.
.TP
\fB\-\-restore\-mark\fP [\fB\-\-mask\fP \fImask\fP]
Copy the ctmark to the nfmark. If a mask is specified, only those bits are
copied. This is only valid in the \fBmangle\fR table.
.SS CONNSECMARK
This module copies security markings from packets to connections
(if unlabeled), and from connections back to packets (also only
if unlabeled).  Typically used in conjunction with SECMARK, it is
only valid in the
.B mangle
table.
.TP
\fB\-\-save\fP
If the packet has a security marking, copy it to the connection
if the connection is not marked.
.TP
\fB\-\-restore\fP
If the packet does not have a security marking, and the connection
does, copy the security marking from the connection to the packet.

.SS CT
The CT target allows to set parameters for a packet or its associated
connection. The target attaches a "template" connection tracking entry to
the packet, which is then used by the conntrack core when initializing
a new ct entry. This target is thus only valid in the "raw" table.
.TP
\fB\-\-notrack\fP
Disables connection tracking for this packet.
.TP
\fB\-\-helper\fP \fIname\fP
Use the helper identified by \fIname\fP for the connection. This is more
flexible than loading the conntrack helper modules with preset ports.
.TP
\fB\-\-ctevents\fP \fIevent\fP[\fB,\fP...]
Only generate the specified conntrack events for this connection. Possible
event types are: \fBnew\fP, \fBrelated\fP, \fBdestroy\fP, \fBreply\fP,
\fBassured\fP, \fBprotoinfo\fP, \fBhelper\fP, \fBmark\fP (this refers to
the ctmark, not nfmark), \fBnatseqinfo\fP, \fBsecmark\fP (ctsecmark).
.TP
\fB\-\-expevents\fP \fIevent\fP[\fB,\fP...]
Only generate the specified expectation events for this connection.
Possible event types are: \fBnew\fP.
.TP
\fB\-\-zone\fP \fIid\fP
Assign this packet to zone \fIid\fP and only have lookups done in that zone.
By default, packets have zone 0.
.SS DNAT
This target is only valid in the
.B nat
table, in the
.B PREROUTING
and
.B OUTPUT
chains, and user-defined chains which are only called from those
chains.  It specifies that the destination address of the packet
should be modified (and all future packets in this connection will
also be mangled), and rules should cease being examined.  It takes one
type of option:
.TP
\fB\-\-to\-destination\fP [\fIipaddr\fP][\fB\-\fP\fIipaddr\fP][\fB:\fP\fIport\fP[\fB\-\fP\fIport\fP]]
which can specify a single new destination IP address, an inclusive
range of IP addresses, and optionally, a port range (which is only
valid if the rule also specifies
\fB\-p tcp\fP
or
\fB\-p udp\fP).
If no port range is specified, then the destination port will never be
modified. If no IP address is specified then only the destination port
will be modified.

In Kernels up to 2.6.10 you can add several \-\-to\-destination options. For
those kernels, if you specify more than one destination address, either via an
address range or multiple \-\-to\-destination options, a simple round-robin (one
after another in cycle) load balancing takes place between these addresses.
Later Kernels (>= 2.6.11-rc1) don't have the ability to NAT to multiple ranges
anymore.
.TP
\fB\-\-random\fP
If option
\fB\-\-random\fP
is used then port mapping will be randomized (kernel >= 2.6.22).
.TP
\fB\-\-persistent\fP
Gives a client the same source-/destination-address for each connection.
This supersedes the SAME target. Support for persistent mappings is available
from 2.6.29-rc2.
.SS DSCP
This target allows to alter the value of the DSCP bits within the TOS
header of the IPv4 packet.  As this manipulates a packet, it can only
be used in the mangle table.
.TP
\fB\-\-set\-dscp\fP \fIvalue\fP
Set the DSCP field to a numerical value (can be decimal or hex)
.TP
\fB\-\-set\-dscp\-class\fP \fIclass\fP
Set the DSCP field to a DiffServ class.
.SS ECN
This target allows to selectively work around known ECN blackholes.
It can only be used in the mangle table.
.TP
\fB\-\-ecn\-tcp\-remove\fP
Remove all ECN bits from the TCP header.  Of course, it can only be used
in conjunction with
\fB\-p tcp\fP.
.SS LOG
Turn on kernel logging of matching packets.  When this option is set
for a rule, the Linux kernel will print some information on all
matching packets (like most IP header fields) via the kernel log
(where it can be read with
.I dmesg
or 
.IR syslogd (8)).
This is a "non-terminating target", i.e. rule traversal continues at
the next rule.  So if you want to LOG the packets you refuse, use two
separate rules with the same matching criteria, first using target LOG
then DROP (or REJECT).
.TP
\fB\-\-log\-level\fP \fIlevel\fP
Level of logging (numeric or see \fIsyslog.conf\fP(5)).
.TP
\fB\-\-log\-prefix\fP \fIprefix\fP
Prefix log messages with the specified prefix; up to 29 letters long,
and useful for distinguishing messages in the logs.
.TP
\fB\-\-log\-tcp\-sequence\fP
Log TCP sequence numbers. This is a security risk if the log is
readable by users.
.TP
\fB\-\-log\-tcp\-options\fP
Log options from the TCP packet header.
.TP
\fB\-\-log\-ip\-options\fP
Log options from the IP packet header.
.TP
\fB\-\-log\-uid\fP
Log the userid of the process which generated the packet.
.SS MARK
This target is used to set the Netfilter mark value associated with the packet.
It can, for example, be used in conjunction with routing based on fwmark (needs
iproute2). If you plan on doing so, note that the mark needs to be set in the
PREROUTING chain of the mangle table to affect routing.
The mark field is 32 bits wide.
.TP
\fB\-\-set\-xmark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fR and XORs \fIvalue\fR into the packet
mark ("nfmark"). If \fImask\fR is omitted, 0xFFFFFFFF is assumed.
.TP
\fB\-\-set\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fR and ORs \fIvalue\fR into the packet
mark. If \fImask\fR is omitted, 0xFFFFFFFF is assumed.
.PP
The following mnemonics are available:
.TP
\fB\-\-and\-mark\fP \fIbits\fP
Binary AND the nfmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark
0/\fR\fIinvbits\fR, where \fIinvbits\fR is the binary negation of \fIbits\fR.)
.TP
\fB\-\-or\-mark\fP \fIbits\fP
Binary OR the nfmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fR\fB/\fR\fIbits\fR.)
.TP
\fB\-\-xor\-mark\fP \fIbits\fP
Binary XOR the nfmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fR\fB/0\fR.)
.SS MASQUERADE
This target is only valid in the
.B nat
table, in the
.B POSTROUTING
chain.  It should only be used with dynamically assigned IP (dialup)
connections: if you have a static IP address, you should use the SNAT
target.  Masquerading is equivalent to specifying a mapping to the IP
address of the interface the packet is going out, but also has the
effect that connections are
.I forgotten
when the interface goes down.  This is the correct behavior when the
next dialup is unlikely to have the same interface address (and hence
any established connections are lost anyway).  It takes one option:
.TP
\fB\-\-to\-ports\fP \fIport\fP[\fB\-\fP\fIport\fP]
This specifies a range of source ports to use, overriding the default
.B SNAT
source port-selection heuristics (see above).  This is only valid
if the rule also specifies
\fB\-p tcp\fP
or
\fB\-p udp\fP.
.TP
\fB\-\-random\fP
Randomize source port mapping
If option
\fB\-\-random\fP
is used then port mapping will be randomized (kernel >= 2.6.21).
.RS
.PP
.SS MIRROR
This is an experimental demonstration target which inverts the source
and destination fields in the IP header and retransmits the packet.
It is only valid in the
.BR INPUT ,
.B FORWARD
and
.B PREROUTING
chains, and user-defined chains which are only called from those
chains.  Note that the outgoing packets are
.B NOT
seen by any packet filtering chains, connection tracking or NAT, to
avoid loops and other problems.
.SS NETMAP
This target allows you to statically map a whole network of addresses onto
another network of addresses.  It can only be used from rules in the
.B nat
table.
.TP
\fB\-\-to\fP \fIaddress\fP[\fB/\fP\fImask\fP]
Network address to map to.  The resulting address will be constructed in the
following way: All 'one' bits in the mask are filled in from the new `address'.
All bits that are zero in the mask are filled in from the original address.
.SS NFLOG
This target provides logging of matching packets. When this target is
set for a rule, the Linux kernel will pass the packet to the loaded
logging backend to log the packet. This is usually used in combination
with nfnetlink_log as logging backend, which will multicast the packet
through a
.IR netlink
socket to the specified multicast group. One or more userspace processes
may subscribe to the group to receive the packets. Like LOG, this is a
non-terminating target, i.e. rule traversal continues at the next rule.
.TP
\fB\-\-nflog\-group\fP \fInlgroup\fP
The netlink group (1 \- 2^32\-1) to which packets are (only applicable for
nfnetlink_log). The default value is 0.
.TP
\fB\-\-nflog\-prefix\fP \fIprefix\fP
A prefix string to include in the log message, up to 64 characters
long, useful for distinguishing messages in the logs.
.TP
\fB\-\-nflog\-range\fP \fIsize\fP
The number of bytes to be copied to userspace (only applicable for
nfnetlink_log). nfnetlink_log instances may specify their own
range, this option overrides it.
.TP
\fB\-\-nflog\-threshold\fP \fIsize\fP
Number of packets to queue inside the kernel before sending them
to userspace (only applicable for nfnetlink_log). Higher values
result in less overhead per packet, but increase delay until the
packets reach userspace. The default value is 1.
.BR
.SS NFQUEUE
This target is an extension of the QUEUE target. As opposed to QUEUE, it allows
you to put a packet into any specific queue, identified by its 16-bit queue
number.
It can only be used with Kernel versions 2.6.14 or later, since it requires
the
.B
nfnetlink_queue
kernel support. The \fBqueue-balance\fP option was added in Linux 2.6.31.
.TP
\fB\-\-queue\-num\fP \fIvalue\fP
This specifies the QUEUE number to use. Valid queue numbers are 0 to 65535. The default value is 0.
.PP
.TP
\fB\-\-queue\-balance\fP \fIvalue\fP\fB:\fP\fIvalue\fP
This specifies a range of queues to use. Packets are then balanced across the given queues.
This is useful for multicore systems: start multiple instances of the userspace program on
queues x, x+1, .. x+n and use "\-\-queue\-balance \fIx\fP\fB:\fP\fIx+n\fP".
Packets belonging to the same connection are put into the same nfqueue.
.SS NOTRACK
This target disables connection tracking for all packets matching that rule.
.PP
It can only be used in the
.B raw
table.
.SS RATEEST
The RATEEST target collects statistics, performs rate estimation calculation
and saves the results for later evaluation using the \fBrateest\fP match.
.TP
\fB\-\-rateest\-name\fP \fIname\fP
Count matched packets into the pool referred to by \fIname\fP, which is freely
choosable.
.TP
\fB\-\-rateest\-interval\fP \fIamount\fP{\fBs\fP|\fBms\fP|\fBus\fP}
Rate measurement interval, in seconds, milliseconds or microseconds.
.TP
\fB\-\-rateest\-ewmalog\fP \fIvalue\fP
Rate measurement averaging time constant.
.SS REDIRECT
This target is only valid in the
.B nat
table, in the
.B PREROUTING
and
.B OUTPUT
chains, and user-defined chains which are only called from those
chains.  It redirects the packet to the machine itself by changing the
destination IP to the primary address of the incoming interface
(locally-generated packets are mapped to the 127.0.0.1 address).
.TP
\fB\-\-to\-ports\fP \fIport\fP[\fB\-\fP\fIport\fP]
This specifies a destination port or range of ports to use: without
this, the destination port is never altered.  This is only valid
if the rule also specifies
\fB\-p tcp\fP
or
\fB\-p udp\fP.
.TP
\fB\-\-random\fP
If option
\fB\-\-random\fP
is used then port mapping will be randomized (kernel >= 2.6.22).
.RS
.PP
.SS REJECT
This is used to send back an error packet in response to the matched
packet: otherwise it is equivalent to
.B DROP
so it is a terminating TARGET, ending rule traversal.
This target is only valid in the
.BR INPUT ,
.B FORWARD
and
.B OUTPUT
chains, and user-defined chains which are only called from those
chains.  The following option controls the nature of the error packet
returned:
.TP
\fB\-\-reject\-with\fP \fItype\fP
The type given can be
\fBicmp\-net\-unreachable\fP,
\fBicmp\-host\-unreachable\fP,
\fBicmp\-port\-unreachable\fP,
\fBicmp\-proto\-unreachable\fP,
\fBicmp\-net\-prohibited\fP,
\fBicmp\-host\-prohibited\fP or
\fBicmp\-admin\-prohibited\fP (*)
which return the appropriate ICMP error message (\fBport\-unreachable\fP is
the default).  The option
\fBtcp\-reset\fP
can be used on rules which only match the TCP protocol: this causes a
TCP RST packet to be sent back.  This is mainly useful for blocking 
.I ident
(113/tcp) probes which frequently occur when sending mail to broken mail
hosts (which won't accept your mail otherwise).
.PP
(*) Using icmp\-admin\-prohibited with kernels that do not support it will result in a plain DROP instead of REJECT
.SS SAME
Similar to SNAT/DNAT depending on chain: it takes a range of addresses
(`\-\-to 1.2.3.4\-1.2.3.7') and gives a client the same
source-/destination-address for each connection.
.PP
N.B.: The DNAT target's \fB\-\-persistent\fP option replaced the SAME target.
.TP
\fB\-\-to\fP \fIipaddr\fP[\fB\-\fP\fIipaddr\fP]
Addresses to map source to. May be specified more than once for
multiple ranges.
.TP
\fB\-\-nodst\fP
Don't use the destination-ip in the calculations when selecting the
new source-ip
.TP
\fB\-\-random\fP
Port mapping will be forcibly randomized to avoid attacks based on 
port prediction (kernel >= 2.6.21).
.SS SECMARK
This is used to set the security mark value associated with the
packet for use by security subsystems such as SELinux.  It is only
valid in the
.B mangle
table. The mark is 32 bits wide.
.TP
\fB\-\-selctx\fP \fIsecurity_context\fP
.SS SET
This modules adds and/or deletes entries from IP sets which can be defined 
by ipset(8).
.TP
\fB\-\-add\-set\fP \fIsetname\fP \fIflag\fP[\fB,\fP\fIflag\fP...]
add the address(es)/port(s) of the packet to the sets
.TP
\fB\-\-del\-set\fP \fIsetname\fP \fIflag\fP[\fB,\fP\fIflag\fP...]
delete the address(es)/port(s) of the packet from the sets
.IP
where flags are
.BR "src"
and/or
.BR "dst"
specifications and there can be no more than six of them.
.PP
Use of -j SET requires that ipset kernel support is provided. As standard
kernels do not ship this currently, the ipset or Xtables-addons package needs
to be installed.
.SS SNAT
This target is only valid in the
.B nat
table, in the
.B POSTROUTING
chain.  It specifies that the source address of the packet should be
modified (and all future packets in this connection will also be
mangled), and rules should cease being examined.  It takes one type
of option:
.TP
\fB\-\-to\-source\fP \fIipaddr\fP[\fB\-\fP\fIipaddr\fP][\fB:\fP\fIport\fP[\fB\-\fP\fIport\fP]]
which can specify a single new source IP address, an inclusive range
of IP addresses, and optionally, a port range (which is only valid if
the rule also specifies
\fB\-p tcp\fP
or
\fB\-p udp\fP).
If no port range is specified, then source ports below 512 will be
mapped to other ports below 512: those between 512 and 1023 inclusive
will be mapped to ports below 1024, and other ports will be mapped to
1024 or above. Where possible, no port alteration will

In Kernels up to 2.6.10, you can add several \-\-to\-source options. For those
kernels, if you specify more than one source address, either via an address
range or multiple \-\-to\-source options, a simple round-robin (one after another
in cycle) takes place between these addresses.
Later Kernels (>= 2.6.11-rc1) don't have the ability to NAT to multiple ranges
anymore.
.TP
\fB\-\-random\fP
If option
\fB\-\-random\fP
is used then port mapping will be randomized (kernel >= 2.6.21).
.TP
\fB\-\-persistent\fP
Gives a client the same source-/destination-address for each connection.
This supersedes the SAME target. Support for persistent mappings is available
from 2.6.29-rc2.
.SS TCPMSS
This target allows to alter the MSS value of TCP SYN packets, to control
the maximum size for that connection (usually limiting it to your
outgoing interface's MTU minus 40 for IPv4 or 60 for IPv6, respectively).
Of course, it can only be used
in conjunction with
\fB\-p tcp\fP.
.PP
This target is used to overcome criminally braindead ISPs or servers
which block "ICMP Fragmentation Needed" or "ICMPv6 Packet Too Big"
packets.  The symptoms of this
problem are that everything works fine from your Linux
firewall/router, but machines behind it can never exchange large
packets:
.PD 0
.RS 0.1i
.TP 0.3i
1)
Web browsers connect, then hang with no data received.
.TP
2)
Small mail works fine, but large emails hang.
.TP
3)
ssh works fine, but scp hangs after initial handshaking.
.RE
.PD
Workaround: activate this option and add a rule to your firewall
configuration like:
.IP
 iptables \-t mangle \-A FORWARD \-p tcp \-\-tcp\-flags SYN,RST SYN
             \-j TCPMSS \-\-clamp\-mss\-to\-pmtu
.TP
\fB\-\-set\-mss\fP \fIvalue\fP
Explicitly sets MSS option to specified value. If the MSS of the packet is
already lower than \fIvalue\fP, it will \fBnot\fP be increased (from Linux
2.6.25 onwards) to avoid more problems with hosts relying on a proper MSS.
.TP
\fB\-\-clamp\-mss\-to\-pmtu\fP
Automatically clamp MSS value to (path_MTU \- 40 for IPv4; \-60 for IPv6).
This may not function as desired where asymmetric routes with differing
path MTU exist \(em the kernel uses the path MTU which it would use to send
packets from itself to the source and destination IP addresses. Prior to
Linux 2.6.25, only the path MTU to the destination IP address was
considered by this option; subsequent kernels also consider the path MTU
to the source IP address.
.PP
These options are mutually exclusive.
.SS TCPOPTSTRIP
This target will strip TCP options off a TCP packet. (It will actually replace
them by NO-OPs.) As such, you will need to add the \fB\-p tcp\fP parameters.
.TP
\fB\-\-strip\-options\fP \fIoption\fP[\fB,\fP\fIoption\fP...]
Strip the given option(s). The options may be specified by TCP option number or
by symbolic name. The list of recognized options can be obtained by calling
iptables with \fB\-j TCPOPTSTRIP \-h\fP.
.SS TEE
The \fBTEE\fP target will clone a packet and redirect this clone to another
machine on the \fBlocal\fP network segment. In other words, the nexthop
must be the target, or you will have to configure the nexthop to forward it
further if so desired.
.TP
\fB\-\-gateway\fP \fIipaddr\fP
Send the cloned packet to the host reachable at the given IP address.
Use of 0.0.0.0 (for IPv4 packets) or :: (IPv6) is invalid.
.PP
To forward all incoming traffic on eth0 to an Network Layer logging box:
.PP
\-t mangle \-A PREROUTING \-i eth0 \-j TEE \-\-gateway 2001:db8::1
.SS TOS
This module sets the Type of Service field in the IPv4 header (including the
"precedence" bits) or the Priority field in the IPv6 header. Note that TOS
shares the same bits as DSCP and ECN. The TOS target is only valid in the
\fBmangle\fR table.
.TP
\fB\-\-set\-tos\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fR and XORs \fIvalue\fR into the
TOS/Priority field. If \fImask\fR is omitted, 0xFF is assumed.
.TP
\fB\-\-set\-tos\fP \fIsymbol\fP
You can specify a symbolic name when using the TOS target for IPv4. It implies
a mask of 0xFF. The list of recognized TOS names can be obtained by calling
iptables with \fB\-j TOS \-h\fP.
.PP
The following mnemonics are available:
.TP
\fB\-\-and\-tos\fP \fIbits\fP
Binary AND the TOS value with \fIbits\fR. (Mnemonic for \fB\-\-set\-tos
0/\fR\fIinvbits\fR, where \fIinvbits\fR is the binary negation of \fIbits\fR.)
.TP
\fB\-\-or\-tos\fP \fIbits\fP
Binary OR the TOS value with \fIbits\fR. (Mnemonic for \fB\-\-set\-tos\fP
\fIbits\fR\fB/\fR\fIbits\fR.)
.TP
\fB\-\-xor\-tos\fP \fIbits\fP
Binary XOR the TOS value with \fIbits\fR. (Mnemonic for \fB\-\-set\-tos\fP
\fIbits\fR\fB/0\fR.)
.SS TPROXY
This target is only valid in the \fBmangle\fR table, in the \fBPREROUTING\fR
chain and user-defined chains which are only called from this chain. It
redirects the packet to a local socket without changing the packet header in
any way. It can also change the mark value which can then be used in advanced
routing rules.
It takes three options:
.TP
\fB\-\-on\-port\fP \fIport\fP
This specifies a destination port to use. It is a required option, 0 means the
new destination port is the same as the original. This is only valid if the
rule also specifies \fB\-p tcp\fP or \fB\-p udp\fP.
.TP
\fB\-\-on\-ip\fP \fIaddress\fP
This specifies a destination address to use. By default the address is the IP
address of the incoming interface. This is only valid if the rule also
specifies \fB\-p tcp\fP or \fB\-p udp\fP.
.TP
\fB\-\-tproxy\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Marks packets with the given value/mask. The fwmark value set here can be used
by advanced routing. (Required for transparent proxying to work: otherwise
these packets will get forwarded, which is probably not what you want.)
.SS TRACE
This target marks packes so that the kernel will log every rule which match 
the packets as those traverse the tables, chains, rules. (The ipt_LOG or
ip6t_LOG module 
is required for the logging.) The packets are logged with the string prefix: 
"TRACE: tablename:chainname:type:rulenum " where type can be "rule" for 
plain rule, "return" for implicit rule at the end of a user defined chain 
and "policy" for the policy of the built in chains. 
.br
It can only be used in the
.BR raw
table.
.SS TTL
This is used to modify the IPv4 TTL header field.  The TTL field determines
how many hops (routers) a packet can traverse until it's time to live is
exceeded.
.PP
Setting or incrementing the TTL field can potentially be very dangerous,
so it should be avoided at any cost.  
.PP
.B Don't ever set or increment the value on packets that leave your local network!
.B mangle
table.
.TP
\fB\-\-ttl\-set\fP \fIvalue\fP
Set the TTL value to `value'.
.TP
\fB\-\-ttl\-dec\fP \fIvalue\fP
Decrement the TTL value `value' times.
.TP
\fB\-\-ttl\-inc\fP \fIvalue\fP
Increment the TTL value `value' times.
.SS ULOG
This target provides userspace logging of matching packets.  When this
target is set for a rule, the Linux kernel will multicast this packet
through a
.IR netlink 
socket. One or more userspace processes may then subscribe to various 
multicast groups and receive the packets.
Like LOG, this is a "non-terminating target", i.e. rule traversal
continues at the next rule.
.TP
\fB\-\-ulog\-nlgroup\fP \fInlgroup\fP
This specifies the netlink group (1-32) to which the packet is sent.
Default value is 1.
.TP
\fB\-\-ulog\-prefix\fP \fIprefix\fP
Prefix log messages with the specified prefix; up to 32 characters
long, and useful for distinguishing messages in the logs.
.TP
\fB\-\-ulog\-cprange\fP \fIsize\fP
Number of bytes to be copied to userspace.  A value of 0 always copies
the entire packet, regardless of its size.  Default is 0.
.TP
\fB\-\-ulog\-qthreshold\fP \fIsize\fP
Number of packet to queue inside kernel.  Setting this value to, e.g. 10
accumulates ten packets inside the kernel and transmits them as one
netlink multipart message to userspace.  Default is 1 (for backwards
compatibility).
.br
