/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the w64 mingw-runtime package.
 * No warranty is given; refer to the file DISCLAIMER within this package.
 */
#ifdef DEFINE_GUID

#ifndef FAR
#define FAR
#endif

DEFINE_GUID(GUID_DEVINTERFACE_DISK,0x53f56307L,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_CDROM,0x53f56308L,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_PARTITION,0x53f5630aL,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_TAPE,0x53f5630bL,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_WRITEONCEDISK,0x53f5630cL,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_VOLUME,0x53f5630dL,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_MEDIUMCHANGER,0x53f56310L,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_FLOPPY,0x53f56311L,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_CDCHANGER,0x53f56312L,0xb6bf,0x11d0,0x94,0xf2,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_STORAGEPORT,0x2accfe60L,0xc130,0x11d2,0xb0,0x82,0x00,0xa0,0xc9,0x1e,0xfb,0x8b);
DEFINE_GUID(GUID_DEVINTERFACE_COMPORT,0x86e0d1e0L,0x8089,0x11d0,0x9c,0xe4,0x08,0x00,0x3e,0x30,0x1f,0x73);
DEFINE_GUID(GUID_DEVINTERFACE_SERENUM_BUS_ENUMERATOR,0x4D36E978L,0xE325,0x11CE,0xBF,0xC1,0x08,0x00,0x2B,0xE1,0x03,0x18);

#define DiskClassGuid GUID_DEVINTERFACE_DISK
#define CdRomClassGuid GUID_DEVINTERFACE_CDROM
#define PartitionClassGuid GUID_DEVINTERFACE_PARTITION
#define TapeClassGuid GUID_DEVINTERFACE_TAPE
#define WriteOnceDiskClassGuid GUID_DEVINTERFACE_WRITEONCEDISK
#define VolumeClassGuid GUID_DEVINTERFACE_VOLUME
#define MediumChangerClassGuid GUID_DEVINTERFACE_MEDIUMCHANGER
#define FloppyClassGuid GUID_DEVINTERFACE_FLOPPY
#define CdChangerClassGuid GUID_DEVINTERFACE_CDCHANGER
#define StoragePortClassGuid GUID_DEVINTERFACE_STORAGEPORT
#define GUID_CLASS_COMPORT GUID_DEVINTERFACE_COMPORT
#define GUID_SERENUM_BUS_ENUMERATOR GUID_DEVINTERFACE_SERENUM_BUS_ENUMERATOR
#endif

#ifndef _WINIOCTL_
#define _WINIOCTL_

#ifndef _DEVIOCTL_
#define _DEVIOCTL_

#define DEVICE_TYPE DWORD

#define FILE_DEVICE_BEEP 0x00000001
#define FILE_DEVICE_CD_ROM 0x00000002
#define FILE_DEVICE_CD_ROM_FILE_SYSTEM 0x00000003
#define FILE_DEVICE_CONTROLLER 0x00000004
#define FILE_DEVICE_DATALINK 0x00000005
#define FILE_DEVICE_DFS 0x00000006
#define FILE_DEVICE_DISK 0x00000007
#define FILE_DEVICE_DISK_FILE_SYSTEM 0x00000008
#define FILE_DEVICE_FILE_SYSTEM 0x00000009
#define FILE_DEVICE_INPORT_PORT 0x0000000a
#define FILE_DEVICE_KEYBOARD 0x0000000b
#define FILE_DEVICE_MAILSLOT 0x0000000c
#define FILE_DEVICE_MIDI_IN 0x0000000d
#define FILE_DEVICE_MIDI_OUT 0x0000000e
#define FILE_DEVICE_MOUSE 0x0000000f
#define FILE_DEVICE_MULTI_UNC_PROVIDER 0x00000010
#define FILE_DEVICE_NAMED_PIPE 0x00000011
#define FILE_DEVICE_NETWORK 0x00000012
#define FILE_DEVICE_NETWORK_BROWSER 0x00000013
#define FILE_DEVICE_NETWORK_FILE_SYSTEM 0x00000014
#define FILE_DEVICE_NULL 0x00000015
#define FILE_DEVICE_PARALLEL_PORT 0x00000016
#define FILE_DEVICE_PHYSICAL_NETCARD 0x00000017
#define FILE_DEVICE_PRINTER 0x00000018
#define FILE_DEVICE_SCANNER 0x00000019
#define FILE_DEVICE_SERIAL_MOUSE_PORT 0x0000001a
#define FILE_DEVICE_SERIAL_PORT 0x0000001b
#define FILE_DEVICE_SCREEN 0x0000001c
#define FILE_DEVICE_SOUND 0x0000001d
#define FILE_DEVICE_STREAMS 0x0000001e
#define FILE_DEVICE_TAPE 0x0000001f
#define FILE_DEVICE_TAPE_FILE_SYSTEM 0x00000020
#define FILE_DEVICE_TRANSPORT 0x00000021
#define FILE_DEVICE_UNKNOWN 0x00000022
#define FILE_DEVICE_VIDEO 0x00000023
#define FILE_DEVICE_VIRTUAL_DISK 0x00000024
#define FILE_DEVICE_WAVE_IN 0x00000025
#define FILE_DEVICE_WAVE_OUT 0x00000026
#define FILE_DEVICE_8042_PORT 0x00000027
#define FILE_DEVICE_NETWORK_REDIRECTOR 0x00000028
#define FILE_DEVICE_BATTERY 0x00000029
#define FILE_DEVICE_BUS_EXTENDER 0x0000002a
#define FILE_DEVICE_MODEM 0x0000002b
#define FILE_DEVICE_VDM 0x0000002c
#define FILE_DEVICE_MASS_STORAGE 0x0000002d
#define FILE_DEVICE_SMB 0x0000002e
#define FILE_DEVICE_KS 0x0000002f
#define FILE_DEVICE_CHANGER 0x00000030
#define FILE_DEVICE_SMARTCARD 0x00000031
#define FILE_DEVICE_ACPI 0x00000032
#define FILE_DEVICE_DVD 0x00000033
#define FILE_DEVICE_FULLSCREEN_VIDEO 0x00000034
#define FILE_DEVICE_DFS_FILE_SYSTEM 0x00000035
#define FILE_DEVICE_DFS_VOLUME 0x00000036
#define FILE_DEVICE_SERENUM 0x00000037
#define FILE_DEVICE_TERMSRV 0x00000038
#define FILE_DEVICE_KSEC 0x00000039
#define FILE_DEVICE_FIPS 0x0000003A
#define FILE_DEVICE_INFINIBAND 0x0000003B

#define CTL_CODE(DeviceType,Function,Method,Access) (((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method))

#define DEVICE_TYPE_FROM_CTL_CODE(ctrlCode) (((DWORD)(ctrlCode & 0xffff0000)) >> 16)

#define METHOD_BUFFERED 0
#define METHOD_IN_DIRECT 1
#define METHOD_OUT_DIRECT 2
#define METHOD_NEITHER 3

#define METHOD_DIRECT_TO_HARDWARE METHOD_IN_DIRECT
#define METHOD_DIRECT_FROM_HARDWARE METHOD_OUT_DIRECT

#define FILE_ANY_ACCESS 0
#define FILE_SPECIAL_ACCESS (FILE_ANY_ACCESS)
#define FILE_READ_ACCESS (0x0001)
#define FILE_WRITE_ACCESS (0x0002)
#endif

#ifndef _NTDDSTOR_H_
#define _NTDDSTOR_H_

#ifdef __cplusplus
extern "C" {
#endif

#define IOCTL_STORAGE_BASE FILE_DEVICE_MASS_STORAGE

#define IOCTL_STORAGE_CHECK_VERIFY CTL_CODE(IOCTL_STORAGE_BASE,0x0200,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_STORAGE_CHECK_VERIFY2 CTL_CODE(IOCTL_STORAGE_BASE,0x0200,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_MEDIA_REMOVAL CTL_CODE(IOCTL_STORAGE_BASE,0x0201,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_STORAGE_EJECT_MEDIA CTL_CODE(IOCTL_STORAGE_BASE,0x0202,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_STORAGE_LOAD_MEDIA CTL_CODE(IOCTL_STORAGE_BASE,0x0203,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_STORAGE_LOAD_MEDIA2 CTL_CODE(IOCTL_STORAGE_BASE,0x0203,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_RESERVE CTL_CODE(IOCTL_STORAGE_BASE,0x0204,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_STORAGE_RELEASE CTL_CODE(IOCTL_STORAGE_BASE,0x0205,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_STORAGE_FIND_NEW_DEVICES CTL_CODE(IOCTL_STORAGE_BASE,0x0206,METHOD_BUFFERED,FILE_READ_ACCESS)

#define IOCTL_STORAGE_EJECTION_CONTROL CTL_CODE(IOCTL_STORAGE_BASE,0x0250,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_MCN_CONTROL CTL_CODE(IOCTL_STORAGE_BASE,0x0251,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_STORAGE_GET_MEDIA_TYPES CTL_CODE(IOCTL_STORAGE_BASE,0x0300,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_MEDIA_TYPES_EX CTL_CODE(IOCTL_STORAGE_BASE,0x0301,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_MEDIA_SERIAL_NUMBER CTL_CODE(IOCTL_STORAGE_BASE,0x0304,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_HOTPLUG_INFO CTL_CODE(IOCTL_STORAGE_BASE,0x0305,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_SET_HOTPLUG_INFO CTL_CODE(IOCTL_STORAGE_BASE,0x0306,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)

#define IOCTL_STORAGE_RESET_BUS CTL_CODE(IOCTL_STORAGE_BASE,0x0400,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_STORAGE_RESET_DEVICE CTL_CODE(IOCTL_STORAGE_BASE,0x0401,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_STORAGE_BREAK_RESERVATION CTL_CODE(IOCTL_STORAGE_BASE,0x0405,METHOD_BUFFERED,FILE_READ_ACCESS)

#define IOCTL_STORAGE_GET_DEVICE_NUMBER CTL_CODE(IOCTL_STORAGE_BASE,0x0420,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_PREDICT_FAILURE CTL_CODE(IOCTL_STORAGE_BASE,0x0440,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_STORAGE_READ_CAPACITY CTL_CODE(IOCTL_STORAGE_BASE,0x0450,METHOD_BUFFERED,FILE_READ_ACCESS)

#define OBSOLETE_IOCTL_STORAGE_RESET_BUS CTL_CODE(IOCTL_STORAGE_BASE,0x0400,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define OBSOLETE_IOCTL_STORAGE_RESET_DEVICE CTL_CODE(IOCTL_STORAGE_BASE,0x0401,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)

  typedef struct _STORAGE_HOTPLUG_INFO {
    DWORD Size;
    BOOLEAN MediaRemovable;
    BOOLEAN MediaHotplug;
    BOOLEAN DeviceHotplug;
    BOOLEAN WriteCacheEnableOverride;
  } STORAGE_HOTPLUG_INFO,*PSTORAGE_HOTPLUG_INFO;

  typedef struct _STORAGE_DEVICE_NUMBER {
    DEVICE_TYPE DeviceType;
    DWORD DeviceNumber;
    DWORD PartitionNumber;
  } STORAGE_DEVICE_NUMBER,*PSTORAGE_DEVICE_NUMBER;

  typedef struct _STORAGE_BUS_RESET_REQUEST {
    BYTE PathId;
  } STORAGE_BUS_RESET_REQUEST,*PSTORAGE_BUS_RESET_REQUEST;

  typedef struct STORAGE_BREAK_RESERVATION_REQUEST {
    DWORD Length;
    BYTE _unused;
    BYTE PathId;
    BYTE TargetId;
    BYTE Lun;
  } STORAGE_BREAK_RESERVATION_REQUEST,*PSTORAGE_BREAK_RESERVATION_REQUEST;

  typedef struct _PREVENT_MEDIA_REMOVAL {
    BOOLEAN PreventMediaRemoval;
  } PREVENT_MEDIA_REMOVAL,*PPREVENT_MEDIA_REMOVAL;

  typedef struct _CLASS_MEDIA_CHANGE_CONTEXT {
    DWORD MediaChangeCount;
    DWORD NewState;
  } CLASS_MEDIA_CHANGE_CONTEXT,*PCLASS_MEDIA_CHANGE_CONTEXT;

  typedef struct _TAPE_STATISTICS {
    DWORD Version;
    DWORD Flags;
    LARGE_INTEGER RecoveredWrites;
    LARGE_INTEGER UnrecoveredWrites;
    LARGE_INTEGER RecoveredReads;
    LARGE_INTEGER UnrecoveredReads;
    BYTE CompressionRatioReads;
    BYTE CompressionRatioWrites;
  } TAPE_STATISTICS,*PTAPE_STATISTICS;

#define RECOVERED_WRITES_VALID 0x00000001
#define UNRECOVERED_WRITES_VALID 0x00000002
#define RECOVERED_READS_VALID 0x00000004
#define UNRECOVERED_READS_VALID 0x00000008
#define WRITE_COMPRESSION_INFO_VALID 0x00000010
#define READ_COMPRESSION_INFO_VALID 0x00000020

  typedef struct _TAPE_GET_STATISTICS {
    DWORD Operation;
  } TAPE_GET_STATISTICS,*PTAPE_GET_STATISTICS;

#define TAPE_RETURN_STATISTICS 0L
#define TAPE_RETURN_ENV_INFO 1L
#define TAPE_RESET_STATISTICS 2L

  typedef enum _STORAGE_MEDIA_TYPE {
    DDS_4mm = 0x20,MiniQic,Travan,QIC,MP_8mm,AME_8mm,AIT1_8mm,DLT,NCTP,IBM_3480,IBM_3490E,IBM_Magstar_3590,IBM_Magstar_MP,STK_DATA_D3,SONY_DTF,
    DV_6mm,DMI,SONY_D2,CLEANER_CARTRIDGE,CD_ROM,CD_R,CD_RW,DVD_ROM,DVD_R,DVD_RW,MO_3_RW,MO_5_WO,MO_5_RW,MO_5_LIMDOW,PC_5_WO,PC_5_RW,PD_5_RW,
    ABL_5_WO,PINNACLE_APEX_5_RW,SONY_12_WO,PHILIPS_12_WO,HITACHI_12_WO,CYGNET_12_WO,KODAK_14_WO,MO_NFR_525,NIKON_12_RW,IOMEGA_ZIP,IOMEGA_JAZ,
    SYQUEST_EZ135,SYQUEST_EZFLYER,SYQUEST_SYJET,AVATAR_F2,MP2_8mm,DST_S,DST_M,DST_L,VXATape_1,VXATape_2,STK_9840,LTO_Ultrium,LTO_Accelis,DVD_RAM,
    AIT_8mm,ADR_1,ADR_2,STK_9940,SAIT
  } STORAGE_MEDIA_TYPE,*PSTORAGE_MEDIA_TYPE;

#define MEDIA_ERASEABLE 0x00000001
#define MEDIA_WRITE_ONCE 0x00000002
#define MEDIA_READ_ONLY 0x00000004
#define MEDIA_READ_WRITE 0x00000008

#define MEDIA_WRITE_PROTECTED 0x00000100
#define MEDIA_CURRENTLY_MOUNTED 0x80000000

  typedef enum _STORAGE_BUS_TYPE {
    BusTypeUnknown = 0x00,BusTypeScsi,BusTypeAtapi,BusTypeAta,BusType1394,BusTypeSsa,BusTypeFibre,BusTypeUsb,BusTypeRAID,BusTypeiScsi,
    BusTypeSas,BusTypeSata,BusTypeMaxReserved = 0x7F
  } STORAGE_BUS_TYPE,*PSTORAGE_BUS_TYPE;

  typedef struct _DEVICE_MEDIA_INFO {
    union {
      struct {
	LARGE_INTEGER Cylinders;
	STORAGE_MEDIA_TYPE MediaType;
	DWORD TracksPerCylinder;
	DWORD SectorsPerTrack;
	DWORD BytesPerSector;
	DWORD NumberMediaSides;
	DWORD MediaCharacteristics;
      } DiskInfo;
      struct {
	LARGE_INTEGER Cylinders;
	STORAGE_MEDIA_TYPE MediaType;
	DWORD TracksPerCylinder;
	DWORD SectorsPerTrack;
	DWORD BytesPerSector;
	DWORD NumberMediaSides;
	DWORD MediaCharacteristics;
      } RemovableDiskInfo;
      struct {
	STORAGE_MEDIA_TYPE MediaType;
	DWORD MediaCharacteristics;
	DWORD CurrentBlockSize;
	STORAGE_BUS_TYPE BusType;
	union {
	  struct {
	    BYTE MediumType;
	    BYTE DensityCode;
	  } ScsiInformation;
	} BusSpecificData;
      } TapeInfo;
    } DeviceSpecific;
  } DEVICE_MEDIA_INFO,*PDEVICE_MEDIA_INFO;

  typedef struct _GET_MEDIA_TYPES {
    DWORD DeviceType;
    DWORD MediaInfoCount;
    DEVICE_MEDIA_INFO MediaInfo[1];
  } GET_MEDIA_TYPES,*PGET_MEDIA_TYPES;

  typedef struct _STORAGE_PREDICT_FAILURE {
    DWORD PredictFailure;
    BYTE VendorSpecific[512];
  } STORAGE_PREDICT_FAILURE,*PSTORAGE_PREDICT_FAILURE;

#ifdef __cplusplus
}
#endif
#endif

#define IOCTL_DISK_BASE FILE_DEVICE_DISK
#define IOCTL_DISK_GET_DRIVE_GEOMETRY CTL_CODE(IOCTL_DISK_BASE,0x0000,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_GET_PARTITION_INFO CTL_CODE(IOCTL_DISK_BASE,0x0001,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_SET_PARTITION_INFO CTL_CODE(IOCTL_DISK_BASE,0x0002,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_DRIVE_LAYOUT CTL_CODE(IOCTL_DISK_BASE,0x0003,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_SET_DRIVE_LAYOUT CTL_CODE(IOCTL_DISK_BASE,0x0004,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_VERIFY CTL_CODE(IOCTL_DISK_BASE,0x0005,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_FORMAT_TRACKS CTL_CODE(IOCTL_DISK_BASE,0x0006,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_REASSIGN_BLOCKS CTL_CODE(IOCTL_DISK_BASE,0x0007,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_PERFORMANCE CTL_CODE(IOCTL_DISK_BASE,0x0008,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_IS_WRITABLE CTL_CODE(IOCTL_DISK_BASE,0x0009,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_LOGGING CTL_CODE(IOCTL_DISK_BASE,0x000a,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_FORMAT_TRACKS_EX CTL_CODE(IOCTL_DISK_BASE,0x000b,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_HISTOGRAM_STRUCTURE CTL_CODE(IOCTL_DISK_BASE,0x000c,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_HISTOGRAM_DATA CTL_CODE(IOCTL_DISK_BASE,0x000d,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_HISTOGRAM_RESET CTL_CODE(IOCTL_DISK_BASE,0x000e,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_REQUEST_STRUCTURE CTL_CODE(IOCTL_DISK_BASE,0x000f,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_REQUEST_DATA CTL_CODE(IOCTL_DISK_BASE,0x0010,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_PERFORMANCE_OFF CTL_CODE(IOCTL_DISK_BASE,0x0018,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_CONTROLLER_NUMBER CTL_CODE(IOCTL_DISK_BASE,0x0011,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define SMART_GET_VERSION CTL_CODE(IOCTL_DISK_BASE,0x0020,METHOD_BUFFERED,FILE_READ_ACCESS)
#define SMART_SEND_DRIVE_COMMAND CTL_CODE(IOCTL_DISK_BASE,0x0021,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define SMART_RCV_DRIVE_DATA CTL_CODE(IOCTL_DISK_BASE,0x0022,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)

#define IOCTL_DISK_GET_PARTITION_INFO_EX CTL_CODE(IOCTL_DISK_BASE,0x0012,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_SET_PARTITION_INFO_EX CTL_CODE(IOCTL_DISK_BASE,0x0013,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_DRIVE_LAYOUT_EX CTL_CODE(IOCTL_DISK_BASE,0x0014,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_SET_DRIVE_LAYOUT_EX CTL_CODE(IOCTL_DISK_BASE,0x0015,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_CREATE_DISK CTL_CODE(IOCTL_DISK_BASE,0x0016,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_LENGTH_INFO CTL_CODE(IOCTL_DISK_BASE,0x0017,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_GET_DRIVE_GEOMETRY_EX CTL_CODE(IOCTL_DISK_BASE,0x0028,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_DISK_REASSIGN_BLOCKS_EX CTL_CODE(IOCTL_DISK_BASE,0x0029,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_UPDATE_DRIVE_SIZE CTL_CODE(IOCTL_DISK_BASE,0x0032,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_GROW_PARTITION CTL_CODE(IOCTL_DISK_BASE,0x0034,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_CACHE_INFORMATION CTL_CODE(IOCTL_DISK_BASE,0x0035,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_SET_CACHE_INFORMATION CTL_CODE(IOCTL_DISK_BASE,0x0036,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define OBSOLETE_DISK_GET_WRITE_CACHE_STATE CTL_CODE(IOCTL_DISK_BASE,0x0037,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_DELETE_DRIVE_LAYOUT CTL_CODE(IOCTL_DISK_BASE,0x0040,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_UPDATE_PROPERTIES CTL_CODE(IOCTL_DISK_BASE,0x0050,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_FORMAT_DRIVE CTL_CODE(IOCTL_DISK_BASE,0x00f3,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_SENSE_DEVICE CTL_CODE(IOCTL_DISK_BASE,0x00f8,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DISK_CHECK_VERIFY CTL_CODE(IOCTL_DISK_BASE,0x0200,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_MEDIA_REMOVAL CTL_CODE(IOCTL_DISK_BASE,0x0201,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_EJECT_MEDIA CTL_CODE(IOCTL_DISK_BASE,0x0202,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_LOAD_MEDIA CTL_CODE(IOCTL_DISK_BASE,0x0203,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_RESERVE CTL_CODE(IOCTL_DISK_BASE,0x0204,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_RELEASE CTL_CODE(IOCTL_DISK_BASE,0x0205,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_FIND_NEW_DEVICES CTL_CODE(IOCTL_DISK_BASE,0x0206,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_DISK_GET_MEDIA_TYPES CTL_CODE(IOCTL_DISK_BASE,0x0300,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define PARTITION_ENTRY_UNUSED 0x00
#define PARTITION_FAT_12 0x01
#define PARTITION_XENIX_1 0x02
#define PARTITION_XENIX_2 0x03
#define PARTITION_FAT_16 0x04
#define PARTITION_EXTENDED 0x05
#define PARTITION_HUGE 0x06
#define PARTITION_IFS 0x07
#define PARTITION_OS2BOOTMGR 0x0A
#define PARTITION_FAT32 0x0B
#define PARTITION_FAT32_XINT13 0x0C
#define PARTITION_XINT13 0x0E
#define PARTITION_XINT13_EXTENDED 0x0F
#define PARTITION_PREP 0x41
#define PARTITION_LDM 0x42
#define PARTITION_UNIX 0x63

#define VALID_NTFT 0xC0

#define PARTITION_NTFT 0x80

#define IsRecognizedPartition(PartitionType) (((PartitionType & PARTITION_NTFT) && ((PartitionType & ~0xC0)==PARTITION_FAT_12)) || ((PartitionType & PARTITION_NTFT) && ((PartitionType & ~0xC0)==PARTITION_IFS)) || ((PartitionType & PARTITION_NTFT) && ((PartitionType & ~0xC0)==PARTITION_HUGE)) || ((PartitionType & PARTITION_NTFT) && ((PartitionType & ~0xC0)==PARTITION_FAT32)) || ((PartitionType & PARTITION_NTFT) && ((PartitionType & ~0xC0)==PARTITION_FAT32_XINT13)) || ((PartitionType & PARTITION_NTFT) && ((PartitionType & ~0xC0)==PARTITION_XINT13)) || ((PartitionType)==PARTITION_FAT_12) || ((PartitionType)==PARTITION_FAT_16) || ((PartitionType)==PARTITION_IFS) || ((PartitionType)==PARTITION_HUGE) || ((PartitionType)==PARTITION_FAT32) || ((PartitionType)==PARTITION_FAT32_XINT13) || ((PartitionType)==PARTITION_XINT13))
#define IsContainerPartition(PartitionType) ((PartitionType==PARTITION_EXTENDED) || (PartitionType==PARTITION_XINT13_EXTENDED))
#define IsFTPartition(PartitionType) (((PartitionType)&PARTITION_NTFT) && IsRecognizedPartition(PartitionType))

typedef enum _MEDIA_TYPE {
  Unknown,F5_1Pt2_512,F3_1Pt44_512,F3_2Pt88_512,F3_20Pt8_512,F3_720_512,F5_360_512,F5_320_512,F5_320_1024,F5_180_512,F5_160_512,
  RemovableMedia,FixedMedia,F3_120M_512,F3_640_512,F5_640_512,F5_720_512,F3_1Pt2_512,F3_1Pt23_1024,F5_1Pt23_1024,F3_128Mb_512,
  F3_230Mb_512,F8_256_128,F3_200Mb_512,F3_240M_512,F3_32M_512
} MEDIA_TYPE,*PMEDIA_TYPE;

typedef struct _FORMAT_PARAMETERS {
  MEDIA_TYPE MediaType;
  DWORD StartCylinderNumber;
  DWORD EndCylinderNumber;
  DWORD StartHeadNumber;
  DWORD EndHeadNumber;
} FORMAT_PARAMETERS,*PFORMAT_PARAMETERS;

typedef WORD BAD_TRACK_NUMBER;
typedef WORD *PBAD_TRACK_NUMBER;

typedef struct _FORMAT_EX_PARAMETERS {
  MEDIA_TYPE MediaType;
  DWORD StartCylinderNumber;
  DWORD EndCylinderNumber;
  DWORD StartHeadNumber;
  DWORD EndHeadNumber;
  WORD FormatGapLength;
  WORD SectorsPerTrack;
  WORD SectorNumber[1];
} FORMAT_EX_PARAMETERS,*PFORMAT_EX_PARAMETERS;

typedef struct _DISK_GEOMETRY {
  LARGE_INTEGER Cylinders;
  MEDIA_TYPE MediaType;
  DWORD TracksPerCylinder;
  DWORD SectorsPerTrack;
  DWORD BytesPerSector;
} DISK_GEOMETRY,*PDISK_GEOMETRY;

#define WMI_DISK_GEOMETRY_GUID { 0x25007f51,0x57c2,0x11d1,{ 0xa5,0x28,0x0,0xa0,0xc9,0x6,0x29,0x10 } }

typedef struct _PARTITION_INFORMATION {
  LARGE_INTEGER StartingOffset;
  LARGE_INTEGER PartitionLength;
  DWORD HiddenSectors;
  DWORD PartitionNumber;
  BYTE PartitionType;
  BOOLEAN BootIndicator;
  BOOLEAN RecognizedPartition;
  BOOLEAN RewritePartition;
} PARTITION_INFORMATION,*PPARTITION_INFORMATION;

typedef struct _SET_PARTITION_INFORMATION {
  BYTE PartitionType;
} SET_PARTITION_INFORMATION,*PSET_PARTITION_INFORMATION;

typedef struct _DRIVE_LAYOUT_INFORMATION {
  DWORD PartitionCount;
  DWORD Signature;
  PARTITION_INFORMATION PartitionEntry[1];
} DRIVE_LAYOUT_INFORMATION,*PDRIVE_LAYOUT_INFORMATION;

typedef struct _VERIFY_INFORMATION {
  LARGE_INTEGER StartingOffset;
  DWORD Length;
} VERIFY_INFORMATION,*PVERIFY_INFORMATION;

typedef struct _REASSIGN_BLOCKS {
  WORD Reserved;
  WORD Count;
  DWORD BlockNumber[1];
} REASSIGN_BLOCKS,*PREASSIGN_BLOCKS;

#include <pshpack1.h>
typedef struct _REASSIGN_BLOCKS_EX {
  WORD Reserved;
  WORD Count;
  LARGE_INTEGER BlockNumber[1];
} REASSIGN_BLOCKS_EX,*PREASSIGN_BLOCKS_EX;
#include <poppack.h>

typedef enum _PARTITION_STYLE {
  PARTITION_STYLE_MBR,PARTITION_STYLE_GPT,PARTITION_STYLE_RAW
} PARTITION_STYLE;

typedef struct _PARTITION_INFORMATION_GPT {
  GUID PartitionType;
  GUID PartitionId;
  DWORD64 Attributes;
  WCHAR Name [36];
} PARTITION_INFORMATION_GPT,*PPARTITION_INFORMATION_GPT;

#define GPT_ATTRIBUTE_PLATFORM_REQUIRED (0x0000000000000001)

#define GPT_BASIC_DATA_ATTRIBUTE_NO_DRIVE_LETTER (0x8000000000000000)
#define GPT_BASIC_DATA_ATTRIBUTE_HIDDEN (0x4000000000000000)
#define GPT_BASIC_DATA_ATTRIBUTE_SHADOW_COPY (0x2000000000000000)
#define GPT_BASIC_DATA_ATTRIBUTE_READ_ONLY (0x1000000000000000)

typedef struct _PARTITION_INFORMATION_MBR {
  BYTE PartitionType;
  BOOLEAN BootIndicator;
  BOOLEAN RecognizedPartition;
  DWORD HiddenSectors;
} PARTITION_INFORMATION_MBR,*PPARTITION_INFORMATION_MBR;

typedef SET_PARTITION_INFORMATION SET_PARTITION_INFORMATION_MBR;
typedef PARTITION_INFORMATION_GPT SET_PARTITION_INFORMATION_GPT;

typedef struct _SET_PARTITION_INFORMATION_EX {
  PARTITION_STYLE PartitionStyle;
  __extension__ union {
    SET_PARTITION_INFORMATION_MBR Mbr;
    SET_PARTITION_INFORMATION_GPT Gpt;
  };
} SET_PARTITION_INFORMATION_EX,*PSET_PARTITION_INFORMATION_EX;

typedef struct _CREATE_DISK_GPT {
  GUID DiskId;
  DWORD MaxPartitionCount;
} CREATE_DISK_GPT,*PCREATE_DISK_GPT;

typedef struct _CREATE_DISK_MBR {
  DWORD Signature;
} CREATE_DISK_MBR,*PCREATE_DISK_MBR;

typedef struct _CREATE_DISK {
  PARTITION_STYLE PartitionStyle;
  __extension__ union {
    CREATE_DISK_MBR Mbr;
    CREATE_DISK_GPT Gpt;
  };
} CREATE_DISK,*PCREATE_DISK;

typedef struct _GET_LENGTH_INFORMATION {
  LARGE_INTEGER Length;
} GET_LENGTH_INFORMATION,*PGET_LENGTH_INFORMATION;

typedef struct _PARTITION_INFORMATION_EX {
  PARTITION_STYLE PartitionStyle;
  LARGE_INTEGER StartingOffset;
  LARGE_INTEGER PartitionLength;
  DWORD PartitionNumber;
  BOOLEAN RewritePartition;
  __extension__ union {
    PARTITION_INFORMATION_MBR Mbr;
    PARTITION_INFORMATION_GPT Gpt;
  };
} PARTITION_INFORMATION_EX,*PPARTITION_INFORMATION_EX;

typedef struct _DRIVE_LAYOUT_INFORMATION_GPT {
  GUID DiskId;
  LARGE_INTEGER StartingUsableOffset;
  LARGE_INTEGER UsableLength;
  DWORD MaxPartitionCount;
} DRIVE_LAYOUT_INFORMATION_GPT,*PDRIVE_LAYOUT_INFORMATION_GPT;

typedef struct _DRIVE_LAYOUT_INFORMATION_MBR {
  DWORD Signature;
} DRIVE_LAYOUT_INFORMATION_MBR,*PDRIVE_LAYOUT_INFORMATION_MBR;

typedef struct _DRIVE_LAYOUT_INFORMATION_EX {
  DWORD PartitionStyle;
  DWORD PartitionCount;
  __extension__ union {
    DRIVE_LAYOUT_INFORMATION_MBR Mbr;
    DRIVE_LAYOUT_INFORMATION_GPT Gpt;
  };
  PARTITION_INFORMATION_EX PartitionEntry[1];
} DRIVE_LAYOUT_INFORMATION_EX,*PDRIVE_LAYOUT_INFORMATION_EX;

typedef enum _DETECTION_TYPE {
  DetectNone,DetectInt13,DetectExInt13
} DETECTION_TYPE;

typedef struct _DISK_INT13_INFO {
  WORD DriveSelect;
  DWORD MaxCylinders;
  WORD SectorsPerTrack;
  WORD MaxHeads;
  WORD NumberDrives;
} DISK_INT13_INFO,*PDISK_INT13_INFO;

typedef struct _DISK_EX_INT13_INFO {
  WORD ExBufferSize;
  WORD ExFlags;
  DWORD ExCylinders;
  DWORD ExHeads;
  DWORD ExSectorsPerTrack;
  DWORD64 ExSectorsPerDrive;
  WORD ExSectorSize;
  WORD ExReserved;
} DISK_EX_INT13_INFO,*PDISK_EX_INT13_INFO;

typedef struct _DISK_DETECTION_INFO {
  DWORD SizeOfDetectInfo;
  DETECTION_TYPE DetectionType;
  __extension__ union {
    __extension__ struct {
      DISK_INT13_INFO Int13;
      DISK_EX_INT13_INFO ExInt13;
    };
  };
} DISK_DETECTION_INFO,*PDISK_DETECTION_INFO;

typedef struct _DISK_PARTITION_INFO {
  DWORD SizeOfPartitionInfo;
  PARTITION_STYLE PartitionStyle;
  __extension__ union {
    struct {
      DWORD Signature;
      DWORD CheckSum;
    } Mbr;
    struct {
      GUID DiskId;
    } Gpt;
  };
} DISK_PARTITION_INFO,*PDISK_PARTITION_INFO;

#define DiskGeometryGetPartition(Geometry) ((PDISK_PARTITION_INFO)((Geometry)->Data))
#define DiskGeometryGetDetect(Geometry) ((PDISK_DETECTION_INFO)(((DWORD_PTR)DiskGeometryGetPartition(Geometry)+ DiskGeometryGetPartition(Geometry)->SizeOfPartitionInfo)))

typedef struct _DISK_GEOMETRY_EX {
  DISK_GEOMETRY Geometry;
  LARGE_INTEGER DiskSize;
  BYTE Data[1];
} DISK_GEOMETRY_EX,*PDISK_GEOMETRY_EX;

typedef struct _DISK_CONTROLLER_NUMBER {
  DWORD ControllerNumber;
  DWORD DiskNumber;
} DISK_CONTROLLER_NUMBER,*PDISK_CONTROLLER_NUMBER;

typedef enum {
  EqualPriority,KeepPrefetchedData,KeepReadData
} DISK_CACHE_RETENTION_PRIORITY;

typedef struct _DISK_CACHE_INFORMATION {
  BOOLEAN ParametersSavable;
  BOOLEAN ReadCacheEnabled;
  BOOLEAN WriteCacheEnabled;
  DISK_CACHE_RETENTION_PRIORITY ReadRetentionPriority;
  DISK_CACHE_RETENTION_PRIORITY WriteRetentionPriority;
  WORD DisablePrefetchTransferLength;
  BOOLEAN PrefetchScalar;
  __extension__ union {
    struct {
      WORD Minimum;
      WORD Maximum;
      WORD MaximumBlocks;
    } ScalarPrefetch;
    struct {
      WORD Minimum;
      WORD Maximum;
    } BlockPrefetch;
  };
} DISK_CACHE_INFORMATION,*PDISK_CACHE_INFORMATION;

typedef struct _DISK_GROW_PARTITION {
  DWORD PartitionNumber;
  LARGE_INTEGER BytesToGrow;
} DISK_GROW_PARTITION,*PDISK_GROW_PARTITION;

#define HIST_NO_OF_BUCKETS 24

typedef struct _HISTOGRAM_BUCKET {
  DWORD Reads;
  DWORD Writes;
} HISTOGRAM_BUCKET,*PHISTOGRAM_BUCKET;

#define HISTOGRAM_BUCKET_SIZE sizeof(HISTOGRAM_BUCKET)

typedef struct _DISK_HISTOGRAM {
  LARGE_INTEGER DiskSize;
  LARGE_INTEGER Start;
  LARGE_INTEGER End;
  LARGE_INTEGER Average;
  LARGE_INTEGER AverageRead;
  LARGE_INTEGER AverageWrite;
  DWORD Granularity;
  DWORD Size;
  DWORD ReadCount;
  DWORD WriteCount;
  PHISTOGRAM_BUCKET Histogram;
} DISK_HISTOGRAM,*PDISK_HISTOGRAM;

#define DISK_HISTOGRAM_SIZE sizeof(DISK_HISTOGRAM)

typedef struct _DISK_PERFORMANCE {
  LARGE_INTEGER BytesRead;
  LARGE_INTEGER BytesWritten;
  LARGE_INTEGER ReadTime;
  LARGE_INTEGER WriteTime;
  LARGE_INTEGER IdleTime;
  DWORD ReadCount;
  DWORD WriteCount;
  DWORD QueueDepth;
  DWORD SplitCount;
  LARGE_INTEGER QueryTime;
  DWORD StorageDeviceNumber;
  WCHAR StorageManagerName[8];
} DISK_PERFORMANCE,*PDISK_PERFORMANCE;

typedef struct _DISK_RECORD {
  LARGE_INTEGER ByteOffset;
  LARGE_INTEGER StartTime;
  LARGE_INTEGER EndTime;
  PVOID VirtualAddress;
  DWORD NumberOfBytes;
  BYTE DeviceNumber;
  BOOLEAN ReadRequest;
} DISK_RECORD,*PDISK_RECORD;

typedef struct _DISK_LOGGING {
  BYTE Function;
  PVOID BufferAddress;
  DWORD BufferSize;
} DISK_LOGGING,*PDISK_LOGGING;

#define DISK_LOGGING_START 0
#define DISK_LOGGING_STOP 1
#define DISK_LOGGING_DUMP 2
#define DISK_BINNING 3

typedef enum _BIN_TYPES {
  RequestSize,RequestLocation
} BIN_TYPES;

typedef struct _BIN_RANGE {
  LARGE_INTEGER StartValue;
  LARGE_INTEGER Length;
} BIN_RANGE,*PBIN_RANGE;

typedef struct _PERF_BIN {
  DWORD NumberOfBins;
  DWORD TypeOfBin;
  BIN_RANGE BinsRanges[1];
} PERF_BIN,*PPERF_BIN;

typedef struct _BIN_COUNT {
  BIN_RANGE BinRange;
  DWORD BinCount;
} BIN_COUNT,*PBIN_COUNT;

typedef struct _BIN_RESULTS {
  DWORD NumberOfBins;
  BIN_COUNT BinCounts[1];
} BIN_RESULTS,*PBIN_RESULTS;

#include <pshpack1.h>
typedef struct _GETVERSIONINPARAMS {
  BYTE bVersion;
  BYTE bRevision;
  BYTE bReserved;
  BYTE bIDEDeviceMap;
  DWORD fCapabilities;
  DWORD dwReserved[4];
} GETVERSIONINPARAMS,*PGETVERSIONINPARAMS,*LPGETVERSIONINPARAMS;
#include <poppack.h>

#define CAP_ATA_ID_CMD 1
#define CAP_ATAPI_ID_CMD 2
#define CAP_SMART_CMD 4

#include <pshpack1.h>
typedef struct _IDEREGS {
  BYTE bFeaturesReg;
  BYTE bSectorCountReg;
  BYTE bSectorNumberReg;
  BYTE bCylLowReg;
  BYTE bCylHighReg;
  BYTE bDriveHeadReg;
  BYTE bCommandReg;
  BYTE bReserved;
} IDEREGS,*PIDEREGS,*LPIDEREGS;
#include <poppack.h>

#define ATAPI_ID_CMD 0xA1
#define ID_CMD 0xEC
#define SMART_CMD 0xB0

#define SMART_CYL_LOW 0x4F
#define SMART_CYL_HI 0xC2

#include <pshpack1.h>
typedef struct _SENDCMDINPARAMS {
  DWORD cBufferSize;
  IDEREGS irDriveRegs;
  BYTE bDriveNumber;
  BYTE bReserved[3];
  DWORD dwReserved[4];
  BYTE bBuffer[1];
} SENDCMDINPARAMS,*PSENDCMDINPARAMS,*LPSENDCMDINPARAMS;
#include <poppack.h>

#include <pshpack1.h>
typedef struct _DRIVERSTATUS {
  BYTE bDriverError;
  BYTE bIDEError;
  BYTE bReserved[2];
  DWORD dwReserved[2];
} DRIVERSTATUS,*PDRIVERSTATUS,*LPDRIVERSTATUS;
#include <poppack.h>

#define SMART_NO_ERROR 0
#define SMART_IDE_ERROR 1
#define SMART_INVALID_FLAG 2
#define SMART_INVALID_COMMAND 3
#define SMART_INVALID_BUFFER 4
#define SMART_INVALID_DRIVE 5
#define SMART_INVALID_IOCTL 6
#define SMART_ERROR_NO_MEM 7
#define SMART_INVALID_REGISTER 8
#define SMART_NOT_SUPPORTED 9
#define SMART_NO_IDE_DEVICE 10

#define SMART_OFFLINE_ROUTINE_OFFLINE 0
#define SMART_SHORT_SELFTEST_OFFLINE 1
#define SMART_EXTENDED_SELFTEST_OFFLINE 2
#define SMART_ABORT_OFFLINE_SELFTEST 127
#define SMART_SHORT_SELFTEST_CAPTIVE 129
#define SMART_EXTENDED_SELFTEST_CAPTIVE 130

#include <pshpack1.h>
typedef struct _SENDCMDOUTPARAMS {
  DWORD cBufferSize;
  DRIVERSTATUS DriverStatus;
  BYTE bBuffer[1];
} SENDCMDOUTPARAMS,*PSENDCMDOUTPARAMS,*LPSENDCMDOUTPARAMS;
#include <poppack.h>

#define READ_ATTRIBUTE_BUFFER_SIZE 512
#define IDENTIFY_BUFFER_SIZE 512
#define READ_THRESHOLD_BUFFER_SIZE 512
#define SMART_LOG_SECTOR_SIZE 512

#define READ_ATTRIBUTES 0xD0
#define READ_THRESHOLDS 0xD1
#define ENABLE_DISABLE_AUTOSAVE 0xD2
#define SAVE_ATTRIBUTE_VALUES 0xD3
#define EXECUTE_OFFLINE_DIAGS 0xD4
#define SMART_READ_LOG 0xD5
#define SMART_WRITE_LOG 0xd6
#define ENABLE_SMART 0xD8
#define DISABLE_SMART 0xD9
#define RETURN_SMART_STATUS 0xDA
#define ENABLE_DISABLE_AUTO_OFFLINE 0xDB

#define IOCTL_CHANGER_BASE FILE_DEVICE_CHANGER
#define IOCTL_CHANGER_GET_PARAMETERS CTL_CODE(IOCTL_CHANGER_BASE,0x0000,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_CHANGER_GET_STATUS CTL_CODE(IOCTL_CHANGER_BASE,0x0001,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_CHANGER_GET_PRODUCT_DATA CTL_CODE(IOCTL_CHANGER_BASE,0x0002,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_CHANGER_SET_ACCESS CTL_CODE(IOCTL_CHANGER_BASE,0x0004,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_CHANGER_GET_ELEMENT_STATUS CTL_CODE(IOCTL_CHANGER_BASE,0x0005,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_CHANGER_INITIALIZE_ELEMENT_STATUS CTL_CODE(IOCTL_CHANGER_BASE,0x0006,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_CHANGER_SET_POSITION CTL_CODE(IOCTL_CHANGER_BASE,0x0007,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_CHANGER_EXCHANGE_MEDIUM CTL_CODE(IOCTL_CHANGER_BASE,0x0008,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_CHANGER_MOVE_MEDIUM CTL_CODE(IOCTL_CHANGER_BASE,0x0009,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_CHANGER_REINITIALIZE_TRANSPORT CTL_CODE(IOCTL_CHANGER_BASE,0x000A,METHOD_BUFFERED,FILE_READ_ACCESS)
#define IOCTL_CHANGER_QUERY_VOLUME_TAGS CTL_CODE(IOCTL_CHANGER_BASE,0x000B,METHOD_BUFFERED,FILE_READ_ACCESS | FILE_WRITE_ACCESS)

#define MAX_VOLUME_ID_SIZE 36
#define MAX_VOLUME_TEMPLATE_SIZE 40

#define VENDOR_ID_LENGTH 8
#define PRODUCT_ID_LENGTH 16
#define REVISION_LENGTH 4
#define SERIAL_NUMBER_LENGTH 32

typedef enum _ELEMENT_TYPE {
  AllElements,ChangerTransport,ChangerSlot,ChangerIEPort,ChangerDrive,ChangerDoor,ChangerKeypad,ChangerMaxElement
} ELEMENT_TYPE,*PELEMENT_TYPE;

typedef struct _CHANGER_ELEMENT {
  ELEMENT_TYPE ElementType;
  DWORD ElementAddress;
} CHANGER_ELEMENT,*PCHANGER_ELEMENT;

typedef struct _CHANGER_ELEMENT_LIST {
  CHANGER_ELEMENT Element;
  DWORD NumberOfElements;
} CHANGER_ELEMENT_LIST ,*PCHANGER_ELEMENT_LIST;

#define CHANGER_BAR_CODE_SCANNER_INSTALLED 0x00000001
#define CHANGER_INIT_ELEM_STAT_WITH_RANGE 0x00000002
#define CHANGER_CLOSE_IEPORT 0x00000004
#define CHANGER_OPEN_IEPORT 0x00000008

#define CHANGER_STATUS_NON_VOLATILE 0x00000010
#define CHANGER_EXCHANGE_MEDIA 0x00000020
#define CHANGER_CLEANER_SLOT 0x00000040
#define CHANGER_LOCK_UNLOCK 0x00000080

#define CHANGER_CARTRIDGE_MAGAZINE 0x00000100
#define CHANGER_MEDIUM_FLIP 0x00000200
#define CHANGER_POSITION_TO_ELEMENT 0x00000400
#define CHANGER_REPORT_IEPORT_STATE 0x00000800

#define CHANGER_STORAGE_DRIVE 0x00001000
#define CHANGER_STORAGE_IEPORT 0x00002000
#define CHANGER_STORAGE_SLOT 0x00004000
#define CHANGER_STORAGE_TRANSPORT 0x00008000

#define CHANGER_DRIVE_CLEANING_REQUIRED 0x00010000

#define CHANGER_PREDISMOUNT_EJECT_REQUIRED 0x00020000

#define CHANGER_CLEANER_ACCESS_NOT_VALID 0x00040000
#define CHANGER_PREMOUNT_EJECT_REQUIRED 0x00080000

#define CHANGER_VOLUME_IDENTIFICATION 0x00100000
#define CHANGER_VOLUME_SEARCH 0x00200000
#define CHANGER_VOLUME_ASSERT 0x00400000
#define CHANGER_VOLUME_REPLACE 0x00800000
#define CHANGER_VOLUME_UNDEFINE 0x01000000

#define CHANGER_SERIAL_NUMBER_VALID 0x04000000

#define CHANGER_DEVICE_REINITIALIZE_CAPABLE 0x08000000
#define CHANGER_KEYPAD_ENABLE_DISABLE 0x10000000
#define CHANGER_DRIVE_EMPTY_ON_DOOR_ACCESS 0x20000000

#define CHANGER_RESERVED_BIT 0x80000000

#define CHANGER_PREDISMOUNT_ALIGN_TO_SLOT 0x80000001
#define CHANGER_PREDISMOUNT_ALIGN_TO_DRIVE 0x80000002
#define CHANGER_CLEANER_AUTODISMOUNT 0x80000004
#define CHANGER_TRUE_EXCHANGE_CAPABLE 0x80000008
#define CHANGER_SLOTS_USE_TRAYS 0x80000010
#define CHANGER_RTN_MEDIA_TO_ORIGINAL_ADDR 0x80000020
#define CHANGER_CLEANER_OPS_NOT_SUPPORTED 0x80000040
#define CHANGER_IEPORT_USER_CONTROL_OPEN 0x80000080
#define CHANGER_IEPORT_USER_CONTROL_CLOSE 0x80000100
#define CHANGER_MOVE_EXTENDS_IEPORT 0x80000200
#define CHANGER_MOVE_RETRACTS_IEPORT 0x80000400

#define CHANGER_TO_TRANSPORT 0x01
#define CHANGER_TO_SLOT 0x02
#define CHANGER_TO_IEPORT 0x04
#define CHANGER_TO_DRIVE 0x08

#define LOCK_UNLOCK_IEPORT 0x01
#define LOCK_UNLOCK_DOOR 0x02
#define LOCK_UNLOCK_KEYPAD 0x04

typedef struct _GET_CHANGER_PARAMETERS {
  DWORD Size;
  WORD NumberTransportElements;
  WORD NumberStorageElements;
  WORD NumberCleanerSlots;
  WORD NumberIEElements;
  WORD NumberDataTransferElements;
  WORD NumberOfDoors;
  WORD FirstSlotNumber;
  WORD FirstDriveNumber;
  WORD FirstTransportNumber;
  WORD FirstIEPortNumber;
  WORD FirstCleanerSlotAddress;
  WORD MagazineSize;
  DWORD DriveCleanTimeout;
  DWORD Features0;
  DWORD Features1;
  BYTE MoveFromTransport;
  BYTE MoveFromSlot;
  BYTE MoveFromIePort;
  BYTE MoveFromDrive;
  BYTE ExchangeFromTransport;
  BYTE ExchangeFromSlot;
  BYTE ExchangeFromIePort;
  BYTE ExchangeFromDrive;
  BYTE LockUnlockCapabilities;
  BYTE PositionCapabilities;
  BYTE Reserved1[2];
  DWORD Reserved2[2];
} GET_CHANGER_PARAMETERS,*PGET_CHANGER_PARAMETERS;

typedef struct _CHANGER_PRODUCT_DATA {
  BYTE VendorId[VENDOR_ID_LENGTH];
  BYTE ProductId[PRODUCT_ID_LENGTH];
  BYTE Revision[REVISION_LENGTH];
  BYTE SerialNumber[SERIAL_NUMBER_LENGTH];
  BYTE DeviceType;
} CHANGER_PRODUCT_DATA,*PCHANGER_PRODUCT_DATA;

#define LOCK_ELEMENT 0
#define UNLOCK_ELEMENT 1
#define EXTEND_IEPORT 2
#define RETRACT_IEPORT 3

typedef struct _CHANGER_SET_ACCESS {
  CHANGER_ELEMENT Element;
  DWORD Control;
} CHANGER_SET_ACCESS,*PCHANGER_SET_ACCESS;

typedef struct _CHANGER_READ_ELEMENT_STATUS {
  CHANGER_ELEMENT_LIST ElementList;
  BOOLEAN VolumeTagInfo;
} CHANGER_READ_ELEMENT_STATUS,*PCHANGER_READ_ELEMENT_STATUS;

typedef struct _CHANGER_ELEMENT_STATUS {
  CHANGER_ELEMENT Element;
  CHANGER_ELEMENT SrcElementAddress;
  DWORD Flags;
  DWORD ExceptionCode;
  BYTE TargetId;
  BYTE Lun;
  WORD Reserved;
  BYTE PrimaryVolumeID[MAX_VOLUME_ID_SIZE];
  BYTE AlternateVolumeID[MAX_VOLUME_ID_SIZE];
} CHANGER_ELEMENT_STATUS,*PCHANGER_ELEMENT_STATUS;

typedef struct _CHANGER_ELEMENT_STATUS_EX {
  CHANGER_ELEMENT Element;
  CHANGER_ELEMENT SrcElementAddress;
  DWORD Flags;
  DWORD ExceptionCode;
  BYTE TargetId;
  BYTE Lun;
  WORD Reserved;
  BYTE PrimaryVolumeID[MAX_VOLUME_ID_SIZE];
  BYTE AlternateVolumeID[MAX_VOLUME_ID_SIZE];
  BYTE VendorIdentification[VENDOR_ID_LENGTH];
  BYTE ProductIdentification[PRODUCT_ID_LENGTH];
  BYTE SerialNumber[SERIAL_NUMBER_LENGTH];
} CHANGER_ELEMENT_STATUS_EX,*PCHANGER_ELEMENT_STATUS_EX;

#define ELEMENT_STATUS_FULL 0x00000001
#define ELEMENT_STATUS_IMPEXP 0x00000002
#define ELEMENT_STATUS_EXCEPT 0x00000004
#define ELEMENT_STATUS_ACCESS 0x00000008
#define ELEMENT_STATUS_EXENAB 0x00000010
#define ELEMENT_STATUS_INENAB 0x00000020

#define ELEMENT_STATUS_PRODUCT_DATA 0x00000040

#define ELEMENT_STATUS_LUN_VALID 0x00001000
#define ELEMENT_STATUS_ID_VALID 0x00002000
#define ELEMENT_STATUS_NOT_BUS 0x00008000
#define ELEMENT_STATUS_INVERT 0x00400000
#define ELEMENT_STATUS_SVALID 0x00800000

#define ELEMENT_STATUS_PVOLTAG 0x10000000
#define ELEMENT_STATUS_AVOLTAG 0x20000000

#define ERROR_LABEL_UNREADABLE 0x00000001
#define ERROR_LABEL_QUESTIONABLE 0x00000002
#define ERROR_SLOT_NOT_PRESENT 0x00000004
#define ERROR_DRIVE_NOT_INSTALLED 0x00000008
#define ERROR_TRAY_MALFUNCTION 0x00000010
#define ERROR_INIT_STATUS_NEEDED 0x00000011
#define ERROR_UNHANDLED_ERROR 0xFFFFFFFF

typedef struct _CHANGER_INITIALIZE_ELEMENT_STATUS {
  CHANGER_ELEMENT_LIST ElementList;
  BOOLEAN BarCodeScan;
} CHANGER_INITIALIZE_ELEMENT_STATUS,*PCHANGER_INITIALIZE_ELEMENT_STATUS;

typedef struct _CHANGER_SET_POSITION {
  CHANGER_ELEMENT Transport;
  CHANGER_ELEMENT Destination;
  BOOLEAN Flip;
} CHANGER_SET_POSITION,*PCHANGER_SET_POSITION;

typedef struct _CHANGER_EXCHANGE_MEDIUM {
  CHANGER_ELEMENT Transport;
  CHANGER_ELEMENT Source;
  CHANGER_ELEMENT Destination1;
  CHANGER_ELEMENT Destination2;
  BOOLEAN Flip1;
  BOOLEAN Flip2;
} CHANGER_EXCHANGE_MEDIUM,*PCHANGER_EXCHANGE_MEDIUM;

typedef struct _CHANGER_MOVE_MEDIUM {
  CHANGER_ELEMENT Transport;
  CHANGER_ELEMENT Source;
  CHANGER_ELEMENT Destination;
  BOOLEAN Flip;
} CHANGER_MOVE_MEDIUM,*PCHANGER_MOVE_MEDIUM;

typedef struct _CHANGER_SEND_VOLUME_TAG_INFORMATION {
  CHANGER_ELEMENT StartingElement;
  DWORD ActionCode;
  BYTE VolumeIDTemplate[MAX_VOLUME_TEMPLATE_SIZE];
} CHANGER_SEND_VOLUME_TAG_INFORMATION,*PCHANGER_SEND_VOLUME_TAG_INFORMATION;

typedef struct _READ_ELEMENT_ADDRESS_INFO {
  DWORD NumberOfElements;
  CHANGER_ELEMENT_STATUS ElementStatus[1];
} READ_ELEMENT_ADDRESS_INFO,*PREAD_ELEMENT_ADDRESS_INFO;

#define SEARCH_ALL 0x0
#define SEARCH_PRIMARY 0x1
#define SEARCH_ALTERNATE 0x2
#define SEARCH_ALL_NO_SEQ 0x4
#define SEARCH_PRI_NO_SEQ 0x5
#define SEARCH_ALT_NO_SEQ 0x6

#define ASSERT_PRIMARY 0x8
#define ASSERT_ALTERNATE 0x9

#define REPLACE_PRIMARY 0xA
#define REPLACE_ALTERNATE 0xB

#define UNDEFINE_PRIMARY 0xC
#define UNDEFINE_ALTERNATE 0xD

typedef enum _CHANGER_DEVICE_PROBLEM_TYPE {
  DeviceProblemNone,DeviceProblemHardware,DeviceProblemCHMError,DeviceProblemDoorOpen,DeviceProblemCalibrationError,DeviceProblemTargetFailure,
  DeviceProblemCHMMoveError,DeviceProblemCHMZeroError,DeviceProblemCartridgeInsertError,DeviceProblemPositionError,DeviceProblemSensorError,
  DeviceProblemCartridgeEjectError,DeviceProblemGripperError,DeviceProblemDriveError
} CHANGER_DEVICE_PROBLEM_TYPE,*PCHANGER_DEVICE_PROBLEM_TYPE;

#define IOCTL_SERIAL_LSRMST_INSERT CTL_CODE(FILE_DEVICE_SERIAL_PORT,31,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_SERENUM_EXPOSE_HARDWARE CTL_CODE(FILE_DEVICE_SERENUM,128,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERENUM_REMOVE_HARDWARE CTL_CODE(FILE_DEVICE_SERENUM,129,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERENUM_PORT_DESC CTL_CODE(FILE_DEVICE_SERENUM,130,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERENUM_GET_PORT_NAME CTL_CODE(FILE_DEVICE_SERENUM,131,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define SERIAL_LSRMST_ESCAPE ((BYTE)0x00)

#define SERIAL_LSRMST_LSR_DATA ((BYTE)0x01)

#define SERIAL_LSRMST_LSR_NODATA ((BYTE)0x02)

#define SERIAL_LSRMST_MST ((BYTE)0x03)

#define SERIAL_IOC_FCR_FIFO_ENABLE ((DWORD)0x00000001)
#define SERIAL_IOC_FCR_RCVR_RESET ((DWORD)0x00000002)
#define SERIAL_IOC_FCR_XMIT_RESET ((DWORD)0x00000004)
#define SERIAL_IOC_FCR_DMA_MODE ((DWORD)0x00000008)
#define SERIAL_IOC_FCR_RES1 ((DWORD)0x00000010)
#define SERIAL_IOC_FCR_RES2 ((DWORD)0x00000020)
#define SERIAL_IOC_FCR_RCVR_TRIGGER_LSB ((DWORD)0x00000040)
#define SERIAL_IOC_FCR_RCVR_TRIGGER_MSB ((DWORD)0x00000080)

#define SERIAL_IOC_MCR_DTR ((DWORD)0x00000001)
#define SERIAL_IOC_MCR_RTS ((DWORD)0x00000002)
#define SERIAL_IOC_MCR_OUT1 ((DWORD)0x00000004)
#define SERIAL_IOC_MCR_OUT2 ((DWORD)0x00000008)
#define SERIAL_IOC_MCR_LOOP ((DWORD)0x00000010)

#ifndef _FILESYSTEMFSCTL_
#define _FILESYSTEMFSCTL_

#define FSCTL_REQUEST_OPLOCK_LEVEL_1 CTL_CODE(FILE_DEVICE_FILE_SYSTEM,0,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_REQUEST_OPLOCK_LEVEL_2 CTL_CODE(FILE_DEVICE_FILE_SYSTEM,1,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_REQUEST_BATCH_OPLOCK CTL_CODE(FILE_DEVICE_FILE_SYSTEM,2,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_ACKNOWLEDGE CTL_CODE(FILE_DEVICE_FILE_SYSTEM,3,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_OPBATCH_ACK_CLOSE_PENDING CTL_CODE(FILE_DEVICE_FILE_SYSTEM,4,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_NOTIFY CTL_CODE(FILE_DEVICE_FILE_SYSTEM,5,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_LOCK_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM,6,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_UNLOCK_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM,7,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_DISMOUNT_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM,8,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define FSCTL_IS_VOLUME_MOUNTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM,10,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_IS_PATHNAME_VALID CTL_CODE(FILE_DEVICE_FILE_SYSTEM,11,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_MARK_VOLUME_DIRTY CTL_CODE(FILE_DEVICE_FILE_SYSTEM,12,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define FSCTL_QUERY_RETRIEVAL_POINTERS CTL_CODE(FILE_DEVICE_FILE_SYSTEM,14,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_GET_COMPRESSION CTL_CODE(FILE_DEVICE_FILE_SYSTEM,15,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_SET_COMPRESSION CTL_CODE(FILE_DEVICE_FILE_SYSTEM,16,METHOD_BUFFERED,FILE_READ_DATA | FILE_WRITE_DATA)

#define FSCTL_MARK_AS_SYSTEM_HIVE CTL_CODE(FILE_DEVICE_FILE_SYSTEM,19,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_ACK_NO_2 CTL_CODE(FILE_DEVICE_FILE_SYSTEM,20,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_INVALIDATE_VOLUMES CTL_CODE(FILE_DEVICE_FILE_SYSTEM,21,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_QUERY_FAT_BPB CTL_CODE(FILE_DEVICE_FILE_SYSTEM,22,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_REQUEST_FILTER_OPLOCK CTL_CODE(FILE_DEVICE_FILE_SYSTEM,23,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_FILESYSTEM_GET_STATISTICS CTL_CODE(FILE_DEVICE_FILE_SYSTEM,24,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_GET_NTFS_VOLUME_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM,25,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_GET_NTFS_FILE_RECORD CTL_CODE(FILE_DEVICE_FILE_SYSTEM,26,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_GET_VOLUME_BITMAP CTL_CODE(FILE_DEVICE_FILE_SYSTEM,27,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_GET_RETRIEVAL_POINTERS CTL_CODE(FILE_DEVICE_FILE_SYSTEM,28,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_MOVE_FILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM,29,METHOD_BUFFERED,FILE_SPECIAL_ACCESS)
#define FSCTL_IS_VOLUME_DIRTY CTL_CODE(FILE_DEVICE_FILE_SYSTEM,30,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_ALLOW_EXTENDED_DASD_IO CTL_CODE(FILE_DEVICE_FILE_SYSTEM,32,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_FIND_FILES_BY_SID CTL_CODE(FILE_DEVICE_FILE_SYSTEM,35,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_SET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM,38,METHOD_BUFFERED,FILE_SPECIAL_ACCESS)
#define FSCTL_GET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM,39,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_DELETE_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM,40,METHOD_BUFFERED,FILE_SPECIAL_ACCESS)
#define FSCTL_SET_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM,41,METHOD_BUFFERED,FILE_SPECIAL_ACCESS)
#define FSCTL_GET_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM,42,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_DELETE_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM,43,METHOD_BUFFERED,FILE_SPECIAL_ACCESS)
#define FSCTL_ENUM_USN_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM,44,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_SECURITY_ID_CHECK CTL_CODE(FILE_DEVICE_FILE_SYSTEM,45,METHOD_NEITHER,FILE_READ_DATA)
#define FSCTL_READ_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM,46,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_SET_OBJECT_ID_EXTENDED CTL_CODE(FILE_DEVICE_FILE_SYSTEM,47,METHOD_BUFFERED,FILE_SPECIAL_ACCESS)
#define FSCTL_CREATE_OR_GET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM,48,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_SET_SPARSE CTL_CODE(FILE_DEVICE_FILE_SYSTEM,49,METHOD_BUFFERED,FILE_SPECIAL_ACCESS)
#define FSCTL_SET_ZERO_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM,50,METHOD_BUFFERED,FILE_WRITE_DATA)
#define FSCTL_QUERY_ALLOCATED_RANGES CTL_CODE(FILE_DEVICE_FILE_SYSTEM,51,METHOD_NEITHER,FILE_READ_DATA)
#define FSCTL_SET_ENCRYPTION CTL_CODE(FILE_DEVICE_FILE_SYSTEM,53,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_ENCRYPTION_FSCTL_IO CTL_CODE(FILE_DEVICE_FILE_SYSTEM,54,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_WRITE_RAW_ENCRYPTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM,55,METHOD_NEITHER,FILE_SPECIAL_ACCESS)
#define FSCTL_READ_RAW_ENCRYPTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM,56,METHOD_NEITHER,FILE_SPECIAL_ACCESS)
#define FSCTL_CREATE_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM,57,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_READ_FILE_USN_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM,58,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_WRITE_USN_CLOSE_RECORD CTL_CODE(FILE_DEVICE_FILE_SYSTEM,59,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_EXTEND_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM,60,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_QUERY_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM,61,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_DELETE_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM,62,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_MARK_HANDLE CTL_CODE(FILE_DEVICE_FILE_SYSTEM,63,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_SIS_COPYFILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM,64,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define FSCTL_SIS_LINK_FILES CTL_CODE(FILE_DEVICE_FILE_SYSTEM,65,METHOD_BUFFERED,FILE_READ_DATA | FILE_WRITE_DATA)
#define FSCTL_HSM_MSG CTL_CODE(FILE_DEVICE_FILE_SYSTEM,66,METHOD_BUFFERED,FILE_READ_DATA | FILE_WRITE_DATA)
#define FSCTL_HSM_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM,68,METHOD_NEITHER,FILE_READ_DATA | FILE_WRITE_DATA)
#define FSCTL_RECALL_FILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM,69,METHOD_NEITHER,FILE_ANY_ACCESS)
#define FSCTL_READ_FROM_PLEX CTL_CODE(FILE_DEVICE_FILE_SYSTEM,71,METHOD_OUT_DIRECT,FILE_READ_DATA)
#define FSCTL_FILE_PREFETCH CTL_CODE(FILE_DEVICE_FILE_SYSTEM,72,METHOD_BUFFERED,FILE_SPECIAL_ACCESS)

typedef struct _PATHNAME_BUFFER {
  DWORD PathNameLength;
  WCHAR Name[1];
} PATHNAME_BUFFER,*PPATHNAME_BUFFER;

typedef struct _FSCTL_QUERY_FAT_BPB_BUFFER {
  BYTE First0x24BytesOfBootSector[0x24];
} FSCTL_QUERY_FAT_BPB_BUFFER,*PFSCTL_QUERY_FAT_BPB_BUFFER;

typedef struct {
  LARGE_INTEGER VolumeSerialNumber;
  LARGE_INTEGER NumberSectors;
  LARGE_INTEGER TotalClusters;
  LARGE_INTEGER FreeClusters;
  LARGE_INTEGER TotalReserved;
  DWORD BytesPerSector;
  DWORD BytesPerCluster;
  DWORD BytesPerFileRecordSegment;
  DWORD ClustersPerFileRecordSegment;
  LARGE_INTEGER MftValidDataLength;
  LARGE_INTEGER MftStartLcn;
  LARGE_INTEGER Mft2StartLcn;
  LARGE_INTEGER MftZoneStart;
  LARGE_INTEGER MftZoneEnd;
} NTFS_VOLUME_DATA_BUFFER,*PNTFS_VOLUME_DATA_BUFFER;

typedef struct {
  DWORD ByteCount;
  WORD MajorVersion;
  WORD MinorVersion;
} NTFS_EXTENDED_VOLUME_DATA,*PNTFS_EXTENDED_VOLUME_DATA;

typedef struct {
  LARGE_INTEGER StartingLcn;
} STARTING_LCN_INPUT_BUFFER,*PSTARTING_LCN_INPUT_BUFFER;

typedef struct {
  LARGE_INTEGER StartingLcn;
  LARGE_INTEGER BitmapSize;
  BYTE Buffer[1];
} VOLUME_BITMAP_BUFFER,*PVOLUME_BITMAP_BUFFER;

typedef struct {
  LARGE_INTEGER StartingVcn;
} STARTING_VCN_INPUT_BUFFER,*PSTARTING_VCN_INPUT_BUFFER;

typedef struct RETRIEVAL_POINTERS_BUFFER {
  DWORD ExtentCount;
  LARGE_INTEGER StartingVcn;
  struct {
    LARGE_INTEGER NextVcn;
    LARGE_INTEGER Lcn;
  } Extents[1];
} RETRIEVAL_POINTERS_BUFFER,*PRETRIEVAL_POINTERS_BUFFER;

typedef struct {
  LARGE_INTEGER FileReferenceNumber;
} NTFS_FILE_RECORD_INPUT_BUFFER,*PNTFS_FILE_RECORD_INPUT_BUFFER;

typedef struct {
  LARGE_INTEGER FileReferenceNumber;
  DWORD FileRecordLength;
  BYTE FileRecordBuffer[1];
} NTFS_FILE_RECORD_OUTPUT_BUFFER,*PNTFS_FILE_RECORD_OUTPUT_BUFFER;

typedef struct {
  HANDLE FileHandle;
  LARGE_INTEGER StartingVcn;
  LARGE_INTEGER StartingLcn;
  DWORD ClusterCount;
} MOVE_FILE_DATA,*PMOVE_FILE_DATA;

#ifdef _WIN64
typedef struct _MOVE_FILE_DATA32 {
  UINT32 FileHandle;
  LARGE_INTEGER StartingVcn;
  LARGE_INTEGER StartingLcn;
  DWORD ClusterCount;
} MOVE_FILE_DATA32,*PMOVE_FILE_DATA32;
#endif

typedef struct {
  DWORD Restart;
  SID Sid;
} FIND_BY_SID_DATA,*PFIND_BY_SID_DATA;

typedef struct {
  DWORD NextEntryOffset;
  DWORD FileIndex;
  DWORD FileNameLength;
  WCHAR FileName[1];
} FIND_BY_SID_OUTPUT,*PFIND_BY_SID_OUTPUT;

typedef struct {
  DWORDLONG StartFileReferenceNumber;
  USN LowUsn;
  USN HighUsn;
} MFT_ENUM_DATA,*PMFT_ENUM_DATA;

typedef struct {
  DWORDLONG MaximumSize;
  DWORDLONG AllocationDelta;
} CREATE_USN_JOURNAL_DATA,*PCREATE_USN_JOURNAL_DATA;

typedef struct {
  USN StartUsn;
  DWORD ReasonMask;
  DWORD ReturnOnlyOnClose;
  DWORDLONG Timeout;
  DWORDLONG BytesToWaitFor;
  DWORDLONG UsnJournalID;
} READ_USN_JOURNAL_DATA,*PREAD_USN_JOURNAL_DATA;

typedef struct {
  DWORD RecordLength;
  WORD MajorVersion;
  WORD MinorVersion;
  DWORDLONG FileReferenceNumber;
  DWORDLONG ParentFileReferenceNumber;
  USN Usn;
  LARGE_INTEGER TimeStamp;
  DWORD Reason;
  DWORD SourceInfo;
  DWORD SecurityId;
  DWORD FileAttributes;
  WORD FileNameLength;
  WORD FileNameOffset;
  WCHAR FileName[1];
} USN_RECORD,*PUSN_RECORD;

#define USN_PAGE_SIZE (0x1000)

#define USN_REASON_DATA_OVERWRITE (0x00000001)
#define USN_REASON_DATA_EXTEND (0x00000002)
#define USN_REASON_DATA_TRUNCATION (0x00000004)
#define USN_REASON_NAMED_DATA_OVERWRITE (0x00000010)
#define USN_REASON_NAMED_DATA_EXTEND (0x00000020)
#define USN_REASON_NAMED_DATA_TRUNCATION (0x00000040)
#define USN_REASON_FILE_CREATE (0x00000100)
#define USN_REASON_FILE_DELETE (0x00000200)
#define USN_REASON_EA_CHANGE (0x00000400)
#define USN_REASON_SECURITY_CHANGE (0x00000800)
#define USN_REASON_RENAME_OLD_NAME (0x00001000)
#define USN_REASON_RENAME_NEW_NAME (0x00002000)
#define USN_REASON_INDEXABLE_CHANGE (0x00004000)
#define USN_REASON_BASIC_INFO_CHANGE (0x00008000)
#define USN_REASON_HARD_LINK_CHANGE (0x00010000)
#define USN_REASON_COMPRESSION_CHANGE (0x00020000)
#define USN_REASON_ENCRYPTION_CHANGE (0x00040000)
#define USN_REASON_OBJECT_ID_CHANGE (0x00080000)
#define USN_REASON_REPARSE_POINT_CHANGE (0x00100000)
#define USN_REASON_STREAM_CHANGE (0x00200000)

#define USN_REASON_CLOSE (0x80000000)

typedef struct {
  DWORDLONG UsnJournalID;
  USN FirstUsn;
  USN NextUsn;
  USN LowestValidUsn;
  USN MaxUsn;
  DWORDLONG MaximumSize;
  DWORDLONG AllocationDelta;
} USN_JOURNAL_DATA,*PUSN_JOURNAL_DATA;

typedef struct {
  DWORDLONG UsnJournalID;
  DWORD DeleteFlags;
} DELETE_USN_JOURNAL_DATA,*PDELETE_USN_JOURNAL_DATA;

#define USN_DELETE_FLAG_DELETE (0x00000001)
#define USN_DELETE_FLAG_NOTIFY (0x00000002)

#define USN_DELETE_VALID_FLAGS (0x00000003)

typedef struct {
  DWORD UsnSourceInfo;
  HANDLE VolumeHandle;
  DWORD HandleInfo;
} MARK_HANDLE_INFO,*PMARK_HANDLE_INFO;

#ifdef _WIN64

typedef struct {
  DWORD UsnSourceInfo;
  UINT32 VolumeHandle;
  DWORD HandleInfo;

} MARK_HANDLE_INFO32,*PMARK_HANDLE_INFO32;
#endif

#define USN_SOURCE_DATA_MANAGEMENT (0x00000001)
#define USN_SOURCE_AUXILIARY_DATA (0x00000002)
#define USN_SOURCE_REPLICATION_MANAGEMENT (0x00000004)

#define MARK_HANDLE_PROTECT_CLUSTERS (0x00000001)
#define MARK_HANDLE_TXF_SYSTEM_LOG (0x00000004)
#define MARK_HANDLE_NOT_TXF_SYSTEM_LOG (0x00000008)

typedef struct {
  ACCESS_MASK DesiredAccess;
  DWORD SecurityIds[1];
} BULK_SECURITY_TEST_DATA,*PBULK_SECURITY_TEST_DATA;

#define VOLUME_IS_DIRTY (0x00000001)
#define VOLUME_UPGRADE_SCHEDULED (0x00000002)

typedef struct _FILE_PREFETCH {
  DWORD Type;
  DWORD Count;
  DWORDLONG Prefetch[1];
} FILE_PREFETCH,*PFILE_PREFETCH;

#define FILE_PREFETCH_TYPE_FOR_CREATE 0x1

typedef struct _FILESYSTEM_STATISTICS {
  WORD FileSystemType;
  WORD Version;
  DWORD SizeOfCompleteStructure;
  DWORD UserFileReads;
  DWORD UserFileReadBytes;
  DWORD UserDiskReads;
  DWORD UserFileWrites;
  DWORD UserFileWriteBytes;
  DWORD UserDiskWrites;
  DWORD MetaDataReads;
  DWORD MetaDataReadBytes;
  DWORD MetaDataDiskReads;
  DWORD MetaDataWrites;
  DWORD MetaDataWriteBytes;
  DWORD MetaDataDiskWrites;
} FILESYSTEM_STATISTICS,*PFILESYSTEM_STATISTICS;

#define FILESYSTEM_STATISTICS_TYPE_NTFS 1
#define FILESYSTEM_STATISTICS_TYPE_FAT 2

typedef struct _FAT_STATISTICS {
  DWORD CreateHits;
  DWORD SuccessfulCreates;
  DWORD FailedCreates;
  DWORD NonCachedReads;
  DWORD NonCachedReadBytes;
  DWORD NonCachedWrites;
  DWORD NonCachedWriteBytes;
  DWORD NonCachedDiskReads;
  DWORD NonCachedDiskWrites;
} FAT_STATISTICS,*PFAT_STATISTICS;

typedef struct _NTFS_STATISTICS {
  DWORD LogFileFullExceptions;
  DWORD OtherExceptions;
  DWORD MftReads;
  DWORD MftReadBytes;
  DWORD MftWrites;
  DWORD MftWriteBytes;
  struct {
    WORD Write;
    WORD Create;
    WORD SetInfo;
    WORD Flush;
  } MftWritesUserLevel;
  WORD MftWritesFlushForLogFileFull;
  WORD MftWritesLazyWriter;
  WORD MftWritesUserRequest;
  DWORD Mft2Writes;
  DWORD Mft2WriteBytes;
  struct {
    WORD Write;
    WORD Create;
    WORD SetInfo;
    WORD Flush;
  } Mft2WritesUserLevel;
  WORD Mft2WritesFlushForLogFileFull;
  WORD Mft2WritesLazyWriter;
  WORD Mft2WritesUserRequest;
  DWORD RootIndexReads;
  DWORD RootIndexReadBytes;
  DWORD RootIndexWrites;
  DWORD RootIndexWriteBytes;
  DWORD BitmapReads;
  DWORD BitmapReadBytes;
  DWORD BitmapWrites;
  DWORD BitmapWriteBytes;
  WORD BitmapWritesFlushForLogFileFull;
  WORD BitmapWritesLazyWriter;
  WORD BitmapWritesUserRequest;
  struct {
    WORD Write;
    WORD Create;
    WORD SetInfo;
  } BitmapWritesUserLevel;
  DWORD MftBitmapReads;
  DWORD MftBitmapReadBytes;
  DWORD MftBitmapWrites;
  DWORD MftBitmapWriteBytes;
  WORD MftBitmapWritesFlushForLogFileFull;
  WORD MftBitmapWritesLazyWriter;
  WORD MftBitmapWritesUserRequest;
  struct {
    WORD Write;
    WORD Create;
    WORD SetInfo;
    WORD Flush;
  } MftBitmapWritesUserLevel;
  DWORD UserIndexReads;
  DWORD UserIndexReadBytes;
  DWORD UserIndexWrites;
  DWORD UserIndexWriteBytes;
  DWORD LogFileReads;
  DWORD LogFileReadBytes;
  DWORD LogFileWrites;
  DWORD LogFileWriteBytes;
  struct {
    DWORD Calls;
    DWORD Clusters;
    DWORD Hints;
    DWORD RunsReturned;
    DWORD HintsHonored;
    DWORD HintsClusters;
    DWORD Cache;
    DWORD CacheClusters;
    DWORD CacheMiss;
    DWORD CacheMissClusters;
  } Allocate;
} NTFS_STATISTICS,*PNTFS_STATISTICS;

typedef struct _FILE_OBJECTID_BUFFER {
  BYTE ObjectId[16];
  __extension__ union {
    __extension__ struct {
      BYTE BirthVolumeId[16];
      BYTE BirthObjectId[16];
      BYTE DomainId[16];
    };
    BYTE ExtendedInfo[48];
  };
} FILE_OBJECTID_BUFFER,*PFILE_OBJECTID_BUFFER;

typedef struct _FILE_SET_SPARSE_BUFFER {
  BOOLEAN SetSparse;
} FILE_SET_SPARSE_BUFFER,*PFILE_SET_SPARSE_BUFFER;

typedef struct _FILE_ZERO_DATA_INFORMATION {
  LARGE_INTEGER FileOffset;
  LARGE_INTEGER BeyondFinalZero;
} FILE_ZERO_DATA_INFORMATION,*PFILE_ZERO_DATA_INFORMATION;

typedef struct _FILE_ALLOCATED_RANGE_BUFFER {
  LARGE_INTEGER FileOffset;
  LARGE_INTEGER Length;
} FILE_ALLOCATED_RANGE_BUFFER,*PFILE_ALLOCATED_RANGE_BUFFER;

typedef struct _ENCRYPTION_BUFFER {
  DWORD EncryptionOperation;
  BYTE Private[1];
} ENCRYPTION_BUFFER,*PENCRYPTION_BUFFER;

#define FILE_SET_ENCRYPTION 0x00000001
#define FILE_CLEAR_ENCRYPTION 0x00000002
#define STREAM_SET_ENCRYPTION 0x00000003
#define STREAM_CLEAR_ENCRYPTION 0x00000004

#define MAXIMUM_ENCRYPTION_VALUE 0x00000004

typedef struct _DECRYPTION_STATUS_BUFFER {
  BOOLEAN NoEncryptedStreams;
} DECRYPTION_STATUS_BUFFER,*PDECRYPTION_STATUS_BUFFER;

#define ENCRYPTION_FORMAT_DEFAULT (0x01)
#define COMPRESSION_FORMAT_SPARSE (0x4000)

typedef struct _REQUEST_RAW_ENCRYPTED_DATA {
  LONGLONG FileOffset;
  DWORD Length;
} REQUEST_RAW_ENCRYPTED_DATA,*PREQUEST_RAW_ENCRYPTED_DATA;

typedef struct _ENCRYPTED_DATA_INFO {
  DWORDLONG StartingFileOffset;
  DWORD OutputBufferOffset;
  DWORD BytesWithinFileSize;
  DWORD BytesWithinValidDataLength;
  WORD CompressionFormat;
  BYTE DataUnitShift;
  BYTE ChunkShift;
  BYTE ClusterShift;
  BYTE EncryptionFormat;
  WORD NumberOfDataBlocks;
  DWORD DataBlockSize[ANYSIZE_ARRAY];
} ENCRYPTED_DATA_INFO;
typedef ENCRYPTED_DATA_INFO *PENCRYPTED_DATA_INFO;

typedef struct _PLEX_READ_DATA_REQUEST {
  LARGE_INTEGER ByteOffset;
  DWORD ByteLength;
  DWORD PlexNumber;
} PLEX_READ_DATA_REQUEST,*PPLEX_READ_DATA_REQUEST;

typedef struct _SI_COPYFILE {
  DWORD SourceFileNameLength;
  DWORD DestinationFileNameLength;
  DWORD Flags;
  WCHAR FileNameBuffer[1];
} SI_COPYFILE,*PSI_COPYFILE;

#define COPYFILE_SIS_LINK 0x0001
#define COPYFILE_SIS_REPLACE 0x0002
#define COPYFILE_SIS_FLAGS 0x0003
#endif

#define IOCTL_VOLUME_BASE ((DWORD) 'V')

#define IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS CTL_CODE(IOCTL_VOLUME_BASE,0,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_VOLUME_IS_CLUSTERED CTL_CODE(IOCTL_VOLUME_BASE,12,METHOD_BUFFERED,FILE_ANY_ACCESS)

typedef struct _DISK_EXTENT {
  DWORD DiskNumber;
  LARGE_INTEGER StartingOffset;
  LARGE_INTEGER ExtentLength;
} DISK_EXTENT,*PDISK_EXTENT;

typedef struct _VOLUME_DISK_EXTENTS {
  DWORD NumberOfDiskExtents;
  DISK_EXTENT Extents[1];
} VOLUME_DISK_EXTENTS,*PVOLUME_DISK_EXTENTS;
#endif
