/*
 *  This code is no longer used, but for now it's simpler to keep it around to
 *  avoid undefined symbols in dirsrv.
 *  
 *  - wheelan (Wed Jun 5 21:00:19 EDT 1996)
 */

double tcmp = 0.0; /* to avoid an undefined symbol */


/*
	search routine generated by gen.
	skip=lC, match=fwd, guard=guard, shift=md2
*/

/*
 * The authors of this software are Andrew Hume and Daniel Sunday.
 * 
 * Copyright (c) 1991 by AT&T and Daniel Sunday.
 * 
 * Permission to use, copy, modify, and distribute this software for any
 * purpose without fee is hereby granted, provided that this entire notice
 * is included in all copies of any software which is or includes a copy
 * or modification of this software and in all copies of the supporting
 * documentation for such software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

#include	<stdio.h>
#include	<ctype.h>
#include        <memory.h>
#ifdef DOUBLE_CHECK
#include        <string.h>
#endif
#include	"freq.h"
#include	"sd.h"
#include	"srch.h"


#include "protos.h"


#ifndef NO_PROSP_CHECK
#define PROSP_CHECK_IN \
do { static ckcnt = 0; if (ckcnt++ > 1000 /*?*/) { ckcnt = 0; ardp_accept(); } } while(0)
#endif


static struct
{
  int patlen;
  CHARTYPE pat[MAXPAT];
  CHARTYPE upat[MAXPAT];
  Tab delta[256];
  int loopoffset;               /* patlen-1 - skip loop char */
  int rarec, rareoff;
  int md2;
} pat;

#ifdef DOUBLE_CHECK
extern char *prog ;
#endif

#ifdef __STDC__
extern void lowercase(char *s, int n) ;
extern void ps(char *s, char *b) ;
extern void uppercase(char *s, int n) ;
#else
extern void lowercase(/* char *s, int n */) ;
extern void ps(/* char *s, char *b */) ;
extern void uppercase(/* char *s, int n */) ;
#endif

int
prep(base, m, ignore_case)
  CHARTYPE *base ;
  int m ;
  int ignore_case ;
{

  CHARTYPE *skipc, *uskipc = 0;
  register CHARTYPE *pe, *pb;
  register int j, r = 0;
  register Tab *d;
  double tmax, fr;
  int rrr, rr;
  register CHARTYPE *pmd2;

  pat.patlen = m;
  if(m > MAXPAT)
  {
    return 0 ;
  }
  memcpy(pat.pat, base, m);
  if(ignore_case)
  {
    memcpy(pat.upat, pat.pat, m) ;
    lowercase(pat.pat, m) ;
    uppercase(pat.upat, m) ;
  }
  skipc = 0;
  if(sd[m] == 0){
    for(j = m; sd[j] == 0; j--)
    sd[j] = 12;
  }

  /*
    Find the character to check in the skip loop.
  */
  tmax = 2+tcmp;
  for(pb = pat.pat, pe = pb+pat.patlen-1; pb <= pe; pb++){
    fr = (1+tcmp*freq[*pb])/sd[pb-pat.pat];
    if(tmax > fr){
      tmax = fr;
      r = pb-pat.pat;
    }
  }
  pat.loopoffset = m-1-r;       /* offset from _end_ of pattern */
  skipc = &pat.pat[m-1-pat.loopoffset]; /* address of this character */
  if(ignore_case)
  {
    uskipc = &pat.upat[m-1-pat.loopoffset]; /* address of this character */
  }

  /*
    Set up the array of skip distances.
  */
  d = pat.delta;
  for(j = 0; j < 256; j++)
  d[j] = m-pat.loopoffset;
  for(pb = pat.pat, pe = pb+m-1-pat.loopoffset; pb <= pe; pb++){
    d[*pb] = pe-pb;             /* case */
    if(ignore_case)
    {      d[toupper((int)*pb)] = pe-pb ;
    }
  }

  /*
    Find the rarest character in the pattern and its offset.
  */
  rrr = 0;
  for(rr = 1; rr < m; rr++){
    if(freq[pat.pat[rr]] < freq[pat.pat[rrr]])
    rrr = rr;
  }
  pat.rarec = pat.pat[rrr];
  pat.rareoff = rrr;

  /*
    Find the distance between the skip loop character and its first
    reoccurance to its left.
  */
  for(pmd2 = skipc-1; pmd2 >= pat.pat; pmd2--)
  if (*pmd2 == *skipc || (ignore_case && *pmd2 == *uskipc)) break;
  pat.md2 = skipc - pmd2;	/* *pmd2 is first leftward reoccurance of *pe */

  return 1 ;
}

/*
  Case sensitive match.
*/

int
cs_exec(base, n, hit_list, max_hits)
  CHARTYPE *base ;
  int n ;
  index_t *hit_list ;
  int max_hits ;
{
  int nmatch = 0 ;
  register CHARTYPE *e, *s ;
  register Tab *d0 = pat.delta ;
  register k, s_offset ;
  register ro, rc ;
  register CHARTYPE *p, *q ;
  register CHARTYPE *ep ;
  register md2 = pat.md2 ;

  k = pat.patlen-1-pat.loopoffset ; /* k is index of char we loop on */
  s = base+k ;
  e = base+n ;
  memset(e, pat.pat[k], pat.patlen) ;
  s_offset = -k ;
  ro = pat.rareoff+s_offset ;   /* offset into s corresponding to rarest */
  rc = pat.rarec ;              /* character of pattern. */
  ep = pat.pat + pat.patlen ;

  while(s < e)
  {
    k = d0[*s] ;
    while(k)
    {
      k = d0[*(s += k)] ;
      k = d0[*(s += k)] ;
      k = d0[*(s += k)] ;
    }
    if(s >= e) return nmatch ;
    if(s[ro] != rc) goto mismatch ; /* case */

    /*
      compare from beginning of pattern
    */
    for(p = pat.pat, q = s+s_offset; p < ep; ) /* case */
    {
      if(*q++ != *p++) goto mismatch ;
    }

    *hit_list++ = s + s_offset - base ; /* always first character of pattern? */
    if(++nmatch >= max_hits)
    {
#ifdef DOUBLE_CHECK
      if(strstr(s+s_offset, pat.pat) == (char *)0)
      {
        fprintf(stderr, "%s: cs_exec: double check failed on (\"%s\", \"%s\").\n",
                prog, s+s_offset, pat.pat) ;
      }
#endif
      return nmatch ;
    }

    while(*s++) ;               /* move to next string */
    continue;

  mismatch:
    s += md2 ;

    PROSP_CHECK_IN;
  }
  return nmatch ;
}

/*
  Case insensitive match.
*/

int
ci_exec(base, n, hit_list, max_hits)
  CHARTYPE *base ;
  int n ;
  index_t *hit_list ;
  int max_hits ;
{

  int nmatch = 0 ;
  register CHARTYPE *e, *s ;
  register Tab *d0 = pat.delta ;
  register k, s_offset ;
  register ro, rc, urc ;
  register CHARTYPE *p, *q, *up ;
  register CHARTYPE *ep ;
  register md2 = pat.md2 ;

  k = pat.patlen-1-pat.loopoffset ; /* k is index of char we loop on */
  s = base+k ;
  e = base+n ;
  memset(e, pat.pat[k], pat.patlen) ;
  s_offset = -k ;
  ro = pat.rareoff+s_offset ;   /* offset into s corresponding to rarest */
  rc = pat.rarec ;              /* character of pattern. */
  urc = toupper((int)rc) ;
  ep = pat.pat + pat.patlen ;

  while(s < e)
  {
    k = d0[*s] ;
    while(k)
    {
      k = d0[*(s += k)] ;
      k = d0[*(s += k)] ;
      k = d0[*(s += k)] ;
    }
    if(s >= e) return nmatch ;
    if(s[ro] != rc && s[ro] != urc) goto mismatch ; /* case */

    /*
      compare from beginning of pattern
    */
    for(p = pat.pat, up = pat.upat, q = s+s_offset; p < ep; ) /* case */
    {
      CHARTYPE y = *q++, z = *up++ ;
      if(y != *p++ && y != z) goto mismatch ;
    }

    *hit_list++ = s + s_offset - base ; /* always first character of pattern? */
    if(++nmatch >= max_hits)
    {
      return nmatch ;
    }

    while(*s++) ;               /* move to next string */
    continue ;

  mismatch:
    s += md2 ;

    PROSP_CHECK_IN;
  }
  return nmatch ;
}


void
lowercase(s, n)
  char *s ;
  int n ;
{

  while(n--)
  {
    *s = tolower((int)*s) ;
    s++ ;
  }
}

void
ps(s, b)
  char *s ;
  char *b ;
{
  char *p = s ;

  while(*p && p-- > b) ;
  p++ ;
#if 0
  printf("%p %p '%s'\n", (void *)p, (void *)s, p) ;
#endif
}

void
uppercase(s, n)
  char *s ;
  int n ;
{

  while(n--)
  {
    *s = toupper((int)*s) ;
    s++ ;
  }
}
