.\" Copyright (c) 1992, 1994, 1996 Bunyip Information Systems Inc.
.\" All rights reserved.  
.\"
.\" Archie 3.5
.\" August 1996
.\"
.\"	@(#)host_manage.n
.\"
.TH HOST_MANAGE N "August 1996"

.SH NAME
.B host_manage
\- administrative management of the Archie host databases

.SH SYNOPSIS
.B host_manage 
[ 
.BI \-M " <dir>"
] [ 
.BI \-h " <dir>"
] [ 
.BI \-C " <config>"
] [ 
.BI \-D " <domain list>"
] [ 
.BI \-H " <source hostname>"
] [
.I <sitename>
]

.SH DESCRIPTION
.PP
.B host_manage 
is a 
.BR curses (3) 
based program which allows the Archie administrator to view and change the
contents of the host databases.

.SH OPTIONS
.TP
.BI \-M " <dir>"
The name of the master Archie database directory. If not given, the program
tries to look in the directory
.B ~archie/db 
and, failing that, defaults to 
.BR ./db .
.TP
.BI \-h " <dir>"
The name of the Archie host database directory. If not supplied the program
will default first to
.B ~archie/db/host_db 
and failing that, to 
.BR ./host_db .
.TP
.BI \-C " <config>"
The name of the file containing configuration information for displaying the
catalog access methods. Without this flag, the default used is
.BR ~archie/etc/hm_db.cf .
.TP
.BI \-D " <domain list>"
Restrict the display to only those sites in the database which belong to the
colon separated list of Archie psuedo-domains given by
.IR <domain list> .
.TP
.BI \-H " <source hostname>"
Use the given
.I <source hostname>
as the value for the `source' field on the display, when adding a new host,
overriding the default value returned by
.BR gethostname (2).
.TP
.I <site name>
The information about the given site will be displayed upon entry into the
program.

.SH DISPLAY
.PP
.B host_manage 
displays the complete information on each site stored in the Archie host
databases.  Note that a number of the fields on the display are for
informational value only and may not be directly modified by the user. These
fields are marked below by an asterisk (`*').
.PP
The screen is partitioned into 4 main areas.
.IP 1) 
Information about the site itself. This is composed of:
.RS 
.RS
.TP
.B Primary Hostname
The primary DNS name for the site. This is used internally by the Archie
system.
.TP
.B Preferred Name	
A valid DNS CNAME record for the site, if one exists. For example, may ftp
archive sites use a CNAME record of the form ftp.\fI<domain>\fP.
.TP
.BR Catalogs *
The list of the auxiliary catalogs currently associated with this site.
.TP
.BR "Primary IP address" *
The valid DNS IP address; used internally by the Archie system.
.TP
.B Operating System
The operating system of the site, if known.
.TP 
.B Prospero Host		
Whether or not the site runs a Prospero system daemon.
.TP
.B Timezone
The timezone in which the site is located. This is displayed as a signed
quantity in hours and minutes (in 15 minute increments). Negative values
represent timezones to the west of the Greenwich meridian, positive
values to the east.
.RE
.RE
.IP 2) 
Information about the various (auxiliary) databases of this site.
.RS
.RS
.TP 
.B Catalog
The name of this catalog entry.
.TP
.BR Source *
The Archie host responsible for monitoring this catalog at this site.
.TP
.BR "Generated By" *
Shows which stage in the Archie update cycle was responsible for this
record. This is useful for entries for which there was some error in
processing.
.TP
.BR "Retrieve Time" *
The time that the Data Aquisition phase acquired the information. Converted to
local time for display.
.TP
.BR "Parse Time" *
The time that the information was parsed. Converted to local time for display.
.TP
.BR "Update Time" *
The time that the information was updated in the catalog. Converted to local
time for display.
.TP
.BR "Number of Records" *
The number of records stored. The definition of `record' is catalog dependent.
.TP
.BR "Fail Count" *
The number of times that update of this site/catalog combination has been
attempted and failed.
.TP
.BR Msg *
Contains information generated by the Archie subsystems which may be of use to
the Archie administrator. This may include such things as reasons for update
failure, etc.
.RE
.RE
.IP 3)
Information concerning the commands used to retrieve the data. Database
dependent. See the section
.SM "Access Display Configuration"
for a description of this display.
.IP 4)
Ancilliary information.
.RS
.RS
.TP 
.B Current Status
The current status of this catalog in the system.  Valid values are:
.RS
.RS
.TP 
.B Active
Entry currently active.
.TP 
.B Inactive 
Entry temporarily inactive by the Archie subsystems. Data files have been
purged from the system.
.TP 
.B Not Supported
This site does not support this catalog type.
.TP 
.B Scheduled for deletion by local administrator
This catalog has been rendered `permanently' inactive by the Archie
administrator
.TP
.B Scheduled for deletion by Archie
Usually means that the data is out of date and has been scheduled for
deletion.
.TP
.B Disabled
Temporarily disabled by the local Archie administrator.
.TP
.B Deleted
The associated data files have been removed and the record will be removed
from the host databases at a later date by the
.BR host_manage (n)
program.
.RE
.RE
.TP
.BR "Force Update" *
The data for this site has been scheduled for early update.
.TP
.BR "Action Status" *
Current action being performed on this record. Values are:
.RS
.RS
.TP
.B Add	
For a new entry
.TP
.B Update	
To modify existing data
.RE
.RE
.RE
.RE

.SH EDITING
.PP
The command set for editing is based on the standard emacs key bindings.
Currently these are not user configurable.
.RS
.PP
.B Cursor Movement
.RS
.TP 
.PD .1v
.B ^A
Beginning of line
.TP
.B ^E
End of line
.TP
.B ^N
Next field
.TP
.B ^P
Previous field
.TP
.B ^F
Next character
.TP
.PD 1v
.B ^B
Previous character
.RE
.PP 
.B Editing
.RS
.PP
The program is always in insert mode.
.TP 
.PD .1v
.B ^K
Kill to end of line (into yank buffer)
.TP
.B ^Y
Insert from yank buffer
.TP
.B ^D
Delete character at cursor
.TP
.B ^H
Delete previous character
.TP
.PD 1v
.B <DEL>
Delete previous character
.RE
.PP
.B Viewing/Modifying the Data
.RS
.TP 
.PD .1v
.B <space>
Next value
.TP
.B <ESC>
Previous value
.TP
.B <TAB>
Display modification menu. See below.
.TP
.B ^G
Bring up host list display. See below.
.TP
.B ^U
Update current entry
.PD 1v
.B <return>
Go to (display record for) given entry.
.RE
.TP 
.B Miscellaneous
.RS
.TP 
.PD .1v
.B ^L
Refresh Screen
.TP
.PD 1v
.B ^C
Exit program
.RE
.RE
.PP
Some fields on the display are read-only. The cursor will not enter these
fields.
.PP
At any time the user may specify the name of a site in the `Primary hostname'
field, then type
.BR <return> .
This will bring up the record for that site if it is found in the database.
.SH HOST LIST DISPLAY
This multi-column display allows one to browse through all the host names
stored in the database. The key bindings are a subset of those on the main
display. All other keys are ignored.
.RS
.RS
.TP
.B <blank>
Forward one page
.TP
.B <ESC>
Backwards one page
.TP
.B ^F
Forward one column.
.TP
.B ^N
Down one entry.
.TP
.B ^P
Up one entry.
.TP
.B ^B
Backward one column.
.TP
.B <return>
Go back to main display and show full record of current (highlighted)
entry.
.TP
.B ^
Go to first host in database.
.TP
.B $
Go to last host in database.
.TP
.B ^G
Return to main display. The last record shown on the main display is
given.

.SH "MODIFICATION MENU"
This menu allows the user to modify the status of the site entry in the host
databases. The following alternatives are provided:
.RS
.RS
.LP
Add site to host database
.IP 
This option clears the values in the fields (with the exception of the
`source' field) and allows the user to enter a new site into the host
databases. All normal cursor movement is permitted. After the information has
been entered, type the `update' key (by default ^U) to add the new entry to
the database.

Note that no default is provided for the `Database' field. This should be
filled with the name of the initial catalog for this host (for example,
`anonftp' or `webindex').
.LP
Delete a site from the host database
.IP 
Since the Archie catalogs (such as anonftp) depend on the host databases for
host name resolution and other information, it is not currently possible to
immediately delete a site or Archie catalog entry. As a result, the method
used to remove a site or catalog entry from the host databases involves first
marking it for deletion. The system will process this information as part of
its normal operations. When the appropriate files (such as sites files in the
anonftp catalog) have been removed, the catalog entry is marked as
`Deleted'. After all catalogs associated with a host have been so marked, the
site itself can be physically removed from the host databases. This command
will perform this function.
.LP
Add Archie catalog to auxiliary host database
.IP
This command will clear the auxiliary host database area of the screen and
permit the addition of a new auxiliary database name. Type the update key (by
default, ^U) to complete the addition.
.LP
Delete Archie catalog from auxiliary host database
.IP 
Use this command to mark an auxiliary database for deletion.
.LP
Reactivate a catalog
.IP
The system or administrator can disable or mark for deletion a catalog for a
particular site. This option causes the current entry to be placed on `ACTIVE'
status.
.LP
Force early update of a site/catalog entry
.IP
Sometimes it is desriable to force the early update of a particular site or
catalog entry, before the time that it would be normally be scheduled. This
command will mark the current catalog for early update.
.LP
Force deletion of the current catalog
.IP
This is a dangerous operation, but may, in some circumstances, be
necessary. For example, since arbitrary catalog names may be used, a
typographical error (such as typing `webindex' as `webinex') can cause an
incorrect entry into the host databases. This option will allow the Archie
administrator to forcefully remove such a catalog without the standard checks
to be performed.
.LP
.SH "ACCESS DISPLAY CONFIGURATION"
.PP
Internally, the generic access method for each Archie catalog type is
stored as a sequence of values (fields) separated by colons. Since each
catalog type may have a different ordering and meaning for these fields,
the host_manage program allows for convenience the administrator to
define names and default values for these fields.
.PP
For this purpose there is a configuration file associated with the
program.  By default the file is
.B ~archie/etc/hm_db.cf 
unless overridden by the 
.B \-C
command line option. This describes how the various
catalog-specific access methods are to be displayed on the screen.
.PP
The file is formatted as 
.IP
.I <catalog name>		
{ 
.I field configurations 
}
.PP
Each field configution is composed of:
.LP
<field name>,<maximum field width>,<default field value>,<modify>
.RS
.TP
.I <field name>		
A string giving the name of the field to be
displayed. This entry is mandatory.
.TP
.I <maximum field width>	
A number specifying the maximum number of characters 
the field value may have. This entry is mandatory.
.TP
.I <default field value>	
Optional. A string giving the default value of the
field should it be empty in the data. 
.TP
.I <modify>		
Optional. Indicates whether the Archie administrator is 
allowed to modify this display field or not. Must either be the
character 
.B W 
or left empty.
.RE
.PP
Multiple field configurations are delimited by a colon ":". Entries for
the optional fields may be omitted. However an empty entry followed by
other optional fields must have its place maintained by ",,".
.PP
.B Example.
.RS
.PP
The following line describes a typical entry for the anonftp catalog.
.LP
anonftp {Filename,40,,W:User,15:Password,15,,W:Account,15:Path,30,,W}
.PP
This specifies that the access method for the catalog "anonftp" contains
5 fields, here named "Filename", "User" and "Password", "Account", "Path".
.PP
The 
.B Filename
field is defined to have a maximum of 40 characters. No
default value is given. The field can be modified by the administrator.
Note that even though a default value is not given, since the optional
.I <modify> 
field has been specified, a placeholder ",," is required to
specifiy that the 
.I <default value> 
field has been omitted.
.PP
The 
.B User 
field has a maximum \fIwidth\fP of 15 characters and has as a default
value of the string "anonymous". It cannot be modified from the host_manage
program (unless the configuration file is modified to make the field
writable).
.PP
The 
.B Password 
field is also a maximum of 15 characters. No default value is given 
and it cannot be modified by the administrator.  Note that since none 
of the optional fields are specifed they are omitted and no placeholder 
is needed.
.PP
Finally, the
.B Path
field specifies the root path of the `ls-lR' file. This is required for
Novell systems.
.B Other Example
.LP
webindex {Port,5,,W:Path,30,,W}
.PP
The
.B Port
field specifies the port on which the services run.
.PP
.B Path
field specifies the root path of the service.
.RE
.SH DIAGNOSTICS
The program tries to ensure that the host data that is entered is
consistent with the Domain Name System. Errors will be flagged on the
status line at the bottom of the display.
.SH BUGS
Due to a strange interaction between xterms and curses(3), use of this
program on xterm windows often causes random garbage to appear on the
screen. Use of the ^L command will draw and restore the display. This can
be fixed by removing the string:
.sp
.in +2in
:me=\E[m:
.in -2in
.sp
from the
.B /etc/termcap
entry for this and other affected terminal types.
.SH NOTES
There is no file or record locking performed on the host database and so
this program may interact badly with any updates which are currently
being performed by other proceses. This will be fixed in a later release.

Inconsistencies in the DNS are tolerated but flagged as errors.

.SH FILES
~archie/db/host_db/*
.br
~archie/etc/hm_db.cf
.SH AUTHOR
Bunyip Information Systems
.br
Montr\o"\'e"al, Qu\o"\'e"bec, Canada
.sp
Archie is a registered trademark of Bunyip Information Systems Inc., Canada,
1990.