#ifndef _SCREEN_H_
#define _SCREEN_H_

#include <curses.h>


#define	 centre(x)	((COLS - strlen(x)) >> 1)
#define	 WFIELD_DBSPEC		    100

#define	 MIN_COL_DIST		    5

#define	 MIN_NUM_LINES		    24

#define	 CUR_HOSTAUX_NAME	    "Catalog: "
#define	 LCUR_HOSTAUX_NAME	    0
#define	 CCUR_HOSTAUX_NAME	    strlen(CUR_HOSTAUX_NAME)
#define	 WFIELD_HOSTAUX_NAME	    0

#define	 CUR_RECORD_NUM_NAME	    "Record Num: "
#define	 LCUR_RECORD_NUM_NAME	    0
#define	 CCUR_RECORD_NUM_NAME	    (strlen(CUR_RECORD_NUM_NAME)+middle)
#define	 WFIELD_RECORD_NUM_NAME	    0

#define	 CUR_PRIMARY_HOSTNAME	    "Primary hostname: "
#define	 LCUR_PRIMARY_HOSTNAME	    0
#define	 CCUR_PRIMARY_HOSTNAME	    strlen(CUR_PRIMARY_HOSTNAME)
#define	 WFIELD_PRIMARY_HOSTNAME    0

#define	 CUR_ACCESS_METHODS	    "Catalogs: "
#define	 LCUR_ACCESS_METHODS	    1
#define	 CCUR_ACCESS_METHODS	    strlen(CUR_ACCESS_METHODS)

#define	 CUR_PREFERRED_HOSTNAME	    "Preferred hostname: "
#define	 LCUR_PREFERRED_HOSTNAME    0
#define	 CCUR_PREFERRED_HOSTNAME    strlen(CUR_PREFERRED_HOSTNAME)
#define	 WFIELD_PREFERRED_HOSTNAME  0

#define	 CUR_PRIMARY_IPADDR	    "Primary IP address: "
#define	 LCUR_PRIMARY_IPADDR	    3
#define	 CCUR_PRIMARY_IPADDR	    strlen(CUR_PRIMARY_IPADDR)

#define	 CUR_OS_TYPE		    "Operating System: "
#define	 LCUR_OS_TYPE		    2
#define	 CCUR_OS_TYPE		    strlen(CUR_OS_TYPE)
#define	 WFIELD_OS_TYPE		    1

#define	 CUR_PROSPERO_HOST	    "Prospero Host: "
#define	 LCUR_PROSPERO_HOST	    2
#define	 CCUR_PROSPERO_HOST	    (strlen(CUR_PROSPERO_HOST) + middle)
#define	 WFIELD_PROSPERO_HOST	    2

#define	 CUR_TIMEZONE		    "Timezone: "
#define	 LCUR_TIMEZONE		    3
#define	 CCUR_TIMEZONE		    (strlen(CUR_TIMEZONE) + middle)
#define	 WFIELD_TIMEZONE	    3

#define	 CUR_GENERATED_BY	    "Generated by: "
#define	 LCUR_GENERATED_BY	    2
#define	 CCUR_GENERATED_BY	    (strlen(CUR_GENERATED_BY) + middle)

#define	 CUR_SOURCE_ARCHIE_HOSTNAME "Source:        "
#define  LCUR_SOURCE_ARCHIE_HOSTNAME   2
#define	 CCUR_SOURCE_ARCHIE_HOSTNAME	  strlen(CUR_SOURCE_ARCHIE_HOSTNAME)


#define	 CUR_RETRIEVE_TIME	    "Retrieve time: "
#define	 LCUR_RETRIEVE_TIME	    3
#define	 CCUR_RETRIEVE_TIME	    strlen(CUR_RETRIEVE_TIME)

#define	 CUR_PARSE_TIME		    "Parse time:    "
#define	 LCUR_PARSE_TIME	    4
#define	 CCUR_PARSE_TIME	    (strlen(CUR_PARSE_TIME))

#define	 CUR_UPDATE_TIME	    "Update time:   "
#define	 LCUR_UPDATE_TIME	    5
#define	 CCUR_UPDATE_TIME	    (strlen(CUR_UPDATE_TIME))

#define	 CUR_NO_RECS		    "Number of records: "
#define	 LCUR_NO_RECS		    3
#define	 CCUR_NO_RECS		    (strlen(CUR_NO_RECS) + middle)

#define	 CUR_CURRENT_STATUS	    "Current status: "
#define	 LCUR_CURRENT_STATUS	    14
#define	 CCUR_CURRENT_STATUS	    (strlen(CUR_CURRENT_STATUS))
#define	 WFIELD_CURRENT_STATUS	    1

#define	 CUR_FAIL_COUNT		    "Fail count: "
#define	 LCUR_FAIL_COUNT	    5
#define	 CCUR_FAIL_COUNT	    (strlen(CUR_FAIL_COUNT) + middle)

#define	 CUR_COMMENT		    "Msg: "
#define	 LCUR_COMMENT		    7
#define	 CCUR_COMMENT		    strlen(CUR_COMMENT)

#define	 CUR_FORCE_UPDATE	    "Force Update: "
#define	 LCUR_FORCE_UPDATE	    15
#define	 CCUR_FORCE_UPDATE	    (strlen(CUR_FORCE_UPDATE))
#define	 WFIELD_FORCE_UPDATE	    2

#define	 CUR_ACTION		    "Action: "
#define	 LCUR_ACTION		    16
#define	 CCUR_ACTION		    strlen(CUR_ACTION)
#define	 WFIELD_ACTION		    3


#define	 MODMEN_TITLE		    "Host Database Modification Menu"
#define	 LCUR_MODMEN_TITLE	    0
#define	 CCUR_MODMEN_TITLE	    15


#define MODMEN_ADDSITE		    "1. Add a site to the host database"
#define LCUR_MODMEN_ADDSITE	    2
#define	CCUR_MODMEN_ADDSITE	    3

#define	 MODMEN_DELSITE		    "2. Delete a site from the host database"
#define LCUR_MODMEN_DELSITE	    4
#define	CCUR_MODMEN_DELSITE	    3

#define MODMEN_ADDHOSTAUX	    "3. Add an archie catalog to current site"
#define LCUR_MODMEN_ADDHOSTAUX	    6
#define	CCUR_MODMEN_ADDHOSTAUX	    3

#define	MODMEN_DELHOSTAUX	    "4. Delete an archie catalog from current site"
#define	LCUR_MODMEN_DELHOSTAUX	    8
#define	CCUR_MODMEN_DELHOSTAUX	    3

#define	MODMEN_REACTIVATE	    "5. Reactivate catalog"
#define	LCUR_MODMEN_REACTIVATE	    10
#define	CCUR_MODMEN_REACTIVATE	    3

#define	MODMEN_FORCE_UPDATE	    "6. Force early update of current catalog"
#define	LCUR_MODMEN_FORCE_UPDATE    12
#define	CCUR_MODMEN_FORCE_UPDATE     3

#define	MODMEN_FORCE_DB_DELETE	    "7. Force deletion of current catalog (dangerous)"
#define	LCUR_MODMEN_FORCE_DB_DELETE 14
#define	CCUR_MODMEN_FORCE_DB_DELETE  3

#define	MODMEN_QUIT		    "0. Quit menu"
#define LCUR_MODMEN_QUIT	    16
#define	CCUR_MODMEN_QUIT	    3

#define	 MODMEN_SEL	      "Selection: "
#define	 LCUR_MODMEN_SEL      17
#define	 CCUR_MODMEN_SEL      15


#ifdef __STDC__

extern	 void		display_hostlist();
extern	 status_t	setup_screen();
extern	 void		teardown_screen();
extern	 status_t	display_records(hostdb_t *, hostdb_aux_t *, dbspec_t *, action_status_t);
extern	 status_t		move_field(WINDOW **, int *, int *, dbspec_t *, int);
extern	 status_t	move_cursor(WINDOW **, int *, int *, int, dbspec_t *, action_status_t);
extern	 int		process_input(hostdb_t *, hostdb_aux_t *, dbspec_t *, action_status_t *);
extern	 void		send_response();
extern	 void		clear_response();
extern	 status_t	print_input(WINDOW **, int *, int *, int, dbspec_t *, action_status_t);
extern	 status_t	get_yn_question();
extern	 void		clear_records();
extern	 int		next_value(hostdb_t *,hostdb_aux_t *,WINDOW **,int *,int *,int,dbspec_t *, action_status_t *);
extern	 int		go_to(WINDOW **,int *);
extern	 int		modify_record(WINDOW *);

#else
extern	 void		display_hostlist();
extern	 status_t	setup_screen();
extern	 void		teardown_screen();
extern	 status_t	display_records();
extern	 void		sig_handle();
extern	 status_t	move_field();
extern	 status_t	move_cursor();
extern	 int		process_input();
extern	 void		send_response();
extern	 void		clear_response();
extern	 status_t		print_input();
extern	 status_t	get_yn_question();
extern	 void		clear_records();
extern	 int		modify_record();

#endif

#endif
