.\" $Id: archie.l,v 3.6 1991/08/03 00:16:30 clipper Exp clipper $
.TH ARCHIE L "28 JULY 1991"

.SH NAME
archie \- query an archie server

.SH SYNOPSIS
.B archie
.RB [ " \-match hits " ]
.RB [ " \-reg " ]
.RB [ " \-exact " ]
.RB [ " \-nocase " ]
.RB [ " \-case " ]
.RB [ " \-server hostname " ]
.RB [ " \-ffile formatfile " ]
.RB [ " \-format format " ]
.RB [ " \-norc " ]
.RB [ " \-rc" ]
.RB [ " \-sort date \| host " ]
.RB [ " \-reverse " ]
.RB [ " \-version " ]
.RB [ " \-domain string " ]
.RB [ " \-along " ]
.IR word1 
.IR word2 \&.\|.\|.
.LP

.SH DESCRIPTION
.B archie
archie queries a remote database to identify files and directories
with the words 'world1', 'word2', etc, in their names.  The program
allows the user to specify a format to print the matching entries.
.LP
archie is a database that assists users in identify the sites that
have files matching the given words.  For example, if you want to find
out the anonymous sites carrying the file 'wonder', a query to the
archie database will return a list of the hosts with files whose names
include that string.  The directory and file name are also returned so
that the user can subsequently retrieve the file.

.LP
.SH NOTE

Please set the maximum hit number to a moderate number. The archie
server you are accessing is used by many people. Setting the maximum
hit number to a very high number in peak periods not only lengthen the
time you have to wait for the response, it also lengthens the time
other people have to wait too. Please also refrain from having a large
number of queries in peak periods for the same reason.

.LP
.SH OPTIONS

You must have all the options listed before the words you want to
match. Otherwise, the options after the first word will be treated as
additional words. For example, `archie word -reg' queries two words,
`word' and `-reg'.

.TP
.B \-match hits
Set the maximum number of hits to be ` hits '. The default number is
40. Please set this to a moderate number.
.TP
.B \-case
Set the search option to be case sensitive.
.TP
.B \-nocase
Set the search option to be case insensitive.
.TP
.B \-exact
Set the search option to be exact.
.TP
.B \-reg
Set the search option to be regular expression.
.TP
.B \-along
Prints the entries along the way. The default is to print the entries
after all of them have been obtained. If the connection dies in the
middle of the query, you will have the partial list up to that time.
.TP
.B \-server hostname 
Set the archie server to ` hostname '.
.TP
.B \-ffile filename
Read the file ` filename ' to get the format string.
.TP
.B \-format string
Set the format string to be ` string '. For example, \-format '%host:%dir:%size:%date\\n'.
Notice the single quotes will prevent the shell from interpreting the string.
.TP
.B \-norc
Do not read the .archierc file from the user's home directory.
.TP
.B \-rc filename
Use filename as the startup file instead.
.TP
.B \-sort [host | date]
Sort by the host or date. To sort by host, the sort key is the domain
of the hosts. This is useful for sorting the entries by the distance
of the hosts to your own machine.
.TP
.B \-reverse
To reverse the sorting order.
.TP
.B \-version
To print out the version number of the program.
.TP
.B \-domain string
If the sorting is done using the hosts, use the order specify by
`string' to order the hosts. For example, if `string' is 'nl de fi fr
edu ca', then the hosts in nl domain will be first; the hosts in the
de domain will be printed second, etc.

.LP
.SH STARTUP FILE
.I Archie
reads the file ` .archierc ' from the user's home directory. The
commands allowed are ` match ', ` search ', ` host ', ` domain ' and `
format '.  The format command must be specified last in the file.
Each line has two fields; the first field is the name of the command
and the second field is the option value. The value of the ` match '
option is an integer. The values allowed for the ` search ' command
are
.I case, nocase, reg, exact
with the same meaning as on the command line. The ` host ' command
allows an alternate archie server to be specified. The file can have
comment lines before the format option. Each comment line must appear
on a separate line.  The `domain' field is used to specify the order
of hosts to be printed. This is useful to specify the nearest hosts
first and farthest hosts at the end. No comments are allowed on the
same lines as the commands. A comment line is started with the \#
character.

.LP
.SH OUTPUT FORMAT
The output of
.I archie
is controled by a format string. This format string can be changed in
the archie startup file, specified on the command line, or read from a
file. The format string has a similar syntax with the format file of
printf(). The escape character for fields is %. The meaning of
backslash is similar to that in printf. The allowed fields are:

.PD 0
.TP 10
.B %
Double % will produce a single % in the output.
.TP
.B host
This field will be replaced by the host name in an entry.
.TP
.B dir
This field specifies the path of the entry.
.TP
.B mode
The protection of the entry.
.TP
.B date
The date of last modification of the entry.
.TP
.B seq
The number of entries processed so far.
.TP
.B size
The size of the entry.
.TP
.B name
The filename of entry.
.TP
.B type
The file type of the entry, a directory or a file.

.LP
After the % character and before the field string, a optional number
is allowed to specify the width of the field possibly zero-padded. For
example, '%04seq' means zero-padded 4-character width field for the
sequence number.

.LP
.SH SEE ALSO
.BR telnet(1)
.BR ftp (1)

.LP
.SH BUGS
.LP
This program is under revision. Probably has quite a few bugs.

.LP
.SH DIAGNOSTICS
.TP
.BI "archie: Format string ignored: a format file was specified"
A format string was specified after a format file was given.
.TP
.BI "archie: Format error. Unknown field: " string
.I String
is not recognized.
.TP
.BI "archie: " user "/.archierc: unknown search option " option
The match option 
.I option
in
.I user
/.archierc is not known.
.TP
.BI "archie: Unknown option in " user "/.archierc: " option
The option in
.I user
archie startup file is not known.

.LP
.SH AUTHOR
Khun Yee Fung (clipper@csd.uwo.ca). Department of Computer Science,
University of Western Ontario.

.LP
.SH AUTHOR OF PROSPERO
The Archie client queries a remote database using the Prospero
protocol.  Clifford Neuman (bcn@isi.edu) designed the Prospero
protocol and wrote the server.


.LP
.SH THE ARCHIE GROUP
The Prospero server queries the Archie database and returns the
results.  It is the Archie database that is responding to your query.
The archie database is written and maintained by Allan Emtage
(bajan\@cs.mcgill.ca) and Bill Heelan (wheelan\@cs.mcgill.ca).  Peter
Deutsch (peterd\@cs.mcgill.ca) is also involved in the archie group in
McGill.

.LP
.SH COPYRIGHT
You can modify, distribute, and generally do anything you want to this
file except to sell it for profit. You must preserve the copyright
notice in all copies of this program.

ABSOLUTELY NO WARRANTY.
