.\" Copyright (c) 1992, 1994, 1996 Bunyip Information Systems Inc.
.\" All rights reserved.  
.\"	
.\" Archie 3.5
.\" August 1996
.\"	
.\"	@(#)insert_anonftp.n	
.\"
.TH INSERT_ANONFTP N "August 1996"

.SH NAME
.B insert_anonftp

.SH SYNOPSIS
.B insert_anonftp  
.BI \-i \ <file>  
[ 
.BI \-M \ <dir> 
] [
.BI \-w \ <dir> 
] [ 
.BI \-h \ <dir> 
] [ 
.BI \-t \ <dir> 
] [
.BI \-I \ <size> 
] [ 
.B \-v
]  [ 
.B \-l 
] [
.BI \-L \ <logfile> 
]

.SH DESCRIPTION
.PP
.B insert_anonftp 
inserts, into the anonftp database, the data from a parsed anonymous ftp listing.
It is normally run from the master control program,
.BR arcontrol (n),
as part of the update phase of the Archie update cycle. It may also be invoked
from the command line. 
.PP
The file to be inserted must be in Archie anonftp parse output format, such as is
generated by the suite of Archie anonftp parsers 
.BR parse_anonftp_* .
This format is standard, regardless of the orginal format of the 
anonymous FTP directory listing. The output of this
program is placed directly into the anonftp catalog.

.B insert_anonftp 
updates on the anonftp database in several phases, in order to
minimize the critical period where interruption of the insertion could
cause the database to be corrupted. However, to prevent the possibility
of this happening at all, the program should not be interrupted at any time. 
.PP
.B insert_anonftp 
will not attempt to update a site which is listed as
.I active
in the host databases, nor overwrite an existing data file in the
anonftp database.  Error conditions, such as a full file system, are also
detected before the anonftp database is modified.
.PP
This program also modifies the anonftp entry, in the auxiliary host database,
corresponding to this site.
.PP
When invoking this program from the command line, care should be taken to
ensure that no other processes are modifying the anonftp catalog.
The exclusive locking mechanism provided by the
.BR update_anonftp (n)
program which invokes
.B insert_anonftp
in normal operation will not be available in the command line
invocation.

.SH OPTIONS
.PP
The following option must be supplied:
.RS
.TP 
.BI \-i \ <file>
The name of the file containing the parsed ftp listing.
.RE
.PP
Additionally, the following options are accepted:
.RS
.TP 
.TP
.BI \-M \ <dir>
The name of the master Archie database directory. If not
specified, the program looks in the directory
.BR ~archie/db ,
then
.BR ./db .
.TP
.BI \-w \ <dir>
The name of the directory in which the Archie anonftp
catalog resides.  This parameter overrides the default
catalog name,
.BR ~archie/db/anonftp ,
as well as the
.B \-M
option.
.TP
.BI \-h \ <dir>
The name of the Archie host database directory. If not
specified, the program first looks in
.BR ~archie/db/host_db ,
then
.BR ./host_db .
.TP 
.BI \-t \ <dir>	
Set the name of directory used to store temporary files. By
default, 
.B ~archie/db/tmp
is used.
.TP 
.BI \-I \ <size>
Set a minimum size, in bytes, for a site file to be indexed.
If the size of the site file is greater than or equal to this size,
a .idx file will accompany the site file in order to speed up search
queries.  The default value of
.I <size>
is 500000 bytes.
.TP 
.BI \-v
Verbose mode.  Print messages indicating what the program is
doing.
.TP
.BI \-l
Log messages to the file
.BR ~archie/logs/archie.log .
The location of the file may be overridden with the
.B \-L
option.  By default, messages are written to
.IR stderr .
.TP
.BI \-L \ <logfile>
Specify the log file.  For this to have any effect, the
.B \-l
option must be specified, as well.  Note that debugging
information is also written to the log file.
.RE

.SH FILES
~archie/db/host_db/*
.br
~archie/db/anonftp_db/*

.SH BUGS
Unlike the previous Archie system, corruption of the database is limited to
the single site when the program is aborted prematurely.  If an insert ends
before the site is created then the data in the
.B db/webindex_db/start_db.*
database will not be accurate but will not affect other insertions.  Your
queries will output error messages in the logs files reflecting the
inconsistency.

.SH "SEE ALSO"
.BR db_check (n),
.BR fix_start_db (n),
.BR update_anonftp (n),
.BR delete_anonftp (n),
.BR parse_anonftp_* (n),
.BR arcontrol (n)

.SH AUTHOR
Bunyip Information Systems
.br
Montr\o"\'e"al, Qu\o"\'e"bec, Canada
.sp
Archie is a registered trademark of Bunyip Information Systems Inc., Canada,
1990.
