.\" Copyright (c) 1992, 1994, 1996 Bunyip Information Systems Inc.
.\" All rights reserved.  
.\"	
.\" Archie 3.5
.\" August 1996
.\"	
.\"	@(#)insert_webindex.n	
.\"
.TH INSERT_WEBINDEX N "August 1996"

.SH NAME
.B insert_webindex

.SH SYNOPSIS
.B insert_webindex  
.BI \-i \ <file>  
[ 
.BI \-M \ <dir> 
] [
.BI \-w \ <dir> 
] [ 
.BI \-h \ <dir> 
] [ 
.BI \-t \ <dir> 
] [
.BI \-I \ <size> 
] [ 
.B \-v
]  [ 
.B \-l 
] [
.BI \-L \ <logfile> 
]

.SH DESCRIPTION
.PP
.B insert_webindex
inserts, into the webindex database, the data from a parsed web index
listing.
It is normally run from the master control program,
.BR arcontrol (n),
as part of the update phase of the Archie update cycle. It may also be invoked
from the command line.
.PP
The file to be inserted must be in Archie webindex parse output format, such as
is
generated by the Archie webindex parser,
.BR parse_webindex .
The output of this program is placed directly into the webindex catalog.

.B insert_webindex
updates the webindex database in several phases, in order to
minimize the critical period where interruption of the insertion could
cause the database to be corrupted. However, to prevent the possibility
of this happening at all, the program should not be interrupted at any time.
.PP
.B insert_webindex
will not attempt to update a site which is listed as
.I active
in the host databases, nor overwrite an existing data file in the
webindex database.  Error conditions, such as a full file system, are also
detected before the webindex database is modified.
.PP
This program also modifies the webindex entry, in the auxiliary host database,
corresponding to this site.
.PP
When invoking this program from the command line, care should be taken to
ensure that no other processes are modifying the webindex catalog.
The exclusive locking mechanism provided by the
.BR update_webindex (n)
program, which invokes
.B insert_webindex
in normal operation, will not be available in the command line
invocation.

.SH OPTIONS
.PP
The following option must be supplied:
.RS
.TP 
.B \-i
Input file name
.RE
.PP
Additionally, the following options are accepted:
.RS
.TP 
.BI \-M \ <dir>
The name of the master Archie database directory. If not
specified, the program looks in the directory
.BR ~archie/db ,
then
.BR ./db .
.TP 
.BI \-w \ <dir> 
The name of the directory in which the Archie webindex 
catalog resides. This parameter overrides the internally generated
catalog name 
.B ~archie/db/webindex 
and the 
.B \-M 
option, if specified.
.TP 
.BI \-h \ <dir>
The name of the Archie host database directory. If not
specified, the program will first default to
.BR ~archie/db/host_db ,
then
.BR ./host_db .
.TP 
.BI \-t \ <dir>	
Set the name of directory used for temporary files. By
default the program uses 
.B ~archie/db/tmp.
.TP 
.BI \-I \ <size> 
Set the minimum size for a site file to be indexed.
The size is in bytes.
If the size of the site file is greater or equal to this size
a .idx file will accompany this site file to speed up
searches in it. By default this size is
500000 bytes.
.TP 
.BI \-v
Verbose mode. Tells you what it is doing.
.TP 
.B \-l
Write any user output to the default log file
.B ~archie/logs/archie.log. 
If desired, this can be overridden with the 
.B \-L
option. Errors will by default be written to
.I stderr.
.TP 
.BI \-L \ <logfile>	
The name of the file to be used for logging information.
Note that debugging information is also written to the
log file. This implies the 
.B \-l 
option as well.		
.RE

.SH FILES
~archie/db/host_db/*
.br
~archie/db/webindex_db/*

.SH BUGS
Unlike the previous Archie system, corruption of the database is limited
to the single site when the program is aborted
prematurely.If an insert ends
before the site is created then the data in the db/webindex_db/start_db.*
database will not be accurate but will not affect other insertions.  Your
queries will output error messages in the logs files reflecting the
inconsistency.

.SH "SEE ALSO"
.BR db_check (n),
.BR fix_start_db (n),
.BR update_webindex (n),
.BR delete_webindex (n),
.BR parse_webindex (n),
.BR arcontrol (n)

.SH AUTHOR
Bunyip Information Systems
.br
Montr\o"\'e"al, Qu\o"\'e"bec, Canada
.sp
Archie is a registered trademark of Bunyip Information Systems Inc., Canada,
1990.
