#!/usr/local/bin/perl
#
# evaluate the ~archie/pfs/pfs.log file (from standard input).
#
# written by Thomas Lenggenhager, SWICH <lenggenhager@switch.ch>
# 940731
#

open(OUT, ">performance");
while (<>) {
    if (/^(..-...-..) (..):(..):(..) .* - L  ARCHIE\/MATCH\((\d*).*(.)\)(.*)/) {
        $date = $1; $hour = $2; $min = $3; $sec = $4;
        $max = $5; $type = $6; $string = $7;
        $search = 1;
    } elsif (/^(..-...-..) (..):(..):(..) .* - matches: (\d*)/) {
        next unless $search;
        $search = 0;
        $match = $5;
        if ($hour > $2) {
            $secs = 60 - $sec;
            $secs += (60 - $min - 1) * 60;
            $secs += (($2 * 60) + $3) * 60 + $4;
        } elsif ($min > $3) {
            $secs = 60 - $sec;
            $secs += (60 - $min -1) * 60;
            $secs += (((($2 - $hour - 1) * 60) + $3) * 60) + $4;
        } elsif ($sec > $4) {
            $secs = 60 - $sec;
            $secs += ($3 - $min - 1) * 60 + $4;
        } else {
            $secs = $4 - $sec;
        }
        print OUT "$hour:$min:$sec - $2:$3:$4\t$secs\t$type $max\t$match\t$string\n";
        $count++;
        $sum += $secs;
        $sqsum += $secs * $secs;
        $count{$type}++;
        $sum{$type} += $secs;
        $sqsum{$type} += $secs * $secs;
        if ($secs > $maxsecs) {
            $maxsecs = $secs;
        }
        if ($secs > $maxsecs{$type}) {
            $maxsecs{$type} = $secs;
        }
        if ($secs > 120) {
            print OUT "$hour:$min:$sec - $2:$3:$4\t$secs\t$type $max\t$match\t$string\n";
        }
#       last if $count == 500;
    }
}
print OUT "\nResults for all Queries:\n";
if ($count < 2) {
	print OUT "No data in log file\n";
	exit
}
$medium = $sum/$count;
$variance = ($sqsum - $medium)/($count - 1);
printf OUT "Samples:\t%d\n", $count;
printf OUT "Mean:\t\t%f\n", $medium;
printf OUT "Std.-deviation:\t%f\n", sqrt($variance);
printf OUT "Maximum:\t%d\n", $maxsecs;
print OUT "\n";
foreach $type (sort keys %count) {
    next if ($count{$type} < 2);
    print OUT "Results for <$type> Queries:\n";
    $medium = $sum{$type}/$count{$type};
    $variance = ($sqsum{$type} - $medium)/($count{$type} - 1);
    printf OUT "Samples:\t%d\n", $count{$type};
    printf OUT "Mean:\t\t%f\n", $medium;
    printf OUT "Std.-deviation:\t%f\n", sqrt($variance);
    printf OUT "Maximum:\t%d\n", $maxsecs{$type};
    print OUT "\n";
}
