{$O+,F+}
UNIT BullShit;

INTERFACE
USES CRT,FastTTT5,types;
{$V-}

FUNCTION valu (q:mstr):INTEGER;
FUNCTION match (s1,s2:anystr):BOOLEAN;
PROCEDURE Highlight(X:INTEGER);
PROCEDURE Display_Logo;
PROCEDURE DMM;
PROCEDURE TheEnd;

IMPLEMENTATION

  FUNCTION valu (q:mstr):INTEGER;
  VAR I,S,pu:INTEGER;
    r:REAL;
  BEGIN
  valu:=0;
  IF LENGTH(q)=0 THEN EXIT;
  IF NOT (q[1] IN ['0'..'8','-']) THEN EXIT;
  IF LENGTH(q)>5 THEN EXIT;
  VAL (q,r,S);
  IF S<>0 THEN EXIT;
  IF (r<=32767.0) AND (r>=-32767.0)
  THEN valu:=ROUND(r)
  END;

  FUNCTION match (s1,s2:anystr):BOOLEAN;
  VAR cnt:INTEGER;
  BEGIN
  match:=FALSE;
  IF LENGTH(s1)<>LENGTH(s2) THEN EXIT;
  FOR cnt:=1 TO LENGTH(s1) DO
    IF UPCASE(s1[cnt])<>UPCASE(s2[cnt])
    THEN EXIT;
  match:=TRUE
  END;

  PROCEDURE Highlight (X:INTEGER);
  BEGIN
  CASE X OF
    1 : WriteAT (29,12,LightCyan,Blue,' General Configuration ');
    2 : WriteAT (29,13,LightCyan,Blue,'  Modem Configuration  ');
    3 : WriteAT (29,14,LightCyan,Blue,'    Security Levels    ');
    4 : WriteAT (29,15,LightCyan,Blue,' Screen Configurations ');
    5 : WriteAT (29,16,LightCyan,Blue,'     Matrix Logins     ');
    6 : WriteAT (29,17,LightCyan,Blue,' String Configurations ');
    7 : WriteAT (29,18,LightCyan,Blue,'  Event Configuration  ');
    8 : WriteAT (29,19,LightCyan,Blue,'     Miscellaneous     ');
  END;
  END;

  PROCEDURE UNCRUNCH (VAR Addr1,Addr2; BlkLen:INTEGER);
  BEGIN
  INLINE (
    $1E/               {       PUSH    DS             ;Save data segment.}
    $C5/$B6/Addr1/     {       LDS     SI,[BP+Addr1]  ;Source Address}
    $C4/$BE/Addr2/     {       LES     DI,[BP+Addr2]  ;Destination Addr}
    $8B/$8E/BlkLen/    {       MOV     CX,[BP+BlkLen] ;Length of block}
    $E3/$5B/           {       JCXZ    Done}
    $8B/$D7/           {       MOV     DX,DI          ;Save X coordinate for later.}
    $33/$C0/           {       XOR     AX,AX          ;Set Current attributes.}
    $FC/               {       CLD}
    $AC/               {LOOPA: LODSB                  ;Get next character.}
    $3C/$20/           {       CMP     AL,32          ;If a control character, jump.}
    $72/$05/           {       JC      ForeGround}
    $AB/               {       STOSW                  ;Save letter on screen.}
    $E2/$F8/           {Next:  LOOP    LOOPA}
    $EB/$4C/           {       JMP     Short Done}
                       {ForeGround:}
    $3C/$10/           {       CMP     AL,16          ;If less than 16, then change the}
    $73/$07/           {       JNC     BackGround     ;foreground color.  Otherwise jump.}
    $80/$E4/$F0/       {       AND     AH,0F0H        ;Strip off old foreground.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$F1/           {       JMP     Next}
                       {BackGround:}
    $3C/$18/           {       CMP     AL,24          ;If less than 24, then change the}
    $74/$13/           {       JZ      NextLine       ;background color.  If exactly 24,}
    $73/$19/           {       JNC     FlashBitToggle ;then jump down to next line.}
    $2C/$10/           {       SUB     AL,16          ;Otherwise jump to multiple output}
    $02/$C0/           {       ADD     AL,AL          ;routines.}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $80/$E4/$8F/       {       AND     AH,8FH         ;Strip off old background.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$DA/           {       JMP     Next}
                       {NextLine:}
    $81/$C2/$A0/$00/   {       ADD     DX,160         ;If equal to 24,}
    $8B/$FA/           {       MOV     DI,DX          ;then jump down to}
    $EB/$D2/           {       JMP     Next           ;the next line.}
                       {FlashBitToggle:}
    $3C/$1B/           {       CMP     AL,27          ;Does user want to toggle the blink}
    $72/$07/           {       JC      MultiOutput    ;attribute?}
    $75/$CC/           {       JNZ     Next}
    $80/$F4/$80/       {       XOR     AH,128         ;Done.}
    $EB/$C7/           {       JMP     Next}
                       {MultiOutput:}
    $3C/$19/           {       CMP     AL,25          ;Set Z flag if multi-space output.}
    $8B/$D9/           {       MOV     BX,CX          ;Save main counter.}
    $AC/               {       LODSB                  ;Get count of number of times}
    $8A/$C8/           {       MOV     CL,AL          ;to display character.}
    $B0/$20/           {       MOV     AL,32}
    $74/$02/           {       JZ      StartOutput    ;Jump here if displaying spaces.}
    $AC/               {       LODSB                  ;Otherwise get character to use.}
    $4B/               {       DEC     BX             ;Adjust main counter.}
                       {StartOutput:}
    $32/$ED/           {       XOR     CH,CH}
    $41/               {       INC     CX}
    $F3/$AB/           {       REP STOSW}
    $8B/$CB/           {       MOV     CX,BX}
    $49/               {       DEC     CX             ;Adjust main counter.}
    $E0/$AA/           {       LOOPNZ  LOOPA          ;Loop if anything else to do...}
    $1F);              {Done:  POP     DS             ;Restore data segment.}
  END; {UNCRUNCH}

  PROCEDURE Display_Logo;
{ TheDraw Pascal Crunched Screen Image }
  CONST
    IMAGEDATA_WIDTH=80;
    IMAGEDATA_DEPTH=25;
    IMAGEDATA_LENGTH=396;
    IMAGEDATA : ARRAY [1..396] OF CHAR = (
      #15,#16,#25,#27, #5,'','','', #1,'', #5,#26, #8,'', #1,'','',
      '', #5,#26, #4,'',#24,#25,#30, #1,'',#25, #2, #5,'',' ',' ', #1,
      '','','',' ','',' ','','','',#24,#25, #9, #8,'L',' ','i',' ',
      'm',' ','e',' ','L',' ','i',' ','g',' ','h',' ','t',' ', #1,'','',
      '','','','','', #5,'', #1,'','','','','','','','','',
      '','','','',' ', #8,'L',' ','i',' ','m',' ','e',' ','L',' ','i',
      ' ','g',' ','h',' ','t',#24,#25,#29, #1,'',#25, #2, #5,'','',#25,
      #4, #1,'','',#24,#25, #3, #8,'T',' ','e',' ','c',' ','h',' ','n',
      ' ','o',' ','l',' ','o',' ','g',' ','i',' ','e',' ','s',' ', #5,'',
      #1,'','', #5,'', #1,'','','','',' ', #5,#26, #3,'', #1,'',
      #5,#26, #6,'',' ', #8,'T',' ','e',' ','c',' ','h',' ','n',' ','o',
      ' ','l',' ','o',' ','g',' ','i',' ','e',' ','s',#24,#25,#28, #1,'',
      '','',' ', #5,'','',' ','','','','',' ', #1,'',#24,#25,#27,
      #26, #4,'', #5,'','','', #1,#26,#12,'',#24,#25, #3, #8,#26,'D',
      '',#24,#24,#25,#25, #9,'T',' ','r',' ','a',' ','n',' ','s',' ','P',
      ' ','h',' ','o',' ','r',#25, #2,'2',' ','0',' ','0',' ','0',#24,#24,
      #24,#25,#22,#13,'U','n','d','e','r','g','r','o','u','n','d',' ','C',
      'o','m','m','u','n','i','c','a','t','i','o','n','s',' ','S','y','s',
      't','e','m',#24,#25,#22, #7,#26,' ','',#24,#24,#24,#25,#25, #5,'C',
      'o','n','f','i','g','u','r','a','t','i','o','n',' ','P','r','o','g',
      'r','a','m',' ','v','.','0','1','a',#24,#24,#25, #3, #8,#26,'D','',
      #24,#24,#24,#25,#24,#27,'(','%',' ','P','r','e','s','s',' ','E','n',
      't','e','r',' ','t','o',' ','C','o','n','t','i','n','u','e',' ','%',
      ')',#24,#24,#24,#24);

  TYPE ScreenType = ARRAY [0..3999] OF BYTE;
  VAR ScreenAddr : ScreenType ABSOLUTE $B800:$0000;
  BEGIN
  UNCRUNCH(IMAGEDATA,ScreenAddr[ (1*2) + (2*160) -162],2000);
  END;

  PROCEDURE DMM; { Display Main Menu }
{ TheDraw Pascal Crunched Screen Image.  Date: 08/08/95 }
const
  IMAGEDATA_WIDTH=80;
  IMAGEDATA_DEPTH=25;
  IMAGEDATA_LENGTH=381;
  IMAGEDATA : array [1..381] of Char = (
    #15,#16,#25,#12, #5,'','','', #1,'', #5,#26, #8,'', #1,'','',
    '', #5,#26, #4,'',#24,#25,#15, #1,'',#25, #2, #5,'',' ',' ', #1,
    '','','',' ','',' ','','','',#25, #2, #8,'%',' ','L','i','m',
    'e','L','i','g','h','t',' ','T','e','c','h','n','o','l','o','g','i',
    'e','s',' ','O','n','L','i','n','e','!',#24,#25,#12, #1,'','','',
    '','','','', #5,'', #1,'','','','','','','','','','',
    '','','',#24,#25,#14,'',#25, #2, #5,'','',#25, #4, #1,'','',
    #25, #6, #8,'%',' ','T','r','a','n','s','P','h','o','r',' ','2','0',
    '0','0',#24,#25,#12, #5,'', #1,'','', #5,'', #1,'','','','',
    ' ', #5,#26, #3,'', #1,'', #5,#26, #6,'',#24,#25,#13, #1,'','',
    '',' ', #5,'','',' ','','','','',' ', #1,'',#25, #7, #8,'%',
    ' ','C','o','n','f','i','g','u','r','a','t','i','o','n',' ','P','r',
    'o','g','r','a','m',' ','v','0','.','1','a',#24,#25,#12, #1,#26, #4,
    '', #5,'','','', #1,#26,#12,'',#24,#24,#24,#25,#26,'', #9,'',
     #5,'',#13,'',#25,#16,'', #5,'', #9,'', #1,'',#24,#25,#26, #9,
    '',#25,#22,'',#24,#25,#26, #5,'',#25,#22,'',#24,#25,#26,#13,'',
    #25,#22,'',#24,#24,#24,#25,#26,'',#25,#22,'',#24,#25,#26, #5,'',
    #25,#22,'',#24,#25,#26, #9,'',#25,#22,'',#24,#25,#26, #1,'', #9,
    '', #5,'',#13,'',#25,#16,'', #5,'', #9,'', #1,'',#24,#24,#25,
    #15, #7,'U','s','e',' ',#26, #0,#24,' ','-',' ',#26, #0,#25,' ','t',
    'o',' ','n','a','v','i','g','a','t','e',' ','/',' ','E','S','C',' ',
    't','e','r','m','i','n','a','t','e','s',' ','p','r','o','g','r','a',
    'm','.',#24,#24,#24,#24,#24);
  TYPE ScreenType = ARRAY [0..3999] OF BYTE;
  VAR ScreenAddr : ScreenType ABSOLUTE $B800:$0000;
  BEGIN
  UNCRUNCH(IMAGEDATA,ScreenAddr[ (1*2) + (2*160) -162],1088);
  END;

  PROCEDURE TheEnd; { Display Exiting Screen }
{ TheDraw Pascal Crunched Screen Image.  Date: 08/07/95 }
const
  IMAGEDATA_WIDTH=80;
  IMAGEDATA_DEPTH=25;
  IMAGEDATA_LENGTH=311;
  IMAGEDATA : array [1..311] of Char = (
     #7,#16,#24,#25,#27, #5,'','','', #1,'', #5,#26, #8,'', #1,'',
    '','', #5,#26, #4,'',#24,#25,#30, #1,'',#25, #2, #5,'',' ',' ',
     #1,'','','',' ','',' ','','','',#24,#25, #9, #8,'L',' ','i',
    ' ','m',' ','e',' ','L',' ','i',' ','g',' ','h',' ','t',' ', #1,'',
    '','','','','','', #5,'', #1,'','','','','','','','',
    '','','','','',' ', #8,'L',' ','i',' ','m',' ','e',' ','L',' ',
    'i',' ','g',' ','h',' ','t',#24,#25,#29, #1,'',#25, #2, #5,'','',
    #25, #4, #1,'','',#24,#25, #3, #8,'T',' ','e',' ','c',' ','h',' ',
    'n',' ','o',' ','l',' ','o',' ','g',' ','i',' ','e',' ','s',' ', #5,
    '', #1,'','', #5,'', #1,'','','','',' ', #5,#26, #3,'', #1,
    '', #5,#26, #6,'',' ', #8,'T',' ','e',' ','c',' ','h',' ','n',' ',
    'o',' ','l',' ','o',' ','g',' ','i',' ','e',' ','s',#24,#25,#28, #1,
    '','','',' ', #5,'','',' ','','','','',' ', #1,'',#24,#25,
    #27,#26, #4,'', #5,'','','', #1,#26,#12,'',#24,#24,#24,#24,#24,
    #24,#24, #8,#26,'N','',#24,#25,#14,'N','o','w',' ','e','x','i','t',
    'i','n','g',' ', #7,'T','r','a','n','s','P','h','o','r',' ','2','0',
    '0','0',' ', #8,'c','o','n','f','i','g','u','r','a','t','i','o','n',
    ' ','p','r','o','g','r','a','m','.',#24,#26,'O','',#24,#24,#24,#24,
    #24,#24,#24,#24,#24);
  TYPE ScreenType = ARRAY [0..3999] OF BYTE;
  VAR ScreenAddr : ScreenType ABSOLUTE $B800:$0000;
  BEGIN
  UNCRUNCH(IMAGEDATA,ScreenAddr[ (1*2) + (2*160) -162],993);
  END;

END.
