Program Celerity_To_Vision_Convert;

{ Written by: The Elemental }
{ There's no stop'n US! }

Uses Gentypes,Configrt,Crt;

Type CELConfType=(lowerc,eightyc,linef,postp,morep,asciig,ansig,udsys,bulletinsys,
                  votingsys,emailsys,doorssys,mainsys,databasesys,NewUserSys,
                  gfsys,want,showt,vt522,fsedit);
     CELFListType=(ffname,ffext,fffulnam,ffofwhat,ffsize,ffpoints,ffuploader,
                   ffuploaded,ffdown,ffdescript);
     NuvSet = set of 1..255;

     CELURec = Record
       Handle,RealName,Note:MStr;
       Macro1,Macro2,Macro3:LStr;
       Password:Sstr;
       PhoneNum:String[12];
       Laston:Longint;
       Numon,TimeToday,Nup,Ndn,Nbu,Uploads,Downloads:Integer;
       TotalTime:Real;
       Voted:Array [1..5] of Byte;
       UdLevel,UdPoints,Level,EmailAnnounce,BeepedPwd:Integer;
       Infoforms:array [1..5] of Integer;
       RegularColor,PromptColor,StatColor,InputColor,FifthColor,SixthColor,
       SeventhColor,EighthColor,DisplayLen:Byte;
       LastMessages,LastUps,LastGfiles,LastDBases,Integer1:Integer;
       DownK,UpK:Longint;
       GFLevel,GfUploads,GFDownloads:Integer;
       MenuType,Byte1:Byte;
       DefProto,Char1:Char;
       Hack:Byte;
       Config:Set of CELConfType;
       NewScanConfig,Access1,Access2:Set of Byte;
       TimeinStorage:Word;
       LastRead:Array [0..20,1..5] of Word;
       ConfAccess:Array [0..5] of Boolean;
       LastCps,CpsTimes:Word;
       FileList:Set of CELFListType;
       CommPoints,ValPoints:Integer;
       ScanNet:Boolean;
       QuikConf:Array [1..5] of Boolean;
       UserPcr,UserUdr,Age:Byte;
       UserSex:Boolean;
       VoteYes,VoteNo,TimePerDay:Byte;
     End;

     visconfig=(lowercas,eightycol,linefeed,postprompt,moreprompt,
                asciigraphic,ansigraphic,udsyso,bulletinsyso,votingsyso,
                emailsyso,doorssysop,mainsyso,databasesyso,wante,
                showtim,vt5,fsedito);


     visrec=record
       handle,              (* Users Handle *)
       realname:mstr;       (* Users Real Name *)
       password:sstr;       (* Users Password *)
       phonenum:string[10]; (* Users Phone Number *)
       laston:longint;      (* Last Call date in DATEPACK form *)
       numon,               (* Total Calls *)
       timetoday,           (* Time left today *)
       nup,                 (* G-File Uploads *)
       ndn,                 (* G-File Downloads *)
       nbu,                 (* Messages posted *)
       uploads,             (* Uploads *)
       downloads:integer;   (* Downloads *)
       totaltime:real;      (* Total Time spent on system by user *)
       voted:voteset;       (* What the user voted on *)
       udlevel,             (* File Level *)
       udpoints,            (* File Points *)
       level,               (* Main Access Level *)
       emailannounce,       (* Sector for Email Announcement "-1" if none *)
       beepedpwd,           (* Reserved *)
       infoform,            (* Location for Infoform #1 *)
       glevel,              (* G-File Level *)
       gpoints:integer;     (* G-File Points *)
       regularcolor,        (* The following are the users colors. *)
       promptcolor,
       statcolor,
       inputcolor,
       displaylen,
       menuboard,
       menuback,
       blowboard,
       blowinside:byte;
       config:set of visconfig;   (* Various config stuff, i.e. Ansi, etc *)
       newscanconfig,              (* Various stuff dealing with message
                                      bases. Do not mess with these. *)
       access1,
       access2:set of byte;
       usernote,                   (* Account Note [Public] *)
       macro1,                     (* Predefined user macros *)
       macro2,
       macro3:mstr;
       upkay,                      (* Upload K *)
       dnkay:longint;              (* Download K *)
       lastbaud,                   (* Last baud rate used *)
       lastlevel,                  (* Last main access level *)
       lastxfer,                   (* Last File Level *)
       lastxferpts:integer;        (* Last File Points *)
       confset:conferenceset;      (* Array [1..32] of byte for the
                                      sub-conferences *)
       hackattempts:integer;       (* Password Hack Attempts *)
       revision:integer;           (* Last Revision Number *)
       lastposts,                  (* Last total messages in system *)
       lastfiles:word;             (* Last total files in system *)
       infoform2,                  (* Location of Infoforms 2-5 *)
       infoform3,
       infoform4,
       infoform5:integer;
       lastread:array [0..255] of word;        (* Message Stuff *)
       expdate:longint;             (* Expiration date in DATEPACK form *)
       timebank:integer;            (* Time stored in Time Bank *)
       lastcalno:word;              (* Last Caller Number *)
       udratio,                     (* Individual Upload/Download Ratio *)
       udkratio,                    (* Individual U/D K Ratio *)
       pcratio:integer;             (* Individual Post/Call Ratio *)
       avatar:byte;                 (* 0=Normal ansi, 1=Pull Down Windows,
                                       2=Avatar (not implemented yet) *)
       timelimits:integer;          (* Daily time limit (0 means normal) *)
       Conf:Array [1..5] of Boolean;   (* Main Conference Flags *)
       LastConf:Byte;                  (* Last Conference user was in *)
       SpecialSysopNote:Mstr;          (* Special Sysop Note *)
       MenuHighlight,statusboxcolor:Byte;
       LastGfiles:Word;
       prompttype:integer;
       NewVoteYes,NewVoteNo:integer;
       newvoteit:array [1..30] of integer;
       nuv1,nuv2,nuv3,nuv4,nuv5,nuv6,nuv7,nuv8,nuv9,nuv10:lstr;
       use1,use2,use3,use4,use5,use6,use7,use8:BooLean;
  end;



Procedure CelerityUserConvert;
Var UFile:File of CELURec;
    CEL:CELURec;
    VFile:File of UserRec;
    VIS:UserRec;
    Cnt,I:Integer;
Begin
  Writeln ('Converting: Celerity User List to Vision Format!');
  Assign (UFile,'USERS');       { Open And Rename Celerity Users File }
  Reset (UFile);
  If IOResult <> 0 Then Begin
    Writeln ('File: USERS not found.. Cannot continue!');
    Close (UFile);
    Exit
  End;
  Rename (UFile,'USERS.CEL');
  Assign (VFile,'USERS.');      { Open and Create Vision Users File }
  Rewrite (VFile);
  Seek (UFile,1);
  Seek (VFile,0);
  Cnt:=0;
  TextAttr:=11;
  VIS.Handle:='';
  While Not Eof(UFile) Do Begin
    Read (UFile,CEL);
    For I:=1 to Length(VIS.Handle) Do
     Write (#8#32#8);
    FillChar (VIS,SizeOf(VIS),0);
    If Length(CEL.Handle) > 0 Then Begin
      Cnt:=Cnt + 1;
      Write (VIS.Handle);
      VIS.Handle:=CEL.Handle;
      VIS.RealName:=CEL.RealName;
      VIS.UserNote:=CEL.Note;
      VIS.Macro1:=CEL.Macro1;
      VIS.Password:=CEL.Password;
      VIS.PhoneNum:=Copy(CEL.PhoneNum,1,3) + Copy(CEL.PhoneNum,5,3) +
                    Copy(CEL.PhoneNum,9,4);
      VIS.Level:=CEL.Level;
      VIS.Numon:=CEL.Numon;
      VIS.NBu:=CEL.NBu;
      VIS.UdLevel:=CEL.UdLevel;
      VIS.UdPoints:=CEL.UdPoints;
      VIS.Uploads:=CEL.Uploads;
      VIS.Downloads:=CEL.Downloads;
      VIS.RegularColor:=CEL.RegularColor;
      VIS.StatColor:=CEL.StatColor;
      VIS.InputColor:=CEL.InputColor;
      VIS.PromptColor:=CEL.PromptColor;
      VIS.MenuBoard:=CEL.FifthColor;
      VIS.MenuBack:=CEL.SixthColor;
      VIS.MenuHighLight:=CEL.SeventhColor;
      VIS.DisplayLen:=CEL.DisplayLen;
      VIS.BlowInside:=7;
      VIS.BlowBoard:=7;
      VIS.StatusBoxColor:=7;

      VIS.Config:=[LowerCase,LineFeeds,AnsiGraphics,AsciiGraphics,Fseditor,
                   EightyCols];
      Seek (VFile,Cnt - 1);
      Write (VFile,VIS);
    End;
  End;
  Writeln (Cnt,' Users Converted over to Vision!');
  If Cnt > 70 Then Writeln ('Ahh.. Busy Day!!');
  Close (UFile);
  Close (VFile);
End;

Procedure ViSiONUserConvert;
Var UFile:File of VisRec;
    OLD:VisRec;
    VFile:File of UserRec;
    VIS:UserRec;
    Wow,Cnt,I:Integer;
Begin
  Writeln ('Converting: ViSiON User List to Vision Format!');
  Assign (UFile,'USERS');       { Open And Rename Celerity Users File }
  Reset (UFile);
  If IOResult <> 0 Then Begin
    Writeln ('File: USERS not found.. Cannot continue!');
    Close (UFile);
    Exit;
  End;
  Rename (UFile,'USERS.VIS');
  Assign (VFile,'USERS.');      { Open and Create Vision Users File }
  Rewrite (VFile);
  Seek (UFile,0);
  Seek (VFile,0);
  Cnt:=0;
  TextAttr:=11;
  VIS.Handle:='';
  While Not Eof(UFile) Do Begin
    Read (UFile,OLD);
    For I:=1 to Length(VIS.Handle) Do
     Write (#8#32#8);
    FillChar (VIS,SizeOf(VIS),0);
      Cnt:=Cnt + 1;
      Gotoxy(1,12);
      Write('                                             ');
      Gotoxy(1,12);
      Write('Converting: '+OLD.HANDLE);
      Write (VIS.Handle);
      VIS.Handle:=OLD.Handle;
      VIS.RealName:=OLD.RealName;
      VIS.UserNote:=OLD.UserNote;
      VIS.Password:=OLD.Password;
      VIS.PhoneNum:=OLD.PhoneNum;
      VIS.Level:=OLD.Level;
      VIS.Numon:=OLD.Numon;
      VIS.NBu:=OLD.NBu;
      Vis.laston:=Old.laston;
      VIS.UdLevel:=OLD.UdLevel;
      VIS.UdPoints:=OLD.UdPoints;
      VIS.Uploads:=OLD.Uploads;
      VIS.Downloads:=OLD.Downloads;
      VIS.RegularColor:=OLD.RegularColor;
      VIS.StatColor:=OLD.StatColor;
      VIS.InputColor:=OLD.InputColor;
      VIS.PromptColor:=OLD.PromptColor;
      VIS.MenuBoard:=OLD.MenuBoard;
      VIS.MenuBack:=OLD.MenuBack;
      VIS.MenuHighLight:=OLD.MenuHighLight;
      VIS.DisplayLen:=OLD.DisplayLen;
      VIS.BlowInside:=OLD.BlowInside;
      VIS.BlowBoard:=OLD.BlowBoard;
      VIS.StatusBoxColor:=7;
      VIS.usernote:=old.usernote;
      VIS.macro1:=old.macro1;
      VIS.macro2:=old.macro2;
      VIS.macro3:=old.macro3;
      VIS.timetoday:=Old.Timetoday;
      VIS.upkay:=old.upkay;
      VIS.dnkay:=old.dnkay;
      VIS.lastbaud:=old.lastbaud;
      VIS.lastlevel:=old.lastlevel;
      VIS.lastxfer:=old.lastxfer;
      VIS.lastxferpts:=old.lastxferpts;
      VIS.confset:=old.confset;
      VIS.hackattempts:=old.hackattempts;
      VIS.revision:=old.revision;
      VIS.lastposts:=old.lastposts;
      VIS.lastfiles:=old.lastfiles;
      VIS.infoform2:=old.infoform2;
      VIS.infoform3:=old.infoform3;
      VIS.infoform4:=old.infoform4;
      VIS.infoform5:=old.infoform5;
(*      For Wow:=1 to 255 Do Begin
       VIS.lastread[wow]:=old.lastread[wow];
      End;
      For Wow:=1 to 32 Do Begin
       VIS.conf[wow]:=OLD.conf[wow];
      End; *)
      VIS.expdate:=old.expdate;
      VIS.timebank:=old.timebank;
      VIS.lastcalno:=old.lastcalno;
      VIS.udratio:=old.udratio;
      VIS.udkratio:=old.udkratio;
      VIS.pcratio:=old.pcratio;
      VIS.avatar:=old.avatar;
      VIS.timelimits:=old.timelimits;
(*      For Wow:=1 to 5 Do Begin
       VIS.Conf[wow]:=Old.conf[wow];
      End; *)
      VIS.LastConf:=old.lastconf;
      VIS.SpecialSysopNote:=Old.SpecialSysopNote;
      VIS.prompttype:=Old.prompttype;
      VIS.NewVoteYes:=Old.NewVoteYes;
      Vis.NewVoteNo:=old.NewVoteNo;
(*      For Wow:=1 to 30 Do Begin
       VIS.newvoteit[wow]:=Old.newvoteit[wow];
      End; *)
      VIS.nuv1:=Old.nuv1;
      Vis.nuv2:=Old.nuv2;
      Vis.nuv3:=Old.nuv3;
      Vis.nuv4:=Old.nuv4;
      Vis.nuv5:=Old.nuv5;
      vis.nuv6:=old.nuv6;
      vis.nuv7:=old.nuv7;
      Vis.nuv8:=Old.nuv8;
      vis.nuv9:=old.nuv9;
      vis.nuv10:=Old.nuv10;
      VIS.use1:=Old.use1;
      Vis.use2:=old.use2;
      vis.use3:=old.use3;
      vis.use4:=old.use4;
      vis.use5:=old.use5;
      vis.use6:=old.use6;
      vis.use7:=old.use7;
      vis.use8:=old.use8;
      VIS.yourprompt:='';
      Vis.msgheader:=3;
      VIS.Config:=[LowerCase,LineFeeds,AnsiGraphics,AsciiGraphics,Fseditor,
                   EightyCols];
      Write (VFile,VIS);
  End;
  WRiteLn;
  Writeln (Cnt,' Users Converted over to Vision!');
  If Cnt > 70 Then Writeln ('Ahh.. Busy Day!!');
  Close (UFile);
  Close (VFile);
End;

Var K:Char;
Begin
  ReadConfig;
  TextAttr:=7;
  ClrScr;
  TextAttr:=12;
  Write (#13#10#13#10'Celerity/old ViSiON to ');
  TextAttr:=13;
  Write ('ViSiON ');
  TextAttr:=12;
  Writeln ('User Converter!');
  TextAttr:=9;
  Writeln ('Written by: The Elemental - ViSiON Programming Staff Member');
  TextAttr:=10;
  Writeln ('(C)opyright 1991 Ruthless Enterprises!!');
  Writeln;
  TextAttr:=12;
  Repeat
   Write ('Continue with Conversion [y/N]? ');
   K:=Upcase(ReadKey);
  Until K in [#13,'Y','N'];
  TextAttr:=11;
  Repeat
   Write (#13#10'Convert Celerity or ViSiON [C/V]? ');
   K:=Upcase(ReadKey);
   textattr:=14;
  Until K in ['C','V'];
  If K = 'C' Then Begin
    CelerityUserConvert;
    WriteLn;
    Writeln ('Celerity Users List Saved as USERS.CEL');
  End Else
  If K = 'V' Then Begin
    ViSiONUserConvert;
    Writeln;
    Writeln ('ViSiON Old Users List Saved as USERS.VIS');
  End;
End.