{-------------------------------------------------------------------}
{ A simple program to illustrate how to plot pixels and draw lines  }
{ in the 320x200 256 color mode available on the VGA and MCGA cards }
{                                                                   }
{ Last update: 5/24/88 by John Sieraski 76117,2022                  }
{-------------------------------------------------------------------}

{$R-,S-}

uses
  Crt, Dos;

procedure PutPixel(X, Y : word; Color : byte);
{ Plot a pixel at (X, Y) in Color }
begin
  Mem[$A000:Y*320+X] := Color;
end;

procedure Switch(var First, Second : integer);
{ Exchange the values of First and second }
var
  Temp : integer;
begin
  Temp := First;
  First := Second;
  Second := Temp;
end; { Switch }

procedure Line(X1, Y1, X2, Y2, Color : integer);
{ Uses Bressenham's algorithm for drawing a line }
var
  LgDelta, ShDelta, LgStep, ShStep, Cycle, PointAddr : integer;

begin
  LgDelta := X2 - X1;
  ShDelta := Y2 - Y1;
  if LgDelta < 0 then
    begin
      LgDelta := -LgDelta;
      LgStep := -1;
    end
  else
    LgStep := 1;
  if ShDelta < 0 then
    begin
      ShDelta := -ShDelta;
      ShStep := -1;
    end
  else
    ShStep := 1;
  if LgDelta > ShDelta then
    begin
      Cycle := LgDelta shr 1; { LgDelta / 2 }
      while X1 <> X2 do
      begin
        Mem[$A000:Y1*320+X1] := Color; { PutPixel(X1, Y1, Color); }
        Inc(X1, LgStep);
        Inc(Cycle, ShDelta);
        if Cycle > LgDelta then
        begin
          Inc(Y1, ShStep);
          Dec(Cycle, LgDelta);
        end;
      end;
    end
  else
    begin
      Cycle := ShDelta shr 1; { ShDelta / 2 }
      Switch(LgDelta, ShDelta);
      Switch(LgStep, ShStep);
      while Y1 <> Y2 do
      begin
        Mem[$A000:Y1*320+X1] := Color; { PutPixel(X1, Y1, Color); }
        Inc(Y1, LgStep);
        Inc(Cycle, ShDelta);
        if Cycle > LgDelta then
        begin
          Inc(X1, ShStep);
          Dec(Cycle, LgDelta);
        end;
      end;
    end;
end; { Line }

procedure SetMode(Mode : byte);
{ Interrupt $10, sub-function 0 - Set video mode }
var
  Regs : Registers;
begin
  with Regs do
  begin
    AH := 0;
    AL := Mode;
  end;
  Intr($10, Regs);
end; { SetMode }

var
  Row   : integer;
  Color : byte;
  Ch    : char;
begin
  SetMode($13);  { 320x200 256 color mode for VGA and MCGA cards }
  Color := 0;
  for Row := 0 to 199 do           { Draw some lines }
  begin
    if Odd(Row) then
    begin
      Line(0, Row, 319, Row, Color);
      Inc(Color);
    end;
  end;
  Ch := ReadKey;
  TextMode(co80);
end.
