
unit Back;

interface

USES Dos, Crt, Graph;

procedure HighBackground(On: boolean);

implementation

PROCEDURE HighBackground(On: boolean);
  VAR
    OUTByte        : Byte;
    DisplayRegs    : Registers;
    ActiveDispDev,
    GraphMode      : Integer;
    CrtModeSet     : byte absolute $40:$65;

  BEGIN
    DetectGraph(ActiveDispDev,GraphMode);
    CASE ActiveDispDev OF
      CGA     :
                begin
                	if On then
                  begin
                  { enable intense background }
									  CrtModeSet := CrtModeSet Xor $20;
									  Port[$3D8] := CrtModeSet;
                  end
                  else
                  begin
									{ enable blink }
									  CrtModeSet := CrtModeSet Xor $20;
									  Port[$3D8] := CrtModeSet;
                  end;
                end;
      EGA..10 :
							Begin
							  With DisplayRegs Do
								Begin
								  AX := $1003;
							    BL := Ord(Not On);
							    Intr($10,DisplayRegs);
							  End;
							End;
    END;
  END;

{BEGIN
  HighBackground(true);
  TextBackground(1);
  ClrScr;
  TextAttr:=0+9*16;
  WriteLn('You now have high background colors.');
  K := readkey;
  HighBackground(false);
  ClrScr;
  Writeln('Yeah!');
  K := ReadKey;}
END.

