{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
{$M 50000,0,0}       { Declared here suffices for all Units as well! }
Program Install; {Cheezy install for impulse bbs}

uses crt,dos;

Type
  acrq    ='@'..'Z';              { AR flags }
  uflags =
   (rlogon,                       { L - Restricted to one call a day }
    rchat,                        { C - Can't page the SysOp }
    rvalidate,                    { V - Posts marked unvalidated }
    rbackspace,                   { B - Can't do ^B/^N/etc in messages }
    ramsg,                        { A - Can't change the AutoMessage }
    rpostan,                      { * - Can't post anonymously }
    rpost,                        { P - Can't post at all }
    remail,                       { E - Can't send any e-mail }
    rvoting,                      { K - Can't vote }
    rmsg,                         { M - Force e-mail deletion }
    spcsr,                        { }
    onekey,                       { onekey input mode }
    avatar,                       { user has AVATAR }
    pause,                        { pause }
    novice,                       { user is at novice help level }
    ansi,                         { user has ANSI }
    color,                        { user has color }
    alert,                        { alert SysOp when user logs on }
    smw,                          { short-message waiting for user }
    nomail,                       { user mail-box is closed }
    fnodlratio,                   { 1 - No UL/DL ratio }
    fnopostratio,                 { 2 - No post/call ratio }
    fnofilepts,                   { 3 - No file points checking }
    fnodeletion);                 { 4 - Protection from deletion }

  secrange= array[0..255] of integer; { security tables }

  zlogrec=                        { ZLOG.DAT : System log }
  record
    date:string[8];
    userbaud:array[0..4] of integer;
    active,calls,newusers,pubpost,privpost,fback,criterr:integer;
    uploads,downloads:integer;
    uk,dk:longint;
  end;

  filearcinforec=                 { Archive configuration records }
  record
    active:boolean;               { whether this archive format is active }
    ext:string[3];                { 3-chr file extension }
    listline,                     { /x for internal;
                                     x: 1=ZIP, 2=ARC/PAK, 3=ZOO, 4=LZH }
    arcline,                      { compression cmdline }
    unarcline,                    { de-compression cmdline }
    testline,                     { integrity test cmdline, '' for *None* }
    cmtline:string[25];           { comment cmdline, '' for *None* }
    succlevel:integer;            { success ERRORLEVEL, -1=ignore results }
  end;

  oldsysrec=
  record
    gfilepath:string[79];             { GFILES path }
    afilepath:string[79];             { AFILES path (text files path) }
    menupath:string[79];              { MENUS path  }
    trappath:string[79];              { LOG path (traps, chats, SysOp logs) }
    msgpath:string[79];               { MSG path (priv/pub mail path) }
    tfilepath:string[79];             { TFILES path }
    temppath:string[79];              { TEMP path - "temp" directory }
    usenuv:boolean;		      { Is new user voting active? }
    nuvyes,			      { Yes votes required for validation in NUV }
    nuvno:byte;			      { No votes required for validation in NUV }
    bbsname:string[80];               { BBS name }
    bbsphone:string[12];              { BBS phone number }
    sysopname:string[30];             { SysOp's full name or alias }
    regnum:string[10];                { BBS Registration Number }
    startdir:string[80];              { prompt for the Dos simulator }
    maxusers,                         { max number of users system can have }
    lowtime,                          { SysOp begin minute (in minutes) }
    hitime,                           { SysOp end time }
    dllowtime,                        { normal downloading hours begin.. }
    dlhitime:integer;                 { ..and end }
    pcbfile:boolean;                  { use RA/PCBoard type file listings }
    sb,                               { *REMOVED* Soundblaster chat toggle }
    dossim,                           { *REMOVED* Dos Simulation Logon }
    pulls,                            { *REMOVED* Pulldown Logon }
    shuttlelog,                       { is matrix logon active? }
    lock300:boolean;                  { lock out 300 baud? }
    sysoppw,                          { SysOp PW }
    newuserpw,                        { newuser PW (or NULL if none) }
    shuttlepw:string[20];             { Shuttle PW (if Shuttle active) }
    b300lowtime,                      { 300 baud calling hours begin.. }
    b300hitime,                       { ..and end }
    b300dllowtime,                    { 300 baud downloading hours begin.. }
    b300dlhitime:integer;             { ..and end }
    closedsystem:boolean;             { DON'T allow new users? }
    swapshell:boolean;                { is swap shell function enabled? }
    eventwarningtime:integer;         { time before event warning }
    tfiledate:string[8];              { last date text-files were inserted }
    lastmsgid:longint;                { last-used message ID (sequential) }

    sop,                              { SysOp }
    csop,                             { Co-SysOp }
    msop,                             { Message SysOp }
    fsop,                             { File SysOp }
    spw,                              { SysOp PW at logon }
    seepw,                            { see SysOp PWs remotely  }
    normpubpost,                      { make normal public posts }
    normprivpost,                     { send normal e-mail }
    anonpubread,                      { see who posted public anon }
    anonprivread,                     { see who sent anon e-mail }
    anonpubpost,                      { make anon posts }
    anonprivpost,                     { send anon e-mail }
    seeunval,                         { see unvalidated files }
    dlunval,                          { DL unvalidated files }
    nodlratio,                        { no UL/DL ratio }
    nopostratio,                      { no post/call ratio }
    nofilepts,                        { no file points checking }
    ulvalreq:string[20];              { uploads require validation by SysOp }

    maxprivpost,                      { max e-mail can send per call }
    maxfback,                         { max feedback per call }
    maxpubpost,                       { max posts per call }
    maxchat,                          { max chat-pages per call }
    maxwaiting,                       { max mail in mail-box }
    csmaxwaiting,                     { max mail in mail-box for Co-SysOp + }
    maxlogontries,                    { tries allowed for PW's at logon }
    bsdelay,                          { backspacing delay }
    maxlines,                         { max lines in message }
    csmaxlines,                       { max lines in message for Co-SysOp + }
    sysopcolor,                       { SysOp color in chat mode }
    usercolor:byte;                   { user color in chat mode }
    minspaceforpost,                  { minimum K drive space left to post }
    minspaceforupload:integer;        { minimum K drive space left to upload }
    backsysoplogs,                    { days to keep SYSOP##.LOG }
    wfcblanktime:byte;                { minutes after which to blank WFC menu }
    linelen,                          { default video line length }
    pagelen:byte;                     { default video page length }

    specialfx,                        { *REMOVED* WFC menu "special effects" }
    fossil,                           { make use of FOSSIL comm driver }
    allowalias,                       { allow alias's? (handles) }
    phonepw,                          { use phone number password in logon? }
    localsec,                         { is local security ON? }
    localscreensec,                   { is local screen-security ON? }
    globaltrap,                       { trap ALL USER'S activity? }
    autochatopen,                     { does chat buffer auto-open? }
    autominlogon,                     { Auto-Message in logon? }
    bullinlogon,                      { bulletins in logon? }
    lcallinlogon,                     { "Last Few Callers" list in logon? }
    yourinfoinlogon,                  { "Your Info" in logon? }
    multitask,                        { is BBS multitasking? }
    offhooklocallogon,                { take phone off-hook for local logons? }
    forcevoting,                      { is manditory logon voting active? }
    compressbases,                    { "compress" file/message base numbers? }
    searchdup:boolean;                { search for dup. filenames when UL? }
    slogtype:byte;                    { SysOp log type: File/Printer/Both }
    stripclog:boolean;                { strip colors from SysOp log output? }
    newapp,                           { user# to send new user application to }
    guestuser,                        { user# of guest user account }
    timeoutbell,                      { minutes before time-out bell }
    timeout:integer;                  { minutes before timeout (logoff) }
    usewfclogo:boolean;               { whether to use WFC menu logo }
    useems:boolean;                   { attempt to use EMS for overlay }
    usebios:boolean;                  { use ROM BIOS for local video output }
    cgasnow:boolean;                  { suppress snow on CGA systems }

    filearcinfo:array[1..8] of filearcinforec; { archive specs }
    filearccomment:array[1..3] of string[80]; { BBS comments for archives }
    ulcheckit,                        { Use Internal Upload Checker? }
    uldlratio,                        { are UL/DL ratios active? }
    fileptratio:boolean;              { is auto file-pt compensation active? }
    fileptcomp,                       { file point compensation ratio }
    fileptcompbasesize,               { file point "base compensation size" }
    ulrefund,                         { percent time refund for ULs }
    tosysopdir:byte;                  { "To SysOp" file base }
    validateallfiles:boolean;         { validate ALL FILES automatically? }
    remdevice:string[10];             { remote output device (GATEx,COMx,etc) }
    maxintemp,                        { max K allowed in TEMP\3\ }
    minresume:integer;                { min K to allow resume-later }
    maxdbatch,                        { max files in DL batch queue }
    maxubatch:byte;                   { max files in UL batch queue }

    newsl,                            { newuser SL }
    newdsl:byte;                      { newuser DSL }
    newar:set of acrq;                { newuser AR }
    newac:set of uflags;              { newuser AC }
    newfp:integer;                    { auto-validation file points }
    autosl,                           { auto-validation SL }
    autodsl:byte;                     { auto-validation DSL }
    autoar:set of acrq;               { auto-validation AR }
    autoac:set of uflags;             { auto-validation AC }

    allstartmenu:string[8];           { logon menu to start ALL users on }
    chatcfilter1,                     { SysOp chat color-filter }
    chatcfilter2:string[12];          { user chat color-filter }
    bulletprefix:string[8];           { default bulletins filename prefix }

    timeallow,                        { time allowance }
    callallow,                        { call allowance }
    dlratio,                          { # ULs/# DLs ratios }
    dlkratio,                         { DLk/ULk ratios }
    postratio:secrange;               { post/call ratios }

    lastdate:string[8];               { last system date }
    curwindow:byte;                   { type of SysOp window currently in use }
    istopwindow:boolean;              { is SysOp window on top of screen? }
    callernum:longint;                { total number of callers }
    numusers:integer;                 { number of users }

    todayzlog:zlogrec;                { TODAY's ZLOG record }

    postcredits:integer; {file points/upload credit compensation for posts}
    rebootforevent:boolean;           { reboot before events? }
    watchdogdoor:boolean;             { WatchDog active in doors? }

    windowon:boolean;

    swappath:string[79];              { swap shell path }
  end;


  systatrec=
  record
    gfilepath:string[79];             { GFILES path }
    afilepath:string[79];             { AFILES path (text files path) }
    menupath:string[79];              { MENUS path  }
    trappath:string[79];              { LOG path (traps, chats, SysOp logs) }
    msgpath:string[79];               { MSG path (priv/pub mail path) }
    tfilepath:string[79];             { TFILES path }
    temppath:string[79];              { TEMP path - "temp" directory }
    usenuv:boolean;		      { Is new user voting active? }
    nuvyes,			      { Yes votes required for validation in NUV }
    nuvno:byte;			      { No votes required for validation in NUV }
    bbsname:string[80];               { BBS name }
    bbsphone:string[12];              { BBS phone number }
    sysopname:string[30];             { SysOp's full name or alias }
    regnum:string[10];                { BBS Registration Number }
    startdir:string[80];              { prompt for the Dos simulator }
    maxusers,                         { max number of users system can have }
    lowtime,                          { SysOp begin minute (in minutes) }
    hitime,                           { SysOp end time }
    dllowtime,                        { normal downloading hours begin.. }
    dlhitime:integer;                 { ..and end }
    pcbfile:boolean;                  { use RA/PCBoard type file listings }
    shuttlelog,                       { is Shuttle Logon active? }
    lock300:boolean;                  { lock out 300 baud? }
    sysoppw,                          { SysOp PW }
    newuserpw,                        { newuser PW (or NULL if none) }
    shuttlepw:string[20];             { Shuttle PW (if Shuttle active) }
    b300lowtime,                      { 300 baud calling hours begin.. }
    b300hitime,                       { ..and end }
    b300dllowtime,                    { 300 baud downloading hours begin.. }
    b300dlhitime:integer;             { ..and end }
    closedsystem:boolean;             { DON'T allow new users? }
    swapshell:boolean;                { is swap shell function enabled? }
    eventwarningtime:integer;         { time before event warning }
    tfiledate:string[8];              { last date text-files were inserted }
    lastmsgid:longint;                { last-used message ID (sequential) }

    sop,                              { SysOp }
    csop,                             { Co-SysOp }
    msop,                             { Message SysOp }
    fsop,                             { File SysOp }
    spw,                              { SysOp PW at logon }
    seepw,                            { see SysOp PWs remotely  }
    normpubpost,                      { make normal public posts }
    normprivpost,                     { send normal e-mail }
    anonpubread,                      { see who posted public anon }
    anonprivread,                     { see who sent anon e-mail }
    anonpubpost,                      { make anon posts }
    anonprivpost,                     { send anon e-mail }
    seeunval,                         { see unvalidated files }
    dlunval,                          { DL unvalidated files }
    nodlratio,                        { no UL/DL ratio }
    nopostratio,                      { no post/call ratio }
    nofilepts,                        { no file points checking }
    ulvalreq:string[20];              { uploads require validation by SysOp }

    maxprivpost,                      { max e-mail can send per call }
    maxfback,                         { max feedback per call }
    maxpubpost,                       { max posts per call }
    maxchat,                          { max chat-pages per call }
    maxwaiting,                       { max mail in mail-box }
    csmaxwaiting,                     { max mail in mail-box for Co-SysOp + }
    maxlogontries,                    { tries allowed for PW's at logon }
    bsdelay,                          { backspacing delay }
    maxlines,                         { max lines in message }
    csmaxlines,                       { max lines in message for Co-SysOp + }
    sysopcolor,                       { SysOp color in chat mode }
    usercolor:byte;                   { user color in chat mode }
    minspaceforpost,                  { minimum K drive space left to post }
    minspaceforupload:integer;        { minimum K drive space left to upload }
    backsysoplogs,                    { days to keep SYSOP##.LOG }
    wfcblanktime:byte;                { minutes after which to blank WFC menu }
    linelen,                          { default video line length }
    pagelen:byte;                     { default video page length }

    specialfx,                        { WFC menu "special effects" }
    fossil,                           { make use of FOSSIL comm driver }
    allowalias,                       { allow alias's? (handles) }
    phonepw,                          { use phone number password in logon? }
    localsec,                         { is local security ON? }
    localscreensec,                   { is local screen-security ON? }
    globaltrap,                       { trap ALL USER'S activity? }
    autochatopen,                     { does chat buffer auto-open? }
    autominlogon,                     { Auto-Message in logon? }
    bullinlogon,                      { bulletins in logon? }
    lcallinlogon,                     { "Last Few Callers" list in logon? }
    yourinfoinlogon,                  { "Your Info" in logon? }
    multitask,                        { is BBS multitasking? }
    offhooklocallogon,                { take phone off-hook for local logons? }
    forcevoting,                      { is manditory logon voting active? }
    compressbases,                    { "compress" file/message base numbers? }
    searchdup:boolean;                { search for dup. filenames when UL? }
    slogtype:byte;                    { SysOp log type: File/Printer/Both }
    stripclog:boolean;                { strip colors from SysOp log output? }
    newapp,                           { user# to send new user application to }
    guestuser,                        { user# of guest user account }
    timeoutbell,                      { minutes before time-out bell }
    timeout:integer;                  { minutes before timeout (logoff) }
    usewfclogo:boolean;               { whether to use WFC menu logo }
    useems:boolean;                   { attempt to use EMS for overlay }
    usebios:boolean;                  { use ROM BIOS for local video output }
    cgasnow:boolean;                  { suppress snow on CGA systems }

    filearccomment:array[1..3] of string[80]; { BBS comments for archives }
    ulcheckit,                        { Use Internal Upload Checker? }
    uldlratio,                        { are UL/DL ratios active? }
    fileptratio:boolean;              { is auto file-pt compensation active? }
    fileptcomp,                       { file point compensation ratio }
    fileptcompbasesize,               { file point "base compensation size" }
    ulrefund,                         { percent time refund for ULs }
    tosysopdir:byte;                  { "To SysOp" file base }
    validateallfiles:boolean;         { validate ALL FILES automatically? }
    remdevice:string[10];             { remote output device (GATEx,COMx,etc) }
    maxintemp,                        { max K allowed in TEMP\3\ }
    minresume:integer;                { min K to allow resume-later }
    maxdbatch,                        { max files in DL batch queue }
    maxubatch:byte;                   { max files in UL batch queue }

    newsl,                            { newuser SL }
    newdsl:byte;                      { newuser DSL }
    newar:set of acrq;                { newuser AR }
    newac:set of uflags;              { newuser AC }
    newfp:integer;                    { newuser file points }
    autosl,                           { auto-validation SL }
    autodsl:byte;                     { auto-validation DSL }
    autoar:set of acrq;               { auto-validation AR }
    autoac:set of uflags;             { auto-validation AC }

    allstartmenu:string[8];           { logon menu to start ALL users on }
    bulletprefix:string[8];           { default bulletins filename prefix }

    timeallow,                        { time allowance }
    callallow,                        { call allowance }
    dlratio,                          { # ULs/# DLs ratios }
    dlkratio,                         { DLk/ULk ratios }
    postratio:secrange;               { post/call ratios }

    lastdate:string[8];               { last system date }
    curwindow:byte;                   { type of SysOp window currently in use }
    istopwindow:boolean;              { is SysOp window on top of screen? }
    callernum:longint;                { total number of callers }
    numusers:integer;                 { number of users }

    todayzlog:zlogrec;                { TODAY's ZLOG record }

    postcredits:integer; {file points/upload credit compensation for posts}
    rebootforevent:boolean;           { reboot before events? }
    watchdogdoor:boolean;             { WatchDog active in doors? }

    windowon:boolean;

    swappath:string[79];              { swap shell path }
  end;

procedure remake_status;
var status:file of systatrec;
    stat:systatrec;
    k,i:integer;
    path:array [1..8] of string;
    curdir:string;
begin
  getdir(0,curdir);
  path[1]:=curdir+'\DATA\';
  path[2]:=curdir+'\MSGS\';
  path[3]:=curdir+'\MENUS\';
  path[4]:=curdir+'\TEXT\';
  path[5]:=curdir+'\ANSI\';
  path[6]:=curdir+'\TRAP\';
  path[7]:=curdir+'\TEMP\';
  path[8]:=curdir+'\SWAP\';
  with stat do begin
    gfilepath:=path[1];
    msgpath:=path[2];
    menupath:=path[3];
    tfilepath:=path[4];
    afilepath:=path[5];
    trappath:=path[6];
    temppath:=path[7];
    swappath:=path[8];
    bbsname:='UnReg''d Sysop';
    bbsphone:='214-555-5555';
    sysopname:='Sysop';
    maxusers:=9999;
    lowtime:=0; hitime:=0;
    dllowtime:=0; dlhitime:=0;
    shuttlelog:=false;
    nuvyes:=7;
    nuvno:=5;
    regnum:=' ';
    pcbfile:=true;
    lock300:=FALSE;
    sysoppw:='SYSOP';
    newuserpw:='';
    shuttlepw:='IMPULSE';
    b300lowtime:=0; b300hitime:=0;
    b300dllowtime:=0; b300dlhitime:=0;
    closedsystem:=FALSE;
    swapshell:=true;
    eventwarningtime:=60;
    tfiledate:='04/12/95';

    sop:='s255';
    csop:='s250';
    msop:='s199';
    fsop:='s230';
    spw:='s250';
    seepw:='s255';
    normpubpost:='s11';
    normprivpost:='s11';
    anonpubread:='s100';
    anonprivread:='s100';
    anonpubpost:='s100';
    anonprivpost:='s100';
    seeunval:='s50';
    dlunval:='s230';
    nodlratio:='s255';
    nopostratio:='s200';
    nofilepts:='s255';
    ulvalreq:='s21';

    maxprivpost:=20;
    maxfback:=5;
    maxpubpost:=20;
    maxchat:=3;
    maxwaiting:=15;
    csmaxwaiting:=50;
    maxlines:=255;
    csmaxlines:=255;
    maxlogontries:=4;
    bsdelay:=20;
    sysopcolor:=4;
    usercolor:=3;
    minspaceforpost:=10;
    minspaceforupload:=100;
    backsysoplogs:=7;
    wfcblanktime:=0;
    linelen:=80;
    pagelen:=25;

    specialfx:=TRUE;
    fossil:=true;
    allowalias:=TRUE;
    phonepw:=false;
    localsec:=FALSE;
    localscreensec:=FALSE;
    globaltrap:=FALSE;
    autochatopen:=false;
    autominlogon:=TRUE;
    bullinlogon:=false;
    lcallinlogon:=false;
    yourinfoinlogon:=TRUE;
    multitask:=FALSE;
    offhooklocallogon:=TRUE;
    forcevoting:=FALSE;
    compressbases:=FALSE;
    searchdup:=FALSE;
    slogtype:=0;
    stripclog:=FALSE;
    newapp:=1;
    guestuser:=-1;
    timeoutbell:=2;
    timeout:=5;
    usewfclogo:=TRUE;
    useems:=FALSE;
    usebios:=TRUE;
    cgasnow:=FALSE;

    filearccomment[1]:='';
    filearccomment[2]:='';
    filearccomment[3]:='';
    ulcheckit:=true;
    uldlratio:=TRUE;
    fileptratio:=FALSE;
    fileptcomp:=3;
    fileptcompbasesize:=10;
    ulrefund:=100;
    tosysopdir:=0;
    validateallfiles:=FALSE;
    remdevice:='COM1';
    maxintemp:=500;
    minresume:=100;
    maxdbatch:=20;
    maxubatch:=20;

    newsl:=20;
    newdsl:=20;
    newar:=[];
    newac:=[rpostan,rvoting];
    newfp:=0;
    autosl:=50;
    autodsl:=50;
    autoar:=[];
    autoac:=[];

    allstartmenu:='MAIN';
    bulletprefix:='BULLET';

    for i:=0 to 255 do begin
      case i of 0..9:k:=1; 10..19:k:=10; 20..29:k:=20; 30..39:k:=40;
                40..49:k:=50; 50..59:k:=80; 60..69:k:=90; 70..79:k:=100;
                80..89:k:=110; 90..99:k:=120; 100..199:k:=130;
                200..239:k:=150; 240..249:k:=200; 250:k:=250;
                251..255:k:=6000; end; timeallow[i]:=k;
      case i of 200..255:k:=20; 100..199:k:=15; 50..99:k:=10;
                30..49:k:=5; 20..29:k:=3; else k:=1; end; callallow[i]:=k;
      case i of 60..255:k:=5; 20..59:k:=3; else k:=2; end; dlratio[i]:=k;
      case i of 60..255:k:=10; 20..59:k:=5; else k:=2; end; dlkratio[i]:=k;
      postratio[i]:=100;
    end;

    lastdate:='04/12/95';
    curwindow:=1;
    istopwindow:=FALSE;
    callernum:=0;
    numusers:=1;

    with todayzlog do begin
      for i:=0 to 4 do userbaud[i]:=0;
      active:=0; calls:=0; newusers:=0; pubpost:=0;
      privpost:=0; fback:=0; criterr:=0;
      uploads:=0; downloads:=0;
      uk:=0; dk:=0;
    end;

    postcredits:=0;
    rebootforevent:=FALSE;
    watchdogdoor:=FALSE;

    windowon:=false;
  end;
  assign(status,'status.dat');
  rewrite(status); write(status,stat); close(status);
end;

procedure fix_swap;
var status:file of systatrec;
    stat:systatrec;
    i:integer;
begin
 assign(status,'status.dat');
 reset(status);
 read(status,stat);
 stat.swappath:='C:\IMP\SWAP';
 write(status,stat);
 close(status);
end;


procedure update_status;
var status:file of systatrec;
    stat:systatrec;
    oldstat:file of oldsysrec;
    old:oldsysrec;
    i:integer;
begin
  assign(oldstat,'STATUS.DAT');
  reset(oldstat);
  read(oldstat,old);
  rename(oldstat,'STATUS.OLD');
  writeln('Renamed STATUS.DAT to STATUS.OLD');
  with stat do begin
    gfilepath:=old.gfilepath;
    msgpath:=old.msgpath;
    menupath:=old.menupath;
    tfilepath:=old.tfilepath;
    afilepath:=old.afilepath;
    trappath:=old.trappath;
    temppath:=old.temppath;
    swappath:=old.swappath;
    bbsname:=old.bbsname;
    bbsphone:=old.bbsphone;
    sysopname:=old.sysopname;
    maxusers:=9999;
    lowtime:=old.lowtime; hitime:=old.hitime;
    dllowtime:=old.dllowtime; dlhitime:=old.dlhitime;
    shuttlelog:=old.shuttlelog;
    nuvyes:=old.nuvyes;
    nuvno:=old.nuvno;
    regnum:=old.regnum;
    pcbfile:=old.pcbfile;
    lock300:=old.lock300;
    sysoppw:=old.sysoppw;
    newuserpw:=old.newuserpw;
    shuttlepw:=old.shuttlepw;
    b300lowtime:=old.b300lowtime; b300hitime:=old.b300hitime;
    b300dllowtime:=old.b300dllowtime; b300dlhitime:=old.b300dlhitime;
    closedsystem:=old.closedsystem;
    swapshell:=old.swapshell;
    eventwarningtime:=old.eventwarningtime;
    tfiledate:=old.tfiledate;

    sop:=old.sop;
    csop:=old.csop;
    msop:=old.msop;
    fsop:=old.fsop;
    spw:=old.spw;
    seepw:=old.seepw;
    normpubpost:=old.normpubpost;
    normprivpost:=old.normprivpost;
    anonpubread:=old.anonpubread;
    anonprivread:=old.anonprivread;
    anonpubpost:=old.anonpubpost;
    anonprivpost:=old.anonprivpost;
    seeunval:=old.seeunval;
    dlunval:=old.dlunval;
    nodlratio:=old.nodlratio;
    nopostratio:=old.nopostratio;
    nofilepts:=old.nofilepts;
    ulvalreq:=old.ulvalreq;

    maxprivpost:=old.maxprivpost;
    maxfback:=old.maxfback;
    maxpubpost:=old.maxpubpost;
    maxchat:=old.maxchat;
    maxwaiting:=old.maxwaiting;
    csmaxwaiting:=old.csmaxwaiting;
    maxlines:=old.maxlines;
    csmaxlines:=old.csmaxlines;
    maxlogontries:=old.maxlogontries;
    bsdelay:=old.bsdelay;
    sysopcolor:=old.sysopcolor;
    usercolor:=old.usercolor;
    minspaceforpost:=old.minspaceforpost;
    minspaceforupload:=old.minspaceforupload;
    backsysoplogs:=old.backsysoplogs;
    wfcblanktime:=old.wfcblanktime;
    linelen:=old.linelen;
    pagelen:=old.pagelen;

    specialfx:=old.specialfx;
    fossil:=old.fossil;
    allowalias:=old.allowalias;
    phonepw:=old.phonepw;
    localsec:=old.localsec;
    localscreensec:=old.localscreensec;
    globaltrap:=old.globaltrap;
    autochatopen:=old.autochatopen;
    autominlogon:=old.autominlogon;
    bullinlogon:=old.bullinlogon;
    lcallinlogon:=old.lcallinlogon;
    yourinfoinlogon:=old.yourinfoinlogon;
    multitask:=old.multitask;
    offhooklocallogon:=old.offhooklocallogon;
    forcevoting:=old.forcevoting;
    compressbases:=old.compressbases;
    searchdup:=old.searchdup;
    slogtype:=old.slogtype;
    stripclog:=old.stripclog;
    newapp:=old.newapp;
    guestuser:=old.guestuser;
    timeoutbell:=old.timeoutbell;
    timeout:=old.timeout;
    usewfclogo:=old.usewfclogo;
    useems:=old.useems;
    usebios:=old.usebios;
    cgasnow:=old.cgasnow;

    filearccomment[1]:=old.filearccomment[1];
    filearccomment[2]:=old.filearccomment[2];
    filearccomment[3]:=old.filearccomment[3];
    ulcheckit:=old.ulcheckit;
    uldlratio:=old.uldlratio;
    fileptratio:=old.fileptratio;
    fileptcomp:=old.fileptcomp;
    fileptcompbasesize:=old.fileptcompbasesize;
    ulrefund:=old.ulrefund;
    tosysopdir:=old.tosysopdir;
    validateallfiles:=old.validateallfiles;
    remdevice:=old.remdevice;
    maxintemp:=old.maxintemp;
    minresume:=old.minresume;
    maxdbatch:=old.maxdbatch;
    maxubatch:=old.maxubatch;

    newsl:=old.newsl;
    newdsl:=old.newdsl;
    newar:=old.newar;
    newac:=old.newac;
    newfp:=old.newfp;
    autosl:=old.autosl;
    autodsl:=old.autodsl;
    autoar:=old.autoar;
    autoac:=old.autoac;

    allstartmenu:=old.allstartmenu;
    bulletprefix:=old.bulletprefix;

    for i:=0 to 255 do begin
      timeallow[i]:=old.timeallow[i];
      callallow[i]:=old.callallow[i];
      dlratio[i]:=old.dlratio[i];
      dlkratio[i]:=old.dlratio[i];
      postratio[i]:=old.dlratio[i];
    end;

    lastdate:=old.lastdate;
    curwindow:=old.curwindow;
    istopwindow:=old.istopwindow;
    callernum:=old.callernum;
    numusers:=old.numusers;

    postcredits:=old.postcredits;
    rebootforevent:=old.rebootforevent;
    watchdogdoor:=old.watchdogdoor;
    windowon:=old.windowon;
  end;

  assign(status,'status.dat');
  rewrite(status);
  write(status,stat);
  close(oldstat);  close(status);
end;

var c:char;
    rs:string[60];
    tmp:string;
    typ:integer;
begin
{$I-}
clrscr;
typ:=0;
writeln('Impulse v4 Quick-Install');
writeln;
writeln('1. Full Installation');
writeln('2. Upgrade from v3.5');
writeln('3. Quit');
writeln;
write('Choice: '); c:=readkey;
repeat until (c in ['1','2','3']);
case c of
'1':begin
      typ:=1;
      gotoxy(1,24);
      writeln('Enter full path to your Desired Impulse Directory (ie. C:\IMP');
      write('Path: '); readln(rs); clrscr;
      mkdir(rs);
      writeln(' Installing v4 Full');
      exec(getenv('COMSPEC'),'/C pkunzip -d -o imp-bbs.dat '+rs);
      chdir(rs);
      remake_status;
    end;
'2':begin
      typ:=2;
      gotoxy(1,24);
      tmp:='imp.exe imp.ovr config.ext impulse.doc';
      writeln('Enter full path to your MAIN Impulse Directory (ie. C:\IMP');
      write('Path: '); readln(rs); clrscr;
      writeln(' Upgrading from v3.5');
      exec(getenv('COMSPEC'),'/C pkunzip imp-bbs.dat '+tmp+' '+rs);
      tmp:='data/strfix.exe';
      exec(getenv('COMSPEC'),'/C pkunzip imp-bbs.dat '+tmp+' '+rs+'\data');
      chdir(rs+'\data');
      exec(getenv('COMSPEC'),'/C strfix.exe');
      chdir(rs);
      update_status;
    end;
'3':begin
      typ:=3;
      writeln;
      writeln('Program Terminated');
      halt(255);
    end;
end;
writeln;
if (typ=1) then writeln('Installation Completed.  Type IMP.EXE to run.')
  else
if (typ=2) then writeln('Upgrade Completed.  Read IMPULSE.DOC for new stuff.');
writeln;
end.