Unit Modem;
{$F+}
Interface


Var SendChar    : Procedure (K:Char);
    SendModemStr: Procedure (Str:String; Display:Boolean);
    SendString  : Procedure (Str:String);
    GetChar     : Function : Char;
    Carrier     : Function : Boolean;
    NumChars    : Function : Boolean;
    ClosePort   : Procedure;
    Ring        : Function : Boolean;
    HangUp      : Procedure;
    DoAnswer    : Procedure;
    DontAnswer  : Procedure;
    NukeInput   : Procedure;
    NukeOutput  : Procedure;
    SetParam    : Procedure (Shit:Longint);
    Comport     : Word;

Function InstallFossil : Boolean;
Procedure Null_Modem;

Implementation

uses crt;

Procedure ComSendString (S : String);
Var Len : Integer;
    SegS,
    OffS: Word;
Begin
    Len := Length(S);
    SegS:= Seg(S);
    OffS:= Ofs(S)+1;
    Asm
      mov ah,19h
      mov dx,comport
      mov cx,len
      mov es,SegS
      mov di,OffS
      int 14h
    End;
End;

Function CarrierDetected : Boolean; Assembler;
asm
  mov ah,03h
  mov dx,comport
  int 14h
  AND AL, $80
  cmp AL, $80
  JE @1
  mov AL, FALSE
  jmp @2
@1:
  mov AL, TRUE
@2:
end;

Function CharWaiting : Boolean; Assembler;
asm
  mov ah,03h
  mov dx,comport
  int 14h
  AND AH, 1
  CMP AH, 1
  JE @1
  Mov AL, FALSE
  JMP @2
@1:
  MOV AL, TRUE
@2:
end;


Procedure Extended_Baud;
Var BaudHigh : Boolean;
begin
  BaudHigh:==576;
  asm
    MOV AH, 1Bh
    INT 14h
    CMP CX, '0X'
    JNE @EXIT
    MOV AH, 1Eh
    MOV BX, 0000h
    MOV CH, 03h
    MOV DX, COMPORT
    CMP BaudHigh, True
    JE @1
    MOV CL, 84h
    JMP @INT
  @1:
    MOV CL, 82h
  @INT:
    INT 14h
  @EXIT:
  end;
end;



Procedure ComSetParam (Shit:Longint); { ThisNode.BaudRate }
Var Baud : Byte;
Begin
  {BaudRate := Shit;}
  Case Shit of
    12:  Baud := $83;
    24:  Baud := $a3;
    48:  Baud := $c3;
    96:  Baud := $e3;
    192: Baud := $03;
    384: Baud := $23;
    576,
    1152:Begin
           Extended_Baud;
           Exit;
         End;
  end;
  Asm
    mov ah,00h
    mov al,baud
    mov dx,ComPort
    int 14h
  End;
End;

Function InstallFossil : Boolean; Assembler;
Asm
    mov ah,04h
    mov dx,comport
    int 14h
    cmp ax, $1954
    je @1
    mov al, false
    jmp @2
@1:
    mov al, true
@2:
end;

Procedure ComWriteChar(Cha : Char); Assembler;
Asm
  mov ah,01h
  mov al,Cha
  mov dx,comport
  int 14h
End;

Function ComReadChar : Char; Assembler;
Asm
  mov ah,02h
  mov dx,comport
  int 14h
End;

Procedure DeActivatePort; Assembler;
Asm
  mov ax,05h
  mov dx,comport
  int 14h
End;

Procedure FDontAnswer; Assembler;
Asm
  mov ah,06h
  mov al,$00
  mov dx,comport
  int 14h
End;

Procedure FDoAnswer; Assembler;
Asm
  mov ah,06h
  mov al,$01
  mov dx,comport
  int 14h
End;

Function ModemRinging : Boolean; Assembler;
Asm
    mov ah,03h
    mov dx,comport
    int 14h
    cmp al, 120
    je @1
    mov al, false
    jmp @2
@1:
    mov al, true
@2:
End;

Procedure DoHangup;
Begin
  If Not CarrierDetected Then Exit;
  FDontAnswer;
  Delay (700);
  FDoAnswer;
  If CarrierDetected Then ComSendString('+++')
End;

Procedure ClearOutBuffer; Assembler;
Asm
  mov ah,09h
  mov dx,comport
  int 14h
End;

Procedure ClearInBuffer; Assembler;
Asm
  mov ah,0ah
  mov dx,comport
  int 14h
End;

Procedure ComSendModemStr (Str:String; Display:Boolean);
Var X : Byte;
Begin
  For X:=1 to Length(Str) do begin
    Case Str[X] of
      '|' : ComWriteChar(#13);
      '~' : Delay (300);
     else   ComWriteChar(Str[x])
    End;
  Delay(50);
  If Display then While CharWaiting do Write(ComReadChar);
  end;
  For X:=1 to 255 do If Display and CharWaiting then Write(ComReadChar);
End;

Procedure Null_Proc;
Begin
End;

Function Null_NumChars : Word;
Begin
  Null_NumChars := 0;
End;

Function Null_Boolean_Func : Boolean;
Begin
  Null_Boolean_Func := False;
End;

Function Null_Char_Func : Char;
Begin
End;

Procedure Null_SendChar (K : Char);
Begin
End;

Procedure Null_SetParam (Shit:LongInt);
Begin
End;

Procedure Null_SendString (Str : String);
Begin
End;

Procedure Null_SendModemStr (Str:String; Display:Boolean);
Begin
End;

Procedure Null_Modem;
Begin
  GetChar    := Null_Char_Func;
  SendChar   := Null_SendChar;
  SendString := Null_SendString;
  Carrier    := Null_Boolean_Func;
  NumChars   := Null_Boolean_Func;
  ClosePort  := Null_Proc;
  Ring       := Null_Boolean_Func;
  HangUp     := Null_Proc;
  DoAnswer   := Null_Proc;
  DontAnswer := Null_Proc;
  NukeInput  := Null_Proc;
  NukeOutput := Null_Proc;
  SetParam   := Null_SetParam;
SendModemStr := Null_SendModemStr;
End;

Begin
    Comport    := 2;
    GetChar    := ComReadChar;
    SendChar   := ComWriteChar;
    Carrier    := CarrierDetected;
    NumChars   := CharWaiting;
    ClosePort  := DeActivatePort;
    Ring       := ModemRinging;
    HangUp     := DoHangup;
    DoAnswer   := FDoAnswer;
    DontAnswer := FDontAnswer;
    NukeInput  := ClearInBuffer;
    NukeOutput := ClearOutBuffer;
    SetParam   := ComSetParam;
    SendString := ComSendString;
  SendModemStr := ComSendModemStr;
End.
