{$O+}
unit TheUnit;

interface

uses Crt;

procedure Pause;
function StringOf(n: byte; k:char): string;
function UpCaseStr(stri: string): string;
function MixCaseStr(stri: string): string;
function LTrim(stri: string): string;
function RTrim(stri: string): string;
function Trim(stri: string): string;
function ToInt(S: string): integer;
function ToStr(I: longint): string;
function Arrange(s: string; len: byte): string;
function ToDir(s: string): string;

implementation

procedure Pause;
	var
  	key: char;
  begin
  	key := ReadKey;
    if key = #0 then
    	key := ReadKey;
  end;

function StringOf(n: byte; k: char): string;
	var
  	cou: byte;
    temp: string;
  begin
    temp := '';
    if n > 0 then
  	for cou := 1 to n do
    	temp := temp + k;
    StringOf := temp;
  end;

function LoCase(ch: char): char;
	begin
  	if ch in ['A'..'Z'] then ch := Chr(Ord(ch)+32);
    LoCase := ch;
  end;

function UpCaseStr(stri: string): string;
	var
  	i: integer;
	begin
    if Length(stri) > 0 then
	  	for i := 1 to Length(stri) do
  	  	stri[i] := UpCase(stri[i]);
    UpCaseStr := stri;
	end;

function MixCaseStr(stri: string): string;
	var
  	ctr: byte;
    up: boolean;
	begin
    up := true;
  	if Length(stri) > 0 then
      for ctr := 1 to Length(stri) do
      begin
        if up then stri[ctr] := UpCase(stri[ctr])
        else stri[ctr] := LoCase(stri[ctr]);
       	up := stri[ctr] in [' ', '/', '-', '(', ')', '[', ']', '&', '.'];
      end;
    MixCaseStr := stri;
  end;

function LTrim(stri: string): string;
	begin
  	while (stri[1] = ' ') and (Length(stri) > 0) do
    	stri := Copy(stri, 2, 255);
    LTrim := stri;
  end;

function RTrim(stri: string): string;
  var
  	ok: boolean;
	begin
  	ok := false;
    if Length(stri) > 0 then
    begin
	    repeat
  	  	if stri[Length(stri)] = ' ' then
    	  	stri := Copy(stri, 1, Length(stri)-1)
      	else
      		ok := true;
	    until ok;
    end;
    RTrim := stri;
  end;

function Trim(stri: string): string;
  begin
  	while stri[1] = ' ' do
    	stri := Copy(stri, 2, Length(stri));
    if Pos(' ', stri) > 0 then
    	stri := Copy(stri, 1, Pos(' ', stri)-1);
  	Trim := stri;
  end;

function ToInt(S: string): integer;
	var
  	I, Code: integer;
  begin
  	Val(S, I, Code);
    if Code <> 0 then
    	ToInt := -1
    else
    	ToInt := I;
  end;

function ToStr(I: longint): string;
	var
  	Strin: string;
  begin
  	Str(I, Strin);
    ToStr := Strin;
  end;

function Arrange(s: string; len: byte): string;
	begin
  	if Length(s) > len then Arrange := Copy(s, 1, len)
    else Arrange := s + StringOf(len-Length(s), ' ');
  end;

function ToDir(s: string): string;
	begin
  	if s = '' then s := '.';
    if s[Length(s)] <> '\' then s := s + '\';
    ToDir := UpCaseStr(s);
  end;

end.
