#ifndef IMP_REC
#define IMP_REC
/* Version 4.5 Developmental Kit - C version.
Ŀ
                             
                           
                                                                             
 Description: Impulse Record types and variables.  Needed for reading data   
              files crucial to the bbs.                                      
       Notes: All variables marked with "*REMOVED*" are no longer in use and 
              will be removed to save space in future versions.              

*/

#define Version "4.5";
#define maxboards 254;      /* 1 - x */
#define maxconfs 20;
#define maxuboards 143;     /* 0 - x */
#define maxprotocols 10;    /* 0 - x */
#define maxevents 10;       /* 0 - x  { #0 is Nightly Events (if active) } */
#define maxubatchfiles 20;
#define numvoteqs 10;
#define numvoteas 9;
#define maxmenucmds 50;
#define FALSE 0;
#define TRUE 1;

typedef unsigned char byte;
typedef unsigned char boolean;
typedef unsigned int bit;
typedef unsigned int word;

typedef char astr[161];
typedef char acstring[21];       /* Access Condition String */
typedef byte acrq[4];            /* AR flags */
 
typedef struct {

    bit rlogon       : 1;                /* L - Restricted to one call a day */
    bit rchat        : 1;                /* C - Can't page the SysOp */
    bit rvalidate    : 1;                /* V - Posts marked unvalidated */
    bit rbackspace   : 1;                /* B - Can't do ^B/^N/etc in messages */
    bit ramsg        : 1;                /* A - Can't change the AutoMessage */
    bit rpostan      : 1;                /* * - Can't post anonymously */
    bit rpost        : 1;                /* P - Can't post at all */
    bit remail       : 1;                /* E - Can't send any e-mail */
    bit rvoting      : 1;                /* K - Can't vote */
    bit rmsg         : 1;                /* M - Force e-mail deletion */
    bit spcsr        : 1;                /* */
    bit onekey       : 1;                /* onekey input mode */
    bit avatar       : 1;                /* user has AVATAR */
    bit pause        : 1;                /* pause */
    bit novice       : 1;                /* user is at novice help level */
    bit ansi         : 1;                /* user has ANSI */
    bit color        : 1;                /* user has color */
    bit alert        : 1;                /* alert SysOp when user logs on */
    bit smw          : 1;                /* short-message waiting for user */
    bit nomail       : 1;                /* user mail-box is closed */
    bit fnodlratio   : 1;                /* 1 - No UL/DL ratio */
    bit fnopostratio : 1;                /* 2 - No post/call ratio */
    bit fnofilepts   : 1;                /* 3 - No file points checking */
    bit fnodeletion  : 1;                /* 4 - Protection from deletion */
 
    } uflags;

typedef struct {

    bit fname        : 1;              /* filename */
    bit fsize        : 1;              /* file size */
    bit fpts         : 1;              /* file points */
    bit fdesc        : 1;              /* file desc. */
    bit extdesc      : 1;              /* extended desc. */
    bit whoul        : 1;              /* who uploaded it */
    bit dateul       : 1;              /* date uploaded */
    bit numdl        : 1;              /* num of d/l's. */

    } flistflags;

typedef struct {
    bit atno          : 1;             /* No anonymous posts allowed */
    bit atyes         : 1;             /* Anonymous posts are allowed */
    bit atforced      : 1;             /* ALL posts are forced anonymous */
    bit atdearabby    : 1;             /* "Dear Abby" message base */
    bit atanyname     : 1;             /* User's can post as ANY name they want */

    } anontyp;
                 
typedef byte clrs[2][10];        /* color records */
typedef int secrange[256];       /* security tables */
typedef byte cpackdatetime[6];
typedef byte mzscanr[32];
typedef byte fzscanr[18];
typedef cpackdatetime mhireadr[254];      
typedef byte dlnscan[13];

/* CONF.DAT */
typedef struct { 
            char ACSLevel[6][20];       /* SL level required. */ 
            char ConfName[21][20];      /* Name of Conference */
        } ConfRec;
        
typedef struct {
            int unum;                   /* User number being voted on */
            astr handler;               /* Handle of user being voted on */
            int no;                     /* No votes */
            int yes;                    /* Yes votes */
            int totvoted;               /* # of users voted on him already */
            int votedby[255];           /* #'s of users that have voted on him, so they can't vote more than once */
            byte exists;                /* Still exists to be voted upon? */
            long commentptr;            /* Pointer to comments in comment file */
            byte res[10];               /* RESERVED */
        } nuvrec;

typedef struct {
       char user[41];              /* User that left comment */
       astr comm;                  /* Actual comment */
       long nextcomment;           /* Pointer to next comment */
       byte exists;                /* Does comment actually exist */
       byte res[50];               /* RESERVED */

        } nuvcomrec; 

typedef struct {
    char desc[41];            /* Short node description (Subscriber line, 2400 line, HST line, etc) */
    acstring acs;             /* ACS required to log in to that node */
    byte status;              /* What the node is doing at the moment */
    char username[41];        /* User that is on right now */
    int usernum;              /* User # that is on right now */
    byte res[10];             /* RESERVED */

    } noderec;

typedef struct {
    char mess[81];           /* Message that is going to that node */
    boolean deleted;         /* It is deleted? */
    byte nodeto;             /* Which node is it going to? */
    byte nodefrom;           /* Which node is it from? */
    char namefrom[41];       /* Username that it is from */
    int numfrom;             /* User number that it is from */
    byte res[10];            /* RESERVED */
    
    } nodemessrec;


typedef struct {
    char user[81];               /* Name of user in that slot */
    boolean deleted;             /* Is the slot record deleted? */
    byte node;                   /* Node that they are on */
  } forumrec;

typedef struct {                   /* NAMES.LST : Sorted names listing */
    char name[37];                 /* user name */
    boolean deleted;               /* user is deleted */
    int number;                    /* user number */
  } smalrec;

typedef struct {                   /* USER.LST : User account records */
    char name[37];                 /* user name        */
    char realname[37];             /* real name        */
    char pw[21];                   /* user password    */
    char ph[13];                   /* user phone #     */
    char bday[9];                  /* user birthdate   */
    char firston[9];               /* firston date     */
    byte x1xs[2];
    char laston[9];                /* laston date      */
    byte x2xs[2];
    char street[31];               /* mailing address  */
    char citystate[31];            /* city, state      */
    char zipcode[11];              /* zipcode          */
    char computer[31];             /* type of computer */
    char occupation[41];           /* (borrowed variable) autosig */
    char wherebbs[41];             /* BBS reference    */
    char note[40];                 /* SysOp note       */
    int  prompt;                   /* Chosen Menu Prompt */
    boolean lockedout;             /* if locked out    */
    boolean deleted;               /* if deleted       */
    char lockedfile[9];            /* lockout msg to print */
    byte novotes;
    byte yesvotes;                 /* # of yes/no votes in NUV */
    uflags ac;                     /* user flags   */
    flistflags fflag;              /* users configable file list */
    acrq ar;                       /* AR flags     */

    word zzqscan[64];              /* last read msg pointers */
    word xqxxx[64];
    boolean zzqscn[64];            /* scan boards flags  */
    dlnscan zzdlnscn;              /* scan uboards flags */

    byte vote[20];                 /* voting data  */

    char sex;                      /* user sex */

    long ttimeon;                  /* total mins spent on  */
    int x1xx;                    
    long uk;                       /* UL k                 */
    int x2xx;
    long dk;                       /* DL k                 */
    int x3xx;

    int uploads;
    int downloads;                 /* # of ULs / # of DLs  */
    int loggedon;                  /* # times logged on    */
    int tltoday;                   /* # min left today     */
    int msgpost;                   /* # public posts       */
    int emailsent;                 /* # email sent         */
    int feedback;                  /* # feedback sent      */
    int forusr;                    /* forward mail to user # */
    int filepoints;                /* # of file points     */

    byte waiting;                  /* mail waiting         */
    byte linelen;                  /* line length (# cols) */
    byte pagelen;                  /* page length (# rows) */
    byte ontoday;                  /* # times on today     */
    byte illegal;                  /* # illegal logon attempts */
    byte sl,dsl;                   /* SL / DSL */

    clrs cols;                     /* user colors */

    byte lastmsg;                  /* last msg/file areas   */
    byte lastfil;
    long credit;                   /* $$$ credit in dollars */
    int x4xx;
    int timebank;                  /* # mins in Time Bank   */
    byte boardsysop[5];            /* msg board SysOp       */

    boolean trapactivity;          /* if trapping users activity */
    boolean trapseperate;          /* if trap to seperate TRAP file */

    int timebankadd;               /* time added to timebank TODAY */
    long mpointer;                 /* *REMOVED* */
    boolean chatauto;              /* if auto chat trapping */
    boolean chatseperate;          /* if seperate chat file to trap to */
    char userstartmenu[9];         /* menu to start user out on */
    boolean slogseperate;          /* seperate SysOp log? */
    byte clsmsg;                   /* 1 if clear-screen msg, 2 if not */

/* NEW STUFF */

    byte flistopt;                 /* type of file list type to use */
    byte msgorder;                 /* 0:Chrono, 1:ReplyTree */
    byte avadjust;                 /* AVATAR color adjust: 1=no, 2=yes */

/* NEW STUFF *ENDS* */

    byte res[54];                  /* RESERVED */

    } userrec;

typedef struct {                 /* ZSCAN.DAT : NewScan recs (file/msg) */
    mhireadr mhiread;            /* NewScan high message pointers */
    mzscanr mzscan;              /* NewScan message bases */
    fzscanr fzscan;              /* NewScan file bases */
    
    } zscanrec;

typedef struct {
    bit miexist        : 1;      /* does message actually exist? */
    bit miencrypted    : 1;      /* is it encrypted? */
    bit miunvalidated  : 1;      /* is message unvalidated? */
    bit mipermanent    : 1;      /* is the message permanent? */
    bit miallowmci     : 1;      /* DID owner have access to MCI? */
    bit mithreads      : 1;      /* is message referenced? (threaded) */
    bit mimassmail     : 1;      /* is it private, mass mail? */
    bit miscanned      : 1;      /* is message scanned for FidoNet? */

    } msgindexstatr;

typedef struct {                 /* *.MIX : Message index records */
    word messagenum;             /* message number, tonum in EMAIL.MIX */
    long hdrptr;                 /* pointer to message header */
    long msgid;                  /* message ID (sequential) */
    long isreplytoid;            /* ID of replied message */
    cpackdatetime msgdate;       /* message date/time (packed) */
    byte msgdowk;                /* message day-of-week (0=Sun ...) */
    msgindexstatr msgindexstat;  /* status flags */
    word isreplyto;              /* reply this message is to (-1=None) */
    word numreplys;              /* number of replies to THIS message */
 
    } msgindexrec;
 
typedef struct {               /* from/to information for mheaderrec */
     byte anon;                /* anonymous type */
     word usernum;             /* user number */
     char as[43];              /* given name for this case */
     char real[37];            /* user real name */
     char alias[37];           /* user alias */

    } fromtoinfo;
 
typedef struct {               /* *.BRD : Message header records */
     long signature;           /* header signature - $FFFFFFFF */
     long msgptr;              /* pointer to message text */
     long msglength;           /* length of message text */
     fromtoinfo fromi;         /* from information */
     fromtoinfo toi;           /* to information */
     char title[61];           /* title of message */
     char origindate[20];      /* Echo/Group original msg date */

    } mheaderrec;
 
typedef struct {               /* ZLOG.DAT : System log */
     char date[9];
     int userbaud[5];
     int active;
     int calls;
     int newusers;
     int pubpost;
     int privpost;
     int fback;
     int criterr;
     int uploads;
     int downloads;
     long uk;
     long dk;
    } zlogrec;
 
typedef struct {
     long waitbaud;              /* wait baud */
     byte comport;               /* comport number */
     word inoutbuff;             /* modem in/out buffer size */
     byte irqnum;                /* irq number 0-7 (255 for none) */
     char init[81];              /* initialization string */
     char answer[41];            /* answer string */
     char hangup[41];            /* hangup string */
     char offhook[41];           /* phone off-hook string */
     int nocallinittime;         /* reinit modem after x mins of inactivity */
     long arq9600rate;           /* baud rate to USE when 9600 ARQ result code */
     boolean noforcerate;        /* whether to force baud rate */
     boolean hardware;           /* use hardware handshaking */
} modemrec;


typedef struct {
     char ansiq[81];             /* system pw string */
     char enterhandle[81];       /* Handle */
     char enterpw[81];           /* Password */
     char lprompt[81];           /* File Listings prompt */
     char echoc;                 /* Echo char for PWs */
     char engage[81];            /* "Engage Chat" */
     char endchat[81];           /* "End Chat" */
     char wait[81];              /* "SysOp Working" */
     char pause[81];             /* "Pause" */
     char entermsg1[81];         /* Join Conference */
     char entermsg2[81];         /* Prompt Choice */
     char newscan1[81];          /* "NewScan begin" */
     char newscan2[81];          /* "NewScan done" */
     char scanmessage[81];       /* Message scanning prompt */
     char automsgt[81];          /* Auto-Message title */
     char autom;                 /* Auto-Message border characters */

     char shelldos1[81];         /* " >> SysOp shelling to DOS ..." */
     char shelldos2[81];         /* " ... thank you for waiting." */
     char chatcall1[81];         /* "Paging SysOp, please wait..." */
     char chatcall2[81];         /* ">>><*><<<" */
     char guestline[81];         /* "To be a guest ... " */
     char namenotfound[81];      /* "Name NOT found in user list." */
     char bulletinline[81];      /* Bulletin line */
     char thanxvote[81];         /* "Thanks for voting" */

     char listline[81];          /* "List files - P to pause" */
     char newline[81];           /* "Search for new files -" */
     char searchline[81];        /* "Search all dirs for file mask" */
     char findline1[81];         /* "Search for descriptions... " */
     char findline2[81];         /* "Enter the string to search for.." */
     char downloadline[81];      /* "Download - " */
     char uploadline[81];        /* "Upload - " */
     char viewline[81];          /* "View interior files - " */
     char nofilepts[81];         /* "Insufficient file points." */
     char unbalance[81];         /* "Your UL/DL ratio is unbalanced" */

     char pninfo[81];            /* "P to Pause, N for next dir" */
     char gfnline1[81];          /* "[Enter]=All files" */
     char gfnline2[81];          /* "File mask: " */
     char batchadd[81];          /* (borrowed) area changing */
     char newuserp[81];          /* new user password                  */
     char logonnew[81];          /* logon as new?                      */
     char quotebegin[81];        /* begin quote                        */
     char quoteend[81];          /* end quote                          */
     char updatesys[81];         /* updating system status             */
     char enteroneline[81];      /* enter a oneliner                   */
     char protselect[81];        /* protocol selection                 */
     char multitask[81];         /* (borrowed) Search [W/S]            */
     char phonenum[81];          /* enter your phone #                 */
     char bbsadd[81];            /* bbslist: add bbs?                  */
     char bbsphone[81];          /* bbslist: add bbs phone             */
     char bbsname[81];           /* bbslist: add bbs name              */
     char bbsspeed[81];          /* bbslist: max speed                 */
     char bbstype[81];           /* bbslist: bbs type                  */
     char leavefeedback[81];     /* leave feedback?                    */
     char sysoppass[81];         /* sysop password                     */
     char nuzipcode[81];         /* *borrowed*                         */
     char nuaddress[81];         /* newuser address                    */
     char nubday[81];            /* newuser birthday                   */
     char nucity[81];            /* newuser where are you from?        */
     char nuphone[81];           /* newuser phone                      */
     char numisc1[81];           /* newuser misc1                      */
     char nuscrwide[81];         /* newuser screen width               */
     char nuscrlines[81];        /* newuser screen lines               */
     char nureal[81];            /* newuser real name                  */
     char nuhandle[81];          /* newuser handle                     */
     char nustate[81];           /* *borrowed* newuser info change     */
     char nusex[81];             /* newuser sex                        */
     char numisc2[81];           /* newuser misc2                      */
     char numisc3[81];           /* newuser misc3                      */
     char nuwords[81];           /* newuser words blinking?            */
     char nuansi[81];            /* newuser use ansi?                  */
     char nupause[81];           /* newuser use pause?                 */
     char nuenterpw[81];         /* newuser enter password             */
/*     {New for 3.5 or 4.0}            */
     char postanon[81];          /*       {** Post anonymously? */
     char quote1[81];            /*** starting at: */
     char quote2[81];            /*** Ending At: */
     char enterunote[81];        /*** enter user note */
     char newusernote[81];       /*** default user note */
     char msgtitle[81];          /*** title: */
     char msgsendto[81];         /*** send to: */
     char uploadmsg[81];         /*** upload msg? */
     char fileaddedtobq[81];     /*** file added to batch queue */
     char fnewscan[81];          /*** file newscan start */
     char enterautosig[81];      /*** prompt for autosig */
     char enterfilenametoul[81]; /*** enter filename to ul/dl */
     char deletereadmail[81];    /*** delete read mail? */
     char nomsgs[81];            /*** no msgs on General */
     char globalnewscan[81];     /*** globalnewscan? */
     char nomailwaiting[81];     /*** no mail waiting */
     char numbermsgs[81];        /*** 102 msgs on General */
     char startmsgread[81];      /*** start msg reading */
     char fseprompt[81];         /*** FSE prompt */
     char aborted[81];           /*** Aborted... */
     char msgsaved[81];          /*** Msg posted on General */
     char logoffafter[81];       /*** logoff after transfer? */
     char posthere[81];          /*** Post on General? */
     char turbologin[81];        /*** turbo login? */
     char readmailq[81];         /* read your email? */
 } fstringrec;                   /* string upgrades easier on sysops) */

typedef struct {
     char gfilepath[80];         /* GFILES path */
     char afilepath[80];         /* AFILES path (text files path) */
     char menupath[80];          /* MENUS path  */
     char trappath[80];          /* LOG path (traps, chats, SysOp logs) */
     char msgpath[80];           /* MSG path (priv/pub mail path) */
     char tfilepath[80];         /* TFILES path */
     char temppath[80];          /* TEMP path - "temp" directory */
     boolean usenuv;             /* Is new user voting active? */
     byte nuvyes;                /* Yes votes required for validation in NUV */
     byte nuvno;                 /* No votes required for validation in NUV */
     char bbsname[81];           /* BBS name */
     char bbsphone[13];          /* BBS phone number */
     char sysopname[31];         /* SysOp's full name or alias */
     char regnum[11];            /* BBS Registration Number */
     char startdir[81];          /* batch file to run instead of NScan */
     int maxusers;               /* max number of users system can have */
     int lowtime;                /* SysOp begin minute (in minutes) */
     int hitime;                 /* SysOp end time */
     int dllowtime;              /* normal downloading hours begin.. */
     int dlhitime;               /* ..and end */
     boolean pcbfile;            /* use RA/PCBoard type file listings */
     boolean shuttlelog;         /* is Shuttle Logon active? */
     boolean lock300;            /* lock out 300 baud? */
     char sysoppw[21];           /* SysOp PW */
     char newuserpw[21];         /* newuser PW (or NULL if none) */
     char shuttlepw[21];         /* Shuttle PW (if Shuttle active) */
     int b300lowtime;            /* 300 baud calling hours begin.. */
     int b300hitime;             /* ..and end */
     int b300dllowtime;          /* 300 baud downloading hours begin.. */
     int b300dlhitime;           /* ..and end */
     boolean closedsystem;       /* DON'T allow new users? */
     boolean swapshell;          /* is swap shell function enabled? */
     int eventwarningtime;       /* time before event warning */
     char tfiledate[9];          /* last date text-files were inserted */
     long lastmsgid;             /* last-used message ID (sequential) */
 
     acstring sop,               /* SysOp */
     csop,                       /* Co-SysOp */
     msop,                       /* Message SysOp */
     fsop,                       /* File SysOp */
     spw,                        /* SysOp PW at logon */
     seepw,                      /* see SysOp PWs remotely  */
     normpubpost,                /* make normal public posts */
     normprivpost,               /* send normal e-mail */
     anonpubread,                /* see who posted public anon */
     anonprivread,               /* see who sent anon e-mail */
     anonpubpost,                /* make anon posts */
     anonprivpost,               /* send anon e-mail */
     seeunval,                   /* see unvalidated files */
     dlunval,                    /* DL unvalidated files */
     nodlratio,                  /* no UL/DL ratio */
     nopostratio,                /* no post/call ratio */
     nofilepts,                  /* no file points checking */
     ulvalreq;                   /* uploads require validation by SysOp */
 
     byte maxprivpost,           /* max e-mail can send per call */
     maxfback,                   /* max feedback per call */
     maxpubpost,                 /* max posts per call */
     maxchat,                    /* max chat-pages per call */
     maxwaiting,                 /* max mail in mail-box */
     csmaxwaiting,               /* max mail in mail-box for Co-SysOp + */
     maxlogontries,              /* tries allowed for PW's at logon */
     bsdelay,                    /* backspacing delay */
     maxlines,                   /* max lines in message */
     csmaxlines,                 /* max lines in message for Co-SysOp + */
     sysopcolor,                 /* SysOp color in chat mode */
     usercolor;                  /* user color in chat mode */
     int minspaceforpost,        /* minimum K drive space left to post */
     minspaceforupload;          /* minimum K drive space left to upload */
     byte backsysoplogs,         /* days to keep SYSOP##.LOG */
     wfcblanktime;               /* minutes after which to blank WFC menu */
     byte linelen,               /* default video line length */
     pagelen;                    /* default video page length */
 
     boolean specialfx,          /* Use iCEcolor? */
     fossil,                     /* make use of FOSSIL comm driver */
     allowalias,                 /* allow alias's? (handles) */
     phonepw,                    /* use phone number password in logon? */
     localsec,                   /* is local security ON? */
     localscreensec,             /* is local screen-security ON? */
     globaltrap,                 /* trap ALL USER'S activity? */
     autochatopen,               /* does chat buffer auto-open? */
     autominlogon,               /* Auto-Message in logon? */
     bullinlogon,                /* bulletins in logon? */
     lcallinlogon,               /* Last Callers list in logon? */
     yourinfoinlogon,            /* User Stats in logon? */
     multitask,                  /* is BBS multitasking? */
     offhooklocallogon,          /* take phone off-hook for local logons? */
     forcevoting,                /* is manditory logon voting active? */
     compressbases,              /* "compress" file/message base numbers? */
     searchdup;                  /* search for dup. filenames when UL? */
     byte slogtype;              /* SysOp log type: File/Printer/Both */
     boolean stripclog;          /* strip colors from SysOp log output? */
     int newapp,                 /* user# to send new user application to */
     guestuser,                  /* user# of guest user account */
     timeoutbell,                /* minutes before time-out bell */
     timeout;                    /* minutes before timeout (logoff) */
     boolean usewfclogo;         /* whether to use WFC menu logo */
     boolean useems;             /* attempt to use EMS for overlay */
     boolean usebios;            /* use ROM BIOS for local video output */
     boolean cgasnow;            /* suppress snow on CGA systems */
 
     char filearccomment[3][81]; /* BBS comments for archives */
     boolean ulcheckit,          /* Use Internal Upload Checker? */
     uldlratio,                  /* are UL/DL ratios active? */
     fileptratio;                /* is auto file-pt compensation active? */
     byte fileptcomp,            /* file point compensation ratio */
     fileptcompbasesize,         /* file point "base compensation size" */
     ulrefund,                   /* percent time refund for ULs */
     tosysopdir;                 /* "To SysOp" file base */
     boolean validateallfiles;   /* validate ALL FILES automatically? */
     char remdevice[11];         /* remote output device (GATEx,COMx,etc) */
     int maxintemp,              /* max K allowed in TEMP\3\ */
     minresume;                  /* min K to allow resume-later */
     byte maxdbatch,             /* max files in DL batch queue */
     maxubatch;                  /* max files in UL batch queue */
 
     byte newsl,                 /* newuser SL */
     newdsl;                     /* newuser DSL */
     acrq newar;                 /* newuser AR */
     uflags newac;               /* newuser AC */
     int newfp;                  /* newuser file points */
     byte autosl,                /* auto-validation SL */
     autodsl;                    /* auto-validation DSL */
     acrq autoar;                /* auto-validation AR */
     uflags autoac;              /* auto-validation AC */
 
     char allstartmenu[9];       /* logon menu to start ALL users on */
     char bulletprefix[9];       /* default bulletins filename prefix */
 
     secrange timeallow,         /* time allowance */
     callallow,                  /* call allowance */
     dlratio,                    /* # ULs/# DLs ratios */
     dlkratio,                   /* DLk/ULk ratios */
     postratio;                  /* post/call ratios */
 
     char lastdate[9];           /* last system date */
     byte curwindow;             /* type of SysOp window currently in use */
     boolean istopwindow;        /* is SysOp window on top of screen? */
     long callernum;             /* total number of callers */
     int numusers;               /* number of users */
 
     zlogrec todayzlog;          /* TODAY's ZLOG record */
 
     int postcredits;            /*file points/upload credit compensation for posts*/
     boolean rebootforevent;     /* reboot before events? */
     boolean watchdogdoor;       /* WatchDog active in doors? */
 
     boolean windowon;
 
     char swappath[80];          /* swap shell path */
} systatrec;

typedef struct {                 /* VOTING.DAT : Voting records */
    char question[80];           /* voting question */
    int numa;                    /* number of user's who have answered */
    struct {
       char ans[41];             /* answer description */
       int numres;               /* # user's who picked this answer */
    } answ[10];
} vdatar; 

typedef struct {
     mbunhidden : 1;             /* whether *VISIBLE* to users w/o access */
     mbrealname : 1;             /* whether real names are forced */
     mbisdir    : 1;             /* if a message base directory */
     mbmsgpath  : 1;             /* if *.BRD file stored in MSGPATH */
     mbfilter   : 1;             /* whether to filter ANSI/8-bit ASCII */
     mbskludge  : 1;             /* strip IFNA kludge lines */
     mbsseenby  : 1;             /* strip SEEN-BY lines */
     mbsorigin  : 1;             /* strip origin lines */
     mbscenter  : 1;             /* strip centering codes */
     mbsbox     : 1;             /* strip box codes */
     mbmcenter  : 1;             /* center boxed/centered lines */
     mbaddtear  : 1;             /* add tear/origin lines */
     mbtopstar  : 1;             /* whether XBase for XMail base */
} mbflags; 

typedef struct {                 /* BOARDS.DAT : Message base records */
     char name[41];              /* message base description */
     char filename[9];           /* BRD/MIX/TRE data filename */
     long lastmsgid;             /* last message ID number */
     char msgpath[41];           /* messages pathname   */
     acstring acs,               /* access requirement */
     postacs,                    /* post access requirement */
     mciacs;                     /* MCI usage requirement */
     word maxmsgs;               /* max message count */
     anontyp anonymous;          /* anonymous type */
     char password[21];          /* base password */
     mbflags mbstat;             /* message base status vars */
     long permindx;              /* permanent index # */
     int mbtype;                 /* base type (0=Local,1=Echo,2=XNet) */
     char origin[51];            /* origin line */
     byte text_color,            /* color of standard text */
     quote_color,                /* color of quoted text */
     tear_color,                 /* color of tear line */
     origin_color;               /* color of origin line */
     int zone,                   /* alternate address     */
     net,                        /* (zone:net/node.point) */
     node,
     point;
     byte conf;                  /* base conference */
     byte res[2];                /* RESERVED */
    } boardrec;

typedef struct {
    bit fbnoratio     : 1;       /* if <No Ratio> active */
    bit fbunhidden    : 1;       /* whether *VISIBLE* to users w/o access */
    bit fbdirdlpath   : 1;       /* if *.DIR file stored in DLPATH */
    bit fbisdir       : 1;       /* if a file base directory */
    bit fbusegifspecs : 1;       /* whether to use GifSpecs */
    bit fbnetlink     : 1;       /* whether Net-Linked to other Telegards */
    } fbflags;
 
typedef struct {                 /* UPLOADS.DAT : File base records */
     char name[41];              /* area description  */
     char filename[13];          /* filename + ".DIR" */
     char dlpath[41],            /* download path     */
     ulpath[41];                 /* upload path       */
     int maxfiles;               /* max files allowed */
     char password[21];          /* password required */
     byte arctype,               /* wanted archive type (1..max,0=inactive) */
     cmttype;                    /* wanted comment type (1..3,0=inactive) */
     int fbdepth;                /* file base dir depth */
     fbflags fbstat;             /* file base status vars */
     acstring acs,               /* access requirements */
     ulacs,                      /* upload requirements */
     nameacs;                    /* see-names requirements */
     long permindx;              /* permanent index # */
     byte Conf;                  /* fbase conference */
     byte res[5];                /* RESERVED */
   } ulrec;
 
typedef struct {
    bit notval      : 1;         /* if file is NOT validated */
    bit isrequest   : 1;         /* if file is REQUEST */
    bit resumelater : 1;         /* if file is RESUME-LATER */
    } filstat;
 
typedef struct {                 /* *.DIR : File records */
     char filename[13];          /* Filename */
     char description[61];       /* File description */
     int filepoints;             /* File points */
     int nacc;                   /* Number DLs */
     byte ft;                    /* File type (useless?) */
     int blocks;                 /* # 128 byte blks */
     int owner;                  /* ULer of file */
     char stowner[37];           /* ULer's name */
     char date[9];               /* Date ULed */
     int daten;                  /* Numeric date ULed */
     long vpointer;              /* Pointer to verbose descr, -1 if none */
     filstat filestat;           /* File status */
     byte res[10];               /* RESERVED */
   } ulfrec;

typedef struct {                 /* VERBOSE.DAT : Verbose descriptions */
     char descr[51][20];
   } verbrec;
 
typedef struct {                 /* LASTON.DAT : Last few callers records */
     int callernum;              /* system caller number */
     char name[37];              /* user name of caller */
     int number;                 /* user number of caller */
     char citystate[31];         /* city/state of caller */
   } lcallers;
 
typedef struct {                 /* EVENTS.DAT : Event records */
     boolean active;             /* whether active */
     char description[31];       /* event description (for logs) */
     char etype;                 /* A:CS, C:hat, D:os call, E:xternal */
     char execdata[21];          /* errorlevel if "E", commandline if "D" */
     int busytime;               /* off-hook time before; 0 if none */
     int exectime;               /* time of execution */
     boolean busyduring;         /* busy phone DURING event? */
     int duration;               /* length of time event takes */
     byte execdays;              /* bitwise execution days or day of month if monthly */
     boolean monthly;            /* monthly event? */
   } eventrec;
 
typedef struct {
    bit clrscrbefore : 1;        /* C: clear screen before menu display */
    bit dontcenter   : 1;        /* D: don't center the menu titles! */
    bit nomenuprompt : 1;        /* N: no menu prompt whatsoever? */
    bit forcepause   : 1;        /* F: force a pause before menu display? */
    bit pulldown     : 1;        /* P: pulldown flag. */
    bit autotime     : 1;        /* T: is time displayed automatically? */
   } mnuflags; 

typedef struct {                 /* *.MNU : Menu records */
     char menuname[101][3];      /* menu name */
     char directive[13],         /* help file displayed */
     tutorial[13];               /* tutorial help file */
     char menuprompt[121];       /* menu prompt */
     acstring acs;               /* access requirements */
     char password[16];          /* password required */
     char fallback[9];           /* fallback menu */
     byte forcehelplevel;        /* forced help level for menu */
     byte gencols;               /* generic menus: # of columns */
     byte gcol[3];               /* generic menus: colors */
     mnuflags menuflags;         /* menu status variables */
   } menurec;
 
typedef struct {
    bit hidden   : 1;            /* H: is command ALWAYS hidden? */
    bit pull     : 1;            /* P: is command flagged as Pulldown Active? */
    bit unhidden : 1;            /* U: is command ALWAYS visible? */
    } cmdflags; 

typedef struct {                 /* *.MNU : Command records */
     char ldesc[71];             /* long/Normal Text command description */
     char sdesc[36];             /* short/Highlighted command description */
     char xpoint[4],             /* the command's X position */
     ypoint[4];                  /* the command's Y position */
     char ckeys[15];             /* command-execution keys */
     acstring acs;               /* access requirements */
     char cmdkeys[3];            /* command keys: type of command */
     char mstring[51];           /* MString: command data */
     cmdflags commandflags;      /* command status variables */
   } commandrec;
 
typedef struct {
    bit xbactive : 1,
    xbisbatch    : 1,
    xbisresume   : 1,
    xbxferokcode : 1;
    } xbflags;
 
typedef struct {
     xbflags xbstat;                    /* protocol flags */
     char ckeys[15];                    /* command keys */
     char descr[41];                    /* description */
     acstring acs;                      /* access string */
     char templog[26];                  /* temp. log file */
     char uloadlog[26],dloadlog[26];    /* permanent log files */
     char ulcmd[79],dlcmd[79];          /* UL/DL commandlines */
     char ulcode[6][7],dlcode[6][7];    /* UL/DL codes */
     char envcmd[61];                   /*(B) environment setup cmd */
     char dlflist[26];                  /*(B) DL file lists */
     int maxchrs;                       /* max chrs in cmdline */
     int logpf,logps;                   /*(B) pos in log file for data */
     long permindx;                     /* permanent index # */
     byte res[11];                      /* RESERVED */
   } protrec;
 
typedef struct {
     long day,hour,min,sec;
    } datetimerec;
 
typedef byte cfilterrec[256];         /* color filter record */

 
typedef struct {                 /* FIDONET.DAT : FidoNet information */
     int zone;                   /* FidoNet zone number */
     int net;                    /* FidoNet net number */
     int node;                   /* FidoNet node number */
     int point;                  /* FidoNet point number */
     char origin[51];            /* origin line */
     byte text_color;            /* color of standard text */
     byte quote_color;           /* color of quoted text */
     byte tear_color;            /* color of tear line */
     byte origin_color;          /* color of origin line */
     boolean skludge;            /* strip kludge lines? */
     boolean sseenby;            /* strip SEEN-BY lines? */
     boolean sorigin;            /* strip origin line? */
     boolean scenter;            /* strip TG centering codes? */
     boolean sbox;               /* strip TG box codes? */
     boolean mcenter;            /* center boxed/centered lines? */
     boolean addtear;            /* add tear/origin lines? */
     byte res[1978];             /* RESERVED */
    } fidorec;
#endif
