{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
unit AutoMsg;

interface

procedure autoReply;
procedure autoShowAutoMessage;
procedure autoWriteAutoMessage;

implementation

uses
   FsEditor, Input, StrProc, ShowFile, Output, Misc, Global, MsgArea, Logs,
   DateTime, Email;

procedure autoShowAutoMessage;
var tF : Text; Txt : tMessage; Lns, N : Word; Ans : Boolean;
    Title, From : String; Anon : Boolean;
begin
   logWrite('Displayed system automessage');
   Assign(tF,Cfg^.pathData+fileAutoMsg);
   Lns := 0;
   Title := 'None';
   From := 'Unknown';
   {$I-}
   Reset(tF);
   ReadLn(tF,From);
   ReadLn(tF,Title);
   {$I+}
   if ioResult = 0 then
   begin
      while not Eof(tF) do
      begin
         Inc(Lns,1);
         ReadLn(tF,Txt[Lns]);
      end;
      Close(tF);
   end;
   while (Lns > 1) and (Txt[Lns] = '') do Dec(Lns,1);
   Anon := From[1] = #255;
   if Anon then
   begin
      Delete(From,1,1);
      if acsOk(Cfg^.acsCoSysOp) then From := mStr(strAnonymous)+' ['+From+']' else
                                     From := mStr(strAnonymous);
   end;
   Msg^.FromInfo.Name := From;
   Msg^.Subject := Title;
   sfStr[1] := Title;
   sfStr[2] := From;
   PausePos := 1;
   PauseAbort := False;
   Ans := sfShowTextFile(txAutoTop,ftAutoMsg);
   if not Ans then
   begin
      oDnLn(1);
      oStrLn(' |U6'+bbsTitle+'|U4 AutoMessage |U5- |U4From|U5: |U6'+strSquish(From,30)+
             '  |U4Title|U5: |U6'+strSquish(Title,30));
      oSetCol(colBorder);
      oWriteLn(sRepeat('',79));
      oUpPause(4);
   end else oUpPause(ansiRows-1);
   if not sfGotoPos(3) then oSetCol(colText);
   if Lns = 0 then oStringLn(strNoAutoMsg) else
      for N := 1 to Lns do if (not HangUp) and (not PauseAbort) then
      begin
         oStrCtrLn(Txt[N]);
         oUpPause(1);
      end;
   sfStr[1] := Title;
   sfStr[2] := From;
   Ans := sfShowTextFile(txAutoBot,ftAutoMsg);
   if not Ans then
   begin
      oSetCol(colBorder);
      oWriteLn(sRepeat('',79));
      oUpPause(1);
   end else oUpPause(ansiRows-1);
   oDnLn(1);
   oUpPause(1);
   PausePos := 0;
end;

procedure autoWriteAutoMessage;
var tF : Text; Head : ^tMsgHeaderRec; Txt : ^tMessage; Lns, N : Word;
begin
   New(Head);
   New(Txt);
   FillChar(Head^,SizeOf(Head^),0);
   Head^.Status := [];
   with Head^.ToInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      Name := 'n/a';
      UserNote := 'None';
   end;
   oDnLn(1);
   oString(strMsgAskTitle);
   Head^.Subject := iReadString('',inNormal,chNormal,'',40);
   if Head^.Subject = '' then
   begin
      Dispose(Head);
      Dispose(Txt);
      Exit;
   end;
   Head^.Subject := #10+Head^.Subject;
   Head^.Status := [];
   with Head^.FromInfo do
   begin
      UserNum := User^.Number;
      Alias := User^.UserName;
      RealName := User^.RealName;
      Name := User^.UserName;
      UserNote := User^.UserNote;
   end;
   if acsOk(Cfg^.acsAnonAutoMsg) then
   begin
      oString(strMsgAskAnonymous);
      if iYesNo(False,True) then Head^.Status := Head^.Status+[msgAnonymous];
   end;
   Head^.Replies := 0;
   Head^.Date := dtDateTimePacked;
   Head^.sigPos := 0;
   Head^.incFile := 0;
   if fsEdit(Txt^,Head^,True,nil,nil,False,False) then
   begin
      if msgAnonymous in Head^.Status then Insert(#255,Head^.FromInfo.Name,1);
      Assign(tF,Cfg^.pathData+fileAutoMsg);
      {$I-}
      Rewrite(tF);
      {$I+}
      if ioResult <> 0 then Exit;
      WriteLn(tF,Head^.FromInfo.Name);  { ---------------- }
      WriteLn(tF,Head^.Subject);
      for N := 1 to Head^.Size do WriteLn(tF,Txt^[N]);
      Close(tF);
      logWrite('Changed the automessage');
   end else logWrite('Automessage change aborted');
   Dispose(Head);
   Dispose(Txt);
end;

procedure autoReply;
var tF : Text; Title, From : String; Anon : Boolean;
begin
   Assign(tF,Cfg^.pathData+fileAutoMsg);
   {$I-}
   Reset(tF);
   {$I+}
   if ioResult <> 0 then Exit;
   ReadLn(tF,From);
   ReadLn(tF,Title);
   Close(tF);
   Anon := From[1] = #255;
   if (Anon) and (not acsOk(Cfg^.acsCoSysOp)) then
   begin
      oStringLn(strAutoMsgAnon);
      Exit;
   end else if Anon then Delete(From,1,1);
   if emailEnterEmail(From,'Re: '+Title,False) then
      logWrite('Replied to '+From+'''s automsg [title: '+Title+']');
end;

end.
