{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
unit Comm;

interface

uses
   {$IFDEF OS2} Use32, {$ENDIF}
   Crt, WinDos, eComm;

const
   noDevice = 0;

procedure cCheckIt;
procedure cCheckUser;
function  cInitialize : Boolean;
function  cModemRinging : Boolean;
function  cNoCarrier : Boolean;
procedure cClearInBuffer;
procedure cClearOutBuffer;
procedure cHangUp;
procedure cModemWrite(S : String);
procedure cPurgeInput;
procedure cRaiseDTR;
procedure cTerminate;
procedure cWaitOutput;

implementation

uses
   Global, StrProc, StatBar, Misc, Logs, Output, DateTime, Nodes;

function cAbort : Boolean; far;
begin
   cAbort := (keypressed) and (readkey = #27);
end;

function cInitialize : Boolean;
begin
  if modemOff=false then
    cInitialize:=eInit(modem^.comport, modem^.baudrate);
end;
(*var pa : paritytype; cn : ComNameType; dev : Byte; addr : Word; err : Integer;
begin
   if modemOff then dev := NoDevice else dev := modem^.comDevice;
{$IFDEF OS2}
   if dev <> nodevice then dev := FossilDevice;
{$ENDIF}
   Val('$'+modem^.baseAddr,addr,err);
   if err <> 0 then addr := 0;
   case modem^.comport of
      1 : cn := com1;   5 : cn := com5;
      2 : cn := com2;   6 : cn := com6;
      3 : cn := com3;   7 : cn := com7;
      4 : cn := com4;   8 : cn := com8;
   end;
   case upcase(modem^.parity) of
      'N' : pa := NoParity;
      'O' : pa := OddParity;
      'E' : pa := EvenParity;
       else pa := NoParity;
   end;
   case dev of
      NoDevice      : New(pcomm,init);
{$IFNDEF OS2}
      UartDevice    : begin
         uSetUart(cn,addr,modem^.irqnumber,0);
         New(UartPortPtr(pcomm),
         initCustom(cn,modem^.baudrate,pa,
                    modem^.databits,modem^.stopbits,modem^.recvBuff,
                    modem^.sendBuff,defportoptions));
         end;
      Int14Device   : New(Int14PortPtr(pcomm),
         initCustom(cn,modem^.baudrate,pa,
                    modem^.databits,modem^.stopbits,modem^.recvBuff,
                    modem^.sendBuff,defportoptions));
      Digi14Device  : New(Digi14PortPtr(pcomm),
         initCustom(cn,modem^.baudrate,pa,
                    modem^.databits,modem^.stopbits,modem^.recvBuff,
                    modem^.sendBuff,defportoptions));
{$ENDIF}
      FossilDevice  : New(FossilPortPtr(pcomm),
         initCustom(cn,modem^.baudrate,pa,
                    modem^.databits,modem^.stopbits,modem^.recvBuff,
                    modem^.sendBuff,defportoptions));
   end;
   pcomm^.setAbortFunc(cAbort);
   cInitialize := asyncStatus = ecOk;
end;
*)

procedure cTerminate;
begin
   eclosemodem;
end;

function cNoCarrier : Boolean;
begin
   cNoCarrier := ModemIO and (not echeckdcd);
end;

procedure cCheckIt;
begin
   if UserOn then sbUpdate;
   if not LocalIO then
   begin
      if (HangUp) and (not cNoCarrier) then
      begin
         HungUp := False;
         if not asDoor then cHangUp;
         RemoteOut := False;
         LocalIO := True;
         ModemIO := False;
      end else
      if cNoCarrier then
      begin
         HangUp := True;
         HungUp := True;
         logWrite('Carrier lost');
         if not asDoor then cHangUp;
         RemoteOut := False;
         LocalIO := True;
         ModemIO := False;
      end;
   end;
   if (not nodebusy) and (useron) then nodeProcess;
   if oprType > oprDOS then mTimeSlice;
end;

procedure cCheckUser;
begin
   if (not ChatModeOn) and (timeCheck) and (UserOn) and (LoggedIn) and
      (not HangUp) and (mTimeLeft('S') < 1) then
   begin
      oStringLn(strTimeExpired);
      logWrite('User''s time expired.');
      HangUp := True;
   end;
   cCheckIt;
end;

function cModemRinging : Boolean;
begin
   cModemRinging := ModemIO and echeckRI;
end;

procedure cClearOutBuffer;
begin
   if ModemIO then eFlushOutBuffer;
end;

procedure cClearInBuffer;
begin
   if ModemIO then eFlushInBuffer;
end;

procedure cPurgeInput;
var c : Char;
begin
   if ModemIO then
      while echeckdcd and echarready do egetchar(c);
end;

procedure cHangUp;
var
  hTimer: real;
begin
   if ModemIO then
   begin
      esetDTR(False);
      hTimer:=dtTimer;
      repeat
        mTimeSlice;
      until (echeckdcd=false) or (dtTimer>=hTimer+10); {fail in 10 seconds}
      esetDTR(True);
      Delay(100);
      eflushinbuffer;
   end;
end;

procedure cRaiseDTR;
begin
   if ModemIO then esetDTR(True);
end;

procedure cModemWrite(S : String);
var P : Byte;
begin
   if not ModemIO then Exit;
   for P := 1 to Length(S) do
   begin
      case S[P] of
        '|' : eputChar(#13);
        '~' : Delay(500);
        '^' : cHangUp;
        else eputChar(s[p]);
      end;
   end;
end;

procedure cWaitOutput;
begin
   if not ModemIO then Exit;
   while (not Hangup) and (eoutBuffUsed > 0) do cCheckUser;
end;

end.
