{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
unit Config2;

interface

procedure cfgCommunicationsSetup;

implementation

uses
   Crt, Global, Output, StrProc, Input, Files, Config, Misc, Logs, Bbsinit;

const
   noDevice = 0;

var Mdm : tModemRec;

procedure cfgModemConfig;
var Baud, Par : Byte;
    optComDevice : array[1..5] of String;
    optComPort : array[1..32] of String;
    optBaudRate : array[1..19] of String;
    optDataBits : array[1..2] of String;
    optParity : array[1..3] of String;
    optStopBits : array[1..2] of String;
begin
   optComDevice[1] := 'None (local)';
{$IFDEF OS2}
   optComDevice[2] := 'Serial (OS2)';
{$ELSE}
   optComDevice[2] := 'Fossil (DOS)';
{$ENDIF}
   optDataBits[1] := '7';
   optDataBits[2] := '8 [standard]';
   optParity[1] := 'None [standard]';
   optParity[2] := 'Even';
   optParity[3] := 'Odd';
   optStopBits[1] := '1 [standard]';
   optStopBits[2] := '2';
   for par := 1 to 32 do optComPort[par] := 'COM'+st(par);
   optBaudRate[1] := '300';
   optBaudRate[2] := '1200';
   optBaudRate[3] := '2400';
   optBaudRate[4] := '4800';
   optBaudRate[5] := '7200';
   optBaudRate[6] := '9600';
   optBaudRate[7] := '14400';
   optBaudRate[8] := '16800';
   optBaudRate[9] := '19200';
   optBaudRate[10] := '21600';
   optBaudRate[11] := '24000';
   optBaudRate[12] := '26400';
   optBaudRate[13] := '28800';
   optBaudRate[14] := '31200';
   optBaudRate[15] := '33600';
   optBaudRate[16] := '38400';
   optBaudRate[17] := '57600';
   optBaudRate[18] := '64000';
   optBaudRate[19] := '115200';
   cfgDraw := True;
   cfgOver := False;
   if mdm.comport = 0 then mdm.comport := 1;
   if (mdm.comdevice+1 <> 5) and (mdm.comport > 8) then mdm.comport := 1;
   repeat
      cfgInit('General Modem Setup [node '+St(Node)+']');

      Baud := 1;
      while (Baud < 20) and (strToInt(optBaudRate[Baud]) <> Mdm.BaudRate) do Inc(Baud,1);
      if Baud = 20 then begin Mdm.BaudRate := 38400; Baud := 16; end;

      case Mdm.Parity of
         'N' : Par := 1;
         'E' : Par := 2;
         'O' : Par := 3;
         else begin Mdm.Parity := 'N'; Par := 1; end;
      end;

      cfgItem('A Com device',12,cfgOption(optComDevice,Mdm.ComDevice+1),
              'Communications method');
      cfgItem('B Com port',5,cfgOption(optComPort,Mdm.ComPort),
              'Modem communcations port number');
      cfgItem('C Baud rate',10,cfgOption(optBaudRate,Baud),
              'Maximum baud rate for this modem');
      cfgItem('D Data bits',12,cfgOption(optDataBits,Mdm.DataBits-6),
              'Modem communication data bits');
      cfgItem('E Parity',16,cfgOption(optParity,Par),
              'Modem communication parity');
      cfgItem('F Stop bits',12,cfgOption(optStopBits,Mdm.StopBits),
              'Modem communication stop bits');
      cfgItem('G Recv buffer size',5,St(Mdm.recvBuff),
              'Size of receive buffer for this device');
      cfgItem('H Send buffer size',5,St(Mdm.sendBuff),
              'Size of transmit buffer for this device');
      cfgItem('I Locked port',3,B2St(Mdm.LockedPort),
              'Is the FOSSIL driver LOCKED at the specified baudrate? (Usually if high speed)');
      cfgItem('J Multi-ring',3,B2St(Mdm.MultiRing),
              'Multi-ring support, for joint data and voice phone lines (aka select-ring)');
      cfgItem('K Modem IRQ number',1,St(Mdm.irqNumber),
              'UART/Serial modem IRQ (usually com1/com3=4, com2/com4=3) 0=default');
      cfgItem('L Device address',4,Mdm.baseAddr,
              'Base address in HEX (usually com1:03F8 2:02F8 3:03E8 4:02E8) 0=default');
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;
      case cfgKey of
        'A' : begin
                 Inc(mdm.comDevice);
                 cfgReadOption(optComDevice,2,Mdm.ComDevice);
                 cfgSetItem(cfgOption(optComDevice,Mdm.ComDevice));
                 Dec(mdm.comDevice);
                 if (mdm.comdevice+1 <> 5) and (mdm.comport > 8) then
                 begin
                    mdm.comport := 1;
                    cfgDraw := True;
                    cfgOver := True;
                 end;
                 if (mdm.comdevice in [2,3]) and (mdm.baudrate > 38400) then
                 begin
                    mdm.baudrate := 38400;
                    cfgDraw := true;
                    cfgOver := true;
                 end;
              end;
        'B' : begin                                           {comatose}
                 if mdm.comdevice+1 = 5 then par := 32 else par := 8{32};
                 cfgReadOption(optComPort,par,Mdm.ComPort);
                 cfgSetItem(cfgOption(optComPort,Mdm.ComPort));
              end;
        'C' : begin
                 if mdm.comDevice in [2,3] then cfgReadOption(optBaudRate,16,baud) else
                                                cfgReadOption(optBaudRate,19,baud);
                 Mdm.BaudRate := strToInt(optBaudrate[Baud]);
                 cfgSetItem(cfgOption(optBaudRate,Baud));
              end;
        'D' : begin
                 Dec(Mdm.DataBits,6);
                 cfgReadOption(optDataBits,2,Mdm.DataBits);
                 cfgSetItem(cfgOption(optDataBits,Mdm.DataBits));
                 Inc(Mdm.DataBits,6);
              end;
        'E' : begin
                 cfgReadOption(optParity,3,Par);
                 case Par of
                    1 : Mdm.Parity := 'N';
                    2 : Mdm.Parity := 'E';
                    3 : Mdm.Parity := 'O';
                 end;
                 cfgSetItem(cfgOption(optParity,Par));
              end;
        'F' : begin
                 cfgReadOption(optStopBits,2,Mdm.StopBits);
                 cfgSetItem(cfgOption(optStopBits,Mdm.StopBits));
              end;
        'G' : begin
                 cfgReadInfo(St(Mdm.recvBuff),inUpper,chNumeric,'',False);
                 Mdm.recvBuff := mClip(strToInt(cfgRead),512,8192);
                 cfgSetItem(St(Mdm.recvBuff));
              end;
        'H' : begin
                 cfgReadInfo(St(Mdm.sendBuff),inUpper,chNumeric,'',False);
                 Mdm.sendBuff := mClip(strToInt(cfgRead),512,8192);
                 cfgSetItem(St(Mdm.sendBuff));
              end;
        'I' : begin
                 cfgReadBoolean(Mdm.LockedPort);
                 cfgSetItem(B2St(Mdm.LockedPort));
              end;
        'J' : begin
                 cfgReadBoolean(Mdm.MultiRing);
                 cfgSetItem(B2St(Mdm.MultiRing));
              end;
        'K' : begin
                 cfgReadInfo(St(Mdm.irqNumber),inUpper,chNumeric,'',False);
                 Mdm.irqNumber := mClip(strToInt(cfgRead),0,15);
                 cfgSetItem(St(Mdm.irqNumber));
              end;
        'L' : begin
                 cfgReadInfo(Mdm.baseAddr,inUpper,chNormal,'',False);
                 Mdm.baseAddr := cfgRead;
                 cfgSetItem(Mdm.baseAddr);
              end;
      end;
   until (HangUp) or (cfgDone);
   cfgDone := False;
end;

procedure cfgCommandStrings;
var iCmd : String;
begin
   cfgDraw := True;
   cfgOver := False;
   iCmd := '(''~'' = Delay, ''^'' = DTR, ''|'' = CR)  ';
   repeat
      cfgInit('Modem Command Strings');
      cfgItem('A Init String #1',45,Mdm.sInit1,
              iCmd+'Modem initialization string #1');
      cfgItem('B Init String #2',45,Mdm.sInit2,
              iCmd+'Modem initialization string #2');
      cfgItem('C Init String #3',45,Mdm.sInit3,
              iCmd+'Modem initialization string #3');
      cfgItem('D Exit String',45,Mdm.sExitStr,
              iCmd+'Sent before exiting '+bbsTitle);
      cfgItem('E Answer String',45,Mdm.sAnswer,
              iCmd+'Command to answer modem');
      cfgItem('F Hangup String',45,Mdm.sHangup,
              iCmd+'Modem hangup string');
      cfgItem('G Offhook String',45,Mdm.sOffhook,
              iCmd+'Command to offhook modem');
      cfgItem('H Dialing Prefix',45,Mdm.sDialPrefix,
              'Prefix sent to modem before phone number to dial');
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;
      case cfgKey of
        'A' : begin
                 cfgReadInfo(Mdm.sInit1,inNormal,chNormal,'',False);
                 Mdm.sInit1 := cfgRead;
                 cfgSetItem(Mdm.sInit1);
              end;
        'B' : begin
                 cfgReadInfo(Mdm.sInit2,inNormal,chNormal,'',False);
                 Mdm.sInit2 := cfgRead;
                 cfgSetItem(Mdm.sInit2);
              end;
        'C' : begin
                 cfgReadInfo(Mdm.sInit3,inNormal,chNormal,'',False);
                 Mdm.sInit3 := cfgRead;
                 cfgSetItem(Mdm.sInit3);
              end;
        'D' : begin
                 cfgReadInfo(Mdm.sExitStr,inNormal,chNormal,'',False);
                 Mdm.sExitStr := cfgRead;
                 cfgSetItem(Mdm.sExitStr);
              end;
        'E' : begin
                 cfgReadInfo(Mdm.sAnswer,inNormal,chNormal,'',False);
                 Mdm.sAnswer := cfgRead;
                 cfgSetItem(Mdm.sAnswer);
              end;
        'F' : begin
                 cfgReadInfo(Mdm.sHangup,inNormal,chNormal,'',False);
                 Mdm.sHangup := cfgRead;
                 cfgSetItem(Mdm.sHangup);
              end;
        'G' : begin
                 cfgReadInfo(Mdm.sOffhook,inNormal,chNormal,'',False);
                 Mdm.sOffhook := cfgRead;
                 cfgSetItem(Mdm.sOffhook);
              end;
        'H' : begin
                 cfgReadInfo(Mdm.sDialPrefix,inNormal,chNormal,'',False);
                 Mdm.sDialPrefix := cfgRead;
                 cfgSetItem(Mdm.sDialPrefix);
              end;
      end;
   until (HangUp) or (cfgDone);
   cfgDone := False;
end;

procedure cfgResultStrings;
begin
   cfgDraw := True;
   cfgOver := False;
   repeat
      cfgInit('Modem Result Strings');
      cfgItem('A Command Error',45,Mdm.rError,
              'Returned when a modem command error occurs');
      cfgItem('B No Carrier',45,Mdm.rNoCarrier,
              'Returned when the connection is broken, and carrier is lost');
      cfgItem('C Command Ok',45,Mdm.rOk,
              'Returned when a modem command is successful');
      cfgItem('D Ring',45,Mdm.rRing,
              'Returned when the modem is ringing');
      cfgItem('E Busy',45,Mdm.rBusy,
              'Returned when a dial attempt reports a busy signal');
      cfgItem('F No dial tone',45,Mdm.rNoDialTone,
              'Returned when the modem reports that there is no dial tone');
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;
      case cfgKey of
        'A' : begin
                 cfgReadInfo(Mdm.rError,inNormal,chNormal,'',True);
                 Mdm.rError := cfgRead;
                 cfgSetItem(Mdm.rError);
              end;
        'B' : begin
                 cfgReadInfo(Mdm.rNoCarrier,inNormal,chNormal,'',True);
                 Mdm.rNoCarrier := cfgRead;
                 cfgSetItem(Mdm.rNoCarrier);
              end;
        'C' : begin
                 cfgReadInfo(Mdm.rOk,inNormal,chNormal,'',True);
                 Mdm.rOk := cfgRead;
                 cfgSetItem(Mdm.rOk);
              end;
        'D' : begin
                 cfgReadInfo(Mdm.rRing,inNormal,chNormal,'',True);
                 Mdm.rRing := cfgRead;
                 cfgSetItem(Mdm.rRing);
              end;
        'E' : begin
                 cfgReadInfo(Mdm.rBusy,inNormal,chNormal,'',True);
                 Mdm.rBusy := cfgRead;
                 cfgSetItem(Mdm.rBusy);
              end;
        'F' : begin
                 cfgReadInfo(Mdm.rNoDialTone,inNormal,chNormal,'',True);
                 Mdm.rNoDialTone := cfgRead;
                 cfgSetItem(Mdm.rNoDialTone);
              end;
      end;
   until (HangUp) or (cfgDone);
   cfgDone := False;
end;

procedure cfgConnectStrings;
begin
   cfgDraw := True;
   cfgOver := False;
   repeat
      cfgInit('Modem Connect Messages');
      cfgCol := 20;
      cfgItem('A Connect 300',45,Mdm.c300,
              'Connected at 300 baud');
      cfgItem('B Connect 1200',45,Mdm.c1200,
              'Connected at 1200 baud');
      cfgItem('C Connect 2400',45,Mdm.c2400,
              'Connected at 2400 baud');
      cfgItem('D Connect 4800',45,Mdm.c4800,
              'Connected at 4800 baud');
      cfgItem('E Connect 7200',45,Mdm.c7200,
              'Connected at 7200 baud');
      cfgItem('F Connect 9600',45,Mdm.c9600,
              'Connected at 9600 baud');
      cfgItem('G Connect 14400',45,Mdm.c14400,
              'Connected at 14400 baud');
      cfgItem('H Connect 16800',45,Mdm.c16800,
              'Connected at 16800 baud');
      cfgItem('I Connect 19200',45,Mdm.c19200,
              'Connected at 19200 baud');
      cfgItem('J Connect 21600',45,Mdm.c21600,
              'Connected at 21600 baud');


      cfgLn  := cfgTop;
      cfgSrt := 40;
      cfgCol := 60;


      cfgItem('K Connect 24000',45,Mdm.c24000,
              'Connected at 24000 baud');
      cfgItem('L Connect 26400',45,Mdm.c26400,
              'Connected at 26400 baud');
      cfgItem('M Connect 28800',45,Mdm.c28800,
              'Connected at 28800 baud');
      cfgItem('N Connect 31200',45,Mdm.c31200,
              'Connected at 31200 baud');
      cfgItem('O Connect 33600',45,Mdm.c33600,
              'Connected at 33600 baud');
      cfgItem('P Connect 38400',45,Mdm.c38400,
              'Connected at 38400 baud');
      cfgItem('Q Connect 57600',45,Mdm.c57600,
              'Connected at 57600 baud');
      cfgItem('R Connect 64000',45,Mdm.c64000,
              'Connected at 64000 baud');
      cfgItem('S Connect 115200',45,Mdm.c115200,
              'Connected at 115200 baud');
      if cfgDraw then Dec(cfgBot,8);
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;
      case cfgKey of
        'A' : begin
                 cfgReadInfo(Mdm.c300,inNormal,chNormal,'',True);
                 Mdm.c300 := cfgRead;
                 cfgSetItem(Mdm.c300);
              end;
        'B' : begin
                 cfgReadInfo(Mdm.c1200,inNormal,chNormal,'',True);
                 Mdm.c1200 := cfgRead;
                 cfgSetItem(Mdm.c1200);
              end;
        'C' : begin
                 cfgReadInfo(Mdm.c2400,inNormal,chNormal,'',True);
                 Mdm.c2400 := cfgRead;
                 cfgSetItem(Mdm.c2400);
              end;
        'D' : begin
                 cfgReadInfo(Mdm.c4800,inNormal,chNormal,'',True);
                 Mdm.c4800 := cfgRead;
                 cfgSetItem(Mdm.c4800);
              end;
        'E' : begin
                 cfgReadInfo(Mdm.c7200,inNormal,chNormal,'',True);
                 Mdm.c7200 := cfgRead;
                 cfgSetItem(Mdm.c7200);
              end;
        'F' : begin
                 cfgReadInfo(Mdm.c9600,inNormal,chNormal,'',True);
                 Mdm.c9600 := cfgRead;
                 cfgSetItem(Mdm.c9600);
              end;
        'G' : begin
                 cfgReadInfo(Mdm.c14400,inNormal,chNormal,'',True);
                 Mdm.c14400 := cfgRead;
                 cfgSetItem(Mdm.c14400);
              end;
        'H' : begin
                 cfgReadInfo(Mdm.c16800,inNormal,chNormal,'',True);
                 Mdm.c16800 := cfgRead;
                 cfgSetItem(Mdm.c16800);
              end;
        'I' : begin
                 cfgReadInfo(Mdm.c19200,inNormal,chNormal,'',True);
                 Mdm.c19200 := cfgRead;
                 cfgSetItem(Mdm.c19200);
              end;
        'J' : begin
                 cfgReadInfo(Mdm.c21600,inNormal,chNormal,'',True);
                 Mdm.c21600 := cfgRead;
                 cfgSetItem(Mdm.c21600);
              end;
        'K' : begin
                 cfgReadInfo(Mdm.c24000,inNormal,chNormal,'',True);
                 Mdm.c24000 := cfgRead;
                 cfgSetItem(Mdm.c24000);
              end;
        'L' : begin
                 cfgReadInfo(Mdm.c26400,inNormal,chNormal,'',True);
                 Mdm.c26400 := cfgRead;
                 cfgSetItem(Mdm.c26400);
              end;
        'M' : begin
                 cfgReadInfo(Mdm.c28800,inNormal,chNormal,'',True);
                 Mdm.c28800 := cfgRead;
                 cfgSetItem(Mdm.c28800);
              end;
        'N' : begin
                 cfgReadInfo(Mdm.c31200,inNormal,chNormal,'',True);
                 Mdm.c31200 := cfgRead;
                 cfgSetItem(Mdm.c31200);
              end;
        'O' : begin
                 cfgReadInfo(Mdm.c33600,inNormal,chNormal,'',True);
                 Mdm.c33600 := cfgRead;
                 cfgSetItem(Mdm.c33600);
              end;
        'P' : begin
                 cfgReadInfo(Mdm.c38400,inNormal,chNormal,'',True);
                 Mdm.c38400 := cfgRead;
                 cfgSetItem(Mdm.c38400);
              end;
        'Q' : begin
                 cfgReadInfo(Mdm.c57600,inNormal,chNormal,'',True);
                 Mdm.c57600 := cfgRead;
                 cfgSetItem(Mdm.c57600);
              end;
        'R' : begin
                 cfgReadInfo(Mdm.c64000,inNormal,chNormal,'',True);
                 Mdm.c64000 := cfgRead;
                 cfgSetItem(Mdm.c64000);
              end;
        'S' : begin
                 cfgReadInfo(Mdm.c115200,inNormal,chNormal,'',True);
                 Mdm.c115200 := cfgRead;
                 cfgSetItem(Mdm.c115200);
              end;
      end;
   until (HangUp) or (cfgDone);
   cfgDone := False;
end;

procedure cfgCommunicationsSetup;
var oldBar : Byte;
begin
   mCursor(false);
   Mdm := Modem^;
   logWrite('*Communications/node setup [node '+st(node)+']');
   oldBar := 1;
   repeat
      cfgDraw := True;
      cfgOver := False;
      cfgInit('Communications Setup [node '+st(node)+']');
      cfgBarPos := oldBar;
      cfgItem('A Modem configuration',0,'','');
      cfgItem('B Command strings',0,'','');
      cfgItem('C Result strings',0,'','');
      cfgItem('D Connect strings',0,'','');
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;
      oldBar := cfgBarPos;
      case cfgKey of
        'A' : cfgModemConfig;
        'B' : cfgCommandStrings;
        'C' : cfgResultStrings;
        'D' : cfgConnectStrings;
      end;
   until (HangUp) or (cfgDone);
   cfgInfo('Save node configuration? ');
   if iYesNo(True,true) then
   begin
      Modem^ := Mdm;
      if (Modem^.ComDevice = NoDevice) or (not ModemOff) then ModemOff := True;
      fSaveModem(Node);
      initcommport(false);
   end;
end;

end.
