{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
unit Config3;

interface

procedure cfgStringEditor;

implementation

uses
   Crt, Global, Output, StrProc, Input, Files, Config, BBSinit, Logs, Misc;

const
   maxStr = 5;

var
   curStr : Integer;
   sStr : String;

function cfgStringHeader(N : Word) : String;
var S : String;
begin
   S := '';
   case N of

     strDetectEmu         : S := '[term]  Detecting emulation';
     strDetectNone        : S := '[term]  No emulation detected';
     strDetectANSi        : S := '[term]  ANSI detected';
     strDetectAVATAR      : S := '[term]  Avatar/ANSI detected';
     strDetectRIP         : S := '[term]  RIP/ANSI detected (terminal: %S1)';
     strNoAnsiDetected    : S := '[term]  Could not detect an Ansi-compatible terminal emulation';
     strNoAnsiAskContinue : S := '[term]  Proceed with login? (enable ANSI/Avt/RIP in your terminal first)';
     strNoAnsiContinuing  : S := '[term]  Proceeding with login; ANSI enabled';
     strDetectTextFX      : S := '[term]  TextFX detected! (environment: %S1)';

     strMenuPassword      : S := '[menu]  Menu password:';
     strMenuAccessDenied  : S := '[menu]  Menu access denied';
     strCmdAccessDenied   : S := '[menu]  Command access denied';
     strInvalidCommand    : S := '[menu]  Invalid menu command';
     strInvalidMnuCmd     : S := '[menu]  Invalid menu command: "%S1"';

     strLoginSystemPW     : S := '[login] Enter sysop login password:';
     strLoginName         : S := '[login] Enter your name, handle, or user number:';
     strLoginPassword     : S := '[login] Enter your password:';
     strLoginPhone        : S := '[login] Complete phone number: (###)###-';
     strLoginBDate        : S := '[login] Enter your birthdate [mm/dd/yy]:';
     strLoginUnknown      : S := '[login] Unknown user';
     strLoginError        : S := '[login] Login error';
     strLoginAskApply     : S := '[login] Apply as a NEW user?';
     strLoginHelpName     : S := '[login] Enter your name, handle or user number';
     strLoginHelpPw       : S := '[login] Enter your password';
     strLoginHelpPhone    : S := '[login] Please complete your phone number';
     strLoginHelpBirth    : S := '[login] Enter your birthdate';
     strLoginHelpApply    : S := '[login] Logon to system as a new user?';
     strLoginHelpSysPw    : S := '[login] Enter system password';
     strAskInvisibleLogin : S := '[login] Logon in invisible mode?';

     strNuHandle          : S := '[new]   Please select an alias:';
     strNuName            : S := '[new]   Enter your real first and last name:';
     strNuBirthDate       : S := '[new]   Enter your date of birth [mm/dd/yy]:';
     strNuPhoneNum        : S := '[new]   Enter your voice phone number:';
     strNuAddress         : S := '[new]   Enter your street address:';
     strNuLocation        : S := '[new]   Enter your city name:';
     strNuYesNoBar        : S := '[new]   Use yes/no selection bars?';
     strNuHotKey          : S := '[new]   Enable hotkeys for fast menu input?';
     strNuExpertMode      : S := '[new]   Enable "expert" mode?';
     strNuPassword        : S := '[new]   Please select a password:';
     strNuBadAlias        : S := '[new]   Invalid alias.  Please choose another';
     strNuDupUser         : S := '[new]   Duplicate user';
     strNuBadName         : S := '[new]   Invalid name';
     strNuFullName        : S := '[new]   You must enter your first AND last name';
     strNuBadBirth        : S := '[new]   Invalid birthdate';
     strNuSmallPassword   : S := '[new]   Password too short.  It must be at least 4 characters in length';
     strNuValidatePW      : S := '[new]   Enter your password again for verification:';
     strNuPWnoMatch       : S := '[new]   Password do not match.  Try again';
     strNuSavingInfo      : S := '[new]   Saving new user information ...';
     strNuYourAgeIs       : S := '[new]   You are %S1 years old';
     strNuAskSex          : S := '[new]   Your sex? [m]ale [f]emale:';
     strNuEnterNewUserPW  : S := '[new]   Enter new user password:';
     strNuBadNewUserPW    : S := '[new]   Incorrect newuser password';
     strNuAskPageLen      : S := '[new]   Enter your screen length in rows:';
     strNuAskState        : S := '[new]   Enter your state or province abbreviation:';
     strNuPausing         : S := '[new]   Enable screen pausing?';
     strNuAutoQuote       : S := '[new]   Use reply AutoQuoting?';
     strNuAskCountry      : S := '[new]   Your country? [U]nited States / [C]anada / [O]ther:';
     strNuEnterCountry    : S := '[new]   Enter the name of your country:';
     strNuEnterZipCode    : S := '[new]   Enter your postal/zip code [format: %S1]:';
     strNuAskApply        : S := '[new]   Proceed with new user application process?';

     strChatInitiate      : S := '[chat]  - Chat mode initiated -';
     strChatTerminate     : S := '[chat]  - Chat mode terminated -';
     strPageAskWhy        : S := '[chat]  Why do you wish to chat with the SysOp?:';
     strPageSysOpNotAvail : S := '[chat]  The SysOp is currently not available to chat.  Try leaving mail';
     strPagePaging        : S := '[chat]  Paging!';
     strPageNoAnswer      : S := '[chat]  Sorry, the SysOp was unable to answer your page';
     strPageNoMore        : S := '[chat]  Sorry, you can''t page the sysop (maximum per call = %S1)';
     strPageAskOverride   : S := '[chat]  Chat availability is disabled.  Do you wish to override?';
     strPageAskPassword   : S := '[chat]  Enter chat override password:';
     strPageBadPw         : S := '[chat]  Incorrect override password.';
     strPageBegin         : S := '[chat]  Paging sysop ... (press any key to abort page)';
     strPageLeaveEmail    : S := '[chat]  Send email to the sysop (%S1)?';

     strFsAskAbort        : S := '[fse]   Abort message?';
     strFsAskCommand      : S := '[fse]   Message editor command [?/help]:';
     strFsCommandHelp     : S := '[fse]   Enter '+bbsTitle+' message editor command.  Hit ''?'' for help';
     strFsSavingMsg       : S := '[fse]   Saving message ...';
     strFsAskClear        : S := '[fse] Clear Message?';

     strMsgNoPostAcs      : S := '[msg]   You don''t have post access in this message area';
     strMsgAskWhoTo       : S := '[msg]   Message destination:';
     strMsgAskPrivate     : S := '[msg]   Private message?';
     strMsgAskTitle       : S := '[msg]   Enter message title:';
     strMsgaskselectscan  : S := '[msg]   Message area scan selection';
     strMsgToggledScanTrue: S := '[msg]   Message area will be scanned';
     strMsgToggledScanFalse:S := '[msg]   Message area will not be scanned';
     strMsgReadNoMsgs     : S := '[msg]   There are no messages in the current message area';
     strMsgReadStartAt    : S := '[msg]   Start reading at which message? [1-%S1] [current=%S2]:';
     strMsgReadPrompt     : S := '[msg]   Reading message %S1 of %S2 - Command [?/help,enter/next]:';
     strMsgReadAskPost    : S := '[msg]   Post a message in this area?';
     strMsgAlterTitle     : S := '[msg]   Enter new message title';
     strMsgQuoteFirst     : S := '[msg]   Enter first line of message to quote [1-%S1]:';
     strMsgQuoteSecond    : S := '[msg]   Enter second line of message to quote [%S1-%S2]:';
     strMsgDeleted        : S := '[msg]   Message deleted';
     strMsgUndeleted      : S := '[msg]   Message undeleted';
     strMsgNewScanInit    : S := '[msg]   Global message newscan initiated';
     strMsgNewScanDone    : S := '[msg]   Global message newscan completed';
     strMsgNewScanStart   : S := '[msg]   Message area %S1 - [%S2] messages, newscanning ...';
     strMsgNewScanEnd     : S := '[msg]   Message area %S1 - [%S2] messages, complete ...';
     strMsgNewScanAskAll  : S := '[msg]   Newscan all message areas?';
     strMsgPackStart      : S := '[msg]   Packing message area [%S1] - %S2 msgs ...';
     strMsgPackEnd        : S := '[msg]   Message packing complete';
     strMsgPackAskAll     : S := '[msg]   Pack all message areas?';
     strAnonymous         : S := '[msg]   Anonymous';
     strMsgAskAnonymous   : S := '[msg]   Post anonymously?';
     strMsgReadMandatory  : S := '[msg]   You must read all of the messages in this area!';
     strMsgSetPointer     : S := '[msg]   Message base newscan pointer set to current message';
     strMsgAskChangeArea  : S := '[msg]   Change to which message area?';
     strMsgChangedAreas   : S := '[msg]   Current message area is now %S1';
     strMsgAskPointer     : S := '[msg]   Enter new message pointer date [mm/dd/yy]:';
     strMsgAskAllPointers : S := '[msg]   Update all message area pointers?';
     strMsgAskUploadMsg   : S := '[msg]   Upload prepared message?';
     strMsgScanMandatory  : S := '[msg]   Scanning for mandatory messages...';
     strMsgAskPassword    : S := '[msg]   Enter password for this message area:';
     strMsgAskQuote       : S := '[msg]   AutoQuote text from message?';
     strMsgPublicPosted   : S := '[msg]   Message posted in area: %S1';
     strMsgLowestArea     : S := '[msg]   Lowest accessible message area';
     strMsgHighestArea    : S := '[msg]   Highest accessible message area';
     strMsgNewscanAskConfs: S := '[msg]   Scan all message conferences?';
     strMsgCopyAskDest    : S := '[msg]   Copy message to which area?';
     strMsgMoveAskDest    : S := '[msg]   Move message to which area?';
     strMsgQuoteHeader    : S := '[msg]   %S1 said the following';
     strMsgQuoteFooter    : S := '[msg]   %S1 stopped talking';

     strDidYouMeanUser    : S := '[msg]   Did you mean %S1?';

     strBBSaskName        : S := '[bbs]   Enter the name of the BBS to add:';
     strBBSexists         : S := '[bbs]   That BBS already exists in the list!';
     strBBSaskPhone       : S := '[bbs]   Enter BBS phone number:';
     strBBSaskSysOp       : S := '[bbs]   Enter SysOp of the BBS:';
     strBBSaskBaud        : S := '[bbs]   Enter the BBS''s maximum baudrate:';
     strBBSaskSoftware    : S := '[bbs]   Enter BBS software:';
     strBBSaskStorage     : S := '[bbs]   Enter the BBS''s maximum storage in megabytes:';
     strBBSaskInfo        : S := '[bbs]   Other info:';
     strBBSsavingEntry    : S := '[bbs]   Adding BBS to list ...';
     strBBSaskSaveBBS     : S := '[bbs]   Save this system to BBS list?';
     strBBSnoSystems      : S := '[bbs]   There are currently no BBSs in the list';
     strBBSshowOne        : S := '[bbs]   Enter system number to display [1-%S1]:';
     strBBSdeleteOne      : S := '[bbs]   Remove which BBS from list? [1-%S1]:';
     strBBSverifyKill     : S := '[bbs]   Delete this system?';
     strBBSclearAll       : S := '[bbs]   Clear the entire BBS list?';
     strBBSisIniquity     : S := '[bbs]   Bbs added is iniquity';
     strBBStelnet         : S := '[bbs]   Is this a telnet board?';
     strBBSaskAddress     : S := '[bbs]   Telnet address';

     strEmailUserUnknown  : S := '[email] That user doesn''t exist';
     strEmailNoMail       : S := '[email] You currently have no mail waiting';
     strEmailSelectToRead : S := '[email] Begin reading at which message? [1-%S1]:';
     strEmailReadPrompt   : S := '[email] Reading email %S1 of %S2 - Command [?/help,enter/next]:';
     strEmailNoAccess     : S := '[email] Email access denied';
     strEmailKillOriginal : S := '[email] Delete original message?';
     strEmailAskRead      : S := '[email] You have email.  Read it?';
     strEmailSent         : S := '[email] Email sent to %S1';
     strEmailAskKillAll   : S := '[email] Delete all read email?';
     strEmailAskNetmail   : S := '[email] Is this a netmail message?';
     strEmailAskAddress   : S := '[email] Enter address in z:n/n.p format';
     strEmailAskOriginAddr: S := '[email] Send using which AKA?';

     strAutoSigChanged    : S := '[sig]   AutoSig saved';
     strAutoSigAskDelete  : S := '[sig]   Delete current AutoSig?';
     strAutoSigDeleted    : S := '[sig]   AutoSig deleted';
     strAutoSigShow       : S := '[sig]   Current AutoSig:';
     strAutoSigNone       : S := '[sig]   You have no AutoSig';
     strAutoSigAskUpload  : S := '[sig]   Upload prepared AutoSignature?';

     strConfMsgSelect     : S := '[conf]  Select message conference to join [?/list]:';
     strConfFileSelect    : S := '[conf]  Select file conference to join [?/list]:';
     strConfMsgChanged    : S := '[conf]  Joined message conference: %S1';
     strConfFileChanged   : S := '[conf]  Joined file conference: %S1';

     strAtchAskDesc       : S := '[atch]  Enter description of attached file:';
     strAtchFileAttached  : S := '[atch]  File "%S1" successfully attached to message';
     strAtchAlreadyInc    : S := '[atch]  There is already a file attached to this message.  Replace it?';
     strAtchIsAttached    : S := '[atch]  There is a file attached to this message';
     strAtchShowDesc      : S := '[atch]  Attached file description: %S1';
     strAtchShowInfo      : S := '[atch]  Attached file name: %S1, size: %S2';
     strAtchAskDownload   : S := '[atch]  Do you wish to download this file now?';

     strFaAskFileDownload : S := '[file]  Enter filename to download:';
     strFaSearching       : S := '[file]  Searching for file ...';
     strFaFileNotFound    : S := '[file]  File not found';
     strFaFoundInArea     : S := '[file]  %S1 found in file area: %S2';
     strFaFileNotThere    : S := '[file]  File %S1 does not actually exist';
     strFaDownloadPrompt  : S := '[file]  File download -- [Enter/C] Continue, [Esc/A] Abort:';
     strFaNoTimeForDL     : S := '[file]  %S1: Insufficient time remaining for download';
     strFaNewScanning     : S := '[file]  File area %S1 - [%S2] files, newscanning...';
     strFaNewScanAskAll   : S := '[file]  Newscan all file areas?';
     strFaAskNewScanDate  : S := '[file]  Enter file newscan date [mm/dd/yy]:';
     strFaNoFilePts       : S := '[file]  %S3: Insufficient file points for file [have: %S1; need: %S2]';
     strFaOverDLlimit     : S := '[file]  %S2 would exceed your daily download limit of %S1 files p/day';
     strFaOverDLkbLimit   : S := '[file]  %S2 would exceed your daily download kb limit of %S1kb p/day';
     strFaFileNotValid    : S := '[file]  Sorry, %S1 has not yet been validated';
     strFaAskPassword     : S := '[file]  Enter password for this file area:';
     strFaAskChangeArea   : S := '[file]  Change to which file area?';
     strFaAskSelectScan   : S := '[file]  File area scan selection';
     strFaToggledScanTrue : S := '[file]  File area will be scanned';
     strFaToggledScanFalse: S := '[file]  File area will not be scanned';
     strFaChangedAreas    : S := '[file]  Current file area is now %S1';
     strFaNoFilesInArea   : S := '[file]  Sorry, this file area contains no files';
     strFaSortStart       : S := '[file]  Sorting file area [%S1] - %S2 files...';
     strFaSortEnd         : S := '[file]  Sorting complete';
     strFaSortAskAll      : S := '[file]  Sort all file areas?';
     strFaAskListFiles    : S := '[file]  Enter filespec to list [Enter for all]';
     strFaNoMatchingFiles : S := '[file]  No matching files found';
     strFaBatchFull       : S := '[file]  Sorry, your download batch is full';
     strFaBatchAskAdd     : S := '[file]  Enter filename to add to batch:';
     strFaBatchAdded      : S := '[file]  File "%S1" added to batch';
     strFaBatchFileDL     : S := '[file]  Selected for download: %S1 [size = %S2 bytes, time = %S3]';
     strFaBatchDLtotal    : S := '[file]  Total selected: %S1 files, %S2 bytes [time = %S3]';
     strFaBatchAskDL      : S := '[file]  %S1 files in batch, download them now?';
     strFaBatchAlready    : S := '[file]  That file is already in your download batch';
     strFaBatchCDROM      : S := '[file]  String displayed before a cdrom file is transfered';
     strFaXferFailed      : S := '[file]  Transfer failed';
     strFaXferSuccess     : S := '[file]  Transfer successful';
     strFaXferFilesSent   : S := '[file]  %S2 bytes sent in %S1 file(s)';
     strFaListInfo        : S := '[file]  Listing files - up/dn: file selector; left/right: lightbar';
     strFaListInfoBar     : S := '[file]  File selector - up/dn: filebar; left/right: menu lightbar';
     strFaViewAskFile     : S := '[file]  Enter archive name to view:';
     strFaInfoAskfile     : S := '[file]  Show information on which file?';
     strFaULnoAccess      : S := '[file]  You do not have upload access in this area';
     strFaDLnoAccess      : S := '[file]  You do not have download access in this area';
     strFaDLaccessDenied  : S := '[file]  %S1: Download access denied';
     strFaULenterFiles    : S := '[file]  Enter up to %S1 files to upload';
     strFaULenterToEnd    : S := '[file]  Hit ENTER on a blank line when done';
     strFaULenterFilename : S := '[file]  [%S1] File to upload:';
     strFaULfileExists    : S := '[file]  Sorry, %S1 is already on this BBS';
     strFaULaskDescNow    : S := '[file]  Enter file description(s) now or after transfer?';
     strFaULaddingFile    : S := '[file]  Adding %S1 to file area ...';
     strFaULfileAdded     : S := '[file]  %S1 added [%S2 line description]';
     strFaULdescribe      : S := '[file]  Enter file description for %S1.  Blank line when done';
     strFaULdescLine      : S := '[file]  Desc line #%S1:';
     strFaULDLratioBad    : S := '[file]  %S1 would put your UL/DL ratio out of balance';
     strFaKBratioBad      : S := '[file]  %S1 would put your UL/DL kilobyte ratio out of balance';
     strFaLowestArea      : S := '[file]  Lowest accessible file area';
     strFaHighestArea     : S := '[file]  Highest accessible file area';
     strFaSearchAskFile   : S := '[file]  Enter filespec to search for:';
     strFaSearchAskAll    : S := '[file]  Search all file areas?';
     strFaSearchAskConfs  : S := '[file]  Search all file conferences?';
     strFaSearchArea      : S := '[file]  Searching file area %S1 ...';
     strFaSearchNone      : S := '[file]  No matching files found';
     strFaULfileFound     : S := '[file]  Blind upload detected.  Found: %S1';
     strFaULaskBlind      : S := '[file]  Perform a "blind" upload?';
     strFaSearchAskDesc   : S := '[file]  Enter text to search for:';
     strFaXferDlPts       : S := '[file]  %S1 files points have been deducted from your account';
     strFaXferUlPts       : S := '[file]  You have been awarded %S1 file points for your upload';
     strFaDlStats         : S := '[file]  You have downloaded a total of %S1 file(s), %S2 bytes';
     strFaUlStats         : S := '[file]  You have uploaded %S1 file(s), a total of %S2 bytes';
     strFaXferAskAutoOff  : S := '[file]  Auto-logoff when file transfer is done?';
     strFaXferAutoLogoff  : S := '[file]  Auto-logout in %S1 seconds; [enter] stay online, [h] hangup';
     strXferSending       : S := '[file]  Initiating file transfer [protocol: %S1] ...';
     strXferReceiving     : S := '[file]  Waiting for file(s); please initiate %S1 upload now ...';
     strFaNewscanAskConfs : S := '[file]  Scan all file conferences?';
     strFaBatchEdit       : S := '[file]  Download batch editor - (a)dd file, (r)emove, (c)lear, (esc)exit';
     strFaBatchRemoved    : S := '[file]  Removed file "%S1" from download batch queue';
     strFaBatchCleared    : S := '[file]  Download batch queue has been cleared';


     strQwkDLaskCurConf   : S := '[qwk]   Gather messages from current conference only?';
     strQwkDLerror        : S := '[qwk]   Error encountered while creating QWK message packet, inform SysOp';
     strQwkDLaskDownload  : S := '[qwk]   QWK packet size: %S1 bytes ... Download it?';
     strQwkDLnoNewMsgs    : S := '[qwk]   Sorry, there are no new messages';
     strQwkDLaskUpdatePtrs: S := '[qwk]   Update message area newscan pointers?';
     strQwkDLupdatingPtrs : S := '[qwk]   Updating message pointers ... Please wait';
     strQwkULerror        : S := '[qwk]   Error encountered while processing REP packet, inform SysOp';
     strQwkULalready      : S := '[qwk]   This REP packet has already been uploaded!';
     strQwkDLownMsgs      : S := '[qwk]   Include your own messages in packet?';

     strFaTestCRCok       : S := '[scan]  %S1 passed integrity (CRC) check';
     strFaTestCRCfail     : S := '[scan]  %S1 failed integrity check!';
     strFaTestDecompOk    : S := '[scan]  %S1 decompressed successfully';
     strFaTestDecompFail  : S := '[scan]  Error decompressing %S1!';
     strFaTestVirusOk     : S := '[scan]  %S1 passed virus scan';
     strFaTestVirusFail   : S := '[scan]  %S1 failed virus scan!';
     strFaTestAgeOk       : S := '[scan]  %S1 passed age test.  File date: %S2';
     strFaTestAgeFail     : S := '[scan]  %S1 failed age test!  File date: %S2';
     strFaTestFilesRemoved: S := '[scan]  Useless files removed from %S1';
     strFaTestFilesAdded  : S := '[scan]  Necessary files added to %S1';
     strFaTestCommented   : S := '[scan]  BBS file comment successfully added to %S1';
     strFaTestExternal    : S := '[scan]  External maintenence on %S1 complete';
     strFaTestDescFound   : S := '[scan]  Description found in %S1';
     strFaTestNoDesc      : S := '[scan]  No description found in %S1';
     strFaTestSauceFound  : S := '[scan]  Sauce description found in %S1';
     strFaTestNoSauce     : S := '[scan]  %S1 does not contain a sauce description';
     strFaTestPassed      : S := '[scan]  %S1 has passed all file tests';
     strFaTestFailed      : S := '[scan]  %S1 failed';
     strFaTestBadZip      : S := '[scan]  Bad zip archive';

     strPwAskOld          : S := '[pass]  Enter current password:';
     strPwWrong           : S := '[pass]  Incorrect password';
     strPwNewPassword     : S := '[pass]  Enter your new password:';
     strPwTooSmall        : S := '[pass]  Password must be at least 4 characters long';
     strPwValidate        : S := '[pass]  Verify new password:';
     strPwNoMatch         : S := '[pass]  Passwords do not match!';
     strPwChanged         : S := '[pass]  Password successfully changed';

     strNuvScanning       : S := '[nuv]   Checking for new users to vote on ...';
     strNuvVote           : S := '[nuv]   Your vote for %S1? [y)es n)o a)bstain i)nfoforms]';
     strNuvAskComment     : S := '[nuv]   Leave a comment about this user?';
     strNuvComment        : S := '[nuv]   Enter nuv comment:';
     strNuvValidated      : S := '[nuv]   %S1 has been auto-validated by NUV';
     strNuvDeleted        : S := '[nuv]   %S1 has been deleted by NUV';
     strNuvNoInfoforms    : S := '[nuv]   No NUV infoforms exist for this user';
     strNuvIsDisabled     : S := '[nuv]   New user voting is disabled on this BBS';
     strNuvNone           : S := '[nuv]   There are no new users to vote on';

     strMNCyouspeak       : S := '[mnc]   :%S1: %S2 (your public messages)';
     strMNCtheyspeak      : S := '[mnc]   <%S1> %S2 (other node''s public messages)';
     strMNCenterchat      : S := '[mnc]   %S1 has entered multinode chat';
     strMNCquitchat       : S := '[mnc]   %S1 has quit multinode chat';
     strMNCmsgsent        : S := '[mnc]   Successful page message';
     strMNCusrnotfound    : S := '[mnc]   Failed page message';
     strMNCyoumsg         : S := '[mnc]   *%s1* %s2 (your private message)';
     strMNCtheymsg        : S := '[mnc]   -%s1- %s2 (other node''s private message)';
     strMNCmsgnotsent     : S := '[mnc]   Private message not sent';
     strMNCaction         : S := '[mnc]   %s1 %s2 (username,action)';

     strNodeAskNode       : S := '[node]  Enter node # or username to send text to [?/list] ';
     strNodeUserOn        : S := '[node]  Node #%S1 - %S2 is online at %S3 bps';
     strNodeMsgAskText    : S := '[node]  Enter message to send:';
     strNodeMsgSent       : S := '[node]  Message sent to %S1 on node %S2';
     strNodeMsgReceived   : S := '[node]  Message received from %S1 on node %S2:';
     strNodeBCaskText     : S := '[node]  Enter message to broadcast:';
     strNodeBCsent        : S := '[node]  Broadcast sent to all nodes';
     strNodeBCreceived    : S := '[node]  Received system-wide broadcast from %S1 on node %S2:';
     strNodeNotMulti      : S := '[node]  This is not a multi-node BBS, function disabled';


     strTbnkAskDeposit    : S := '[bank] Deposit how much time? ';
     strTbnkAskWithdraw   : S := '[bank] Withdraw how much time? ';
     strTbnkDOverMax      : S := '[bank] Can''t deposit %S1 min. You have a max of %S2';
     strTbnkDNoTimeLeft   : S := '[bank] Can''t deposit %S1 min. You only have %S2 left';
     strTbnkDTooMuchTime  : S := '[bank] Can''t deposit %S1 min. You have a max of %S2 per day';
     strTbnkWTooMuchTime  : S := '[bank] Can''t withdraw %S1 min. You have a max of %S2 per day';
     strTbnkWMoreThanInAccount : S := '[bank] Can''t withdraw %S1 min. You have %S2 in your account';
     strTbnkKbAskDeposit  : S := '[bank] Deposit how many kbytes?';
     strTbnkKbAskWithdraw : S := '[bank] Withdraw how many kbytes?';
     strTbnkDNotEnoughKb  : S := '[bank] Can''t deposit %S1 kbytes. You have %S2 kbytes left';
     strTbnkDOverMaxKB    : S := '[bank] Can''t deposit %S1 kbytes. You have a max of %S2';
     strTbnkDTooMuchKb    : S := '[bank] Can''t deposit %S1 kbytes. You have a max of %S2 per day';
     strTbnkWTooMuchKb    : S := '[bank] Can''t withdraw %S1 kbytes. You have a max of %S2 per day';
     strTbnkWOverwithdrawl: S := '[bank] Can''t withdraw %S1 kbytes. You have %S2 in your account';
     strTbnkWOverMax      : S := '[bank] Can''t withdraw %S1 kbytes. You can only withdraw %S2k per day';
     strTbnkapproved      : S := '[bank] Transaction approved';

     strVoteSelectAnswer  : S := '[vote] Select your answer';
     strVoteEnterQuestion : S := '[vote] Enter your question';
     strVoteAddChoice     : S := '[vote] Enter your answer text';
     strVoteEnterChoice   : S := '[vote] Select your answer';
     strVoteSelectQuestion: S := '[vote] Select a question';
     strVoteEnterAnswers  : S := '[vote] Enter your answers - blank answer to stop adding answers';
     strVoteAskAllowNewAns: S := '[vote] Allow other users to add answers?';
     strVoteAskOk         : S := '[vote] Add this question?';
     strVoteTooMuchQuestions:S:= '[vote] You can''t add more voting questions';
     strVotePressAToAddAnswer:S := '[vote] Press A to add an answer';
     strVoteAskViewResults: S := '[vote] View results?';
     strVoteNoQuestions   : S := '[vote] No voting questions.';
     strVoteAlreadyVoted  : S := '[vote] You already answered to that question.';
     strVoteAskChangeVote : S := '[vote] You already voted to that question. Change your vote?';
     strVoteDelete        : S := '[vote] Delete which voting question prompt';

     strInfoAskWhich      : S := '[info]  Fill out which infoform? [1-%S1]';
     strInfoAskReplace    : S := '[info]  This infoform has already been completed.  Continue?';

     strNoAutoMsg         : S := '[auto]  No automessage currently exists';
     strAutoMsgAnon       : S := '[auto]  Can''t reply to an anonymous automessage!';

     strJumpToDOS         : S := '[dos]   SysOp in DOS.  Please wait';
     strBackFromDOS       : S := '[dos]   SysOp has returned from DOS';

     strInUserEditor      : S := '[misc]  In user editor prompt';
     strConnectedAt       : S := '[misc]  Connected at %S1 baud';
     strAskSystemPW       : S := '[misc]  Sysop password:';
     strPause             : S := '[misc]  Paused - [s]top / [c]ontinuous';
     strHitAKey           : S := '[misc]  Press a key to continue';
     strTimeExpired       : S := '[misc]  Sorry, your time has expired';
     strInitBBS           : S := '[misc]  Initializing '+bbsTitle+'...';
     strTimeInactive      : S := '[misc]  Sorry, you have been auto-logged off due to inactivity';
     strBbsHangingUp      : S := '[misc]  Hanging up ...';
     strBbsMinBaudrate    : S := '[misc]  Minimum baudrate on this BBS: %S1, connected at: %S2';
     strBbsAskBaudPW      : S := '[misc]  Enter baud override password:';
     strEventNowBye       : S := '[misc]  System event initiating NOW!  Disconnecting ...';
     strXferSelectProtocol: S := '[misc]  Select protocol [CR/Abort]:';
   end;

   cfgStringHeader := S;
end;

procedure cfgWriteStrings;
var N : Byte;
begin
   for N := 1 to maxStr do if curStr+N-1 <= numString then
   begin
      oCWriteLn('|U1'+St(N)+'|U2:|U1'+z3(curStr+N-1)+
                '|U2, |U4'+cfgStringHeader(curStr+N-1));
      oSetCol(colInfo);
      oCWriteLn(mStr(curStr+N-1));
      oDnLn(1);
   end;
end;

procedure cfgEditString(N : Byte);
begin
   oDnLn(2);
   oSetCol(colInfo);
   oWriteLn(cfgStringHeader(curStr+N-1));
   oSetCol(colBorder);
   oWriteLn(sRepeat('',79));
   oSetCol(colInfoHi);
   mStrSet(curStr+N-1,
      iEditString(mStr(curStr+N-1),inNormal,chNormal,rsNoClean+rsSpace+rsAbort,255,79));
end;

procedure cfgSearchString;
var S : String; Col : Boolean; Fnd, N, ss1, ss2, sc1, sc2 : Word;
begin
   oDnLn(2);
   if sStr <> '' then oStrCtrLn('|U2-- |U1Current|U2: |U3'+strSquish(sStr,65));
   oStrCtr('|U2-- |U1Enter text to search for |U5[|U6enter|U5/|U4next|U5]: |U3');
   S := UpStr(iReadString('',inNormal,chNormal,rsNoClean+rsSpace,200));
   if S = '' then S := sStr;
   if S = '' then Exit;
   sStr := S;
   Col := NoColor(S) <> S;
   ss1 := curStr+maxStr;
   if ss1 > numString then ss1 := numString;
   ss2 := numString;
   sc1 := 1;
   sc2 := curStr+maxStr-1;
   Fnd := 0;
   for N := ss1 to ss2 do if Fnd = 0 then
   begin
      if Col then Fnd := Pos(sStr,UpStr(mStr(N))) else
                  Fnd := Pos(sStr,UpStr(NoColor(mStr(N))));
      if Fnd > 0 then Fnd := N;
   end;
   if Fnd = 0 then
   for N := sc1 to sc2 do if Fnd = 0 then
   begin
      if Col then Fnd := Pos(sStr,UpStr(mStr(N))) else
                  Fnd := Pos(sStr,UpStr(NoColor(mStr(N))));
      if Fnd > 0 then Fnd := N;
   end;
   if Fnd > 0 then
   begin
      curStr := Fnd;
      if curStr > numString-maxStr+1 then curStr := numString-maxStr+1;
   end;
end;

procedure cfgGotoString;
var S : String; N : Word;
begin
   oDnLn(2);
   oStrCtr('|U2-- |U1Enter string number to jump to |U5[|U41|U5-|U4'+St(numString)+'|U5] |U3');
   S := iReadString('',inNormal,chNumeric,'',3);
   if S = '' then Exit;
   n := strToInt(s);
   if (n = 0) or (n > numString) then Exit;
   curStr := n;
   if curStr > numString-maxStr+1 then curStr := numString-maxStr+1;
end;

{ --- added by ck --------------------------------------------------------------------------- }
procedure cfgResetString;
var N : Word; {removed 'S:string;'  wasnt used --horrid }
    Ch : char;
begin
   oDnLn(2);
   oStrCtr('|U2-- |U1Enter string number to reset |U5[|U41|U5-|U45|U5] |U3');
   repeat
     Ch := UpCase(iReadKey);
   until (HangUp) or (Ch in ['1'..'5',#27]);
   if Hangup then Ch := #27;


   if Ch = #27 then Exit;   {changed S=#37 to Ch=#27. see above. --horrid }
   n := strToInt(Ch);
   if (n = 0) or (n > numString) then Exit;
   mStrSet(curStr+n-1,resetString(curStr+n-1));
end;
{ --- end of changes by ck ------------------------------------------------------------------- }


{ --Added by Horrid, copies string to buffer ---}
procedure cfgCopyString(var copiedString : String);
var N : Word;
    Ch : Char;
begin
   oDnLn(2);
   oStrCtr('|U2-- |U1Enter string number to copy |U5[|U41|U5-|U45|U5] |U3');
    repeat
      Ch := UpCase(iReadKey);
    until (HangUp) or (Ch in ['1'..'5',#27]);
    if Hangup then Ch := #27;
    if Ch = #27 then Exit;
    n := strToInt(Ch);
    if (n = 0) or (n > numString) then Exit;
    copiedString := mStr(curStr+n-1);
end;


{ Paste the string in the buffer from cfgCopyString }
procedure cfgPasteString(var copiedString : String);
var N : Word;
    Ch : char;
    begin
       { If they haven't copied a string then don't allow them to paste! }
       if copiedString = '' then begin
          oDnLn(1);
          oStrCtr('|U2-- |U1You have not copied a string!');
          oDnLn(1);
          oPromptKey;
          exit;
       end;
       oDnLn(2);
       oStrCtr('|U2-- |U1Enter string number to paste |U5[|U41|U5-|U45|U5] |U3');
       repeat
         Ch := UpCase(iReadKey);
       until (HangUp) or (Ch in ['1'..'5',#27]);
       if Hangup then Ch := #27;
       if Ch = #27 then Exit;
       n := strToInt(Ch);
       if (n = 0) or (n > numString) then Exit;
   { set the string they choose to the copied string }
   mStrSet(curStr+n-1,copiedString);
end;

{ --- End of changes by horrid --- }





procedure cfgStringEditor;
var Ch : Char;              {changed string editor to use 2 lines--horrid}
    cmdStrEdit : array[1..4] of String; {changed from 1..9 to 1..4}
    cmdStrEdit2 : array[1..5] of String;{added this array for line2}
    copiedString : String;
begin
   copiedString  := '';
   cmdStrEdit[1] := '[ Previous';
   cmdStrEdit[2] := '] Next';
   cmdStrEdit[3] := '1-5 Edit string';
   cmdStrEdit[4] := '= Jump';
   cmdStrEdit2[1] := '/ Search';
   cmdStrEdit2[2] := 'R Reset'; { added by ck }
   cmdStrEdit2[3] := 'C Copy';  { added by horrid }
   cmdStrEdit2[4] := 'P Paste'; { added by horrid }
   cmdStrEdit2[5] := 'Esc Quit';
   curStr := 1;
   cfgDone := False;
   sStr := '';
   logWrite('*Strings edited.');
   StringEdit := True;
   mCursor(false);
   repeat
      oClrScr;
      cfgWriteStrings;
      oDnLn(1);                { doubled this, horrid }
      cfgPrompt2(cmdStrEdit,4);
      oDnLn(1);
      cfgPrompt(cmdStrEdit2,5);
      repeat
         Ch := UpCase(iReadKey);                 { added 'P' 'C' --horrid }
      until (HangUp) or (Ch in ['1'..'5','[',']','/','=','R','P','C',#27]);
      if HangUp then Ch := #27;
      if Ch = #27 then oWrite('Quit') else oWriteChar(Ch);

      case Ch of
         #27 : cfgDone := True;
         '1'..'5' : cfgEditString(StrToInt(Ch));
         '/' : cfgSearchString;
         '=' : cfgGotoString;
         '[' : begin Dec(curStr,maxStr); if curStr < 1 then curStr := numString-maxStr+1; end;
         ']' : begin Inc(curStr,maxStr); if curStr > numString then curStr := 1; end;
         'R' : cfgResetString;  { added ck? }
         'C' : cfgCopyString(copiedString);   { added horrid }
         'P' : cfgPasteString(copiedString);  { added horrid }
      end;
   until (HangUp) or (cfgDone);
   oDnLn(2);
{  oSetCol(colInfo);
   oWrite('Save changes? ');
   if iYesNo(True) then fSaveStrings else fLoadStrings;}
   StringEdit := False;
end;
end.
