{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
unit Config7;

interface

procedure cfgProtocolEditor;

implementation

uses
   WinDos, Global, StrProc, Config, Output, Input, Menus, Files, Misc,
   bbsInit, MsgArea, Logs, Transfer;

procedure cfgProtocolEditor;
var optCode : array[1..2] of String; optType : array[1..7] of String;
    curProt, Z, lt : Byte; B : Boolean; X : Byte;
begin
   optType[1] := 'External';
{   optType[2] := 'Xmodem';
   optType[3] := 'Ymodem';
   optType[4] := 'Ymodem-G';
   optType[5] := 'Zmodem';
   optType[6] := 'Kermit';
   optType[7] := 'Ascii';}

   optCode[1] := 'Transfer successful';
   optCode[2] := 'Transfer failed';
   curProt := 1;
   logWrite('*Protocol edit');
   xferLoadProt(curProt);

   prot^.ptype:=1;  { <------- }

   if (prot^.ptype < 1) or (prot^.ptype > 7) then prot^.ptype := 1;
   cfgOver := False;
   cfgDraw := True;
   repeat
      cfgInit(bbsTitle+' Protocol Editor');
      cfgCol := 25;
      cfgItem('--Current protocol #',2,St(curProt),'');
      Dec(cfgLn);
      cfgCol := 50;
      cfgSrt := 40;
      cfgItem('[ Prev',0,'','');
      cfgSrt := 60;
      cfgCol := 70;
      Dec(cfgLn);
      cfgItem('] Next',0,'','');
      cfgSrt := 1;
      cfgCol := 25;
{      if cfgDraw then Dec(cfgBot,2);
      cfgItem('A Protocol type',12,cfgOption(optType,prot^.ptype),
              'Type of file negotiation protocol');
      Dec(cfgLn);}
      cfgSrt := 40;
      cfgCol := 65;
      cfgItem('B Description',14,Prot^.Desc,
              'Text that will appear when listed on the protocol menu');
      cfgSrt := 1;
      cfgCol := 25;
      cfgItem('1 Active protocol',3,b2st(protActive in Prot^.Flag),
              'Is this protocol currently active or disabled?');
      Dec(cfgLn);
      cfgSrt := 40;
      cfgCol := 65;
      cfgItem('2 Batch protocol',3,b2st(protBatch in Prot^.Flag),
              'Is this protocol used in batch (multiple file) transfers?');
      cfgSrt := 1;
      cfgCol := 25;
      cfgItem('3 Bidirectional',3,b2st(protBiDir in Prot^.Flag),
              'Is this protocol bidirectional? (simultaneous two-way, NOT SUPPORTED YET)');
      Dec(cfgLn);
      cfgSrt := 40;
      cfgCol := 65;
      cfgItem('4 Activation key',1,Prot^.Key,
              'Key pressed to select this protocol');
      cfgSrt := 1;
      cfgCol := 25;
      if cfgDraw then Dec(cfgBot,3);
      cfgItem('C Access required',20,Prot^.Acs,
              'Access condition required to initiate this protocol');
      if prot^.ptype = 1 then
      begin
         cfgItem('D Log file',25,Prot^.Log,
                 'Log file with transfer result. %TD=workdir, %ND=node');
         cfgItem('E Receive command',53,Prot^.cmdUL,
{$IFNDEF OS2}
                 'Recv command: %CP=comport, %BR=bps, %PR=baud, %FN=file');
{$ELSE}
                 'Recv macros: %CP=comport, %CH=comhandle, %BR=bps, %PR=baud, %FN=file');
{$ENDIF}
         cfgItem('F Send command',53,Prot^.cmdDL,
{$IFNDEF OS2}
                 'Send command: %CP=comport, %BR=bps, %PR=baud, %FN=file/%FL=batch');
{$ELSE}
                 'Send macros: %CP=comport, %CH=comhandle, %BR=bps, %PR=baud, %FN=file/%FL=batch');
{$ENDIF}
         cfgItem('G Filename position',5,St(Prot^.posFile),
                 'Position in log file where the filename is located.');
         cfgItem('H Status position',5,St(Prot^.posStat),
                 'Position in log file where transfer status is located.');
         cfgItem('I Batch list filename',25,Prot^.listDL,
                 'Filename to store download batch list in. %TD=workdir, %ND=node');
         cfgItem('J Environment cmd',40,Prot^.cmdEnv,
                 'Environment command to be set when executing protocol. %LF=logfile');
         cfgItem('K Result code means',20,cfgOption(optCode,Prot^.codeIs),
                 'Do codes mean success or failure?');

         for Z := 1 to 2 do  { was 1 to 6, coma }
         cfgItem(Chr(Ord('L')-1+Z)+' Receive code #'+St(Z),6,Prot^.codeUL[Z],
                 'Result code number '+St(Z)+' when receiving files.');
         Dec(cfgLn,2);{6}
         cfgCol := 65;
         cfgSrt := 40;
         for Z := 1 to 2 do { was 1 to 6,  coma }
         cfgItem(Chr(Ord('R')-1+Z)+' Send code #'+St(Z),6,Prot^.codeDL[Z],
                 'Result code number '+St(Z)+' when sending files.');
         if cfgDraw then Dec(cfgBot,3);
      end else
      begin
         if prot^.ptype in [3..6] then
            cfgPut('|u5### |u4Note|u5: |u4This protocol is internal |u5[supports single and batch transfers]') else
            cfgPut('|u5### |u4Note|u5: |u4This protocol is internal |u5[supports only single file transfers]');
      end;
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;
      case cfgKey of
        'A' : begin
                 lt := prot^.ptype;
                 cfgReadOption(optType,7,prot^.ptype);
                 cfgSetItem(cfgOption(optType,prot^.ptype));
                 if ((prot^.ptype = 1) and (lt <> 1)) or
                    ((prot^.ptype <> 1) and (lt = 1)) then
                 begin
                    cfgOver := False;
                    cfgDraw := True;
                 end;
              end;
        'B' : begin
                 cfgEditInfo(Prot^.Desc,36,inNormal,chNormal,rsNoClean,False);
                 Prot^.Desc := cfgRead;
                 cfgSetItem(Prot^.Desc);
              end;
        '1' : begin
                 B := protActive in Prot^.Flag;
                 cfgReadBoolean(B);
                 cfgSetItem(b2st(B));
                 if B then Prot^.Flag := Prot^.Flag+[protActive] else
                           Prot^.Flag := Prot^.Flag-[protActive];
              end;
        '2' : begin
                 B := protBatch in Prot^.Flag;
                 cfgReadBoolean(B);
                 cfgSetItem(b2st(B));
                 if B then Prot^.Flag := Prot^.Flag+[protBatch] else
                           Prot^.Flag := Prot^.Flag-[protBatch];
              end;
        '3' : begin
                 B := protBiDir in Prot^.Flag;
                 cfgReadBoolean(B);
                 cfgSetItem(b2st(B));
                 if B then Prot^.Flag := Prot^.Flag+[protBiDir] else
                           Prot^.Flag := Prot^.Flag-[protBiDir];
              end;
        '4' : begin
                 cfgReadInfo(Prot^.Key,inUpper,chAlpha,'',False);
                 Prot^.Key := cfgRead[1];
                 cfgSetItem(Prot^.Key);
              end;
        'C' : begin
                 cfgReadInfo(Prot^.Acs,inLower,chNormal,'',False);
                 Prot^.Acs := cfgRead;
                 cfgSetItem(Prot^.Acs);
              end;
        'D' : begin
                 cfgReadInfo(Prot^.Log,inUpper,chDirectory,'',False);
                 Prot^.Log := cfgRead;
                 cfgSetItem(Prot^.Log);
              end;
        'E' : begin
                 cfgEditInfo(Prot^.cmdUL,78,inNormal,chNormal,'',False);
                 Prot^.cmdUL := cfgRead;
                 cfgSetItem(Prot^.cmdUL);
              end;
        'F' : begin
                 cfgEditInfo(Prot^.cmdDL,78,inNormal,chNormal,'',False);
                 Prot^.cmdDL := cfgRead;
                 cfgSetItem(Prot^.cmdDL);
              end;
        'G' : begin
                 cfgReadInfo(St(Prot^.posFile),inUpper,chNumeric,'',False);
                 Prot^.posFile := mClip(StrToInt(cfgRead),0,64000);
                 cfgSetItem(St(Prot^.posFile));
              end;
        'H' : begin
                 cfgReadInfo(St(Prot^.posStat),inUpper,chNumeric,'',False);
                 Prot^.posStat := mClip(StrToInt(cfgRead),0,64000);
                 cfgSetItem(St(Prot^.posStat));
              end;
        'I' : begin
                 cfgReadInfo(Prot^.listDL,inUpper,chDirectory,'',False);
                 Prot^.listDL := cfgRead;
                 cfgSetItem(Prot^.listDL);
              end;
        'J' : begin
                 cfgReadInfo(Prot^.cmdEnv,inNormal,chNormal,'',False);
                 Prot^.cmdEnv := cfgRead;
                 cfgSetItem(Prot^.cmdEnv);
              end;
        'K' : begin
                 cfgReadOption(optCode,2,Prot^.codeIs);
                 cfgSetItem(cfgOption(optCode,Prot^.codeIs));
              end;

        'L'..'Q' :
              begin
                 X := Ord(cfgKey)-Ord('L')+1;
                 cfgReadInfo(Prot^.codeUL[X],inNormal,chNormal,'',False);
                 Prot^.codeUL[X] := cfgRead;
                 cfgSetItem(Prot^.codeUL[X]);
              end;
        'R'..'W' :
              begin
                 X := Ord(cfgKey)-Ord('R')+1;
                 cfgReadInfo(Prot^.codeDL[X],inNormal,chNormal,'',False);
                 Prot^.codeDL[X] := cfgRead;
                 cfgSetItem(Prot^.codeDL[X]);
              end;
        '[' : begin
                 xferSaveProt(curProt);
                 lt := prot^.ptype;
                 Dec(curProt);
                 if curProt < 1 then curProt := maxProt;
                 xferLoadProt(curProt);
                 cfgDraw := True;
                 if ((prot^.ptype = 1) and (lt <> 1)) or
                    ((prot^.ptype <> 1) and (lt = 1)) then
                    cfgOver := False else cfgOver := True;
              end;
        ']' : begin
                 xferSaveProt(curProt);
                 lt := prot^.ptype;
                 Inc(curProt);
                 if curProt > maxProt then curProt := 1;
                 xferLoadProt(curProt);
                 cfgDraw := True;
                 if ((prot^.ptype = 1) and (lt <> 1)) or
                    ((prot^.ptype <> 1) and (lt = 1)) then
                    cfgOver := False else cfgOver := True;
              end;
      end;
   until (HangUp) or (cfgDone);
   xferSaveProt(curProt);
   cfgDone := False;
end;

end.
