unit extern;

{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
interface

procedure cfgExternal;
procedure cfgexternalcfg(i :byte);  {added nuitari}

implementation

uses fastio, output, input, config, global, strproc, misc;

procedure cfgExternal;      {Added Nuitari}
begin
   cfgDraw := True;
   cfgOver := False;
   repeat
      cfgInit('External Application Configuration');
      cfgItem('A WFC Screen External Application 1 Setup',0,'','');
      cfgItem('B WFC Screen External Application 2 Setup',0,'','');
      cfgItem('C WFC Screen External Application 3 Setup',0,'','');
      cfgItem('D WFC Screen External Application 4 Setup',0,'','');
      cfgItem('E WFC Screen External Application 5 Setup',0,'','');
      cfgItem('F WFC Screen External Application 6 Setup',0,'','');
      cfgItem('G WFC Screen External Application 7 Setup',0,'','');
      cfgItem('H WFC Screen External Application 8 Setup',0,'','');
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;
      if cfgkey = #27 then cfgdone := true;
      if cfgdone = false then cfgExternalCfg(byte(UpCase(cfgKey))-64);

   until (HangUp) or (cfgDone);
   cfgDone := False;
end;

procedure cfgExternalCfg(i : byte);
var optDropFiles : array[1..8] of String;  {was [1..4] nuitari}
    num : byte;
    Door : byte;
begin
   num := i;
   optDropFiles[1] := 'None';
   optDropFiles[2] := 'DorinfoX.def';
   optDropFiles[3] := 'Door.sys';
   optDropFiles[4] := 'Chain.txt';
   optDropFiles[5] := 'doorfile.sr';           {added nuitari}
   optDropFiles[6] := 'callinfo.bbs';          {added nuitari}
   optDropFiles[7] := 'sfdoors.dat';           {added nuitari}
   optDropFiles[8] := 'door.sys (readback)';   {added nuitari}
   cfgDraw := True;
   cfgOver := False;
   repeat
      cfgInit('External Application '+St(Num)+' Setup');
      cfgItem('A Name',14,Cfg^.externalNames[num],
      'Name of the program.');
      cfgItem('B Command Line',45,Cfg^.externalCmds[num],
      'Command to start the application with.');
      cfgItem('C Door File type',20,cfgOption(optDropFiles,Cfg^.ExternalDoors[num]+1),
              'Door File to create');
      cfgItem('[ Previous',0,'','');
      cfgItem('] Next',0,'','');

      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;

      case cfgKey of
       'A' : begin
                 cfgReadInfo(Cfg^.externalNames[Num],inNormal,chNormal,'',False);
                 Cfg^.externalNames[Num] := cfgRead;
                 cfgSetItem(cfg^.externalNames[Num]);
             end;
       'B' : begin
                 cfgReadInfo(Cfg^.externalCmds[Num],inNormal,chNormal,'',False);
                 Cfg^.externalCmds[Num] := cfgRead;
                 cfgSetItem(cfg^.externalCmds[Num]);
             end;
       'C' : begin
                 Door := Cfg^.externalDoors[Num]+1;
                 cfgReadOption(optDropFiles,8,Door); {was ,4,door) nuitari}
                 Cfg^.externalDoors[Num] := Door - 1;
                 cfgSetItem(cfgOption(optDropFiles,Door));
             end;
       ']' : begin;
              inc(num,1);
              if num > 8 then num := 1;
              cfgDraw := true;
             end;
       '[' : begin;
              if num > 1 then dec(num,1) else num := 8;
              cfgDraw := true;
             end;
       #27 :  cfgDone := true;
       end;
   until (HangUp) or (cfgDone);
end;

end.