program Ill2iNiQ;  {illusion to iniquity users.dat converter by: comatose }

uses
   WinDos, Crt, Global, Misc, FastIO, StrProc;

type

 AcRq               = '@'..'Z';        { AR flags }

{ User Listings from ILLUSION.INC in v2.03 }

  SmalRec=              { 1 - x }       { USERS.IDX : sorted names listing }
  record
    Name             : String[36];      { user name }
    Number           : Integer;         { user number }
  end;

  uFlags =                              { user AC Flags - stored in UserRec }
   (rLogon,                             { L - restricted to one call a day }
    rChat,                              { C - can't page the sysop }
    rValidate,                          { V - posts marked unvalidated }
    rFastLogon,                         { F - force fast logon }
    rAMsg,                              { A - can't change the automessage }
    rPostAn,                            { * - can't post anonymously }
    rPost,                              { P - can't post at all }
    rEmail,                             { E - can't send any e-mail }
    rVoting,                            { K - can't vote }
    rMsg,                               { M - force e-mail deletion }

    Rip,                                { user has rip }
    OneKey,                             { hotkey input mode }
    Avatar,                             { user has avatar }
    Pause,                              { pause is active }
    Novice,                             { expert mode is off (novice on) }
    Ansi,                               { user has ansi }

    res1,                               { reserved }

    Alert,                              { alert sysop when user logs on }
    Smw,                                { telegram waiting for user }
    NoMail,                             { user mailbox is closed }

    fNoDLRatio,                         { 1 - no UL/DL ratio }
    fNoPostRatio,                       { 2 - no post/call ratio }
    fNoFilePts,                         { 3 - no file points checking }
    fNoDeletion);                       { 4 - protection from deletion }

  tIllUserRec=           { 1 - x }       { USERS.DAT : user account records }
  record
    Name             : String[36];      { user name/alias }
    RealName         : String[36];      { real name }
    PW               : String[20];      { user password }
    Ph               : String[12];      { user phone number }
    Bday             : String[8];       { user birthdate }
    FirstOn          : String[8];       { date first applied }
    LastOn           : String[8];       { date last logged on }
    Street           : String[30];      { mailing address }
    CityState        : String[30];      { city, state, country }
    ZipCode          : String[10];      { zip/postal code }
    Computer         : String[30];      { type of computer }
    Occupation       : String[40];      { occupation }
    WhereBBS         : String[40];      { BBS reference }
    Note             : String[39];      { sysop note }
    UserNote         : String[25];      { user note }

    res1:Array[1..164] of Byte;         { reserved }

    LockedOut        : Boolean;         { locked out? }
    Deleted          : Boolean;         { deleted? }
    LockedFile       : String[8];       { lockout file to display (in TEXT) }

    AC               : set of uFlags;   { user flags (see above) }
    AR               : set of AcRq;     { AR flags }

    Vote             : Array[1..20] of Byte; { voting data }
    Sex              : Char;            { user gender }

    tTimeOn          : LongInt;         { total minutes spent online }
    Uk               : LongInt;         { total kbytes uploaded }
    Dk               : LongInt;         { total kbytes downloaded }
    Uploads          : Word;            { number of files uploaded }
    Downloads        : Word;            { number files downloaded }
    LoggedOn         : Word;            { number of times logged on }
    tlToday          : Word;            { minutes left today }
    MsgPost          : Word;            { number of public posts }
    EmailSent        : Word;            { number of email sent }

    res2:Array[1..2] of Byte;           { reserved }

    ForUsr           : Word;            { forward mail to user # }
    FilePoints       : LongInt;         { number of file points }

    res3:Array[1..19] of Byte;          { reserved }

    LineLen          : Byte;            { line length (# cols) }
    PageLen          : Byte;            { page length (# rows) }
    OnToday          : Byte;            { number of times on today }
    Illegal          : Byte;            { number of illegal logon attempts }
    SL               : Byte;            { security level (SL) }
    DSL              : Byte;            { download security level (DSL) }
    LastMsg          : Byte;            { msg area when last logged off }
    LastFil          : Byte;            { file area when last logged off }

    res4:Array[1..10] of Byte;          { reserved }

    Credit           : Integer;         { credits }
    TimeBankAdd      : Integer;         { time added to time bank today }
    TimeBank         : Integer;         { number of minutes in time bank }

    res5:Array[1..10] of Byte;          { reserved }

    SLogSeperate     : Boolean;         { seperate sysop log for each user? }
    ChatAuto         : Boolean;         { automatically trap chat sessions? }
    ChatSeperate     : Boolean;         { trap chat to separate files for each user? }
    TrapActivity     : Boolean;         { trap all users' activity? }
    TrapSeperate     : Boolean;         { trap to separate files for each user? }

    res6:Array[1..5] of Byte;           { reserved }

    mPointer         : LongInt;         { pointer to entry in MACROS.DAT }
    UserStartMenu    : String[8];       { menu to start all users out on }

    res7:Array[1..2] of Byte;           { reserved }

    Conference       : Char;            { current conference }

    fListC           : Array[1..10,1..2] of Byte; { file listing configuation }
                                        { 1..10: file listing elements        }
                                        { 1..2:  1: 0:off 1:on                }
                                        {        2: color                     }

    QwkArc           : String[3];       { QWK archive type }
    QwkFiles         : Boolean;         { list new files in packet? (not used) }

    EdType           : Byte;            { editor type          }
                                        { 0:select at time     }
                                        { 1:line editor        }
                                        { 2:full screen editor }

    res8:Array[1..99] of Byte;          { reserved }
  end;



var illU : tIllUserRec;
    iniU : tUserRec;
    illF : file of tIllUserRec;
    iniF : file of tUserRec;
    cfgF : file of tCfgRec;
       z : Word;
    numU : Word;
    curU : Word;
    cfg  : tCfgRec;

begin
   ioInitFastIO;
   ioTextMode;
   ioClrScr;
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($0F);
   ioWriteLn('Ill2iniq v'+bbsVersion+'  (c)Copyright 1998, IDT');
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($07);
   ioWriteLn('Illusion to Iniquity user file conversion utility');
   ioTextAttr($08);
   ioWrite(sRepeat('',80));
   ioTextAttr($07);
   Assign(cfgF,fileConfig);
   {$I-}
   Reset(cfgF);
   {$I+}
   if ioResult <> 0 then
   begin
      ioWriteLn(fileConfig+' not found in current directory.');
      ioWriteLn('Please change to your Iniquity directory before executing this program.');
      Halt(255);
   end;
   Read(cfgF,cfg);
   Close(cfgF);

   if ParamCount < 1 then
   begin
      ioWriteLn('Please specify the full path to your illusion user file USERS.DAT');
      ioWriteLn('when executing the program.');
      Halt(255);
   end;
   Assign(illF,ParamStr(1));
   {$I-}
   Reset(illF);
   {$I+}
   if ioResult <> 0 then
   begin
      Assign(illF,ParamStr(1)+'\USERS.DAT');
      {$I-}
      Reset(illF);
      {$I+}
      if ioResult <> 0 then
      begin
         ioWriteLn('Illusion user file USERS.DAT not found in the path specified.');
         Halt(255);
      end;
   end;
   numU := FileSize(illF);
   curU := 0;
   ioWriteLn('USERS.DAT found in specified path ('+St(numU-1)+' users).');
   ioWriteLn('Renaming previous Iniquity user file to USERS.OLD.');
   Assign(iniF,cfg.pathData+fileUsers);
   {$I-}
   Rename(iniF,cfg.pathData+'USERS.OLD');
   {$I+}
   if ioResult <> 0 then ioWriteLn('Error renaming old data file, continuing...');

   Assign(iniF,cfg.pathData+fileUsers);
   {$I-}
   Rewrite(iniF);
   {$I+}
   if ioResult <> 0 then
   begin
      ioWriteLn('Unable to create Iniquity user file '+cfg.pathData+fileUsers);
      Halt(255);
   end;
   ioWriteLn('Creating '+cfg.pathData+fileUsers+'...');
   ioWrite('Building Iniquity user data file: ');
   while not Eof(illF) do
   begin
      ioWrite(St(Round(curU / numU * 100))+'%');
      ioGotoXY(35,ioWhereY);
      Read(illF,illU);
      if illU.Name <> '' then
      begin
         Inc(curU);
         FillChar(iniU,SizeOf(iniU),0);
         with iniU do
         begin
            Number              := curU;
            UserName            := strMixed(illU.Name);
            RealName            := strMixed(illU.RealName);
            Password            := illU.Pw;
            PhoneNum            := illU.Ph;
            Insert('(',PhoneNum,1);
            PhoneNum[5] := ')';
            Birthdate           := illU.bDay;
            Location            := illU.CityState;
            Address             := illU.Street;
            UserNote            := illu.Note;
            Sex                 := illU.Sex;
            SL                  := illU.SL;
            DSL                 := illU.DSL;
            BaudRate            := 28800;
            TotalCalls          := illU.LoggedOn;
            curMsgArea          := 1;
            curFileArea         := 1;
            acFlag              := [acANSi,acHotKey,acYesNoBar,acQuote,acPause];
            Color               := cfg.DefaultCol;
            LastCall            := illU.LastOn;
            PageLength          := cfg.DefaultPageLen;
            EmailWaiting        := 0;
            Level               := 'B';
            timeToday           := 60;
            timePerDay          := 60;
            autoSigLns          := 0;
            FillChar(autoSig,SizeOf(autoSig),0);
            confMsg             := 1;
            confFile            := 1;

            FirstCall           := illU.FirstOn;
            StartMenu           := cfg.StartMenu;
            fileScan            := '01/01/80';
            SysOpNote           := 'None';
            Posts               := illU.msgPost;
            Email               := illU.EmailSent;


            CallsToday          := 0;
            Flag                := [];
            filePts             := 0;
            postCall            := 0;
            limitDL             := 0;
            limitDLkb           := 0;
            todayDL             := 0;
            todayDLkb           := 0;
            lastQwkDate         := 0;
            uldlRatio           := 0;
            kbRatio             := 0;
            textLib             := 1;
            zipCode             := illU.zipCode;
            voteYes             := 0;
            voteNo              := 0;
            Uploads             := illU.Uploads;
            Downloads           := illU.Downloads;
            UploadKb            := illU.uk;
            DownloadKb          := illU.dk;

            MaxTimeAllowed     := 480;
            MaxTimeBankDeposit := 60;
            MaxTimeBankWithdraw:= 30;
            TimeInBank         := illU.TimeBank;
            TimeDepositToday   := illU.TimeBankAdd;
            TimeWithdrawToday  := 0;
            MaxKBallowed       := 9000;
            MaxKbBankDeposit   := 1000;
            MaxKbBankWithdraw  := 500;
            KbInBank           := 0;
            KbDepositToday     := 0;
            KbWithdrawToday    := 0;

            z := 1;
            for z := 1 to maxVotingQuestions do
            votingAnswers[z] := 0;

            z := 1;
            for z := 1 to maxfilearea do
             filescanarea[z] := 0;

            z := 1;
            for z := 1 to maxmsgarea do
             msgscanarea[z] := 0;
         end;
         Write(iniF,iniU);
      end else Dec(numU,1);
   end;
   ioWriteLn(St(curU div numU * 100)+'%');
   Close(illF);
   Close(iniF);
   ioWriteLn('Conversion process complete.');
   ioWriteLn('Old Iniquity user file renamed to USERS.OLD.');
end.
