program iniqInit;

uses
   WinDos, Crt, Files, Global, BBSinit, StrProc, FastIO;


procedure resetCfg;
var I : Word;
begin
   FillChar(Cfg^,SizeOf(tCfgRec),0);
   with Cfg^ do
   begin

      bbsName                := bbsTitle+' '+bbsVersion;
      bbsPhone               := '(000)000-0000';
      SysOpAlias             := 'SysOp';
      SysOpName              := 'System Operator';
      SystemPW               := 'SYSTEM';
      acsSysOp               := 's255';
      acsCoSysOp             := 's250';
      DirectWrites           := True;
      SnowChecking           := False;
      LoadOVR                := [ovrLxms] + [ovrLems];
      RealNameSystem         := False;
      ShowPwLocal            := True;
      ShowPwLogon            := True;
      iniqAsDoor             := False;
      TimeSlices             := True;

      StatOnDefault          := True;
      StatBarOn              := True;
      StatType               := sbBot;
      StatBar                := 1;
      StatLo                 := $10;
      StatTxt                := $17;
      StatHi                 := $1F;

      for I := 0 to maxColor do
      begin
         DefaultCol[I].Fore := 7;
         DefaultCol[I].Back := 0;
         DefaultCol[I].Blink := False;
      end;

      DefaultCol[colError].Fore  := 12;

      DefaultCol[colText].Fore   := 7;
      DefaultCol[colTextLo].Fore := 8;
      DefaultCol[colTextHi].Fore := 15;

      DefaultCol[colInfo].Fore   := 15;
      DefaultCol[colInfoLo].Fore := 8;
      DefaultCol[colInfoHi].Fore := 7;

      DefaultCol[colItem].Fore := 8;
      DefaultCol[colItemSel].Fore := 8;
      DefaultCol[colItemSel].Back := 7;

      DefaultCol[colBorder].Fore := 8;

      DefaultCol[colEdit].Fore := 15;
      DefaultCol[colEdit].Back := 1;

      ESCtoExit              := True;
      OffhookLocal           := True;
      VgaEffects             := False;
      ScreenSaver            := 2;
      BlankSeconds           := 180;
      DefWFCstat             := 8;

      pathData               := startdir+'DATA\';
      pathText               := startdir+'TEXT\';
      pathMenu               := startdir+'MENU\';
      pathMsgs               := startdir+'MSGS\';
      pathSwap               := startdir+'SWAP\';
      pathDoor               := startdir+'DOOR\';
      pathProt               := startdir+'PROT\';
      pathTemp               := startdir+'TEMP\';
      pathDnld               := startdir+'DNLD\';
      pathLogs               := startdir+'LOGS\';
      pathArch               := startdir+'ARCH\';
      pathAtch               := startdir+'ATCH\';
      pathNetMail            := startdir+'MAIL\';
      pathLibs               := startdir+'LIBS\';
      pathIPLX               := startdir+'IPLX\';
      pathNetModem           := 'C:\NETMODEM\';
      pathWindows            := 'C:\WINDOWS\';

      NoBBSlogging           := False;
      LogLineChat            := True;
      LogSplitChat           := True;
      LogMicroDOS            := True;

      SwapInShell            := True;
      SwapToMore             := 255;
      ProtocolSwap           := True;
      ArchiverSwap           := True;

      BbsAccessPw            := '';
      NoBaudPW               := '';
      SysOpAutoLogin         := False;
      MatrixLogin            := True;
      AskApply               := True;
      TimeLimitPerCall       := False;
      acsSystemPWLogin       := 's250';
      CallsBirth             := 10;
      CallsPhone             := 5;
      LoginTrys              := 5;

      Origin[1] := bbsTitle+' -- '+bbsPhone;

      NoChatPW               := '';
      ChatPageNoise          := True;
      maxPageTimes           := 3;
      maxPageBeeps           := 6;
      restoreChatTime        := True;

      PwEchoChar             := '';
      RemovePause            := True;
      AddLocalCalls          := False;
      numLastCalls           := 10;

      acsPostEmail           := 's25';
      acsAnonymous           := 's50';
      acsAnonAutoMsg         := 's50';
      acsUploadMessage       := 's25';
      acsAutoSigUse          := 's25';
      acsAttachPublic        := 's50';
      acsAttachEmail         := 's50';
      AbortMandOk            := False;
      AskPrivateMsg          := True;
      AskPrivateReply        := True;
      AskPostInArea          := True;
      AskUploadReply         := False;
      AskUploadEmail         := True;
      AskKillMsg             := True;
      AskKillAllMsg          := True;
      AskAutoQuote           := True;
      DefaultQuoteNum        := True;
      maxQuoteLines          := 11;
      confIgnoreMsg          := True;
      compMsgAreas           := True;
      msgQuoteHeaders        := True;

      NewUserPW              := '';
      AliasFormat            := 2;
      DefaultPageLen         := 24;
      NewExpert              := False;
      NewYesNoBars           := True;
      NewHotKeys             := True;
      NewPause               := True;
      NewQuote               := True;
      NewAskExpert           := True;
      NewAskYesNoBars        := True;
      NewAskHotKeys          := True;
      NewAskPageLen          := True;
      NewAskPause            := True;
      NewAskQuote            := True;
      StartMenu              := 'STARTUP';

      compFileAreas          := True;
      kbPerFilePoint         := 15;
      useFilePoints          := False;
      importDescs            := True;
      useDLlimit             := True;
      useDLkbLimit           := True;
      useUPLtimeRefund       := True;
      bbsLocation            := 'Somewhere, ??';
      qwkFilename            := UpStr(bbsTitle);
      qwkWelcome             := txWelcome+'.ANS';
      qwkNews                := 'NEWS.ANS';
      qwkGoodbye             := txLogoff+'.ANS';
      qwkLocalPath           := startdir;
      qwkIgnoreTime          := True;
      qwkStripSigs           := True;
      noDescLine             := 'No description';
      waitConnect            := 45;
      modemReInit            := 600;
      lightChar              := '';
      lightCharOk            := '';
      lightCharFail          := 'x';
      virusScan              := 'SCAN /NOMEM /NOEXPIRE /SUB %FN';
      virusOk                := 0;
      maxFileAge             := 4;
      strictAge              := True;
      delFile                := 'DELETE.LST';
      addFile                := 'ADD.LST';
      comFile                := 'COMMENT.TXT';
      extMaint               := False;
      ulSearch               := 4;
      autoValidate           := True;
      filePtsPer             := 175;
      useUlDlratio           := False;
      useKbRatio             := False;
      fileDesc1              := 'FILE_ID.DIZ';
      fileDesc2              := 'DESC.SDI';
      useTextLibs            := False;
      echomailLev            := 100;
      newConfig              := True;
      newVerify              := True;
      pmtYes                 := '|U5[|U6Y|U5/|U4n|U5] |U6';
      pmtNo                  := '|U5[|U4y|U5/|U6N|U5] |U6';
      pmtYesWord             := 'Yes';
      pmtNoWord              := 'No';
      pmtYesBar              := '|U8 Yes |U7 No ';
      pmtNoBar               := '|U7 Yes |U8 No |U1';
      descWrap               := True;
      chatStart              := '11:00';
      chatEnd                := '20:00';
      chatOverAcs            := 's150';
      advFileBar             := True;
      inactTime              := True;
      inactSeconds           := 180;
      inactWarning           := 120;
      ansiString             := '(ansi codes detected; line not displayed)';
      pageAskEmail           := True;
      soundRestrict          := True;
      inactLocal             := True;
      allowBlind             := True;
      nuvVotesYes            := 5;
      nuvVotesNo             := 3;
      nuvAccess              := '!s50';
      nuvVoteAccess          := 's50';
      nuvInitials            := True;
      nuvUserLevel           := 'B';
      nuvValidation          := True;
      MultiNode              := True;
      askXferHangup          := True;
      xferAutoHangup         := 10;
      ifNoAnsi               := 2;
      minBaud                := 2400;
      upgradeVersion         := 1;
      fileidLines            := 50;
      wfcScroll              := True;
   end;
end;

var f : file of tCfgRec;

begin
   ioInitFastIO;
   ioTextMode;
   ioClrScr;
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($0F);
   ioWriteLn('iniqInit v'+bbsVersion+'  (c)Copyright 1997-1998 iDT');
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($07);
   ioWriteLn('Main BBS data file initialization utility');
   ioTextAttr($08);
   ioWrite(sRepeat('',80));
   ioTextAttr($07);
   New(Cfg);
   GetDir(0,StartDir);
   StartDir := strBkSlash(True,StartDir);
   ResetCfg;
   assign(f,'iniquity.dat');
   rewrite(f);
   write(f,cfg^);
   close(F);
   Dispose(Cfg);
   ioTextAttr($07);
   ioWriteLn('Initialization complete');
   ioGotoXY(1,22);
end.
