{F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
{$M 40000,0,100000}
{$UNDEF PLUS}

(*                                                                          *)
(*   Iniquity EchoMail Manager                                              *)
(*   (C)Copyright 1994, Mike Fricker                                        *)
(*   (C)Copyright 1998, Comatose & iDT                                      *)

program iniqMail;

uses
   Dos, Crt, Global, FastIO, Files, Misc, Strings, MsgArea, DateTime,
   Email, StrProc, Users;

const
   fileHiWater = bbsTitle+'.HWM';
   fileGecho   = '1.MSG';
   maxBuf      = 2048;

type
   tFidoHeadRec = record
      maFrom,
      maTo           : array[1..36] of Char;
      maSubject      : array[1..72] of Char;
      maDate         : array[1..20] of Char;
      maTimesRead,
      nodeDest,
      nodeOrig,
      maCost,
      netOrig,
      netDest         : Integer;
      dateWritten,
      dateArrived     : LongInt;
      maRef           : Integer;
      maAttrL,
      maAttrH         : Byte;
      UnReply         : Integer;
   end;

var
   fA : file of tMsgAreaRec;
   fC : file of tCfgRec;
   skipfirst     : boolean;
   doNetmail     : boolean;
   doEchomail    : boolean;
   doStats       : boolean;
   count         : word;
   numEchoMsgsIn : word;
   numNetMsgsIn  : word;
   numEchoMsgsOut: word;
   numNetMsgsOut : word;

function mailPackedDate(S : String) : LongInt;
var Dt : Dos.DateTime; L : LongInt; Z : String;
begin
   mailPackedDate := 0;
   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Day := strToInt(Z);

   Z := UpStr(S[1]+S[2]+S[3]);
   Delete(S,1,4);

   Dt.Month := 1;
   if Z = 'JAN' then Dt.Month := 1 else
   if Z = 'FEB' then Dt.Month := 2 else
   if Z = 'MAR' then Dt.Month := 3 else
   if Z = 'APR' then Dt.Month := 4 else
   if Z = 'MAY' then Dt.Month := 5 else
   if Z = 'JUN' then Dt.Month := 6 else
   if Z = 'JUL' then Dt.Month := 7 else
   if Z = 'AUG' then Dt.Month := 8 else
   if Z = 'SEP' then Dt.Month := 9 else
   if Z = 'OCT' then Dt.Month := 10 else
   if Z = 'NOV' then Dt.Month := 11 else
   if Z = 'DEC' then Dt.Month := 12;

   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Year := 1900+StrToInt(Z);

   if S[1] = ' ' then Delete(S,1,1);

   Z := S[1]+S[2];
   if Z[1] = ' ' then Delete(Z,1,1);
   Delete(S,1,3);
   Dt.Hour := StrToInt(Z);

   Z := S[1]+S[2];
   Delete(S,1,3);
   Dt.Min := StrToInt(Z);

   Z := S[1]+S[2];
   Dt.Sec := StrToInt(Z);

   PackTime(Dt,L);

   mailPackedDate := L;
end;


function MatchAKA(Address : tNetAddressRec) : byte;  {added comatose}
var i       : byte;
    Matched : boolean;

begin;
  Matched := false;
  i := 0;
  while (i < MaxAddress) and (not Matched) do
  begin;
    inc(i,1);
    if (Cfg^.Address[i].Zone = Address.Zone) and
       (Cfg^.Address[i].net = Address.net) and
       (Cfg^.Address[i].node = Address.node) then Matched := true;
  end;
  if Matched then MatchAKA := i else MatchAKA := 0;
end;

function mailReadMarker(Fn : String) : LongInt;
var F : file; {M : tFidoHeadRec;} L : LongInt;
begin
   mailReadMarker := 0;
   Assign(F,Fn);
   {$I-}
   Reset(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockRead(F,L,SizeOf(L));
   Close(F);
   mailReadMarker := L;
end;


function mailFidoDate(L : LongInt) : String; { DD MMM YY  HH:MM:SS }
var Dt : Dos.DateTime; Z, S : String;
begin
   UnpackTime(L,Dt);
   mailFidoDate := '';
   FillChar(S,SizeOf(S),0);
   S := St(Dt.Day);
   if Length(S) < 2 then Insert('0',S,1);
   S := S+' ';
   case Dt.Month of
     1  : Z := 'Jan';
     2  : Z := 'Feb';
     3  : Z := 'Mar';
     4  : Z := 'Apr';
     5  : Z := 'May';
     6  : Z := 'Jun';
     7  : Z := 'Jul';
     8  : Z := 'Aug';
     9  : Z := 'Sep';
     10 : Z := 'Oct';
     11 : Z := 'Nov';
     12 : Z := 'Dec';
     else Z := 'Ukn';
   end;
   if Dt.Year < 1901 then Dt.Year := 1901;
   S := S+Z+' '+St(Dt.Year-1900)+'  ';

   Z := St(Dt.Hour);
   if Length(Z) < 2 then Insert('0',Z,1);
   S := S+Z+':';
   Z := St(Dt.Min);
   if Length(Z) < 2 then Insert('0',Z,1);
   S := S+Z+':';
   Z := St(Dt.Sec);
   if Length(Z) < 2 then Insert('0',Z,1);
   S := S+Z;
   mailFidoDate := S;
end;





function mailmportEcho(Fn : String; var Head : tMsgHeaderRec; var Txt : tMessage) : Boolean;
var mHead : tFidoHeadRec;
       fH : file of tFidoHeadRec;
        C : Char;
       fT : file;
  N, Z, X : Word;
       un : String;
      Buf : array[1..maxBuf] of Char;
    sRead,
    tRead : LongInt;
    nRead : Integer;
    msgId : string;
    reply : string;
        b : boolean;

begin
   mailmportEcho := False;
   fn:=upstr(fn);
   Assign(fH,Fn);
   {$I-}
   Reset(fH);
   {$I+}
   if ioResult <> 0 then Exit;
   {$I-}
   Read(fH,mHead);
   {$I+}
   if ioResult <> 0 then begin Close(fH); Exit; end;
   Close(fH);

   msgid := '';
   reply := '';

   Assign(fT,Fn);
   Reset(fT,1);

   Seek(fT,SizeOf(mHead));
   FillChar(Txt,SizeOf(Txt),0);
   FillChar(Head,SizeOf(Head),0);
   N := 1;
   Head.sigPos := 0;
   tRead := 0;
   sRead := FileSize(ft)-SizeOf(mHead); {sizeof text area}
   while (ioResult = 0) and (N <= maxMsgLines) and (tRead < sRead) do
   begin
      {$I-}
      BlockRead(ft,Buf,maxBuf,nRead);
      {$I+}
      Inc(tRead,nRead);
      x := 1;
      b := false;
      while (X < nRead) do if (N <= maxMsgLines) then
      begin
        z := 1;
        while (z <= 80) and (N <= maxMsgLines) do if (not b) then
        begin;
          if (not (Buf[x] in [#10,#13])) and (Buf[x] <> '') then Txt[N] := Txt[N]+Buf[x] else
          if (Buf[x] = #13) then Inc(N);
          if (z = 80) and (not (buf[x] in [#13])) and
           (X <= nRead) and (Buf[x] <> '') then
            begin;
              z := 1;
              inc(n);
            end;
          inc(x);
          inc(z);
          if x >= nRead then b := true;
          if (buf[x] in [#13]) then z := 81;
           if x >= nRead then z := 81;
        end;
        if (N > maxMsgLines) then X := nRead;
      end;
   end;
   Close(ft);
   if N > maxMsgLines then Txt[maxMsgLines] := '--- [iniqMail] This message has been truncated to '+st(maxMsgLines)+' lines.';
   Un := '';
   Z := 1;
   while Z <= N do if Txt[Z,1] = #1 then
   begin
      if Copy(Txt[Z],1,10) = #1'USERNOTE:' then Un := Copy(Txt[Z],12,255) else
      if Copy(Txt[Z],1,8) = #1'SIGPOS:' then Head.sigPos := strToInt(Copy(Txt[Z],10,255));
      if Copy(Txt[Z],1,7) = #1'REPLY:' then
      begin;
        reply := copy(Txt[Z],9,sizeof(txt[z]));
        reply := copy(reply,1,pos(' ',reply)-1);
      end;
      if Copy(Txt[Z],1,7) = #1'MSGID:' then
      begin;
        msgid := copy(Txt[Z],9,sizeof(txt[z]));
        msgid := copy(msgid,1,pos(' ',msgid)-1);
      end;

      for X := Z+1 to N do if (N <= maxMsgLines) then Txt[X-1] := Txt[X];
      Dec(N);

   end else
   begin;
     if (Copy(Txt[Z],1,10) = ' * Origin:') and (msgid = '') then
      reply := copy(Txt[z],pos('(',txt[z])+1,pos(')',txt[z])-1);
     Inc(Z);
   end;

   if Head.sigPos = 0 then
   for Z := 1 to N do
   begin
      if (Copy(Txt[Z],1,4) = '--- ') and (Head.sigPos = 0) then Head.sigPos := Z;
      if (Copy(Txt[Z],1,10) = ' * Origin:') and (Head.sigPos = 0) then Head.sigPos := Z;
   end;
   with Head.FromInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      for Z := 1 to 36 do if mHead.maFrom[Z] in [' ',#0] then mHead.maFrom[Z] := ' ';
      Name := CleanUp(mHead.maFrom);
      if Un <> '' then UserNote := Un else UserNote := 'None';
      with address do
      begin
       zone := strtoint(copy(msgid,1,pos(':',msgid)-1));
       net  := strtoint(copy(msgid,pos(':',msgid)+1,pos('/',msgid)-pos(':',msgid)));
       if pos('.',reply) > 0 then
        begin
          node  := strtoint(copy(msgid,pos('/',msgid)+1,pos('.',msgid)-pos('/',msgid)));
          point := strtoint(copy(msgid,pos('.',msgid)+1,sizeof(msgid)-pos('.',msgid)));
        end else
        begin
          node  := strtoint(copy(msgid,pos('/',msgid)+1,sizeof(msgid)-pos('/',msgid)));
          point := 0;
        end;
      end;
   end;

   with Head.ToInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      for Z := 1 to 36 do if mHead.maTo[Z] in [' ',#0] then mHead.maTo[Z] := ' ';
      Name := CleanUp(mHead.maTo);
      UserNote := 'None';
      with address do

       begin
       zone := strtoint(copy(reply,1,pos(':',reply)-1));
       net  := strtoint(copy(reply,pos(':',reply)+1,pos('/',reply)-pos(':',reply)));
       if pos('.',reply) > 0 then
        begin
          node  := strtoint(copy(reply,pos('/',reply)+1,pos('.',reply)-pos('/',reply)));
          point := strtoint(copy(reply,pos('.',reply)+1,sizeof(reply)-pos('.',reply)));
        end else
        begin
          node  := strtoint(copy(reply,pos('/',reply)+1,sizeof(reply)-pos('/',reply)));
          point := 0;
        end;
      end;
   end;

   Head.Size := N;
   Head.Date := dtDateTimePacked; {mailEchoDate(mHead.maDate);}
   for Z := 1 to 72 do if mHead.maSubject[Z] in [' ',#0] then mHead.maSubject[Z] := ' ';
   Head.Subject := strSquish(CleanUp(mHead.maSubject),40);
   Head.Status := [msgEchoMail];
   Head.NetFlag := [];
   Z := mHead.maAttrL;
   if mGetBit(Z,00) then Head.netFlag := Head.netFlag+[nPrivate];
   if mGetBit(Z,01) then Head.netFlag := Head.netFlag+[nCrash];
   if mGetBit(Z,02) then Head.netFlag := Head.netFlag+[nReceived];
   if mGetBit(Z,03) then Head.netFlag := Head.netFlag+[nSent];
   if mGetBit(Z,04) then Head.netFlag := Head.netFlag+[nFileAttached];
   if mGetBit(Z,05) then Head.netFlag := Head.netFlag+[nInTransit];
   if mGetBit(Z,06) then Head.netFlag := Head.netFlag+[nOrphan];
   if mGetBit(Z,07) then Head.netFlag := Head.netFlag+[nKillSent];
   Z := mHead.maAttrH;
   if mGetBit(Z,00) then Head.netFlag := Head.netFlag+[nLocal];
   if mGetBit(Z,01) then Head.netFlag := Head.netFlag+[nHold];
   if mGetBit(Z,02) then Head.netFlag := Head.netFlag+[nUnused];
   if mGetBit(Z,03) then Head.netFlag := Head.netFlag+[nFileRequest];
   if mGetBit(Z,04) then Head.netFlag := Head.netFlag+[nReturnReceiptRequest];
   if mGetBit(Z,05) then Head.netFlag := Head.netFlag+[nIsReturnReceipt];
   if mGetBit(Z,06) then Head.netFlag := Head.netFlag+[nAuditRequest];
   if mGetBit(Z,07) then Head.netFlag := Head.netFlag+[nFileUpdateRequest];
   if nPrivate in Head.netFlag then Head.Status := Head.Status+[msgPrivate];
   Head.Replies := 0;
   Head.incFile := 0;
   mailmportEcho := True;
end;


{--- added comatose ---}
function mailmportNet(Fn : String; var Head : tMsgHeaderRec; var Txt : tMessage) : Boolean;
var mHead : tFidoHeadRec;
       fH : file of tFidoHeadRec;
        C : Char;
       fT : file;
  N, Z, X : Word;
       un : String;
      Buf : array[1..maxBuf] of Char;
    sRead,
    tRead : LongInt;
    nRead : Integer;
        U : tUserRec;
    msgid : string;

begin
   mailmportNet := False;
   fn:=upstr(fn);
   Assign(fH,Fn);
   {$I-}
   Reset(fH);
   {$I+}
   if ioResult <> 0 then Exit;
   {$I-}
   Read(fH,mHead);
   {$I+}
   if ioResult <> 0 then begin Close(fH); Exit; end;

   if mGetBit(mHead.maAttrL,02) then exit;
   mHead.maAttrL := mHead.maAttrl or (1 shl 2);
   seek(fH,0);
   write(fH,mHead);
   Close(fH);

   Assign(fT,Fn);
   Reset(fT,1);
   Seek(fT,SizeOf(mHead)+7);
   blockread(ft,msgid,20);
   msgid := copy(msgid,1,pos(' ',msgid)-1);

   Seek(fT,SizeOf(mHead));
   FillChar(Txt,SizeOf(Txt),0);
   FillChar(Head,SizeOf(Head),0);
   N := 1;
   Head.sigPos := 0;

   tRead := 0;
   sRead := FileSize(ft)-SizeOf(mHead);
   while (ioResult = 0) and (N <= maxMsgLines) and (tRead < sRead) do
   begin
      {$I-}
      BlockRead(ft,Buf,maxBuf,nRead);
      {$I+}
      Inc(tRead,nRead);
      for X := 1 to nRead do if (N <= maxMsgLines) then
      begin
         if (not (Buf[x] in [#10,#13])) and (Ord(Txt[N,0]) < 80) then
            Txt[N] := Txt[N]+Buf[x] else if Buf[x] = #13 then Inc(N);
      end;
   end;
   Close(ft);

   if N > maxMsgLines then Txt[maxMsgLines] := '--- [iniqMail] This message has been truncated to '+st(maxMsgLines)+' lines.';
   Un := '';
   Z := 1;
   while Z <= N do if Txt[Z,1] = #1 then
   begin
      if Copy(Txt[Z],1,10) = #1'USERNOTE:' then Un := Copy(Txt[Z],12,255) else
      if Copy(Txt[Z],1,8) = #1'SIGPOS:' then Head.sigPos := strToInt(Copy(Txt[Z],10,255));
      for X := Z+1 to N do if (N <= maxMsgLines) then Txt[X-1] := Txt[X];
      Dec(N);

   end else Inc(Z);

   if Head.sigPos = 0 then
   for Z := 1 to N do
   begin
      if (Copy(Txt[Z],1,4) = '--- ') and (Head.sigPos = 0) then Head.sigPos := Z;
      if (Copy(Txt[Z],1,10) = ' * Origin:') and (Head.sigPos = 0) then Head.sigPos := Z;
   end;
   with Head.FromInfo do
   begin
      UserNum := 0;
      Alias := 'None';
      RealName := 'None';
      for Z := 1 to 36 do if mHead.maFrom[Z] in [' ',#0] then mHead.maFrom[Z] := ' ';
      Name := CleanUp(mHead.maFrom);
      if Un <> '' then UserNote := Un else UserNote := 'None';
      with address do
      begin
       zone := strtoint(copy(msgid,1,pos(':',msgid)-1));
       net  := strtoint(copy(msgid,pos(':',msgid)+1,pos('/',msgid)-pos(':',msgid)));
       if pos('.',msgid) > 0 then
        begin
          node  := strtoint(copy(msgid,pos('/',msgid)+1,pos('.',msgid)-pos('/',msgid)));
          point := strtoint(copy(msgid,pos('.',msgid)+1,sizeof(msgid)-pos('.',msgid)));
        end else
        begin
          node  := strtoint(copy(msgid,pos('/',msgid)+1,sizeof(msgid)-pos('/',msgid)));
          point := 0;
        end;
      end;
   end;
   with Head.ToInfo do
   begin
      for Z := 1 to 36 do if mHead.maTo[Z] in [' ',#0] then
       mHead.maTo[Z] := ' ';
      if mHead.maTo <= '' then exit;

        U.userName := mhead.maTo;
        if (not userSearch(U,True)) then U.Number := 1;

           if userLoad(U) = false then exit;
           UserNum  := U.Number;
           Alias    := U.UserName;
           RealName := U.RealName;
           Name     := CleanUp(mHead.maTo);
           UserNote := U.UserNote;

      with address do
      begin
       zone := strtoint(copy(msgid,1,pos(':',msgid)-1));
       net  := mHead.netDest;
       node := mHead.nodeDest;
      end;
      if MatchAKA(Head.ToInfo.Address) = 0 then exit;

   end;
   Head.Size := N;
   Head.Date := dtDateTimePacked; {mailEchoDate(mHead.maDate);}
   for Z := 1 to 72 do if mHead.maSubject[Z] in [' ',#0] then mHead.maSubject[Z] := ' ';
   Head.Subject := strSquish(CleanUp(mHead.maSubject),40);
   Head.Status := [msgPrivate];
   Head.NetFlag := [];
   Z := mHead.maAttrL;
   if mGetBit(Z,00) then Head.netFlag := Head.netFlag+[nPrivate];
   if mGetBit(Z,01) then Head.netFlag := Head.netFlag+[nCrash];
   if mGetBit(Z,02) then Head.netFlag := Head.netFlag+[nReceived];
   if mGetBit(Z,03) then Head.netFlag := Head.netFlag+[nSent];
   if mGetBit(Z,04) then Head.netFlag := Head.netFlag+[nFileAttached];
   if mGetBit(Z,05) then Head.netFlag := Head.netFlag+[nInTransit];
   if mGetBit(Z,06) then Head.netFlag := Head.netFlag+[nOrphan];
   if mGetBit(Z,07) then Head.netFlag := Head.netFlag+[nKillSent];
   Z := mHead.maAttrH;
   if mGetBit(Z,00) then Head.netFlag := Head.netFlag+[nLocal];
   if mGetBit(Z,01) then Head.netFlag := Head.netFlag+[nHold];
   if mGetBit(Z,02) then Head.netFlag := Head.netFlag+[nUnused];
   if mGetBit(Z,03) then Head.netFlag := Head.netFlag+[nFileRequest];
   if mGetBit(Z,04) then Head.netFlag := Head.netFlag+[nReturnReceiptRequest];
   if mGetBit(Z,05) then Head.netFlag := Head.netFlag+[nIsReturnReceipt];
   if mGetBit(Z,06) then Head.netFlag := Head.netFlag+[nAuditRequest];
   if mGetBit(Z,07) then Head.netFlag := Head.netFlag+[nFileUpdateRequest];
   if nPrivate in Head.netFlag then Head.Status := Head.Status+[msgPrivate];
   Head.Replies := 0;
   Head.incFile := 0;
   mailmportNet := True;
end;


function mailExportEcho(Fn : String; var Head : tMsgHeaderRec; var Txt : tMessage) : Boolean;
var mHead : tFidoHeadRec; fH : file; S : String; X : Word;
begin
   mailExportEcho := False;
   FillChar(mHead,SizeOf(mHead),0);

   with mHead do
   begin
      S := Head.FromInfo.Name;
      Move(S[1],maFrom,Length(S));
      S := Head.ToInfo.Name;
      Move(S[1],maTo,Length(S));
      S := Head.Subject;
      Move(S[1],maSubject,Length(S));
      S := mailFidoDate(Head.Date);
      Move(S[1],maDate,Length(S));
      maTimesRead     := 1;
      nodeDest        := 0; {Cfg^.Address[mArea^.Address].Node;}
      nodeOrig        := Cfg^.Address[mArea^.Address].Node;
      maCost          := 0;
      netOrig         := Cfg^.Address[mArea^.Address].Net;
      netDest         := 0; {Cfg^.Address[mArea^.Address].Net;}
      dateWritten     := 0; {Head.Date;}
      dateArrived     := 0; {dtDateTimePacked;}
      maRef           := 0;
      maAttrL         := 0;
      maAttrH         := 0;

      if nPrivate in Head.netFlag then maAttrL := maAttrL or (1 shl 0);
      if nCrash in Head.netFlag then maAttrL := maAttrL or (1 shl 1);
      if nReceived in Head.netFlag then maAttrL := maAttrl or (1 shl 2);
      if nSent in Head.netFlag then maAttrL := maAttrL or (1 shl 3);
      if nFileAttached in Head.netFlag then maAttrL := maAttrL or (1 shl 4);
      if nInTransit in Head.netFlag then  maAttrL := maAttrL or (1 shl 5);
      if nOrphan in Head.netFlag then maAttrL := maAttrL or (1 shl 6);
      if nKillSent in Head.netFlag then maAttrL := maAttrL or (1 shl 7);

      if nLocal in Head.netFlag then maAttrH := maAttrH or (1 shl 0);
      if nHold in Head.netFlag then maAttrH := maAttrH or (1 shl 1);
      if nUnused in Head.netFlag then maAttrH := maAttrH or (1 shl 2);
      if nFileRequest in Head.netFlag then maAttrH := maAttrH or (1 shl 3);
      if nReturnReceiptRequest in Head.netFlag then maAttrH := maAttrH or (1 shl 4);
      if nIsReturnReceipt in Head.netFlag then maAttrH := maAttrH or (1 shl 5);
      if nAuditRequest in Head.netFlag then maAttrH := maAttrH or (1 shl 6);
      if nFileUpdateRequest in Head.netFlag then maAttrH := maAttrH or (1 shl 7);

      UnReply := 0;
   end;
   Assign(fH,Fn);
   {$I-}
   Rewrite(fH,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockWrite(fH,mHead,SizeOf(mHead));
   S := #1+'PID: '+bbsTitle+' v'+bbsVerLong+#13;
   BlockWrite(fH,S[1],Length(S));
   S := #1+'USERNOTE: '+Head.FromInfo.UserNote+#13;
   BlockWrite(fH,S[1],Length(S));

   for X := 1 to Head.Size do
   begin
      S := Txt[X]+#13;{#10}
      BlockWrite(fH,S[1],Length(S));
   end;

   if Cfg^.Origin[mArea^.Origin] <> '' then
   begin
      S := '--- '+bbsTitle+' v'+bbsVerLong+#13;{}
      BlockWrite(fH,S[1],Length(S));
      S := ' * Origin: '+Cfg^.Origin[mArea^.Origin]+
           ' ('+St(Cfg^.Address[mArea^.Address].Zone)+
           ':'+St(Cfg^.Address[mArea^.Address].Net)+
           '/'+St(Cfg^.Address[mArea^.Address].Node)+')'+#13#13;{}
      BlockWrite(fH,S[1],Length(S));
   end;
   if Head.sigPos > 0 then
   begin
      S := #1+'SIGPOS: '+St(Head.sigPos)+#13#13;
      BlockWrite(fH,S[1],Length(S));
   end;

   Close(fH);
   mailExportEcho := True;
end;

{-- added comatose --}
function mailExportNet(Fn : String; var Head : tMsgHeaderRec; var Txt : tMessage) : Boolean;
var mHead : tFidoHeadRec; fH : file; S : String; X : Word;
begin
   mailExportNet := False;
   FillChar(mHead,SizeOf(mHead),0);

   with mHead do
   begin
      S := Head.FromInfo.Name;
      Move(S[1],maFrom,Length(S));
      S := Head.ToInfo.Name;
      Move(S[1],maTo,Length(S));
      S := Head.Subject;
      Move(S[1],maSubject,Length(S));
      S := mailFidoDate(Head.Date);
      Move(S[1],maDate,Length(S));
      maTimesRead     := 1;
      nodeDest        := head.toInfo.address.node;
      nodeOrig        := Cfg^.Address[mArea^.Address].Node;
      maCost          := 0;
      netOrig         := Cfg^.Address[mArea^.Address].Net;
      netDest         := head.toInfo.address.net;
      dateWritten     := head.date;
      dateArrived     := 0;
      maRef           := 0;
      maAttrL         := 0;
      maAttrH         := 0;
      if nPrivate in Head.netFlag then maAttrL := maAttrL or (1 shl 0);
      maAttrL := maAttrL or (1 shl 7);  { kill }
      maAttrH := maAttrH or (1 shl 0);  { local }
      if nHold in Head.netFlag then maAttrH := maAttrH or (1 shl 1);
      UnReply         := 0;
   end;
   Assign(fH,Fn);
   {$I-}
   Rewrite(fH,1);
   {$I+}
   if ioResult <> 0 then Exit;

   BlockWrite(fH,mHead,SizeOf(mHead));
   S := #1+'MSGID: '+st(head.fromInfo.address.zone)+':'+
                     st(head.fromInfo.address.net)+'/'+
                     st(head.fromInfo.address.node)+' '+#13;
   BlockWrite(fH,S[1],Length(S));
   S := #1+'PID: '+bbsTitle+' v'+bbsVerLong+#13;
   BlockWrite(fH,S[1],Length(S));
   S := #1+'USERNOTE: '+Head.FromInfo.UserNote+#13;
   BlockWrite(fH,S[1],Length(S));
   if Head.sigPos > 0 then
   begin
      S := #1+'SIGPOS: '+St(Head.sigPos)+#13;
      BlockWrite(fH,S[1],Length(S));
   end;
   for X := 1 to Head.Size do
   begin
      S := Txt[X]+#13#10;
      BlockWrite(fH,S[1],Length(S));
   end;
   Close(fH);
   mailExportNet := True;
end;





(*
procedure mailUpdateMarker(Fn : String; High : LongInt);
var F : file; M : tFidoHeadRec; S : String;
begin
   FillChar(M,SizeOf(M),0);
   with M do
   begin
      S := bbsTitle;
      Move(S[1],maFrom,Length(S));
      S := bbsTitle;
      Move(S[1],maTo,Length(S));
      S := 'High water marking message';
      Move(S[1],maSubject,Length(S));
      S := mailFidoDate(High);
      Move(S[1],maDate,Length(S));
      maTimesRead     := 0;
      nodeDest        := 0;
      nodeOrig        := 0;
      maCost          := 0;
      netOrig         := 0;
      netDest         := 0;
      dateWritten     := 0;
      dateArrived     := 0;
      maRef           := 0;
      maAttr          := 0;
      maAttr          := maAttr or (0 shl 9);
      maAttr          := maAttr or (2 shl 9);
      maAttr          := maAttr or (3 shl 9);
      UnReply         := 0;
   end;
   Assign(F,Fn);
   {$I-}
   Rewrite(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockWrite(F,M,SizeOf(M));
   FillChar(S,SizeOf(S),0);
   S := bbsTitle+' v'+bbsVersion+' echomail processor -- high water marker'+#13#13;
   BlockWrite(F,S[1],Length(S));
   Close(F);
end; *)

procedure mailUpdateMarker(Fn : String; High : LongInt);
var F : file;
begin
   Assign(F,Fn);
   {$I-}
   Rewrite(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   BlockWrite(F,High,SizeOf(High));
   Close(F);
end;

procedure savearea;
begin
   Seek(Fa,count-1);
   {$I-}
   Write(Fa,mArea^);
   {$I+}
   Seek(Fa,count);
end;

procedure mailToss;
var Y, X : Word; Txt : tMessage; Head : tMsgHeaderRec;{ fH : file of tMsgHeaderRec; }
begin
   numEchoMsgsIn := 0;
   while not Eof(fA) do
   begin
      Read(fA,mArea^);
      inc(count);
      if mArea^.areaType = mareaEchoMail then
      begin
         ioGotoXY(1,ioWhereY);
         ioClrEol;
         ioCwrite('|09a|01nalyzing |09a|01rea|08: |09'+mArea^.name+'|08 ...');
         X := ioWhereX;
         Y := 1;
         if skipfirst then inc(y);
         while fExists(mArea^.MsgPath+St(y)+extMsgEcho) do
         begin
            numEchoMsgsIn := Y;
            ioGotoXY(X,ioWhereY);
            ioTextAttr($05);
            ioWrite('(msg ');
            ioTextAttr($0D);
            ioWrite(St(y));
            ioTextAttr($05);
            ioWrite(')');
            if mailmportEcho(mArea^.MsgPath+St(y)+extMsgEcho,Head,Txt) then
               begin maAddMessage(Txt,Head,false); savearea; end;
            Inc(y);
         end;
         mailUpdateMarker(mArea^.MsgPath+fileHiWater,dtDateTimePacked);
         ioGotoXY(X,ioWhereY);
         ioTextAttr($01);
         ioWrite('Complete');
         ioTextAttr($08);
         ioWriteLn('.     ');
      end;
   end;
end;


procedure mailTossNet;
var Y, X  : Word;
        Txt : tMessage;
       Head : tMsgHeaderRec;
         Sr : SearchRec;
begin
  numNetMsgsIn := 0;
  emailLoad;
  ioGotoXY(1,ioWhereY);
  ioClrEol;
  ioCwrite('|09a|01nalyzing |09a|01rea|08: |09netmail|08 ...');
  X := ioWhereX;
  Y := 1;
  FindFirst(cfg^.pathNetmail+'*'+extMsgEcho,0,Sr);
  if skipfirst then findnext(sr);
   while (dosError = 0) do
     if (Sr.Name <> fileHiwater) then
     begin
        numNetMsgsIn := Y;
        ioGotoXY(X,ioWhereY);
        ioTextAttr($05);
        ioWrite('(msg ');
        ioTextAttr($0D);
        ioWrite(St(y));
        ioTextAttr($05);
        ioWrite(')');
        if mailmportNet(cfg^.pathNetmail+Sr.Name,Head,Txt) then
          maAddMessage(Txt,Head,false);
        findNext(sr);
        inc(y);
      end else findNext(sr);
    ioGotoXY(X,ioWhereY);
    ioTextAttr($01);
    ioWrite('Complete');
    ioTextAttr($08);
    ioWriteLn('.     ');
end;


procedure mailStats; {added comatose}
var
        Txt : tMessage;
       Head : tMsgHeaderRec;
          U : tUserRec;
begin
  emailLoad;
  ioGotoXY(1,ioWhereY);
  ioClrEol;
  ioCwrite('|11s|03ending |11s|03tatus|08 |11email|08 ...');

  FillChar(Txt,SizeOf(Txt),0);
  FillChar(Head,SizeOf(Head),0);

  U.Number := 1;
  if userLoad(U) = false then exit;

   with Head.fromInfo do
   begin
     UserNum  := U.Number;
     Alias    := U.UserName;
     RealName := U.RealName;
     Name     := U.UserName;
     UserNote := U.UserNote;
   end;

   with Head.ToInfo do
   begin
     UserNum  := U.Number;
     Alias    := U.UserName;
     RealName := U.RealName;
     Name     := U.UserName;
     UserNote := U.UserNote;
   end;

   Head.Size := 10;
   Head.Date := dtDateTimePacked;
   Head.Subject := 'Iniqmail status mail';
   Head.Status := [msgPrivate];
   Head.NetFlag := [];
   Head.Replies := 0;
   Head.incFile := 0;

   Txt[1] := '';
   Txt[2] := '|07Number of echomail messages scanned: |15'+st(numEchoMsgsOut);
   Txt[3] := '|07Number of echomail messages tossed:  |15'+st(numEchoMsgsIn);
   Txt[4] := '|07Number of netmail messages scanned:  |15'+st(numNetMsgsOut);
   Txt[5] := '|07Number of netmail messages tossed:   |15'+st(numNetMsgsIn);

   maAddMessage(Txt,Head,false);

   ioTextAttr($01);
   ioWrite('Complete');
   ioTextAttr($08);
   ioWriteLn('.     ');
end;


procedure mailScan;
var Dt, Hi : LongInt; N, Z, X : Word; Txt : tMessage; Head : tMsgHeaderRec; fH : file of tMsgHeaderRec;
begin
   numEchoMsgsOut := 0;
   while not Eof(fA) do
   begin
      Read(fA,mArea^);
      if mArea^.areaType = mareaEchoMail then
      begin
         ioTextAttr($02);
         ioWrite('Scanning ');
         ioTextAttr($0A);
         ioWrite(mArea^.Name);
         ioTextAttr($08);
         ioWrite('... ');
         X := ioWhereX;
         N := 0;
         dt := mailReadMarker(mArea^.MsgPath+fileHiWater);
         if (not skipFirst) then fDeleteFile(mArea^.MsgPath+fileGecho);
         if skipFirst then inc(n);
         Hi := dt;
         Assign(fH,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
         {$I-}
         Reset(fH);
         {$I+}
         if ioResult = 0 then
         begin
            Z := 0;
            while not Eof(fH) do
            begin
               Read(fH,Head);
               Hi := Head.Date;
               Inc(Z);
               if (not (msgDeleted in Head.Status)) and
                  (Head.Date > dt) and (maLoadMessage(Txt,Head,Z)) then
               begin
                  Inc(N);
                  while (fExists(mArea^.MsgPath+St(N)+extMsgEcho)) and (N < 999) do Inc(N);
                  numEchomsgsOut := N;
                  ioGotoXY(X,ioWhereY);
                  ioTextAttr($08);
                  ioWrite('(msg ');
                  ioTextAttr($07);
                  ioWrite(St(N));
                  ioTextAttr($08);
                  ioWrite(')');
                  mailExportEcho(mArea^.MsgPath+St(N)+extMsgEcho,Head,Txt);
                  Head.Status := Head.Status+[msgSent];
                  Seek(fH,Z-1);
                  Write(fH,Head);
               end;
            end;
            Close(fH);
         end;
         mailUpdateMarker(mArea^.MsgPath+fileHiWater,dtDateTimePacked);
         ioGotoXY(X,ioWhereY);
         ioTextAttr($02);
         ioWrite('Complete');
         ioTextAttr($08);
         ioWriteLn('.     ');
      end;
   end;
end;

procedure mailScanNet;
var
    N, Z, X : Word;
        Txt : tMessage;
       Head : tMsgHeaderRec;
         fH : file of tMsgHeaderRec;

begin
  numNetMsgsOut := 0;
  emailLoad;
  ioTextAttr($02);
  ioWrite('Scanning ');
  ioTextAttr($0A);
  ioWrite(mArea^.Name);
  ioTextAttr($08);
  ioWrite('... ');
  X := ioWhereX;
  N := 0;
  Assign(fH,Cfg^.pathMsgs+mArea^.Filename+extMsgHead);
  {$I-}
  Reset(fH);
  {$I+}
  if ioResult = 0 then
  begin
    Z := 0;
    while not Eof(fH) do
    begin
      Read(fH,Head);
      Inc(Z);
      if (not (msgDeleted in Head.Status)) and
         (not (msgSent in Head.Status)) and
         (maLoadMessage(Txt,Head,Z)) then
      begin
        Inc(N);
        while (fExists(Cfg^.pathNetmail+St(N)+extMsgEcho)) and
              (N < 999) do Inc(N);
        numNetMsgsOut := N;
        ioGotoXY(X,ioWhereY);
        ioTextAttr($08);
        ioWrite('(msg ');
        ioTextAttr($07);
        ioWrite(St(N));
        ioTextAttr($08);
        ioWrite(')');
        mailExportNet(Cfg^.pathNetmail+St(N)+extMsgEcho,Head,Txt);
        Head.Status := Head.Status+[msgSent];
        Head.Status := Head.Status+[msgDeleted];
        Seek(fH,Z-1);
        Write(fH,Head);
      end;
     end;
    Close(fH);
   end;

   ioGotoXY(X,ioWhereY);
   ioTextAttr($02);
   ioWrite('Complete');
   ioTextAttr($08);
   ioWriteLn('.     ');
end;

procedure mailPurge;
var X : Word; Txt : tMessage; Sr : SearchRec; cD : String; F : file;
begin
   while not Eof(fA) do
   begin
      Read(fA,mArea^);
      if mArea^.areaType = mareaEchoMail then
      begin
         ioTextAttr($04);
         ioWrite('Purging ');
         ioTextAttr($0C);
         ioWrite(mArea^.Name);
         ioTextAttr($08);
         ioWrite('... ');
         X := ioWhereX;
         FindFirst(mArea^.MsgPath+'*'+extMsgEcho,0,Sr);
         if (skipFirst) and (sr.Name = fileGecho) then FindNext(Sr);
         while dosError = 0 do
          if (Sr.Name <> fileHiWater) then
         begin
            ioGotoXY(X,ioWhereY);
            ioTextAttr($07);
            ioWrite('(msg ');
            ioTextAttr($0F);
            ioWrite(Copy(Sr.Name,1,Pos('.',Sr.Name)-1));
            ioTextAttr($07);
            ioWrite(')');
            Assign(F,mArea^.MsgPath+Sr.Name);
            {$I-}
            Erase(F);
            {$I+}
            FindNext(Sr);
         end else FindNext(Sr);
         ioGotoXY(X,ioWhereY);
         ioTextAttr($04);
         ioWrite('Complete');
         ioTextAttr($08);
         ioWriteLn('.     ');
      end;
   end;
end;


procedure mailPurgeNet;
var X : Word; Txt : tMessage; Sr : SearchRec; cD : String; F : file;
begin
  ioTextAttr($04);
  ioWrite('Purging ');
  ioTextAttr($0C);
  ioWrite(mArea^.Name);
  ioTextAttr($08);
  ioWrite('... ');
  X := ioWhereX;
  FindFirst(Cfg^.pathNetmail+'*'+extMsgEcho,0,Sr);
  if skipfirst then findnext(sr);
  while dosError = 0 do if (Sr.Name <> fileHiWater) then
  begin
     ioGotoXY(X,ioWhereY);
     ioTextAttr($07);
     ioWrite('(msg ');
     ioTextAttr($0F);
     ioWrite(Copy(Sr.Name,1,Pos('.',Sr.Name)-1));
     ioTextAttr($07);
     ioWrite(')');
     Assign(F,Cfg^.pathNetmail+Sr.Name);
     {$I-}
     Erase(F);
     {$I+}
     FindNext(Sr);
  end else FindNext(Sr);
  ioGotoXY(X,ioWhereY);
  ioTextAttr($04);
  ioWrite('Complete');
  ioTextAttr($08);
  ioWriteLn('.     ');
end;

procedure mailReset;
var Dt : Dos.DateTime; L : LongInt;
begin
   Dt.Year := 1990;
   Dt.Month := 1;
   Dt.Day := 1;
   Dt.Hour := 0;
   Dt.Min := 0;
   Dt.Sec := 0;
   PackTime(Dt,L);
   while not Eof(fA) do
   begin
      Read(fA,mArea^);
      if mArea^.areaType = mareaEchoMail then
      begin
         ioTextAttr($05);
         ioWrite('Resetting ');
         ioTextAttr($0D);
         ioWrite(mArea^.Name);
         ioTextAttr($08);
         ioWrite('... ');
         mailUpdateMarker(mArea^.MsgPath+fileHiWater,0);
         fDeleteFile(mArea^.MsgPath+fileGecho);
         ioTextAttr($05);
         ioWrite('Complete');
         ioTextAttr($08);
         ioWriteLn('.     ');
      end;
   end;
end;

procedure mailError;
begin
   Dispose(Cfg);
   Dispose(mArea);
   Halt(255);
end;

begin
   New(mArea);
   New(Cfg);
   count:=0;
   TextMode(co80);
   ioInitFastIO;
   ioClrScr;
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($0F);
   ioWriteLn('iniqMail v'+bbsVersion+'  (c)Copyright 1994-96 Mike Fricker, 1997-1998 iDT');
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($07);
   ioWriteLn('Echomail import/export utility for Iniquity bulletin board systems');
   ioTextAttr($08);
   ioWrite(sRepeat('',80));
   ioTextAttr($07);
   Assign(fC,fileConfig);
   {$I-}
   Reset(fC);
   {$I+}
   if ioResult <> 0 then
   begin
      ioCWriteLn(fileConfig+' not found in current directory.');
      ioCWriteLn('Please change to your Iniquity directory before executing this program.');
      mailError;
   end;
   Read(fC,Cfg^);
   Close(fC);
   Assign(fA,Cfg^.pathData+fileMsgArea);
   {$I-}
   Reset(fA);
   {$I+}
   if ioResult <> 0 then
   begin
      ioCWriteLn('|12'+fileMsgArea+' |04not found in your data directory ('+Cfg^.pathData+').');
      ioCWriteLn('|04Please ensure that this file exists before using this program.');
      mailError;
   end;
   doNetmail  := true;
   doEchomail := true;
   doStats    := false;

   if mparam('-N') then doEchomail := false;
   if mparam('-E') then doNetmail := false;
   if mparam('-1') then skipfirst := true;  {Skip the first *.msg file}
   if mparam('-I') then doStats := true;
   if mParam('RESET') then mailReset;
   if mParam('TOSS') then
    begin
      if doEchomail then mailToss;
      if doNetmail then mailTossNet;
    end;
   if mParam('PURGE') then mailPurge;
   if mParam('PURGENET') then mailPurgeNet;
   if mParam('SCAN') then
    begin
      if doEchomail then mailScan;
      if doNetmail then mailScanNet;
    end;
   if doStats then mailStats;
   if paramcount=0 then
   begin
      if ParamCount = 0 then ioCwriteLn('|04No mail operation specified') else
                             ioCwriteLn('|04Invalid mail command');
      ioCwriteLn('');
      ioCwriteLn('|08syntax: |15'+paramStr(0)+' |07<command> -switches');
      ioCwriteLn('');
      ioCwriteLn(' |15scan     |07scan/export new outbound messages');
      ioCwriteLn(' |15toss     |07toss incoming messages to echomail msg areas');
      ioCwriteLn(' |15purge    |07destroy messages in echomail directories');
      ioCwriteLn(' |15purgenet |07destroy messages in netmail directory');
      ioCwriteLn(' |15reset    |07reset echoscan pointers to current date');
      ioCwriteLn(' |15-n       |07process only netmail');
      ioCwriteLn(' |15-e       |07process only echomail');
      ioCwriteLn(' |15-i       |07mail sysop iniqmail stats');
      ioCwriteLn(' |15-1       |07skip first message for gecho (1.msg)');
      close(fa);
      mailError;
   end;
   Close(fA);
   Dispose(Cfg);
   Dispose(mArea);
end.

