(*  IqString -- Iniquity BBS String File Compiler/Decompiler               *)
(*  Written by Joseph Kirk  converted to native iniq code by comatose      *)

Program IqString;

 Uses Crt, FastIO, Strproc, Output, Global ;


 Var TempTxt    : Text;
     TempStr    : File Of String;
     TempString : String;
     CfgFile    : File Of tCfgRec;
     Cfg        : tCfgRec;
     NumStrings : Integer;
     fname      : String;

 Const Comment = ';';

 Procedure UpdateNum;
 Var  S : String;
 Begin
  str(numStrings,S);
  If ParamCount = 1 then ioGotoXY(1,7) else ioGotoXY(1,6);
  ioCwrite('|08 ');
  ioCWriteln('|07Current String |08:|15 '+S);
 End;

 Function UpString (S : String) : String;
 Var I : Byte;
 Begin
  For I := 1 To Length (S) Do S[I] := UpCase (S[I]);
  UpString := S;
 End;

 Procedure LoadConfig;
 Begin
  Assign (CfgFile, 'INIQUITY.DAT');
  {$I-} Reset (CfgFile); {$I+}
  If IoResult <> 0 Then Begin
   ioCWrite('|08 |15INIQUITY.DAT not found!!!');
   Halt (3);
  End;
  Read (CfgFile, Cfg);
  Close (CfgFile);
 End;

 Procedure Logo;
 Begin
  ioClrScr;
  ioCwriteln('|08-- |15iqString v2.00  (C)opyright 1997-1998, Joseph Kirk [Kargus]');
  ioCWriteln('|08-- |07Iniquity BBS STRINGS.DAT Compiler/Decompiler');
  ioCWriteln('|08'+sRepeat('',80));
 End;

 Procedure ShowHelp;
 Begin
  Logo;
  ioCWriteln('|08 |07Syntax |08: ');
  oDnLn(1);
  ioCWriteln(' |15IQSTRING |07COMPILE   |01<|09filename|01> |08= |07Compiles <filename> into STRINGS.DAT.');
  ioCwriteln(' |15IQSTRING |07DECOMPILE |01<|09filename|01> |08= |07Decompiles STRINGS.DAT into <filename>.');
  oDnLn(1);
  ioCWriteln('|08 |07Note |08: |15When compiling, any string starting with ";" is ignored.');
  Halt (3);
 End;


 Procedure Compile (FileName : String);
 Begin
  Assign (TempTxt, FileName);
  {$I-} Reset (TempTxt); {$I+}
  If IoResult <> 0 Then Begin
   ioCWriteln('|08 |15'+ FileName +' |07not found!!!');
   Halt (5);
  End;

  ioCwriteln('|08 |07Compiling |15'+FileName+' |08-> |07STRINGS.DAT');

  Assign  (TempStr, Cfg.PathData + 'STRINGS.DAT');
  Rewrite (TempStr);

  While Not Eof (TempTxt) Do Begin
   FillChar(TempString, SizeOf (TempString), #0);
   ReadLn (TempTxt, TempString);
   If TempString[1] <> Comment Then Begin
    Write (TempStr, TempString);
    Inc (NumStrings);
    Delay (1);
    UpdateNum;
   End;
  End;
  Close (TempTxt);
  Close (TempStr);
  WriteLn;
  ioCWriteln('|08 |15Compile successful...');
 End;

 Procedure DeCompile (FileName : String);
 Begin
  Assign (TempStr, Cfg.PathData + 'STRINGS.DAT');
  {$I-} Reset (TempStr); {$I+}
  If IoResult <> 0 Then Begin
   ioCWriteln('|08 |15STRINGS.DAT |07not found!!!');
   Halt (5);
  End;
  ioCwriteln ('|08 |07Decompiling |15STRINGS.DAT |08-> |07'+FileName);
  Assign  (TempTxt, FileName);
  Rewrite (TempTxt);
  Writeln(Temptxt,comment+'-- iqString v2.00  (C)opyright 1997-1998, Joseph Kirk [Kargus]');
  Writeln(Temptxt,comment+'-- Iniquity BBS STRINGS.DAT Compiler/Decompiler');
  Writeln(Temptxt,comment+'-');
   While Not Eof (TempStr) Do Begin
    FillChar(TempString, SizeOf (TempString), #0);
    Read (TempStr, TempString);
    WriteLn (TempTxt, TempString);
    Inc (NumStrings);
    Delay (1);
    UpdateNum;
  End;
  Close (TempTxt);
  Close (TempStr);
  WriteLn;
  ioCWriteln('|08 |15Decompile successful...');
 End;

 Begin
  ioInitFastIO;
  ioTextMode;
  ioClrScr;

  NumStrings := 0;

  If ParamCount < 1 Then ShowHelp;

  Logo;
  WriteLn;

  LoadConfig;
  if ParamCount = 2 then
   begin;
     If UpString (ParamStr (1)) = 'COMPILE' Then Compile (UpString(ParamStr (2))) Else
     If UpString (ParamStr (1)) = 'DECOMPILE' Then Decompile (UpString(ParamStr (2)));
   end else
   begin
     ioCWrite('|08 |07Enter Filename|08: ');
     ioGotoXY(19,5);
     readln(fname);
     oDnLn(1);
     If fname = '' then ShowHelp;
     If UpString (ParamStr (1)) = 'COMPILE' Then Compile (UpString(fname)) Else
     If UpString (ParamStr (1)) = 'DECOMPILE' Then Decompile (UpString(fname));
   end;
 End.
