{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
unit Logon;

interface

function  logonGetLogin : Boolean;
procedure logonInit;
procedure logonSystem;

implementation

uses
   Crt, Global, Output, Detect, Misc, StrProc, Input, Files, ShowFile,
   MsgArea, StatBar, BBSinit, Levels, Apply, Callers, Logs, Users, FastIO,
   Comm, Emulate, dateTime;

procedure logonInit;
var Z : Byte; S, X : String;
begin
   PausePos := 0;
   if not ((LocalIO) and (Cfg^.SysOpAutologin)) then
   begin
      sbInfo('Initializing logon system ...',True);
      InMenuEditor := false;
      InUserEditor := false;
      iplResult    := '';
      User^.acFlag := User^.acFlag - [acYesNoBar,acAnsi,acRIP,acAVATAR];
      emuTextFX := false;
      if not LocalIO then
      begin
         Delay(1200);
         oDnLn(1); {ClrScr;}
         sbInfo('Detecting terminal emulation ...',True);
         User^.BaudRate := BaudRate;
         ioTextAttr($07);
         oString(strDetectEmu);
         detEmulation;
         if DetAnsi then User^.acFlag := User^.acFlag + [acAnsi];
         if DetRIP then User^.acFlag := User^.acFlag + [acRIP];
         if DetAVATAR then User^.acFlag := User^.acFlag + [acAVATAR];
         if DetTextFX then
         begin
            emuTextFX := True;
            fxInit;
            oStrLn(strCode(mStr(strDetectTextFX),1,RIPterm));
            S := 'TextFX detected! ('+RIPterm+')';
         end else
         if DetRIP then
         begin
            oStrLn(strCode(mStr(strDetectRIP),1,RIPterm));
            S := 'RIP support detected (terminal ID: '+RIPterm+')';
         end else
         if DetAVATAR then
         begin
            oStringLn(strDetectAVATAR);
            S := 'Avatar/ANSI terminal detected';
         end else
         if DetAnsi then
         begin
            oStringLn(strDetectAnsi);
            S := 'ANSI terminal detected';
         end else
         begin
            oStringLn(strDetectNone);
            S := 'Emulation detect failed';
         end;
         sbInfo(S,True);
         logWrite(S);
         User^.BaudRate := BaudRate;
         if emuTextFX or detRIP or detAvatar then User^.acFlag := User^.acFlag+[acAnsi];
         if not (acAnsi in User^.acFlag) then
         begin
            oStringLn(strNoAnsiDetected);
            if cfg^.ifNoAnsi = 1 then Hangup := True else
            if cfg^.ifNoAnsi = 2 then
            begin
               oString(strNoAnsiAskContinue);
               if not iYesNo(true,true) then
               begin
                  logWrite('User chose not to continue without ansi, disconnecting');
                  Hangup := True;
               end;
            end;
            if not Hangup then
            begin
               oStringLn(strNoAnsiContinuing);
               User^.acFlag := User^.acFlag+[acAnsi];
            end;
         end;
         cCheckUser;
         oStrLn(strCode(mStr(strConnectedAt),1,mBaudString(User^.BaudRate)));
         Delay(1200);
         x := 'x';
         if BaudRate < cfg^.minBaud then
         begin
            oStrLn(strCode(strCode(mStr(strBbsMinBaudrate),1,st(cfg^.minBaud)),2,st(BaudRate)));
            if cfg^.noBaudPW <> '' then
            begin
               z := 1;
               repeat
                  oString(strBbsAskBaudPW);
                  s := iReadString('',inUpper,chNormal,rsPassword,20);
                  Inc(z);
               until (s = upStr(cfg^.noBaudPW)) or (Hangup) or (z > 3);
               if s = upStr(cfg^.noBaudPW) then x := '';
            end;
            if x <> '' then
            begin
               oStringLn(strBbsHangingUp);
               Hangup := True;
               cCheckUser;
            end;
         end;
         oSetColor(7,0);
      end else
      begin
         detEmulation;
         fxInit;
         User^.acFlag := User^.acFlag+[acAnsi];
         User^.BaudRate := 0;
         oSetColor(7,0);
      end;
      oClrScr;
      sbInfo('',False);
      sfShowTextFile(txPrelogon,ftNormal);
   end else
   begin
      detEmulation;
      fxInit;
   end;
   LoggedIn := False;
end;

procedure logonSystem;
var N : Byte; Ok : Boolean;
begin
   if (logonGetLogin) and (not LoggedIn) then applyToBBS;
   if (not LoggedIn) and (not Cfg^.MatrixLogin) then HangUp := True;
   if not ((LocalIO) and (Cfg^.SysOpAutoLogin)) then
   begin
      dtGetDateTime(TimeOn);
      sfShowTextFile(txWelcome,ftNormal);
      N := 1;
      repeat
         Ok := sfShowTextFile(txWelcome+'.'+St(N),ftNormal);
         Inc(N,1);
      until (N > 9) or (not Ok);
      sfShowTextFile(txSL+St(User^.SL),ftNormal);
      sfShowTextFile(txDSL+St(User^.DSL),ftNormal);
   end;
end;

function logonGetLogin : Boolean;
var Found, Ans : Boolean;
    Pw, Un, Ph, Bd, sPw, S {'S'nuitari} : String;
    Try : Word;
    Ok : Boolean;
    Len, iLen, hLen : Byte;

 procedure glWriteHelp(S : String);
 begin
    if (not Ans) or (not sfGotoPos(4)) then Exit;
    if hLen > 0 then
    begin
       oWrite(sRepeat(' ',hLen));
       sfGotoPos(4);
    end;
    hLen := Length(NoColor(S));
    oStr(S);
 end;

 procedure glWriteInfo(S : String);
 begin
    if (not Ans) or (not sfGotoPos(3)) then Exit;
    if iLen > 0 then
    begin
       oWrite(sRepeat(' ',iLen));
       sfGotoPos(3);
    end;
    iLen := Length(NoColor(S));
    oStr(S);
 end;

begin
   logonGetLogin := False;
   hLen := 0;
   iLen := 0;
   if (not HangUp) and (not HungUp) and
      (LocalIO) and (Cfg^.SysOpAutoLogin) then
   begin
      logWrite('*SysOp autologin initiated.');
      userReset;
      User^.BaudRate := 0;
      logonGetLogin := True;
      LoggedIn := True;
      Exit;
   end;
   sbInfo('Preparing login system.',True);
   Ans := sfShowTextFile(txLogin,ftLogin);
   Len := Length(NoColor(mStr(strLoginUnknown)));
   if Length(NoColor(mStr(strLoginError))) > Len then
      Len := Length(NoColor(mStr(strLoginError)));
   if Length(NoColor(mStr(strLoginAskApply)))+11 > Len then
      Len := Length(NoColor(mStr(strLoginAskApply)))+11;
   if not Ans then
   begin
      oClrScr;
      oGotoXY(1,8);
   end;
   Try := 0;
   Ok := False;
   User^.UserName := '';
   Pw := '';
   Un := '';
   repeat
      UserPrelogonInit;
      sbInfo('Awaiting user login.',True);
      if Ans then
      begin
         glWriteHelp(mStr(strLoginHelpName));
         glWriteInfo('');
         if Pw <> '' then
         begin
            sfClearPos(2,Length(Pw));
            sfClearPos(1,Length(Un));
         end else sfGotoPos(1);
      end else oString(strLoginName);
      Un := iReadString('',mAliasFormat,chNormal,rsNoEdit+rsMin,36);
      User^.UserName := Un;
      Ok := False;
      if (Cfg^.AskApply) and (upStr(User^.UserName) = 'NEW') then
      begin
         logWrite('User logged in as ''new''; application system loaded');
         Found := False;
         LoggedIn := False;
         Ok := True;
      end else Found := userSearch(User^,False);
      if (not Found) and (not Ok) then
      begin
         sbInfo('Unknown user.',True);
         if Ans then glWriteHelp(mStr(strLoginUnknown)) else
            oStringLn(strLoginUnknown);
         if Cfg^.AskApply then
         begin
            logWrite('-User not found in records ('+User^.Username+'), offering application');
            Pw := '--';
            if Ans then
            begin
               if not HangUp then Delay(1000);
               glWriteHelp(mStr(strLoginHelpApply));
               glWriteInfo(mStr(strLoginAskApply));
               Inc(iLen,10);
            end else oString(strLoginAskApply);
            Ok := iYesNo(False,true);
            LoggedIn := False;
         end else logWrite('-User not found in records ('+User^.Username+')');
      end;
      if (Found) and (userLoad(User^)) then
      begin
{--- start nuitari ---}
{added}  if Cfg^.ShowPwLogon then S := User^.Password else
{added}  S := strEcho(User^.Password);
         sbInfo('|MUser |L[|H'+User^.Username+'|L] -- |MPassword |L[|H'+S+'|L]',True);
{old     sbInfo('|MUser |L[|H'+User^.Username+'|L] -- |MPassword |L[|H'+User^.Password+'|L]',True); }
{--- end nuitari ---}
         glWriteHelp(mStr(strLoginHelpPw));
         if Ans then sfGotoPos(2) else oString(strLoginPassword);
         User^.BaudRate := BaudRate;
         Ph := '';
         Bd := '';
         Ok := True;
         Pw := iReadString('',inUpper,chNormal,rsNoEdit+rsPassword+rsMin,20);
         if (mStdPhone(User^.PhoneNum)) and (Cfg^.CallsPhone > 0) and (User^.TotalCalls mod Cfg^.CallsPhone = 0) then
         begin
            sbInfo('|MUser |L[|H'+User^.Username+'|L] -- |MPhone Number |L[|H'+User^.PhoneNum+'|L]',True);
            glWriteHelp(mStr(strLoginHelpPhone));
            if Ans then glWriteInfo(mStr(strLoginPhone)) else
               oString(strLoginPhone);
            Inc(iLen,4);
            Ph := iReadString('',inUpper,chNumeric,rsNoEdit+rsReq,4);
            if Ok then
            begin
               Ok := Ph = Copy(User^.PhoneNum,10,4);
               if not Ok then
               begin
                  logWrite('-User "'+User^.Username+'" failed phone number verification test');
                  logWrite('-Phone number is '+Copy(User^.PhoneNum,10,4)+'.  User entered '+Ph);
               end;
            end;
         end;
         if (Cfg^.CallsBirth > 0) and (User^.TotalCalls mod Cfg^.CallsBirth = 0) then
         begin
            sbInfo('|MUser |L[|H'+User^.Username+'|L] -- |MBirthdate |L[|H'+User^.Birthdate+'|L]',True);
            glWriteHelp(mStr(strLoginHelpBirth));
            if Ans then glWriteInfo(mStr(strLoginBDate)) else
               oString(strLoginBDate);
            Inc(iLen,8);
            Bd := iReadDate('');
            if Ok then
            begin
               Ok := Bd = User^.BirthDate;
               if not Ok then
               begin
                  logWrite('-User "'+User^.Username+'" failed birthdate verification test');
                  logWrite('-Birthdate is '+User^.Birthdate+'.  User entered '+Bd);
               end;
            end;
         end;
         if Ok then
         begin
            Ok := Pw = User^.Password;
            if not Ok then
            begin
               logWrite('-User "'+User^.Username+'" entered password incorrectly');
               logWrite('-Password is "'+User^.Password+'".  User entered "'+Pw+'"');
            end;
         end;
         if (Ok) and (Cfg^.SystemPW <> '') and (acsOk(Cfg^.acsSystemPWLogin)) then
         begin
            sbInfo('|MUser |L[|H'+User^.Username+'|L] -- |MAwaiting sysop password.',True);
            glWriteHelp(mStr(strLoginHelpSysPw));
            if Ans then glWriteInfo(mStr(strLoginSystemPW)) else
               oString(strLoginSystemPW);
            sPw := iReadString('',inUpper,chNormal,rsNoEdit+rsPassword+rsMin,20);
            Inc(iLen,Length(sPw));
            Ok := sPw = Cfg^.SystemPW;
            if not Ok then
            begin
               logWrite('-Incorrect sysop access password entered');
               logWrite('-Received: '+sPw+'.  Real: '+Cfg^.SystemPW);
            end;
         end;
         if not Ok then
         begin
            sbInfo('Invalid login attempt.',True);
            if Ans then glWriteHelp(mStr(strLoginError)) else
               oStringLn(strLoginError);
            Delay(1000);
         end else LoggedIn := True;
      end;
      Inc(Try);
   until (HangUp) or (Ok) or ((Cfg^.LoginTrys > 0) and (Try >= Cfg^.LoginTrys));
   if ((Cfg^.LoginTrys > 0) and (Try >= Cfg^.LoginTrys) and (Ok=false)) then
     userPreLogonInit;
   logonGetLogin := (Ok) and (not HangUp);
   cCheckUser;
   sbInfo('',False);
end;

end.
