{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
unit MCIcodes;

{ ck - added code for mci parameters }

interface

function mciProcess(S : String; Len : Byte) : String;
function mciProcessControlCode(C : String) : Boolean;
function mciProcessMCICode(C : String) : Boolean;
function mciProcessParams(s,Params : String) : String;

implementation

uses
   Crt, Global, Output, StrProc, Misc, DateTime, Input, Netmodem;

function mciProcessControlCode(C : String) : Boolean;
begin
   mciProcessControlCode := False;
   if (Length(C) <> 3) or (C[1] <> ctrHeader) then Exit;
   Delete(C,1,1);
   C := UpStr(C);
   if (noControl) and (copy(C,1,2) <> 'ZB') then exit; {added comatose}
   mciProcessControlCode := true;
   case C[1] of
     'Z' : case C[2] of
             'A' : nocontrol := true;  {added comatose}
             'B' : noControl := false; {added comatose}
             else mciProcessControlCode := False;
           end;
     '0' : case C[2] of
             '0'..'9' : oSetFore(ord(c[2]) AND $0F);
             { changed : horrid 12/5/1998 }
             else mciProcessControlCode := False; {added codered - fse fix}
           end;
     '1' : case C[2] of
             '0'..'5' : oSetFore(10 + (ord(c[2]) AND $0F));
             { changed : horrid 12/5/1998 }
             '6'..'9' : oSetBack((ord(c[2]) AND $0F) - 6);
             { changed : horrid 12/5/1998 }
             else mciProcessControlCode := False; {added codered - fse fix}
           end;
     '2' : case C[2] of
             '0'..'3' : oSetBack(4 + (ord(c[2]) AND $0F));
             { changed : horrid 12/5/1998 }
             else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'A' : case C[2] of
              'S' : saveCol := Col;
              'L' : oSetColRec(saveCol);
              'D' : EnableAnsiAborting := false;
              else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'B' : case C[2] of
             '0'..'7' : oSetBack(ord(c[2]) AND $0F);
             { changed : horrid 12/5/1998 }
             else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'C' : case C[2] of
              'B' : oMoveDown(25);
              'D' : oMoveDown(1);
              'E' : oMoveRight(80);
              'H' : oMoveLeft(80);
              'L' : oMoveLeft(1);
              'R' : oMoveRight(1);
              'S' : oClrScr;
              'T' : oMoveUp(25);
              'U' : oMoveUp(1);
              'Z' : oClrEol;
              else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'D' : case C[2] of
              'E' : Delay(750);
              'H' : Delay(500);
              'M' : Delay(100);
              'S' : Delay(1000);
              else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'H' : case C[2] of
              'C' : oGotoXY(1,1);
              else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'L' : case C[2] of
              'C' : oRestoreCursor;
              'F' : oWrite(#13#10);
              else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'P' : case C[2] of
              'A' : oPromptKey;
              'K' : iReadKey;
              'S' : oPause;
              else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'S' : case C[2] of
              'C' : oSaveCursor;
              else mciProcessControlCode := False; {added codered - fse fix}
           end;
     'U' : case C[2] of
              '0' : oSetCol(colError);
              '1' : oSetCol(colText);
              '2' : oSetCol(colTextLo);
              '3' : oSetCol(colTextHi);
              '4' : oSetCol(colInfo);
              '5' : oSetCol(colInfoLo);
              '6' : oSetCol(colInfoHi);
              '7' : oSetCol(colItem);
              '8' : oSetCol(colItemSel);
              '9' : oSetCol(colBorder);
              else mciProcessControlCode := False; {added codered - fse fix}
           end;
     else mciProcessControlCode := False;
   end;
end;

function mciProcessMCICode(C : String) : Boolean;
var S     : String;
    SSnum : Word;
begin
   if noControl then exit;
   mciProcessMCIcode := False;
   S := '';
   C := UpStr(C);
   if (Length(C) <> 3) or (C[1] <> mciHeader) then Exit;
   mciProcessMCIcode := true;
   Delete(C,1,1);
   case C[1] of
     'A' : case C[2] of
         '1'..'6' : if User^.AutoSigLns >= StrToInt(C[2]) then
                    S := User^.AutoSig[StrToInt(C[2])] else S := '';
              'C' : S := mAreaCode(User^.PhoneNum);
              'D' : S := User^.Address;
              'L' : S := St(User^.AutoSigLns);
              'Q' : S := B2St(acQuote in User^.acFlag);
           end;
     'B' : case C[2] of
              'D' : S := User^.Birthdate;
              'L' : S := Cfg^.bbsLocation;
              'N' : S := Cfg^.BBSname;
              'P' : S := Cfg^.BBSphone;
              'R' : S := mBaudString(User^.BaudRate);
           end;
     'C' : case C[2] of
              'F' : S := fConf^.Desc;
              'M' : S := mConf^.Desc;
              'T' : S := Stc(User^.CallsToday);
           end;
     'D' : case C[2] of
              'C' : S := Stc(His^.Calls);
              'D' : S := Stc(His^.Downloads);
              'F' : S := dtDateFullString(dtDateString);
              'K' : S := Stc(User^.DownloadKb)+'k';
              'L' : S := Stc(User^.Downloads);
              'P' : S := Stc(His^.Posts);
              'S' : S := St(User^.DSL);
              'T' : S := dtDateString;
              'U' : S := Stc(His^.Uploads);
           end;
     'E' : case C[2] of
              'M' : S := mEmulation(User^);
           end;
     'F' : case C[2] of
              'A' : S := fArea^.Name;
              'C' : S := User^.FirstCall;
              'D' : S := User^.fileScan;
              'P' : S := St(User^.filePts);
              'I' : S := St(User^.curFileArea);
              'S' : S := User^.fileScan;
           end;
     'H' : case C[2] of
              'K' : S := B2St(acHotKey in User^.acFlag);
           end;
     'I' : case C[2] of
              'D' : S := St(User^.Number);
              'N' : S := bbsTitle;
              'S' : S := inputString;
              'V' : S := bbsVersion;
           end;
     'L' : case C[2] of
              'A' : if tLibOpen then S := textLib^.Author else S := 'n/a';
              'C' : S := User^.LastCall;
              'D' : if tLibOpen then S := textLib^.Desc else S := 'n/a';
              'O' : S := User^.Location;
           end;
     'M' : case C[2] of
              'A' : S := mArea^.Name;
              'I' : S := St(User^.curMsgArea);
              'N' : S := St(curMsg);
              'P' : S := Menu^.PromptName;
              'T' : S := St(numMsg);
              'W' : S := St(User^.EmailWaiting);
           end;
     'N' : case C[2] of
              'D' : S := St(node);
              'H' : S := netmHostName(node);
              'I' : S := netmIPnum(node);
           end;
     'P' : case C[2] of
              'A' : S := B2St(acPause in User^.acFlag);
              'L' : S := St(User^.PageLength);
              'N' : S := User^.PhoneNum;
              'W' : S := User^.Password;
           end;
     'R' : case C[2] of
              'N' : S := User^.RealName;
              'T' : S := ripTerm;
           end;
     'S' : case C[2] of
              'L' : S := St(User^.SL);
              'N' : S := Cfg^.SysOpAlias;
              'O' : S := User^.SysopNote;
              'R' : S := Cfg^.SysOpName;
              'X' : S := mSexString(User^.Sex);
           end;
     'T' : case C[2] of
              'C' : S := Stc(Stat^.Calls);
              'D' : S := Stc(Stat^.Downloads);
              'E' : S := Stc(Stat^.Email);
              'I' : S := dtTimeStr12;
              'L' : S := St(mTimeLeft('M'));
              'M' : S := dtTimeStr24;
              'P' : S := Stc(Stat^.Posts);
              'T' : S := St(User^.TimePerDay);
              'U' : S := Stc(numUsers);
              'Z' : S := mRatio(Stat^.Posts,Stat^.Calls);
           end;
     'U' : case C[2] of
              'A' : S := User^.Level;
              'C' : S := Stc(User^.TotalCalls);
              'E' : S := Stc(User^.Email);
              'I' : S := mInitials(User^.Username);
              'K' : S := Stc(User^.UploadKb)+'k';
              'L' : S := Stc(User^.Uploads);
              'N' : S := User^.UserName;
              'O' : S := User^.UserNote;
              'P' : S := Stc(User^.Posts);
              'Z' : S := mRatio(User^.Posts,User^.TotalCalls);
           end;
     'V' : case C[2] of
              'L' : S := bbsVerLong;
              'N' : S := Stc(User^.voteNo);
              'Y' : S := Stc(User^.voteYes);
           end;
     'X' : case C[2] of
              'M' : S := B2St(acExpert in User^.acFlag);
           end;
     'Y' : case C[2] of
              'N' : S := B2St(acYesNoBar in User^.acFlag);
           end;
     '@' : case C[2] of
         'A'..'Z' : S := B2St(C[2] in User^.Flag);
           end;
     else begin mciProcessMCIcode := False; S := mciHeader+C; end;
   end;
   mciString := S;
end;

function mciProcess(S : String; Len : Byte) : String;
var Cd : String; N : Byte;
    i : byte;
begin
   mciProcess := '';
   N := 0;
   if S = '' then Exit;
   while N < Length(S) do
   begin
      Inc(N);
      if S[N] = mciHeader then
      begin
         if mciProcessMCICode(Copy(S,N,3)) then
         begin
            Delete(S,N,3);
            if Len <> 0 then mciString := strSquish(mciString,Len);
            Insert(mciString,S,N);
            Dec(N);
         end;
      end;
   end;
   mciProcess := S;
end;

function GetWord(num : byte; s : string) : string;
var i : byte;
    wordnum : byte;
    tempstr : string;
begin;
wordnum := 1;
tempstr := '';

i := 1;
while s[i] = ' ' do inc(i,1);

for i := i to length(s) do
    begin;
    if (s[i]=' ') and(s[i-1]<>' ') then inc(wordnum, 1) else
       if (wordnum = num) and (s[i]<>' ') then tempstr := tempstr + s[i];
    end;
GetWord := tempstr;
end;

function GetNumber(s : string; pos : byte) : string;
var i : byte;
    tempstr : string;
begin;
i := pos;
tempstr := '';

while (s[i] in ['0','1'..'9']) and (i <= length(s)) do
 begin;
 tempstr := tempstr + s[i];
 inc(i,1);
 end;
GetNumber := tempstr;
end;

function mciProcessParams(s,Params : String) : String;
var i : byte;
    CodePos : byte;
    TempStr : String;
    Result  : String;
    Color   : String[2];

    IgnoreColorInsertCodes : boolean;

begin;
i := 1;
Result := s;
IgnoreColorInsertCodes := pos('|',Result) > 0;

repeat
case Params[i] of
     'm' : begin;
           TempStr := GetNumber(params, i+1);
           Result := Resize(Result,StrToInt(TempStr));
           inc(i, length(TempStr));
           end;
     'f' : begin;
           inc(i, 1);
           case params[i] of
                'U': Result := UpStr(Result);
                'l': Result := strLow(Result);
                'C': Result := strMixed(Result);
                'w': Result := strWierd(Result);
                '3': Result := str31337(Result);
                end;
            inc(i,1);
           end;
     'c' : begin;
            CodePos := 1;
            repeat
             color := GetNumber(params, i+1);
             inc(i, length(color)+1);
             if length(color) = 1 then color := '0' + color;
             if not IgnoreColorInsertCodes then
              insert('|'+color,Result,CodePos);
             inc(CodePos,4);
            until (params[i] <> ',') or (i > length(params));
           end;
     'w' : begin;
           TempStr := GetNumber(params, i+1);
           Result := GetWord(StrToInt(TempStr), Result);
           inc(i, length(tempstr));
           end;
     else; inc(i, 1);
     end;
until (i>=length(params));

mciProcessParams := Result;
end;

end.
