{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}

unit netmodem;  { NetModem/32 unit for iniquity v1.12   by: Comatose }
                { greets to: horrid, nd, and j-dredd for the help =] }
interface

procedure cfgKillNetmodem;
procedure cfgLoadNetModem;
procedure cfgNetmodemSs;
procedure cfgNetmodemNodes;
procedure cfgNetmodemCr( B : Byte);
procedure cfgNetmodemCalls;
procedure cfgNetmodemCfg( WR : boolean);
procedure cfgNetmodem;
function  netmIPnum( N : Byte) : String;
function  netmHostName( N : Byte) : String;
function  byteToString( B : Byte) : String;
function  wordToString( W : Word) : String;

implementation

uses  config, global, logs, input, output, datetime, crt, strproc;

var
    cfgError : Boolean;
    nsError  : Boolean;
    crError  : Boolean;
    ssError  : Boolean;
        out  : Boolean;

function byteToString( B : Byte) : String;
var S : String;
begin;
str(B,S);
byteToString := S;
end;

function wordToString( W : Word) : String;
var S : String;
    N : String;

begin;
N := '00      ';
str(W,S);
wordToString := S+N;
end;

procedure cfgKillNetmodem;  { empties the dynamic variables }
begin
   dispose(nmNs);
   dispose(nmCfg);
   dispose(nmSs);
   dispose(aNmNs);
   dispose(aNmCfg);

end;

procedure cfgLoadNetModem;  { loads all of netmodems records }
begin
   new(nmSs);
   cfgNetmodemSs;

   new(aNmNs);
   new(nmNs);
   cfgNetmodemNodes;

   new(aNmCfg);
   new(nmCfg);
   cfgNetmodemCfg(false);

end;


procedure cfgNetmodemSs;    { loads netmodems server status }
var
   fISF   : File of tServerRecord;

begin
    assign(fISF,Cfg^.pathNetModem+fileNetmSs);
   {$I-}Reset(fISF);{$I+}
    if ioResult <> 0 then
    begin;
    logWrite('Error Opening '+fileNetmSs+' '+dtTimeStr12+','+dtDateString);
    exit;
    end;

   {$I-}read(fISF,nmSs^);{$I+}
   if ioResult <> 0 then
     begin
      close(fISF);
      logWrite('Error Reading '+fileNetmSs+' '+dtTimeStr12+','+dtDateString);
      exit;
     end;
   Close(fISF);
ssError := False;
end;


procedure cfgNetModemNodes; { reads netmodem nodes status }
var
  fINF  : File of tNodeInfoRecord;
  count : Byte;

begin
   count := 1;
   Assign(fINF,Cfg^.pathNetmodem+fileNetmNs);
   {$I-}Reset(fINF);{$I+}
   if ioResult <> 0 then
    begin;
    logWrite('Error Opening '+fileNetmNs+' '+dtTimeStr12+','+dtDateString);
    exit;
   end;
   seek(fINF,0);

 begin;
   for count := 1 to maxPorts do
    begin;
   {$I-}read(fINF,nmNs^);{$I+}
    if ioResult <> 0 then
     begin;
      close(fINF);
      logWrite('Error Reading '+fileNetmNs+' '+dtTimeStr12+','+dtDateString);
      exit;
     end;
    aNmNs^[count] := nmNs^;
    end;
    Close(fINF);
    end;


nsError := false;
end;

procedure cfgNetModemCr( B : Byte); { reads netmodem connection list }
var
  fICL  : File of tCallRecord;
  count : Byte;
  S     : Byte;

begin
   S := B+1;
   B := B-1;
   new(nmCr);
   Assign(fICL,Cfg^.pathNetmodem+fileNetmCl);
   {$I-}Reset(fICL);{$I+}
   if ioResult <> 0 then
    begin;
    logWrite('Error Opening '+fileNetmCl+' '+dtTimeStr12+','+dtDateString);
    exit;
   end;
    if filesize(fICL) < S then
     begin;
       out := True;
       exit;
     end;

   if filesize(fICL) > 13 then seek(fICL,filesize(fICL)-14+B) else
         seek(fICL,B);

   begin;
   {$I-}read(fICL,nmCr^);{$I+}
    if ioResult <> 0 then
     begin;
      close(fICL);
      dispose(nmCr);
      logWrite('Error Reading '+fileNetmCl+' '+dtTimeStr12+','+dtDateString);
      exit;
     end;
    Close(fICL);
   end;


crError := False;
end;


procedure cfgNetModemCfg( wr : Boolean); { reads and write netmodems config }
var
  fICF  : File of tNodeRecord;
  count : Byte;

begin
   count := 1;
   Assign(fICF,Cfg^.pathWindows+fileNetmCfg);
   {$I-}Reset(fICF);{$I+}
   if ioResult <> 0 then
    begin;
    logWrite('Error Opening '+fileNetmCfg+' '+dtTimeStr12+','+dtDateString);
    exit;
   end;
   seek(fICF,0);

 if wr then
  begin;
  for count := 1 to maxPorts do
   begin;
   {$I-}write(fICF,aNmCfg^[count]);{$I+}
   if ioResult <> 0 then
     begin;
       logWrite('Error Writting '+fileNetmCfg+' '+dtTimeStr12+','+dtDateString);
       exit;
     end;
   end;
   close(fICF);

   end else

   begin;
   for count := 1 to maxPorts do
    begin;
   {$I-}read(fICF,nmCfg^);{$I+}
    if ioResult <> 0 then
     begin;
      close(fICF);
      logWrite('Error Reading '+fileNetmCfg+' '+dtTimeStr12+','+dtDateString);
      exit;
     end;
    aNmCfg^[count]      := nmCfg^;
    aNmCfg^[count].node := count;
    end;
   Close(fICF);
   end;

cfgError := False;
end;


function netmIPnum(n : byte): string;
begin;
  cfgLoadNetmodem;
  netmIPnum := aNmNs^[n].RemoteIP;
  cfgKillNetmodem;
end;

function netmHostName(n : byte): string;
begin;
  cfgLoadNetmodem;
  netmHostName := aNmNs^[n].RemoteHostName;
  cfgKillNetmodem;
end;


procedure cfgNetmodem;      { configuration and statistic viewing }
var
    nmBaudRate  : array[1..18] of Word;
    nmMaxNodes  : Byte;
    nmMaxPorts  : Byte;
    check       : String[1];
    Ch          : Char;
    nod         : Byte;
    conn        : Boolean;
    comp        : Byte;
    B           : Byte;

begin
   cfgError := True;
   nsError  := True;
   crError  := False;
   ssError  := True;

   nmBaudRate[1] := 3;
   nmBaudRate[2] := 12;
   nmBaudRate[3] := 24;
   nmBaudRate[4] := 48;
   nmBaudRate[5] := 72;
   nmBaudRate[6] := 96;
   nmBaudRate[7] := 120;
   nmBaudRate[8] := 144;
   nmBaudRate[9] := 168;
   nmBaudRate[10] := 192;
   nmBaudRate[11] := 216;
   nmBaudRate[12] := 240;
   nmBaudRate[13] := 264;
   nmBaudRate[14] := 288;
   nmBaudRate[15] := 384;
   nmBaudRate[16] := 576;
   nmBaudRate[17] := 640;
   nmBaudRate[18] := 1152;

   cfgLoadNetmodem;


   cfgDraw := True;
   cfgOver := False;

   if aNmCfg^[1].node = 0 then
         aNmCfg^[1].node := 1;

     nod   := aNmCfg^[1].node;


     if nmSs^.Registered = True then
      begin;
      nmMaxNodes := maxPorts;
      end else
      begin;
      nmMaxNodes := 1;
      end;
       nmMaxPorts := maxPorts-1;


     repeat
           { value checking }
     if cfgError = false then
      begin;
       if aNmCfg^[nod].node < 1 then
          aNmCfg^[nod].node := 1;
       if aNmCfg^[nod].node > 8 then
          aNmCfg^[nod].node := 8;
       if aNmCfg^[nod].comport < 2 then
          aNmCfg^[nod].comport := 2;
       if aNmCfg^[nod].comport > 9 then
          aNmCfg^[nod].comport := 9;
       if aNmCfg^[nod].baudrate < 3 then
          aNmCfg^[nod].baudrate := 3;
       if aNmCfg^[nod].baudrate > 1152 then
          aNmCfg^[nod].baudrate := 1152;
       end;

      cfgInit('Netmodem/32 Configuration');

      if cfgError = false then
      begin;
      cfgWrite('    |15Node                     |15'+byteToString(nod));
      end else cfgWrite('    |15Node');

      if ssError = false then
      begin;
      cfgWrite('    |15Version                  |15'+nmSs^.Version);
      cfgWrite('    |15Build                    |15'+nmSs^.xBuild);
      if nmSs^.Registered = True then
      cfgWrite('    |15Registered               |15yes') else
      cfgWrite('    |15Registered               |15no');
      cfgWrite('    |15Local Hostname           |15'+nmSs^.LocalHostName);
      cfgWrite('    |15Local IP Address         |15'+nmSs^.LocalIP);
      end else
       begin;
       cfgWrite('    |15Version');
       cfgWrite('    |15Build');
       cfgWrite('    |15Registered');
       cfgWrite('    |15Local Hostname');
       cfgWrite('    |15Local IP Address');
       end;
      if nsError = false then
      begin;
      conn := aNmNs^[nod].Connected;
      if conn = true then
      cfgWrite('    |15Connected                |15yes') else
      cfgWrite('    |15Connected                |15no');

       if aNmNs^[nod].RemoteHostName[1] = '' then
        begin;  { something is screwy with the nodeinfo record }
         aNmNs^[nod].RemoteHostName := 'Not Available!';
         aNmNs^[nod].RemoteIP := 'Not Available!';
        end;
          cfgWrite('    |15Remote Hostname          |15'+aNmNs^[nod].RemoteHostName);
          cfgWrite('    |15Remote IP                |15'+aNmNs^[nod].RemoteIP);

      end else
        begin;
         cfgWrite('    |15Connected');
         cfgWrite('    |15Remote HostName');
         cfgWrite('    |15Remote IP');
        end;
      if cfgError = false then
          begin;
      cfgItem('A Comport',1,byteToString(aNmCfg^[nod].ComPort+1),
              'Comm Port that this NetModem/32 node will use');
      cfgItem('B Baud Rate',6,wordToString(aNmCfg^[nod].Baudrate),
               'Buad Rate that this Netmodem/32 node will use');
      cfgItem('C Note',40,aNmCfg^[nod].Note,
              'Remarks on this node');
      end else
      begin;
      cfgItem('A Comport',0,'','');
      cfgItem('B Baud Rate',0,'','');
      cfgItem('C Note',0,'','Remarks on this node');
      end;

      cfgItem('D Connections List',0,'',
              'Lists the connections to NetModem/32');


      if cfgError = false then
      begin;
      cfgItem('[ Previous Node',0,'','');
      cfgItem('] Next Node',0,'','');
      end;

      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;

      case cfgKey of


      'A' : begin
          cfginfo('ComPort that this NetModem/32 node will use');
          if cfgError = false then
          begin;


            B := aNmCfg^[nod].ComPort;
            oGotoXY(30,14);
            oSetCol(colTextHi);
            repeat
            oWrite(byteToString(aNmCfg^[nod].ComPort+1));
            oGotoXY(30,14);

                Ch := UpCase(iReadKey);
                if extkey = #0 then
                   case Ch of
                 ' ' : begin
                       Inc(B,1);
                       if B > nmMaxPorts then B := 3;
                       end;
                   end else
                   case extKey of
             #75,#80 : begin
                       Dec(B,1);
                       if B < 2 then B := nmMaxPorts;
                       aNmCfg^[nod].ComPort := B;
                       end;
             #77,#72 : begin
                       inc(B,1);
                       if B > nmMaxPorts then B := 2;
                       aNmCfg^[nod].ComPort := B;
                       end;
                    end;
                    until (HangUp) or (Ch in [#27,#13]);
              cfgSetItem(byteToString(aNmCfg^[nod].ComPort+1));
            end;
          cfginfo('');
          end;

      'B' : begin
          cfgInfo('Baud Rate that this Netmodem/32 node will use');
          if cfgError = false then
           begin;

            oGotoXY(30,15);
            oSetCol(colTextHi);
            repeat
            oWrite(WordToString(aNmCfg^[nod].BaudRate));
            oGotoXY(30,15);

                Ch := UpCase(iReadKey);
                if extkey = #0 then
                   case Ch of
                 ' ' : begin
                       Inc(B,1);
                       if B > 18 then B := 1;

                       end;
                   end else
                   case extKey of
             #75,#80 : begin

                      Dec(B,1);
                      if B < 1 then B := 18;
                      aNmCfg^[nod].BaudRate := nmBaudRate[B];
                      end;
             #77,#72 : begin

                      inc(B,1);
                      if B > 18 then B := 1;
                      aNmCfg^[nod].BaudRate := nmBaudRate[B];
                     end;
                    end;
               until (HangUp) or (Ch in [#27,#13]);
                cfgSetItem(wordToString(aNmCfg^[nod].BaudRate));
               cfgInfo('');
               end;
           end;
        'C' : begin
               if cfgError = false then
               begin;
                 cfgReadInfo(aNmCfg^[nod].Note,inNormal,chNormal,'',False);
                 aNmCfg^[nod].Note := cfgRead;
                 cfgSetItem(aNmCfg^[nod].Note);
               end;
               end;




        'D' : begin
                cfgNetmodemCalls;
                cfgDraw := True;
              end;

        ']' : begin;
            if cfgError = false then
            begin;
               inc(nod,1);
               if nod > nmMaxNodes then nod := 1;
               cfgDraw := true;
            end;
              end;

        '[' : begin;
            if cfgError = false then
            begin;
              if nod > 1 then dec(nod,1) else nod := nmMaxNodes;
              cfgDraw := true;
              end;
            end;

       end;
   until (HangUp) or (cfgDone);
   cfgDone := False;

cfgInfo('Save configuration? ');
  if iYesNo(True,true) then cfgNetmodemcfg(true);
cfgKillNetmodem;

end;


procedure cfgNetmodemCalls;
var  Count, Spot : Byte;

begin;
   cfgDraw := True;
   cfgOver := False;
   Count   := 1;
     out   := False;

   repeat
      cfgInit('Netmodem/32 Connection List');
      cfgWrite('  |15Node              Connected From                     Date       Time');
      spot := 9;
      for Count := 1 to 14 do
       begin;
        if crError = True then exit;
        if out = False then
         begin;
          cfgNetmodemCr(count);
          cfgWrite('');
          oGotoXY(4,spot);
          oStrCtr('|15'+byteToString(NmCr^.Node));
          oGotoXY(12,spot);
          oStrCtr(NmCr^.From);
          oGotoXY(54,spot);
          oStrCtr(' '+NmCr^.CallDate+'  ');
          oGotoXY(64,spot);
          oStrCtr(' '+NmCr^.CallTime+' ');
          inc(spot,1);
         end else dispose(nmCr);
       if out then count := 14;
       if (Count > 1) and (not out) then dispose(nmCr);
       if count = 14 then crError := True;
       end;
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;

      until (HangUp) or (cfgDone);
      cfgDone := False;
end;

end.































(*
         cant read from netmodem.ibl when netmodem.exe has it open
                   it ioerrors for somereason..grr

                                                 coma



procedure cfgNetModemBlocks( wr : Boolean ); { reads and write netmodems block list }
var
  fIBL  : File of tBlockRecord;
  count : Byte;

begin
   count := 1;
   Assign(fIBL,Cfg^.pathNetmodem+fileNetmBl);
   {$I-}Reset(fIBL);{$I+}
   if ioResult <> 0 then
    begin;
    Error := True;
    exit;
   end;
   seek(fIBL,0);

 if wr then
  begin;
  for count := 1 to 15 do
   begin;
   {$I-}write(fIBL,aNmBl^[count]);{$I+}
   if ioResult <> 0 then exit;
   end;
   close(fIBL);
   end else

   begin;
   for count := 1 to 15 do
    begin;
   {$I-}read(fIBL,nmBl^);{$I+}
    if ioResult <> 0 then
             begin;
            {$I-}rewrite(fIBL);{$I+}
                if ioResult <> 0 then
                 begin
                  Error := True;
                  writeln('again');
                   readln;
                  exit;
                   end;
                 end;
    aNmBl^[count] := nmBl^;
    end;
   Close(fIBL);
   end;
end;








procedure cfgNetmodemBl;

begin;
   cfgDraw := True;
   cfgOver := False;
   repeat
      cfgInit('Netmodem/32 Block List');
      cfgItem('A |15'+aNmbl^[1].Address,40,'','');
      cfgItem('A |15'+aNmbl^[1].Address,40,'','');
      cfgItem('B |15'+aNmbl^[2].Address,40,'','');
      cfgItem('C |15'+aNmbl^[3].Address,40,'','');
      cfgItem('D |15'+aNmbl^[4].Address,40,'','');
      cfgItem('E |15'+aNmbl^[5].Address,40,'','');
      cfgItem('F |15'+aNmbl^[6].Address,40,'','');
      cfgItem('G |15'+aNmbl^[7].Address,40,'','');
      cfgItem('H |15'+aNmbl^[8].Address,40,'','');
      cfgItem('I |15'+aNmbl^[9].Address,40,'','');
      cfgItem('J |15'+aNmbl^[10].Address,40,'','');
      cfgItem('K |15'+aNmbl^[11].Address,40,'','');
      cfgItem('L |15'+aNmbl^[12].Address,40,'','');
      cfgItem('M |15'+aNmbl^[13].Address,40,'','');
      cfgItem('N |15'+aNmbl^[14].Address,40,'','');
      cfgItem('O |15'+aNmbl^[15].Address,40,'','');
      cfgBar;
      cfgDrawAllItems;
      cfgPromptCommand;

      case cfgKey of

         'A' : begin
                 cfgReadInfo(aNmBL^[1].Address,inNormal,chNormal,'',False);
                 aNmBl^[1].Address := cfgRead;
                 cfgSetItem(aNmbL^[1].Address);
               end;

      end;
      until (HangUp) or (cfgDone);
      cfgDone := False;

end;













 '+aNmbl^[1].Created,40,);
  '+aNmbl^[1].Created);
   '+aNmbl^[2].Created);
    '+aNmbl^[3].Created);
     '+aNmbl^[4].Created);
      '+aNmbl^[5].Created);
       '+aNmbl^[6].Created);
        '+aNmbl^[7].Created);
         '+aNmbl^[8].Created);
          '+aNmbl^[9].Created);
            '+aNmbl^[10].Created);
              '+aNmbl^[11].Created);
                '+aNmbl^[12].Created);
                  '+aNmbl^[13].Created);
                    '+aNmbl^[14].Created);
                      '+aNmbl^[15].Created);










   fICL  : File;
   fIBL  : File;


      cfgItem('D Block List',0,'',
              'NetModem/32 Block List Configuration');
*)
