{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}
unit Transfer;

interface

uses
   Global;

function  xferGood(Fn : String; Send : Boolean) : Boolean;
procedure xferLoadProt(N : Byte);
function  xferLoadZmodem : Boolean;
function  xferReceive(Fn : String; Pt : tProtFlagSet) : Boolean;
procedure xferSaveProt(N : Byte);
function  xferSelectProtocol(pt : tProtFlagSet) : Byte;
function  xferSend(Fn : String; Pt : tProtFlagSet; aal : Boolean) : Byte;
{function  xferTransfer(pt : byte; send : Boolean; par : String) : Boolean;}

implementation

uses
   Dos, Crt, Files, StrProc, BBSinit, ShowFile, Output, Input, Misc,
   Comm, DateTime, Terminal, HardAnsi, eComm, Nodes;

const
   cpsbuf = 15;

var
   xstime : LongInt;
   cps : array[1..cpsbuf] of Word;

(*procedure xferLog(ap : AbstractProtocolPtr; LogFileStatus : LogFileType); far;
var x : Byte; f : text;
begin
   case logfilestatus of
      lfReceiveStart,
      lfTransmitStart : begin
          for x := 1 to cpsbuf do cps[x] := ap^.actCPS;
          xstime := Trunc(dtTimer);
      end;
      else begin
          Assign(f,fTempPath('F')+fileXferStat);
          {$I-}
          Append(f);
          {$I+}
          if ioresult <> 0 then
          begin
             {$I-}
             Rewrite(f);
             {$I+}
             if ioresult <> 0 then Exit;
          end;
          case logfilestatus of
             lfReceiveFail  : Writeln(f,'+! ',ap^.pathname);
             lfReceiveSkip  : Writeln(f,'+? ',ap^.pathname);
             lfTransmitFail : Writeln(f,'-! ',ap^.pathname);
             lfTransmitSkip : Writeln(f,'-? ',ap^.pathname);
             lfReceiveOk    : Writeln(f,'++ ',ap^.pathname);
             lfTransmitOk   : Writeln(f,'-- ',ap^.pathname);
          end;
          Close(f);
      end;
   end;
end;

procedure xferStatus(ap : AbstractProtocolPtr; Starting, Ending : Boolean); far;
const xyp = 3; tc = $01; bx = 19; bs = 59;
var chk, x, per : Byte; s, z : String; avgcps : Word;
    ip, br, bz, bt, xt, nt, sum : LongInt;
 function times(t : Longint) : String;
 var s, m, h : Byte;
 begin
    h := t div 3600;
    m := (t-(h*3600)) div 60;
    s := t mod 60;
    times := z2(h)+':'+z2(m)+':'+z2(s);
 end;
begin
   if Starting then
   begin
      tmSaveWin(1,xyp,80,xyp+11);
      ansiXfer(xyp);

      hFwrite(45,xyp+1,'|08[|1F Iniquity BBS |17- |1F'+
             ProtocolTypeString[ap^.GetProtocol]+' Transfer |08]');
      xstime := Trunc(dtTimer);
      for x := 1 to cpsbuf do cps[x] := ap^.actCPS;
   end;

   fWrite(13,xyp+2,strresizenc(strLow(ap^.getfilename),12),$0F);
   z := '';
   s := fexpand(ap^.getpathname);
   chk := Pos('\',s);
   while chk > 0 do
   begin
      z := z+Copy(s,1,chk);
      Delete(s,1,chk);
      chk := Pos('\',s);
   end;
   hFwrite(26,xyp+2,resize('|08(|07'+strLow(z)+'|08)',40));

   nt := Trunc(dtTimer);
   bz := ap^.getbytestransferred;
   bt := ap^.getfilesize;
   ip := ap^.getinitialfilepos;
   br := ap^.getbytesremaining;
   xt := nt-xstime;
   if xt < 1 then xt := 1;
   sum := 0;
   for x := 1 to cpsbuf do
   begin
      if x < cpsbuf then cps[x] := cps[x+1] else cps[x] := Trunc((bz-ip)/xt);
      Inc(sum,cps[x]);
   end;
   avgcps := sum div cpsbuf;
   if avgcps < 1 then avgcps := 1;

   fWrite( 9,xyp+4,strright(stc(bt),11),tc);
   fWrite( 9,xyp+5,strright(stc(bz),11),tc);
   fWrite( 9,xyp+6,strright(stc(br),11),tc);

   fWrite(32,xyp+4,strright(st(avgcps),5),tc);
   fWrite(32,xyp+5,strright(st(ap^.blocklen),5),tc);
   fWrite(32,xyp+6,strright(st(ap^.gettotalerrors),5),tc);

   fWrite(51,xyp+4,times((bt-ip) div avgcps),tc);
   fWrite(51,xyp+5,times(dtSecDiff(xstime,Trunc(dtTimer))),tc);
   fWrite(51,xyp+6,times(br div avgcps),tc);


   chk := ap^.getchecktype;
   case chk of
     bcNone      : s := bcsNone;
     bcChecksum1 : s := bcsChecksum1;
     bcChecksum2 : s := bcsChecksum2;
     bcCrc16     : s := bcsCrc16;
     bcCrc32     : s := bcsCrc32;
     bcCrcK      : s := bcsCrcK;
   end;
   fWrite(70,xyp+4,strresizenc(st(ap^.aport^.pr^.curbaud),9),tc);
   fWrite(70,xyp+5,strresizenc(s,9),tc);
   fWrite(70,xyp+6,strresizenc(st(ap^.getblocknum),9),tc);

   if bt = 0 then per := 0 else
      per := abs(100-(br*100) div bt);
   fWrite(13,xyp+8,strright(st(per),3),$0F);

   x := per * bs div 100;
   fillchar(s,100,'');
   s[0] := Char(x);
   if Byte(s[0]) > 0 then
   begin
      Dec(s[0]);
      fWrite(bx+x-1,xyp+8,' ',$11);
   end;
   fWrite(bx,xyp+8,s,$19);
   fillchar(s,100,'');
   s[0] := Char(bs-x);
   fWrite(bx+x,xyp+8,s,$08);

   case AsyncStatus of
     ecOk : s := 'Normal';
     ecGotCrcE, ecGotCrcW, ecGotCrcQ, ecGotCrcG :
        s := 'Receiving file ...';
     else s := StatusStr(AsyncStatus);
   end;

   fWrite(11,xyp+10,strresizenc(s,60),$0F);

   if Ending then
   begin
      tmRestoreWin;
   end;
end; *)

(*function xferTransfer(pt : byte; send : Boolean; par : String) : Boolean;
var b : String; t : Text; {p : filelistptr;}
begin
   xferTransfer := False;
   case pt of
      2 : New(XmodemProtocolPtr(pprot),initCustom(pcomm,False,False,defProtocolOptions));
      3 : New(YmodemProtocolPtr(pprot),initCustom(pcomm,True,False,defProtocolOptions));
      4 : New(YmodemProtocolPtr(pprot),initCustom(pcomm,True,True,defProtocolOptions));
      5 : New(ZmodemProtocolPtr(pprot),initCustom(pcomm,defProtocolOptions));
      6 : New(KermitProtocolPtr(pprot),initCustom(pcomm,defKermitOptions,defProtocolOptions));
      7 : New(AsciiProtocolPtr(pprot),initCustom(pcomm,defInterCharDelay,defInterLineDelay,defProtocolOptions));
     else Exit;
   end;
   pprot^.SetShowStatusProc(xferStatus);
   pprot^.SetLogFileProc(xferLog);
   if send then
   begin
      if par[1] = '@' then
      begin
         Assign(t,Copy(par,2,255));
         {$I-}
         Reset(t);
         {$I+}
         if ioResult = 0 then
         begin
            pprot^.makefilelist(p,1024);
            while not Eof(t) do
            begin
               ReadLn(t,b);
               pprot^.AddFileToList(p,b);
            end;
            Close(t);
            pprot^.setnextfilefunc(nextfilelist);
            pprot^.setfilelist(p);
         end else par := '';
         pprot^.protocolTransmit;
         if pprot^.filelist <> nil then pprot^.disposefilelist(p,1024);
      end else
      begin
         pprot^.setFileMask(par);
         pprot^.protocolTransmit;
      end;
   end else
   begin
      pprot^.setDestinationDirectory('');
      if par <> '' then pprot^.setReceiveFilename(par);
      pprot^.protocolReceive;
   end;

   Dispose(pprot,done);
   xferTransfer := True;
end; *)

procedure xferLoadProt(N : Byte);
var F : file of tProtRec;
begin
   FillChar(Prot^,SizeOf(Prot^),0);
   Assign(F,Cfg^.pathData+fileProt);
   {$I-}
   Reset(F);
   {$I-}
   if (ioResult <> 0) then
   begin
      resetProtocols;
      Reset(F);
   end;
   if FileSize(F) <> maxProt then
   begin
      Close(F);
      resetProtocols;
      Reset(F);
   end;
   Seek(F,N-1);
   Read(F,Prot^);
   Close(F);
end;

function xferLoadZmodem : Boolean;
var F : file of tProtRec; Found : Boolean;
begin
   FillChar(Prot^,SizeOf(Prot^),0);
   Assign(F,Cfg^.pathData+fileProt);
   {$I-}
   Reset(F);
   {$I-}
   if (ioResult <> 0) then
   begin
      resetProtocols;
      Reset(F);
   end;
   if FileSize(F) <> maxProt then
   begin
      Close(F);
      resetProtocols;
      Reset(F);
   end;
   Found := False;
   while (not Eof(F)) and (not Found) do
   begin
      Read(F,Prot^);
      Found := (UpCase(Prot^.codeUL[1,1]) = 'Z') and (protBatch in Prot^.Flag);
   end;
   Close(F);
   xferLoadZmodem := Found;
end;

procedure xferSaveProt(N : Byte);
var F : file of tProtRec;
begin
   Assign(F,Cfg^.pathData+fileProt);
   {$I-}
   Reset(F);
   {$I-}
   if (ioResult <> 0) then
   begin
      resetProtocols;
      Reset(F);
   end;
   if FileSize(F) <> maxProt then
   begin
      Close(F);
      resetProtocols;
      Reset(F);
   end;
   Seek(F,N-1);
   Write(F,Prot^);
   Close(F);
end;

function xferGood(Fn : String; Send : Boolean) : Boolean;
var F : Text; S, Lg, Tp, logFn, logStat : String; Found, xok, ok : Boolean; Z : Byte;
begin
   xferGood := False;
   Tp := fTempPath('F');
   if prot^.ptype > 1 then
   begin
      prot^.log := '%TD\'+fileXferStat;
      prot^.posfile := 4;
      prot^.posstat := 1;
      prot^.codeis := 2;
      prot^.codedl[1] := '-!';
      prot^.codedl[2] := '-?';
      prot^.codedl[3] := '+!';
      prot^.codedl[4] := '+?';
      prot^.codedl[5] := '-!';
      prot^.codedl[6] := '+!';
   end;
   Lg := strReplace(Prot^.Log,'%TD',Copy(Tp,1,Length(Tp)-1));
   Lg := strReplace(Lg,'%ND',St(Node));
   Assign(F,Lg);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then Exit;

   Found := False;
   while (not Found) and (not Eof(F)) do
   begin
      ReadLn(F,S);
{      logStat := Copy(S,Prot^.posStat,255);
      if Pos(' ',logStat) > 0 then Delete(logStat,Pos(' ',logStat),255);
      logFn := Copy(S,Prot^.posFile,255);
      if Pos(' ',logFn) > 0 then Delete(logFn,Pos(' ',logFn),255); }

      logStat := s[1];
      logFn := copy(s, pos(':\', s)-1, 255);
      if pos(' ', logFn) > 0 then delete(logFn, pos(' ', logFn), 255);
      Found := UpStr(strFilename(logFn)) = UpStr(strFilename(Fn));

   end;
   Close(F);
   if not Found then Exit;
   xOk := Prot^.codeIs = xferOk;
   Ok := not xOk;
   if Send then
   begin
      for Z := 1 to 6 do if Pos(Prot^.codeDL[Z],logStat) > 0 then Ok := xOk;
   end else
   begin
      for Z := 1 to 6 do if Pos(Prot^.codeUL[Z],logStat) > 0 then Ok := xOk;
   end;
   xferGood := Ok;
end;

function xferSend(Fn : String; Pt : tProtFlagSet; aal : Boolean) : Byte;
var Ex, Lg, Tp, env : String; Batch : Boolean; P : Byte;

begin
   nodeUpdate('Sending file');
   xferSend := 1;
   P := xferSelectProtocol(pt);
   if P = 0 then Exit;
   xferLoadProt(P);
   Tp := fTempPath('F');
   Batch := protBatch in Prot^.Flag;
   if ((prot^.ptype = 1) and (Prot^.cmdDL = '')) or
      ((Batch) and (not fExists(Tp+fileTempDL))) then Exit;
   if prot^.ptype > 1 then { internal protocol }
   begin
      if batch then fn := '@'+tp+filetempdl;
      fDeleteFile(fTempPath('F')+fileXferStat);
   end else { external }
   begin
      Lg := strReplace(Prot^.Log,'%TD',Copy(Tp,1,Length(Tp)-1));
      Lg := strReplace(Lg,'%ND',St(Node));
      fDeleteFile(Lg);
      env := strReplace(Prot^.cmdEnv,'%LF',Lg);
      Ex := Prot^.cmdDL;
      Ex := strReplace(Ex,'%CP',St(Modem^.ComPort));
{$IFDEF OS2}
      Ex := strReplace(Ex,'%CH',St(eGetahandle));
{$ENDIF}
      Ex := strReplace(Ex,'%BR',St(BaudRate));
      Ex := strReplace(Ex,'%PR',St(Modem^.BaudRate));
      Lg := strReplace(Prot^.listDL,'%TD',Copy(Tp,1,Length(Tp)-1));
      Lg := strReplace(Lg,'%ND',St(Node));
      if Batch then Ex := strReplace(Ex,'%FL',Lg) else
                    Ex := strReplace(Ex,'%FN',Fn);
      if (Batch) and (not (fCopyFile(Tp+fileTempDL,Lg))) then Exit;
      if Prot^.cmdEnv <> '' then Ex := Ex+#1+env;
   end;
   oDnLn(1);
   if aal then
   begin
      if cfg^.askXferHangup then
      begin
         oString(strFaXferAskAutoOff);
         autologout := iYesNo(False,true);
         oDnLn(1);
      end else autologout := False;
   end;
   oStrLn(strCode(mStr(strXferSending),1,prot^.desc));

   if (localio=false) then eclosemodem;

   fShellDos(Cfg^.pathProt+Ex,Cfg^.ProtocolSwap,False,True);

   if (localio=false) then einit(modem^.comport, modem^.baudrate);

{$IFDEF OS2}
   ePurgehandle;
{$ENDIF}
{   if prot^.ptype > 1 then xferTransfer(prot^.ptype,True,fn) else
                           fShellDos(Cfg^.pathProt+Ex,Cfg^.ProtocolSwap,False,True);}
{ %XXF  cInitFossil; }
   if (Batch) or (xferGood(Fn,True)) then xferSend := 0 else xferSend := 2;
end;

function xferReceive(Fn : String; Pt : tProtFlagSet) : Boolean;
var  dt1,dt2,dt3:tDateTimeRec;
     env, Ex, Lg, Tp : String; Batch : Boolean; P : Byte;

begin
   nodeUpdate('Receiving file');
   xferReceive := False;
   if Pt <> [] then
   begin
      P := xferSelectProtocol(pt);
      if P = 0 then Exit;
      xferLoadProt(P);
   end;
   Tp := fTempPath('F');
   Batch := protBatch in Prot^.Flag;
   if prot^.ptype > 1 then { internal }
   begin
      fDeleteFile(fTempPath('F')+fileXferStat);
   end else
   begin
      if prot^.cmdUL = '' then Exit;
      Lg := strReplace(Prot^.Log,'%TD',Copy(Tp,1,Length(Tp)-1));
      Lg := strReplace(Lg,'%ND',St(Node));
      fDeleteFile(Lg);
      env := strReplace(Prot^.cmdEnv,'%LF',Lg);
      Ex := Prot^.cmdUL;
      Ex := strReplace(Ex,'%CP',St(Modem^.ComPort));
{$IFDEF OS2}
      Ex := strReplace(Ex,'%CH',St(egetahandle));
{$ENDIF}
      Ex := strReplace(Ex,'%BR',St(BaudRate));
      Ex := strReplace(Ex,'%PR',St(Modem^.BaudRate));
      Lg := strReplace(Prot^.listDL,'%TD',Copy(Tp,1,Length(Tp)-1));
      Lg := strReplace(Lg,'%ND',St(Node));
      {  if (Fn = '') and (not Batch) then strReplace(Ex,'%FN','');}
{      if not Batch then Ex := strReplace(Ex,'%FN',Fn); }
      Ex := strReplace(Ex,'%FN',Fn);
      if Prot^.cmdEnv <> '' then Ex := Ex+#1+env;
   end;
   if Pt <> [] then
      oStrLn(strCode(mStr(strXferReceiving),1,prot^.desc));

   if (localio=false) then eclosemodem;

   dtGetDateTime(dt1);
   fShellDos(Cfg^.pathProt+Ex,Cfg^.ProtocolSwap,False,True);
   dtGetDateTime(dt2);
   dtTimeDiff(dt3,dt1,dt2);

   if cfg^.useUPLtimeRefund then timeFree := timeFree+dtDateToReal(dt3);
    {comatose}
  { if dtDatetoReal(dt3) > timeFree then timeFree:= 0
   else timeFree:=timeFree-dtDatetoReal(dt3);
   }
   if (localio=false) then einit(modem^.comport, modem^.baudrate);
{$IFDEF OS2}
  epurgehandle;
{$ENDIF}
{   if prot^.ptype > 1 then xferTransfer(prot^.ptype,False,'') else
                           fShellDos(Cfg^.pathProt+Ex,Cfg^.ProtocolSwap,False,True);}
{ %XXF   cInitFossil; }
   xferReceive := (Batch) or (xferGood(Fn,False));
end;

function xferSelectProtocol(pt : tProtFlagSet) : Byte;
 var Ans : Boolean; F : file of tProtRec; N, R, X, W : Word;
    pk : array[1..maxProt] of record Key : Char; Rec : Byte; end;
    Ch : Char; pts : String;
begin
   xferSelectProtocol := 0;
   Ans := (sfGetTextFile(txListProtTop,ftTopLine) <> '') and
          (sfGetTextFile(txListProtMid,ftListProt) <> '') and
          (sfGetTextFile(txListProtBot,ftNormal) <> '');
   PausePos := 1;
   PauseAbort := False;
   if Ans then
   begin
      sfShowTextFile(txListProtTop,ftTopLine);
      oUpPause(ansiRows-1);
      sfGotoPos(1);
      sfLoadRepeat(txListProtMid);
   end else
   begin
      oDnLn(1);
      oUpPause(1);
   end;
   FillChar(Prot^,SizeOf(Prot^),0);
   Assign(F,Cfg^.pathData+fileProt);
   {$I-}
   Reset(F);
   {$I-}
   if (ioResult <> 0) then
   begin
      resetProtocols;
      Reset(F);
   end;
   if FileSize(F) <> maxProt then
   begin
      Close(F);
      resetProtocols;
      Reset(F);
   end;
   N := 0;
   R := 0;
   while (not PauseAbort) and (not Eof(F)) do
   begin
      Read(F,Prot^);
      Inc(R,1);
      if (acsOk(Prot^.Acs)) and (Prot^.Flag = pt) then
      begin
         Inc(N,1);
         pk[N].Key := Prot^.Key;
         pk[N].Rec := R;
         pts := '';
         if protBiDir  in Prot^.Flag then pts := 'BiDir/';
         if protBatch  in Prot^.Flag then pts := pts+'Batch/' else
         if protActive in Prot^.Flag then pts := pts+'Normal' else
                                      pts := pts+'Disabled';
         if pts[Length(pts)] = '/' then Delete(pts,Length(pts),1);
         if Ans then
         begin
            sfStr[1] := Prot^.Key;
            sfStr[2] := Prot^.Desc;
            sfStr[3] := pts;
            sfStr[4] := St(N);
            sfShowRepeat(ftListProt);
            if oWhereX <> 1 then oDnLn(1);
            oUpPause(1);
         end else
         begin
            oCwriteLn(' |U2[|U3'+Prot^.Key+'|U2] |U1'+Prot^.Desc);
            oUpPause(1);
         end;
      end;
   end;
   sfKillRepeat;
   Close(F);
   if Ans then
   begin
      sfShowTextFile(txListProtBot,ftNormal);
      oUpPause(ansiRows);
   end else
   begin
      oDnLn(1);
      oUpPause(1);
   end;
   PausePos := 0;
   if N < 1 then Exit;
   oString(strXferSelectProtocol);
   repeat
      Ch := UpCase(iReadKey);
      W := 0;
      for X := 1 to N do if Ch = pk[X].Key then W := X;
   until (Ch in [#27,#13]) or (HangUp) or (W <> 0);
   if (HangUp) or (Ch in [#27,#13]) then
   begin
      oWriteLn('Abort');
      Exit;
   end else oWriteLn(Ch);
   xferSelectProtocol := pk[W].Rec;
end;

end.
